# Contributing to IRB

Bug reports and pull requests are welcome on GitHub at [https://github.com/ruby/irb](https://github.com/ruby/irb).

## Set up the environment

1. Fork the project to your GitHub account.
2. Clone the fork with `git clone git@github.com:[your_username]/irb.git`.
3. Run `bundle install`.
4. Run `bundle exec rake` to make sure tests pass locally.

## Run integration tests

If your changes affect component rendering, such as the autocompletion's dialog/dropdown, you may need to run IRB's integration tests, known as `yamatanooroti`.

Before running these tests, ensure that you have `libvterm` installed. If you're using Homebrew, you can install it by running:

```bash
brew install libvterm
```

After installing `libvterm`, you can run the integration tests using the following commands:

```bash
WITH_VTERM=1 bundle install
WITH_VTERM=1 bundle exec rake test test_yamatanooroti
```

## Update documentation

IRB's documentation is generated by [RDoc](https://ruby.github.io/rdoc/) and published to [ruby.github.io/irb](https://ruby.github.io/irb/). Most of the documentation source lives under the `doc/` directory.

Run the following command to generate the documentation site locally.

```bash
bundle exec rake rdoc
bundle exec rake rerdoc # to force regeneration
```

Follow the output message to open the documentation site in your browser.

> [!Note]
>
> Please ensure that the changes are rendered correctly on the documentation site.
> RDoc's Markdown support is limited, so the rendered result on GitHub might differ from what’s rendered on [https://ruby.github.io/irb](https://ruby.github.io/irb).

We welcome any improvements to the documentation, including:

- Fixing typos and grammatical errors.
- Adding missing documentation for features.
- Adding missing documentation for configuration options.
- Adding demo images/gifs for features.
