//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class Theme plasma/theme.h <Plasma/Theme>
    ///  Accessed via Plasma.Theme.DefaultTheme() e.g:
    ///  <pre>
    ///  string imagePath = Plasma.Theme.DefaultTheme().ImagePath("widgets/clock")
    ///  </pre>
    ///  Plasma.Theme provides access to a common and standardized set of graphic
    ///  elements stored in SVG format. This allows artists to create single packages
    ///  of SVGs that will affect the look and feel of all workspace components.
    ///  Plasma.Svg uses Plasma.Theme internally to locate and load the appropriate
    ///  SVG data. Alternatively, Plasma.Theme can be used directly to retrieve
    ///  file system paths to SVGs by name.
    ///   See <see cref="IThemeSignals"></see> for signals emitted by Theme
    /// </remarks>        <short> Interface to the Plasma theme.</short>
    [SmokeClass("Plasma::Theme")]
    public class Theme : QObject, IDisposable {
        protected Theme(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Theme), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Theme() {
            staticInterceptor = new SmokeInvocation(typeof(Theme), null);
        }
        public enum ColorRole {
            TextColor = 0,
            HighlightColor = 1,
            BackgroundColor = 2,
            ButtonTextColor = 4,
            ButtonBackgroundColor = 8,
        }
        public enum FontRole {
            DefaultFont = 0,
            DesktopFont = 1,
        }
        [Q_PROPERTY("QString", "themeName")]
        public string ThemeName {
            get { return (string) interceptor.Invoke("themeName", "themeName()", typeof(string)); }
        }
        /// <remarks>
        ///  Default constructor. Usually you want to use the singleton instead.
        /// </remarks>        <short>    Default constructor.</short>
        ///         <see> defaultTheme</see>
        ///         <see> @arg</see>
        ///         <see> parent</see>
        ///         <see> the</see>
        ///         <see> parent</see>
        ///         <see> object</see>
        public Theme(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Theme#", "Theme(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Theme() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Theme", "Theme()", typeof(void));
        }
        /// <remarks>
        ///  Construct a theme. Usually you want to use the singleton instead.
        /// </remarks>        <short>    Construct a theme.</short>
        ///         <see> defaultTheme</see>
        ///         <see> @arg</see>
        ///         <see> themeName</see>
        ///         <see> the</see>
        ///         <see> name</see>
        ///         <see> of</see>
        ///         <see> the</see>
        ///         <see> theme</see>
        ///         <see> to</see>
        ///         <see> create</see>
        ///         <see> @arg</see>
        ///         <see> parent</see>
        ///         <see> the</see>
        ///         <see> parent</see>
        ///         <see> object</see>
        public Theme(string themeName, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Theme$#", "Theme(const QString&, QObject*)", typeof(void), typeof(string), themeName, typeof(QObject), parent);
        }
        public Theme(string themeName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Theme$", "Theme(const QString&)", typeof(void), typeof(string), themeName);
        }
        /// <remarks>
        ///  Retrieve the path for an SVG image in the current theme.
        ///  @arg name the name of the file in the theme directory (without the
        ///            ".svg" part or a leading slash)
        /// </remarks>        <return> the full path to the requested file for the current theme
        ///          </return>
        ///         <short>    Retrieve the path for an SVG image in the current theme.</short>
        public string ImagePath(string name) {
            return (string) interceptor.Invoke("imagePath$", "imagePath(const QString&) const", typeof(string), typeof(string), name);
        }
        /// <remarks>
        ///  Retreives the default wallpaper associated with this theme.
        ///  @arg size the target height and width of the wallpaper; if an invalid size
        ///            is passed in, then a default size will be provided instead.
        /// </remarks>        <return> the full path to the wallpaper image
        ///          </return>
        ///         <short>    Retreives the default wallpaper associated with this theme.</short>
        public string WallpaperPath(QSize size) {
            return (string) interceptor.Invoke("wallpaperPath#", "wallpaperPath(const QSize&) const", typeof(string), typeof(QSize), size);
        }
        public string WallpaperPath() {
            return (string) interceptor.Invoke("wallpaperPath", "wallpaperPath() const", typeof(string));
        }
        /// <remarks>
        ///  Checks if this theme has an image named in a certain way
        ///  @arg name the name of the file in the theme directory (without the
        ///            ".svg" part or a leading slash)
        /// </remarks>        <return> true if the image exists for this theme
        ///          </return>
        ///         <short>    Checks if this theme has an image named in a certain way </short>
        public bool CurrentThemeHasImage(string name) {
            return (bool) interceptor.Invoke("currentThemeHasImage$", "currentThemeHasImage(const QString&) const", typeof(bool), typeof(string), name);
        }
        /// <remarks>
        ///  Returns the color scheme configurationthat goes along this theme.
        ///  This can be used with KStatefulBrush and KColorScheme to determine
        ///  the proper colours to use along with the visual elements in this theme.
        ///          </remarks>        <short>    Returns the color scheme configurationthat goes along this theme.</short>
        public KSharedConfig ColorScheme() {
            return (KSharedConfig) interceptor.Invoke("colorScheme", "colorScheme() const", typeof(KSharedConfig));
        }
        /// <remarks>
        ///  Returns the text color to be used by items resting on the background
        ///  @arg role which role (usage pattern) to get the color for
        ///          </remarks>        <short>    Returns the text color to be used by items resting on the background </short>
        public QColor Color(Plasma.Theme.ColorRole role) {
            return (QColor) interceptor.Invoke("color$", "color(Plasma::Theme::ColorRole) const", typeof(QColor), typeof(Plasma.Theme.ColorRole), role);
        }
        /// <remarks>
        ///  Sets the default font to be used with themed items. Defaults to
        ///  the application wide default font.
        ///  @arg font the new font
        ///  @arg role which role (usage pattern) to set the font for
        ///          </remarks>        <short>    Sets the default font to be used with themed items.</short>
        public void SetFont(QFont font, Plasma.Theme.FontRole role) {
            interceptor.Invoke("setFont#$", "setFont(const QFont&, Plasma::Theme::FontRole)", typeof(void), typeof(QFont), font, typeof(Plasma.Theme.FontRole), role);
        }
        public void SetFont(QFont font) {
            interceptor.Invoke("setFont#", "setFont(const QFont&)", typeof(void), typeof(QFont), font);
        }
        /// <remarks>
        ///  Returns the font to be used by themed items
        ///  @arg role which role (usage pattern) to get the font for
        ///          </remarks>        <short>    Returns the font to be used by themed items </short>
        public QFont Font(Plasma.Theme.FontRole role) {
            return (QFont) interceptor.Invoke("font$", "font(Plasma::Theme::FontRole) const", typeof(QFont), typeof(Plasma.Theme.FontRole), role);
        }
        /// <remarks>
        ///  Returns the font metrics for the font to be used by themed items
        ///          </remarks>        <short>    Returns the font metrics for the font to be used by themed items          </short>
        public QFontMetrics FontMetrics() {
            return (QFontMetrics) interceptor.Invoke("fontMetrics", "fontMetrics() const", typeof(QFontMetrics));
        }
        /// <remarks>
        ///  Returns if the window manager effects (e.g. translucency, compositing) is active or not
        ///          </remarks>        <short>    Returns if the window manager effects (e.</short>
        public bool WindowTranslucencyEnabled() {
            return (bool) interceptor.Invoke("windowTranslucencyEnabled", "windowTranslucencyEnabled() const", typeof(bool));
        }
        /// <remarks>
        ///  Tells the theme whether to follow the global settings or use application
        ///  specific settings
        ///  @arg useGlobal pass in true to follow the global settings
        ///          </remarks>        <short>    Tells the theme whether to follow the global settings or use application  specific settings </short>
        public void SetUseGlobalSettings(bool useGlobal) {
            interceptor.Invoke("setUseGlobalSettings$", "setUseGlobalSettings(bool)", typeof(void), typeof(bool), useGlobal);
        }
        /// <remarks>
        /// </remarks>        <return> true if the global settings are followed, false if application
        ///  specific settings are used.
        ///          </return>
        ///         <short>   </short>
        public bool UseGlobalSettings() {
            return (bool) interceptor.Invoke("useGlobalSettings", "useGlobalSettings() const", typeof(bool));
        }
        /// <remarks>
        /// </remarks>        <return> true if the native widget styles should be used instead of themed
        ///  widgets. Defaults is false.
        ///          </return>
        ///         <short>   </short>
        public bool UseNativeWidgetStyle() {
            return (bool) interceptor.Invoke("useNativeWidgetStyle", "useNativeWidgetStyle() const", typeof(bool));
        }
        /// <remarks>
        ///  Tries to load pixmap with the specified key from cache.
        /// <param> name="key" the name to use in the cache for this image
        /// </param><param> name="pix" the pixmap object to populate with the resulting data if found
        /// </param></remarks>        <return> true when pixmap was found and loaded from cache, false otherwise
        /// </return>
        ///         <short>    Tries to load pixmap with the specified key from cache.</short>
        public bool FindInCache(string key, QPixmap pix) {
            return (bool) interceptor.Invoke("findInCache$#", "findInCache(const QString&, QPixmap&)", typeof(bool), typeof(string), key, typeof(QPixmap), pix);
        }
        /// <remarks>
        ///  This is an overloaded member provided to check with file timestamp
        ///  where cache is still valid.
        /// <param> name="key" the name to use in the cache for this image
        /// </param><param> name="pix" the pixmap object to populate with the resulting data if found
        /// </param><param> name="lastModified" if non-zero, the time stamp is also checked on the file,
        ///                      and must be newer than the timestamp to be loaded
        /// </param></remarks>        <return> true when pixmap was found and loaded from cache, false otherwise
        /// </return>
        ///         <short>    This is an overloaded member provided to check with file timestamp  where cache is still valid.</short>
        public bool FindInCache(string key, QPixmap pix, uint lastModified) {
            return (bool) interceptor.Invoke("findInCache$#$", "findInCache(const QString&, QPixmap&, unsigned int)", typeof(bool), typeof(string), key, typeof(QPixmap), pix, typeof(uint), lastModified);
        }
        /// <remarks>
        ///  Insert specified pixmap into the cache.
        ///  If the cache already contains pixmap with the specified key then it is
        ///  overwritten.
        /// <param> name="key" the name to use in the cache for this pixmap
        /// </param><param> name="pix" the pixmap data to store in the cache
        /// </param></remarks>        <short>    Insert specified pixmap into the cache.</short>
        public void InsertIntoCache(string key, QPixmap pix) {
            interceptor.Invoke("insertIntoCache$#", "insertIntoCache(const QString&, const QPixmap&)", typeof(void), typeof(string), key, typeof(QPixmap), pix);
        }
        /// <remarks>
        ///  Sets the maximum size of the cache (in kilobytes). If cache gets bigger
        ///  the limit then some entries are removed
        ///  Setting cache limit to 0 disables automatic cache size limiting.
        ///  Note that the cleanup might not be done immediately, so the cache might
        ///   temporarily (for a few seconds) grow bigger than the limit.
        /// </remarks>        <short>    Sets the maximum size of the cache (in kilobytes).</short>
        public void SetCacheLimit(int kbytes) {
            interceptor.Invoke("setCacheLimit$", "setCacheLimit(int)", typeof(void), typeof(int), kbytes);
        }
        /// <remarks>
        ///  Tries to load the rect of a sub element from a disk cache
        ///  @arg image path of the image we want to check
        ///  @arg element sub element we want to retrieve
        ///  @arg rect output parameter of the element rect found in cache 
        ///            if not found or if we are sure it doesn't exist it will be QRect()
        /// </remarks>        <return> true if the element was found in cache or if we are sure the element doesn't exist
        /// </return>
        ///         <short>    Tries to load the rect of a sub element from a disk cache </short>
        public bool FindInRectsCache(string image, string element, QRectF rect) {
            return (bool) interceptor.Invoke("findInRectsCache$$#", "findInRectsCache(const QString&, const QString&, QRectF&) const", typeof(bool), typeof(string), image, typeof(string), element, typeof(QRectF), rect);
        }
        /// <remarks>
        ///  Inserts a rectangle of a sub element of an image into a disk cache
        ///  @arg image path of the image we want to insert information
        ///  @arg element sub element we want insert the rect
        ///  @arg rect element rectangle
        /// </remarks>        <short>    Inserts a rectangle of a sub element of an image into a disk cache </short>
        public void InsertIntoRectsCache(string image, string element, QRectF rect) {
            interceptor.Invoke("insertIntoRectsCache$$#", "insertIntoRectsCache(const QString&, const QString&, const QRectF&)", typeof(void), typeof(string), image, typeof(string), element, typeof(QRectF), rect);
        }
        /// <remarks>
        ///  Discards all the information about a given image from the rectangle disk cache
        ///  @arg image the path to the image the cache is assoiated with
        /// </remarks>        <short>    Discards all the information about a given image from the rectangle disk cache </short>
        public void InvalidateRectsCache(string image) {
            interceptor.Invoke("invalidateRectsCache$", "invalidateRectsCache(const QString&)", typeof(void), typeof(string), image);
        }
        /// <remarks>
        ///  Frees up memory used by cached information for a given image without removing
        ///  the permenant record of it on disk.
        ///  @arg image the path to the image the cache is assoiated with
        ///          </remarks>        <short>    Frees up memory used by cached information for a given image without removing  the permenant record of it on disk.</short>
        ///         <see> invalidateRectsCache</see>
        public void ReleaseRectsCache(string image) {
            interceptor.Invoke("releaseRectsCache$", "releaseRectsCache(const QString&)", typeof(void), typeof(string), image);
        }
        /// <remarks>
        ///  Notifies the Theme object that the theme settings have changed
        ///  and should be read from the config file
        /// </remarks>        <short>    Notifies the Theme object that the theme settings have changed  and should be read from the config file </short>
        [Q_SLOT("void settingsChanged()")]
        public void SettingsChanged() {
            interceptor.Invoke("settingsChanged", "settingsChanged()", typeof(void));
        }
        ~Theme() {
            interceptor.Invoke("~Theme", "~Theme()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Theme", "~Theme()", typeof(void));
        }
        /// <remarks>
        ///  Singleton pattern accessor
        /// </remarks>        <short>    Singleton pattern accessor </short>
        public static Plasma.Theme DefaultTheme() {
            return (Plasma.Theme) staticInterceptor.Invoke("defaultTheme", "defaultTheme()", typeof(Plasma.Theme));
        }
        /// <remarks>
        /// </remarks>        <return> a package structure representing a Theme
        ///          </return>
        ///         <short>   </short>
        public static Plasma.PackageStructure PackageStructure() {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure", "packageStructure()", typeof(Plasma.PackageStructure));
        }
        /// <remarks>
        /// </remarks>        <return> a list of all known themes
        /// </return>
        ///         <short>   </short>
        public static List<KPluginInfo> ListThemeInfo() {
            return (List<KPluginInfo>) staticInterceptor.Invoke("listThemeInfo", "listThemeInfo()", typeof(List<KPluginInfo>));
        }
        protected new IThemeSignals Emit {
            get { return (IThemeSignals) Q_EMIT; }
        }
    }

    public interface IThemeSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when the user changes the theme. SVGs should be reloaded at
        ///  that point
        ///          </remarks>        <short>    Emitted when the user changes the theme.</short>
        [Q_SIGNAL("void themeChanged()")]
        void ThemeChanged();
    }
}
