//Auto-generated by kalyptus. DO NOT EDIT.
namespace KImageIO {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  Possible image file access modes.
    ///  Used in various KImageIO static function.
    /// </remarks>        <short>    Possible image file access modes.</short>
    public enum Mode {
        Reading = 0,
        Writing = 1,
    }
    /// <remarks>
    ///  Methods to get information about image format names and
    ///  the corresponding mime type. Also, you can get information about supported
    ///  image types without loading all the imageformat plugins.
    ///  The image processing backends are written as image handlers compatible
    ///  with the QImageIOHandler format. The backends are Qt imageformat plugins. 
    ///  Each format can be identified by a unique type id string.
    ///  <b></b>ormats:
    ///  Currently supported formats include:
    /// 
    /// <li>
    /// BMP     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// EPS     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// EXR     \<read\>
    /// </li>
    /// 
    /// <li>
    /// G3      \<read\>
    /// </li>
    /// 
    /// <li>
    /// GIF     \<read\>
    /// </li>
    /// 
    /// <li>
    /// ICO     \<read\>
    /// </li>
    /// 
    /// <li>
    /// JP2     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// JPEG    \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// NETPBM  \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// PCX     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// PNG     \<read\> \<write, only with newer libraries\>
    /// </li>
    /// 
    /// <li>
    /// TGA     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// TIFF    \<read\>
    /// </li>
    /// 
    /// <li>
    /// XBM     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// XPM     \<read\> \<write\>
    /// </li>
    /// 
    /// <li>
    /// XV      \<read\> \<write\>
    /// </li>
    ///  </remarks>        <short>    Methods to get information about image format names and  the corresponding mime type.</short>
    [SmokeClass("KImageIO")]
    public class Global {
        private static SmokeInvocation staticInterceptor = null;
        static Global() {
            staticInterceptor = new SmokeInvocation(typeof(Global), null);
        }
        /// <remarks>
        ///  Returns a list of patterns of all KImageIO supported formats.
        ///  These patterns can be passed to KFileDialog.GetOpenFileName()
        ///  or KFileDialog.GetSaveFileName(), for example.
        /// <param> name="mode" Tells whether to retrieve modes that can be read or written.
        /// </param></remarks>        <return> a space-separated list of file globs that describe the
        ///  supported formats
        ///    </return>
        ///         <short>    Returns a list of patterns of all KImageIO supported formats.</short>
        public static string Pattern(KImageIO.Mode mode) {
            return (string) staticInterceptor.Invoke("pattern$", "pattern(KImageIO::Mode)", typeof(string), typeof(KImageIO.Mode), mode);
        }
        public static string Pattern() {
            return (string) staticInterceptor.Invoke("pattern", "pattern()", typeof(string));
        }
        /// <remarks>
        ///  Returns the type of a MIME type.
        /// <param> name="mimeType" the MIME type to search
        /// </param></remarks>        <return> type id(s) of the MIME type or List<string>() if the MIME type
        ///          is not supported
        ///    </return>
        ///         <short>    Returns the type of a MIME type.</short>
        public static List<string> TypeForMime(string mimeType) {
            return (List<string>) staticInterceptor.Invoke("typeForMime$", "typeForMime(const QString&)", typeof(List<string>), typeof(string), mimeType);
        }
        /// <remarks>
        ///  Returns a list of all KImageIO supported formats.
        /// <param> name="mode" Tells whether to retrieve modes that can be read or written.
        /// </param></remarks>        <return> a list of the type ids
        ///    </return>
        ///         <short>    Returns a list of all KImageIO supported formats.</short>
        public static List<string> Types(KImageIO.Mode mode) {
            return (List<string>) staticInterceptor.Invoke("types$", "types(KImageIO::Mode)", typeof(List<string>), typeof(KImageIO.Mode), mode);
        }
        public static List<string> Types() {
            return (List<string>) staticInterceptor.Invoke("types", "types()", typeof(List<string>));
        }
        /// <remarks>
        ///   Returns a list of MIME types for all KImageIO supported formats.
        /// <param> name="mode" Tells whether to retrieve modes that can be read or written.
        /// </param></remarks>        <return> a list if MIME types of the supported formats
        ///    </return>
        ///         <short>     Returns a list of MIME types for all KImageIO supported formats.</short>
        public static List<string> MimeTypes(KImageIO.Mode mode) {
            return (List<string>) staticInterceptor.Invoke("mimeTypes$", "mimeTypes(KImageIO::Mode)", typeof(List<string>), typeof(KImageIO.Mode), mode);
        }
        public static List<string> MimeTypes() {
            return (List<string>) staticInterceptor.Invoke("mimeTypes", "mimeTypes()", typeof(List<string>));
        }
        /// <remarks>
        ///  Test to see whether a MIME type is supported to reading/writing.
        /// <param> name="_mimeType" the MIME type to check
        /// </param><param> name="_mode" Tells whether to check for reading or writing capabilities
        /// </param></remarks>        <return> true if the type is supported
        /// </return>
        ///         <short>    Test to see whether a MIME type is supported to reading/writing.</short>
        public static bool IsSupported(string mimeType, KImageIO.Mode mode) {
            return (bool) staticInterceptor.Invoke("isSupported$$", "isSupported(const QString&, KImageIO::Mode)", typeof(bool), typeof(string), mimeType, typeof(KImageIO.Mode), mode);
        }
        public static bool IsSupported(string mimeType) {
            return (bool) staticInterceptor.Invoke("isSupported$", "isSupported(const QString&)", typeof(bool), typeof(string), mimeType);
        }
    }
}
