.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\"
.\" $XFree86: xc/doc/man/X11/XmbTExt.man,v 1.4 2001/01/27 18:20:08 dawes Exp $
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XmbTextExtents 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XmbTextExtents, XwcTextExtents, Xutf8TextExtents \- compute text extents
.SH SYNTAX
int XmbTextExtents\^(\^\fIfont_set\fP\^, \fIstring\fP\^, \fInum_bytes\fP\^, \fIoverall_ink_return\fP\^, \fIoverall_logical_return\fP\^)
.br
      XFontSet \fIfont_set\fP\^;
.br
      char *\fIstring\fP\^;
.br
      int \fInum_bytes\fP\^;
.br
      XRectangle *\fIoverall_ink_return\fP\^;
.br
      XRectangle *\fIoverall_logical_return\fP\^;
.LP
int XwcTextExtents\^(\^\fIfont_set\fP\^, \fIstring\fP\^, \fInum_wchars\fP\^, \fIoverall_ink_return\fP\^, \fIoverall_logical_return\fP\^)
.br
      XFontSet \fIfont_set\fP\^;
.br
      wchar_t *\fIstring\fP\^;
.br
      int \fInum_wchars\fP\^;
.br
      XRectangle *\fIoverall_ink_return\fP\^;
.br
      XRectangle *\fIoverall_logical_return\fP\^;
.LP
int Xutf8TextExtents\^(\^\fIfont_set\fP\^, \fIstring\fP\^, \fInum_bytes\fP\^, \fIoverall_ink_return\fP\^, \fIoverall_logical_return\fP\^)
.br
      XFontSet \fIfont_set\fP\^;
.br
      char *\fIstring\fP\^;
.br
      int \fInum_bytes\fP\^;
.br
      XRectangle *\fIoverall_ink_return\fP\^;
.br
      XRectangle *\fIoverall_logical_return\fP\^;
.SH ARGUMENTS
.IP \fIfont_set\fP 1i
Specifies the font set.
.IP \fInum_bytes\fP 1i
Specifies the number of bytes in the string argument.
.IP \fInum_wchars\fP 1i
Specifies the number of characters in the string argument.
.ds Ov dimensions
.IP \fIoverall_ink_return\fP 1i
Returns the overall ink \*(Ov.
.IP \fIoverall_logical_return\fP 1i
Returns the overall logical \*(Ov.
.IP \fIstring\fP 1i
Specifies the character string.
.SH DESCRIPTION
The
.ZN XmbTextExtents ,
.ZN XwcTextExtents
and
.ZN Xutf8TextExtents
functions set the components of the specified overall_ink_return and
overall_logical_return
arguments to the overall bounding box of the string's image
and a logical bounding box for spacing purposes, respectively.
They return the value returned by 
.ZN XmbTextEscapement ,
.ZN XwcTextEscapement
or
.ZN Xutf8TextEscapement .
These metrics are relative to the drawing origin of the string,
using the fonts loaded for the specified font set.
.LP
If the overall_ink_return argument is non-NULL,
it is set to the bounding box of the string's character ink.
The overall_ink_return for a nondescending, horizontally drawn
Latin character is conventionally entirely above the baseline;
that is, overall_ink_return.height <= \-overall_ink_return.y.
The overall_ink_return for a nonkerned character
is entirely at, and to the right of, the origin;
that is, overall_ink_return.x >= 0.
A character consisting of a single pixel at the origin would set
overall_ink_return fields y = 0, x = 0, width = 1, and height = 1.
.LP
If the overall_logical_return argument is non-NULL,
it is set to the bounding box that provides minimum spacing
to other graphical features for the string.
Other graphical features, for example, a border surrounding the text,
should not intersect this rectangle.
.LP
When the 
.ZN XFontSet
has missing charsets,
metrics for each unavailable character are taken 
from the default string returned by 
.ZN XCreateFontSet 
so that the metrics represent the text as it will actually be drawn.
The behavior for an invalid codepoint is undefined.
.LP
The function
.ZN Xutf8TextExtents
is an XFree86 extension introduced in XFree86 4.0.2. Its presence is
indicated by the macro
.ZN X_HAVE_UTF8_STRING .
.SH "SEE ALSO"
XmbTextEscapement(3X11),
XmbTextPerCharExtents(3X11)
\fI\*(xL\fP
