/*
 * tlmfilter.c
 *
 * Copyright (C) 2000 Klaus Kudielka, Viktor Kudielka
 *
 * Read 512-byte telemetry blocks from stdin, filter them depending
 * on the first byte, and write the matching blocks to stdout.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdio.h>
#include <stdlib.h>


/* Main program */

int main(int argc, char **argv) {
  char block[512];
  unsigned long mask, value;

  if (argc != 3) {
    fprintf(stderr, "Usage: %s <mask> <value>\n", argv[0]);
    return 1;
  }

  mask = strtoul(argv[1], NULL, 0);
  value = strtoul(argv[2], NULL, 0);

  while (!feof(stdin)) {
    if (fread(block, 512, 1, stdin) == 1 && (block[0] & mask) == value) {
      fwrite(block, 512, 1, stdout);
      fflush(stdout);
    }
  }

  return 0;
}

