/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd = null;
    int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private InetAddress cachedSenderInetAddress = null;
    private int cachedSenderPort = 0;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static int ST_UNCONNECTED;
    private static int ST_CONNECTED;
    private static final int ST_KILLED = 2;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private SocketOpts.IP options = null;
    private DatagramSocket socket = null;
    private SocketAddress sender;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$DatagramChannelImpl;

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ST_UNCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * Exception decompiling
     */
    public SocketAddress receive(ByteBuffer var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (!$assertionsDisabled && n3 > n4) {
            throw new AssertionError();
        }
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer && n2 > 0) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer, n2, n3);
        }
        int n6 = Math.max(n2, 1);
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
        int n7 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2, n6, 0);
        byteBuffer2.flip();
        if (n7 > 0 && n2 > 0) {
            byteBuffer.put(byteBuffer2);
        }
        return n7;
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, int n2, int n3) throws IOException {
        int n4 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2, this.isConnected());
        if (n4 > 0) {
            byteBuffer.position(n3 + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n22;
            block23: {
                this.ensureOpen();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (inetAddress == null) {
                    throw new IOException("Target address not resolved");
                }
                Object object2 = this.stateLock;
                synchronized (object2) {
                    if (!this.isConnected()) {
                        if (socketAddress == null) {
                            throw new NullPointerException();
                        }
                        SecurityManager securityManager = System.getSecurityManager();
                        if (securityManager != null) {
                            if (inetAddress.isMulticastAddress()) {
                                securityManager.checkMulticast(inetSocketAddress.getAddress());
                            } else {
                                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                            }
                        }
                    } else if (socketAddress == null) {
                        socketAddress = this.remoteAddress;
                    } else if (!socketAddress.equals(this.remoteAddress)) {
                        throw new IllegalArgumentException("Connected address not equal to  target address");
                    }
                }
                n22 = 0;
                this.begin();
                if (this.isOpen()) break block23;
                int n3 = 0;
                this.writerThread = 0L;
                this.end(n22 > 0 || n22 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n22)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n22 = this.send(this.fd, byteBuffer, socketAddress)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n22);
                this.writerThread = 0L;
                this.end(n22 > 0 || n22 == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n22 > 0 || n22 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n22)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n22)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, socketAddress);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n2);
        int n5 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = this.send0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n2;
            int n3;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n3 = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n4 = 0;
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((n3 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n3);
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            int n2;
            int n3;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n3 = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n4 = 0;
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            try {
                this.readerThread = NativeThread.current();
                while ((n3 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n3);
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
            }
            catch (Throwable throwable) {
                this.readerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n3;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n3 = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n4 = 0;
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n3);
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            int n2;
            int n3;
            block13: {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                n3 = 0;
                this.begin();
                if (this.isOpen()) break block13;
                int n4 = 0;
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                return n4;
            }
            try {
                this.writerThread = NativeThread.current();
                while ((n3 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3 && this.isOpen()) {
                }
                n2 = IOStatus.normalize(n3);
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
            }
            catch (Throwable throwable) {
                this.writerThread = 0L;
                this.end(n3 > 0 || n3 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n3)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n3)) {
                throw new AssertionError();
            }
            return n2;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n2) throws IOException {
                        return Net.getIntOption(DatagramChannelImpl.this.fd, n2);
                    }

                    void setInt(int n2, int n3) throws IOException {
                        Net.setIntOption(DatagramChannelImpl.this.fd, n2, n3);
                    }
                };
                this.options = new SocketOptsImpl.IP(dispatcher);
            }
            return this.options;
        }
    }

    public boolean isBound() {
        return Net.localPortNumber(this.fd) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            SecurityManager securityManager;
            if (this.isConnected() && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localAddress;
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ST_CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != ST_UNCONNECTED) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n3;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n3 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2)) <= 0) {
                        throw new Error();
                    }
                    this.state = ST_CONNECTED;
                    this.remoteAddress = socketAddress;
                    this.sender = inetSocketAddress;
                    this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                    this.cachedSenderPort = inetSocketAddress.getPort();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    DatagramChannelImpl.disconnect0(this.fd);
                    this.remoteAddress = null;
                    this.state = ST_UNCONNECTED;
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l2 = this.readerThread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if ((l2 = this.writerThread) != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            if (this.state == -1) {
                this.state = 2;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if (((n2 & 1) != 0 || (n2 & 8) != 0) && (selectionKeyImpl.interestOps() & 1) != 0) {
            n3 |= 1;
        }
        if (((n2 & 4) != 0 || (n2 & 8) != 0) && (selectionKeyImpl.interestOps() & 4) != 0) {
            n3 |= 4;
        }
        selectionKeyImpl.readyOps(n3);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4, boolean var5) throws IOException;

    private native int send0(FileDescriptor var1, long var2, int var4, SocketAddress var5) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$DatagramChannelImpl == null ? (class$sun$nio$ch$DatagramChannelImpl = DatagramChannelImpl.class$("sun.nio.ch.DatagramChannelImpl")) : class$sun$nio$ch$DatagramChannelImpl).desiredAssertionStatus();
        nd = new DatagramDispatcher();
        ST_UNCONNECTED = 0;
        ST_CONNECTED = 1;
        Util.load();
        DatagramChannelImpl.initIDs();
    }
}

