/*
 *   kjots
 *   This file only: Copyright (C) 1999  Espen Sand, espensa@online.no
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlabel.h>
#include <qlayout.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kfontdialog.h>
#include <klocale.h>


#include "optiondialog.h"


ConfigureDialog::ConfigureDialog( QWidget *parent, char *name, bool modal )
  :KDialogBase( Tabbed, i18n("Configure"), Help|Apply|Ok|Cancel,
		Ok, parent, name, modal )
{
  setHelp( "kjots/index.html", QString::null );
 
  setupFontPage();

  readConfig();
  connect( this, SIGNAL(cancelClicked()), this, SLOT(readConfig()) );
}

ConfigureDialog::~ConfigureDialog( void )
{
}

void ConfigureDialog::setupFontPage( void )
{
  QFrame *page = addPage( i18n("Editor &Font") );
  if( page == 0 ) { return; }

  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  if( topLayout == 0 ) { return; }

  mFontChooser = new KFontChooser(page,"fonts",false,QStringList(),false,4);
  topLayout->addWidget( mFontChooser );
}

void ConfigureDialog::readConfig( void )
{
  KConfig &config = *kapp->config();

  config.setGroup("kjots");

  QFont font( config.readEntry("EFontFamily"), 
	      config.readNumEntry("EFontSize"),
	      config.readNumEntry("EFontWeight"), 
	      config.readNumEntry("EFontItalic"));
  mFontChooser->setFont(font);
}

void ConfigureDialog::writeConfig( void )
{
  KConfig &config = *kapp->config();

  config.setGroup("kjots");
  QFont font = mFontChooser->font();
  config.writeEntry("EFontFamily", font.family());
  config.writeEntry("EFontSize", font.pointSize());
  config.writeEntry("EFontWeight", font.weight());
  config.writeEntry("EFontItalic", font.italic());
//  config.writeEntry("EFontCharset", (int)font.charSet());
}

void ConfigureDialog::slotOk( void )
{
  slotApply();
  accept();
}


void ConfigureDialog::slotApply( void )
{
  writeConfig();
  emit valueChanged();
}


#include "optiondialog.moc"
