/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalIconFactory
implements Serializable {
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon internalFrameAltMaximizeIcon;
    private static Icon internalFrameCloseIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon internalFrameMaximizeIcon;
    private static Icon internalFrameMinimizeIcon;
    private static Icon radioButtonIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;
    private static Icon menuArrowIcon;
    private static Icon menuItemArrowIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxIcon;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;
    private static final Dimension treeControlSize;
    private static final Dimension menuArrowIconSize;
    private static final Dimension menuCheckIconSize;
    private static final int xOff = 4;

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int n2) {
        return new InternalFrameAltMaximizeIcon(n2);
    }

    public static Icon getInternalFrameCloseIcon(int n2) {
        return new InternalFrameCloseIcon(n2);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int n2) {
        return new InternalFrameMaximizeIcon(n2);
    }

    public static Icon getInternalFrameMinimizeIcon(int n2) {
        return new InternalFrameMinimizeIcon(n2);
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        return new TreeFolderIcon();
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getTreeControlIcon(boolean bl2) {
        return new TreeControlIcon(bl2);
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        return null;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getVerticalSliderThumbIcon() {
        return new VerticalSliderThumbIcon();
    }

    static {
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
        treeControlSize = new Dimension(18, 18);
        menuArrowIconSize = new Dimension(4, 8);
        menuCheckIconSize = new Dimension(10, 10);
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public HorizontalSliderThumbIcon() {
            controlBumps = new MetalBumps(10, 6, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(10, 6, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JSlider jSlider = (JSlider)component;
            graphics.translate(n2, n3);
            if (jSlider.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(1, 0, 13, 0);
            graphics.drawLine(0, 1, 0, 8);
            graphics.drawLine(14, 1, 14, 8);
            graphics.drawLine(1, 9, 7, 15);
            graphics.drawLine(7, 15, 14, 8);
            if (jSlider.hasFocus()) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            graphics.fillRect(1, 1, 13, 8);
            graphics.drawLine(2, 9, 12, 9);
            graphics.drawLine(3, 10, 11, 10);
            graphics.drawLine(4, 11, 10, 11);
            graphics.drawLine(5, 12, 9, 12);
            graphics.drawLine(6, 13, 8, 13);
            graphics.drawLine(7, 14, 7, 14);
            if (jSlider.isEnabled()) {
                if (jSlider.hasFocus()) {
                    primaryBumps.paintIcon(component, graphics, 2, 2);
                } else {
                    controlBumps.paintIcon(component, graphics, 2, 2);
                }
            }
            if (jSlider.isEnabled()) {
                graphics.setColor(jSlider.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                graphics.drawLine(1, 1, 13, 1);
                graphics.drawLine(1, 1, 1, 8);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps controlBumps;
        protected static MetalBumps primaryBumps;

        public VerticalSliderThumbIcon() {
            controlBumps = new MetalBumps(6, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlInfo(), MetalLookAndFeel.getControl());
            primaryBumps = new MetalBumps(6, 10, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            int n4;
            JSlider jSlider = (JSlider)component;
            boolean bl2 = MetalUtils.isLeftToRight(jSlider);
            graphics.translate(n2, n3);
            if (jSlider.hasFocus()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            if (bl2) {
                graphics.drawLine(1, 0, 8, 0);
                graphics.drawLine(0, 1, 0, 13);
                graphics.drawLine(1, 14, 8, 14);
                graphics.drawLine(9, 1, 15, 7);
                graphics.drawLine(9, 13, 15, 7);
            } else {
                graphics.drawLine(7, 0, 14, 0);
                graphics.drawLine(15, 1, 15, 13);
                graphics.drawLine(7, 14, 14, 14);
                graphics.drawLine(0, 7, 6, 1);
                graphics.drawLine(0, 7, 6, 13);
            }
            if (jSlider.hasFocus()) {
                graphics.setColor(component.getForeground());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            if (bl2) {
                graphics.fillRect(1, 1, 8, 13);
                graphics.drawLine(9, 2, 9, 12);
                graphics.drawLine(10, 3, 10, 11);
                graphics.drawLine(11, 4, 11, 10);
                graphics.drawLine(12, 5, 12, 9);
                graphics.drawLine(13, 6, 13, 8);
                graphics.drawLine(14, 7, 14, 7);
            } else {
                graphics.fillRect(7, 1, 8, 13);
                graphics.drawLine(6, 3, 6, 12);
                graphics.drawLine(5, 4, 5, 11);
                graphics.drawLine(4, 5, 4, 10);
                graphics.drawLine(3, 6, 3, 9);
                graphics.drawLine(2, 7, 2, 8);
            }
            int n5 = n4 = bl2 ? 2 : 8;
            if (jSlider.isEnabled()) {
                if (jSlider.hasFocus()) {
                    primaryBumps.paintIcon(component, graphics, n4, 2);
                } else {
                    controlBumps.paintIcon(component, graphics, n4, 2);
                }
            }
            if (jSlider.isEnabled()) {
                graphics.setColor(jSlider.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                if (bl2) {
                    graphics.drawLine(1, 1, 8, 1);
                    graphics.drawLine(1, 1, 1, 13);
                } else {
                    graphics.drawLine(8, 1, 14, 1);
                    graphics.drawLine(1, 7, 7, 1);
                }
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl2 = buttonModel.isSelected();
            boolean bl3 = buttonModel.isEnabled();
            boolean bl4 = buttonModel.isPressed();
            boolean bl5 = buttonModel.isArmed();
            graphics.translate(n2, n3);
            if (bl3) {
                if (bl4 || bl5) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawLine(2, 0, 6, 0);
                graphics.drawLine(2, 8, 6, 8);
                graphics.drawLine(0, 2, 0, 6);
                graphics.drawLine(8, 2, 8, 6);
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(7, 1, 7, 1);
                graphics.drawLine(1, 7, 1, 7);
                graphics.drawLine(7, 7, 7, 7);
            }
            if (bl2) {
                if (bl3) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(3, 2, 5, 2);
                graphics.drawLine(2, 3, 6, 3);
                graphics.drawLine(2, 4, 6, 4);
                graphics.drawLine(2, 5, 6, 5);
                graphics.drawLine(3, 6, 5, 6);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl2 = buttonModel.isSelected();
            boolean bl3 = buttonModel.isEnabled();
            boolean bl4 = buttonModel.isPressed();
            boolean bl5 = buttonModel.isArmed();
            graphics.translate(n2, n3);
            if (bl3) {
                if (bl4 || bl5) {
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawRect(0, 0, 8, 8);
            }
            if (bl2) {
                if (bl3) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 4, 8, 0);
                graphics.drawLine(4, 5, 9, 0);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuItemArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n2, n3);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            if (MetalUtils.isLeftToRight(jMenuItem)) {
                graphics.drawLine(0, 0, 0, 7);
                graphics.drawLine(1, 1, 1, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(3, 3, 3, 4);
            } else {
                graphics.drawLine(4, 0, 4, 7);
                graphics.drawLine(3, 1, 3, 6);
                graphics.drawLine(2, 2, 2, 5);
                graphics.drawLine(1, 3, 1, 4);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        ImageCacher imageCacher;
        transient boolean cachedOrientation = true;

        public TreeControlIcon(boolean bl2) {
            this.isLight = bl2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null || this.cachedOrientation != MetalUtils.isLeftToRight(component)) {
                this.cachedOrientation = MetalUtils.isLeftToRight(component);
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2, n2, n3);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            if (MetalUtils.isLeftToRight(component)) {
                if (this.isLight) {
                    graphics.drawImage(image, n2 + 5, n3 + 3, n2 + 18, n3 + 13, 4, 3, 17, 13, null);
                } else {
                    graphics.drawImage(image, n2 + 5, n3 + 3, n2 + 18, n3 + 17, 4, 3, 17, 17, null);
                }
            } else if (this.isLight) {
                graphics.drawImage(image, n2 + 3, n3 + 3, n2 + 16, n3 + 13, 4, 3, 17, 13, null);
            } else {
                graphics.drawImage(image, n2 + 3, n3 + 3, n2 + 16, n3 + 17, 4, 3, 17, 17, null);
            }
        }

        public void paintMe(Component component, Graphics graphics, int n2, int n3) {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            int n4 = MetalUtils.isLeftToRight(component) ? 0 : 4;
            graphics.drawLine(n4 + 4, 6, n4 + 4, 9);
            graphics.drawLine(n4 + 5, 5, n4 + 5, 5);
            graphics.drawLine(n4 + 6, 4, n4 + 9, 4);
            graphics.drawLine(n4 + 10, 5, n4 + 10, 5);
            graphics.drawLine(n4 + 11, 6, n4 + 11, 9);
            graphics.drawLine(n4 + 10, 10, n4 + 10, 10);
            graphics.drawLine(n4 + 6, 11, n4 + 9, 11);
            graphics.drawLine(n4 + 5, 10, n4 + 5, 10);
            graphics.drawLine(n4 + 7, 7, n4 + 8, 7);
            graphics.drawLine(n4 + 7, 8, n4 + 8, 8);
            if (this.isLight) {
                if (MetalUtils.isLeftToRight(component)) {
                    graphics.drawLine(12, 7, 15, 7);
                    graphics.drawLine(12, 8, 15, 8);
                } else {
                    graphics.drawLine(4, 7, 7, 7);
                    graphics.drawLine(4, 8, 7, 8);
                }
            } else {
                graphics.drawLine(n4 + 7, 12, n4 + 7, 15);
                graphics.drawLine(n4 + 8, 12, n4 + 8, 15);
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n4 + 5, 6, n4 + 5, 9);
            graphics.drawLine(n4 + 6, 5, n4 + 9, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n4 + 6, 6, n4 + 6, 6);
            graphics.drawLine(n4 + 9, 6, n4 + 9, 6);
            graphics.drawLine(n4 + 6, 9, n4 + 6, 9);
            graphics.drawLine(n4 + 10, 6, n4 + 10, 9);
            graphics.drawLine(n4 + 6, 10, n4 + 9, 10);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(n4 + 6, 7, n4 + 6, 8);
            graphics.drawLine(n4 + 7, 6, n4 + 8, 6);
            graphics.drawLine(n4 + 9, 7, n4 + 9, 7);
            graphics.drawLine(n4 + 7, 9, n4 + 7, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(n4 + 8, 9, n4 + 9, 9);
            graphics.drawLine(n4 + 9, 8, n4 + 9, 8);
        }

        public int getIconWidth() {
            return treeControlSize.width;
        }

        public int getIconHeight() {
            return treeControlSize.height;
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getShift() {
            return 2;
        }

        public int getAdditionalHeight() {
            return 4;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        ImageCacher imageCacher;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null) {
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            graphics.drawImage(image, n2, n3 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n2 = fileIcon16Size.width - 1;
            int n3 = fileIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getWindowBackground());
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 0, 2, n3);
            graphics.drawLine(2, 0, n2 - 4, 0);
            graphics.drawLine(2, n3, n2 - 1, n3);
            graphics.drawLine(n2 - 1, 6, n2 - 1, n3);
            graphics.drawLine(n2 - 6, 2, n2 - 2, 6);
            graphics.drawLine(n2 - 5, 1, n2 - 4, 1);
            graphics.drawLine(n2 - 3, 2, n2 - 3, 3);
            graphics.drawLine(n2 - 2, 4, n2 - 2, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(3, 1, 3, n3 - 1);
            graphics.drawLine(3, 1, n2 - 6, 1);
            graphics.drawLine(n2 - 2, 7, n2 - 2, n3 - 1);
            graphics.drawLine(n2 - 5, 2, n2 - 3, 4);
            graphics.drawLine(3, n3 - 1, n2 - 2, n3 - 1);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        ImageCacher imageCacher;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Image image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            if (this.imageCacher == null) {
                this.imageCacher = new ImageCacher();
            }
            if ((image = this.imageCacher.getImage(graphicsConfiguration)) == null) {
                image = graphicsConfiguration != null ? graphicsConfiguration.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 2) : new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
                this.imageCacher.cacheImage(image, graphicsConfiguration);
            }
            graphics.drawImage(image, n2, n3 + this.getShift(), null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n2 = folderIcon16Size.width - 1;
            int n3 = folderIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n2 - 5, 3, n2, 3);
            graphics.drawLine(n2 - 6, 4, n2, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 7, 13, 8);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n2 - 6, 5, n2 - 1, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 6, 0, n3);
            graphics.drawLine(1, 5, n2 - 7, 5);
            graphics.drawLine(n2 - 6, 6, n2 - 1, 6);
            graphics.drawLine(n2, 5, n2, n3);
            graphics.drawLine(0, n3, n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 6, 1, n3 - 1);
            graphics.drawLine(1, 6, n2 - 7, 6);
            graphics.drawLine(n2 - 6, 7, n2 - 1, 7);
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    static class ImageCacher {
        Vector images = new Vector(1, 1);
        ImageGcPair currentImageGcPair;

        ImageCacher() {
        }

        Image getImage(GraphicsConfiguration graphicsConfiguration) {
            if (this.currentImageGcPair == null || !this.currentImageGcPair.hasSameConfiguration(graphicsConfiguration)) {
                Enumeration enumeration = this.images.elements();
                while (enumeration.hasMoreElements()) {
                    ImageGcPair imageGcPair = (ImageGcPair)enumeration.nextElement();
                    if (!imageGcPair.hasSameConfiguration(graphicsConfiguration)) continue;
                    this.currentImageGcPair = imageGcPair;
                    return imageGcPair.image;
                }
                return null;
            }
            return this.currentImageGcPair.image;
        }

        void cacheImage(Image image, GraphicsConfiguration graphicsConfiguration) {
            ImageGcPair imageGcPair = new ImageGcPair(image, graphicsConfiguration);
            this.images.addElement(imageGcPair);
            this.currentImageGcPair = imageGcPair;
        }

        class ImageGcPair {
            Image image;
            GraphicsConfiguration gc;

            ImageGcPair(Image image, GraphicsConfiguration graphicsConfiguration) {
                this.image = image;
                this.gc = graphicsConfiguration;
            }

            boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration) {
                return graphicsConfiguration != null && graphicsConfiguration.equals(this.gc) || graphicsConfiguration == null && this.gc == null;
            }
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeFloppyDriveIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 2, 12, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 1, 13, 1);
            graphics.drawLine(14, 2, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 1, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(5, 2, 6, 5);
            graphics.drawLine(4, 8, 11, 8);
            graphics.drawLine(3, 9, 3, 13);
            graphics.drawLine(12, 9, 12, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.fillRect(8, 3, 2, 3);
            graphics.fillRect(4, 9, 8, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(5, 10, 9, 10);
            graphics.drawLine(5, 12, 8, 12);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeHardDriveIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 4, 1, 5);
            graphics.drawLine(2, 3, 3, 3);
            graphics.drawLine(4, 2, 11, 2);
            graphics.drawLine(12, 3, 13, 3);
            graphics.drawLine(14, 4, 14, 5);
            graphics.drawLine(12, 6, 13, 6);
            graphics.drawLine(4, 7, 11, 7);
            graphics.drawLine(2, 6, 3, 6);
            graphics.drawLine(1, 7, 1, 8);
            graphics.drawLine(2, 9, 3, 9);
            graphics.drawLine(4, 10, 11, 10);
            graphics.drawLine(12, 9, 13, 9);
            graphics.drawLine(14, 7, 14, 8);
            graphics.drawLine(1, 10, 1, 11);
            graphics.drawLine(2, 12, 3, 12);
            graphics.drawLine(4, 13, 11, 13);
            graphics.drawLine(12, 12, 13, 12);
            graphics.drawLine(14, 10, 14, 11);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(7, 6, 7, 6);
            graphics.drawLine(9, 6, 9, 6);
            graphics.drawLine(10, 5, 10, 5);
            graphics.drawLine(11, 6, 11, 6);
            graphics.drawLine(12, 5, 13, 5);
            graphics.drawLine(13, 4, 13, 4);
            graphics.drawLine(7, 9, 7, 9);
            graphics.drawLine(9, 9, 9, 9);
            graphics.drawLine(10, 8, 10, 8);
            graphics.drawLine(11, 9, 11, 9);
            graphics.drawLine(12, 8, 13, 8);
            graphics.drawLine(13, 7, 13, 7);
            graphics.drawLine(7, 12, 7, 12);
            graphics.drawLine(9, 12, 9, 12);
            graphics.drawLine(10, 11, 10, 11);
            graphics.drawLine(11, 12, 11, 12);
            graphics.drawLine(12, 11, 13, 11);
            graphics.drawLine(13, 10, 13, 10);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(4, 3, 5, 3);
            graphics.drawLine(7, 3, 9, 3);
            graphics.drawLine(11, 3, 11, 3);
            graphics.drawLine(2, 4, 6, 4);
            graphics.drawLine(8, 4, 8, 4);
            graphics.drawLine(2, 5, 3, 5);
            graphics.drawLine(4, 6, 4, 6);
            graphics.drawLine(2, 7, 3, 7);
            graphics.drawLine(2, 8, 3, 8);
            graphics.drawLine(4, 9, 4, 9);
            graphics.drawLine(2, 10, 3, 10);
            graphics.drawLine(2, 11, 3, 11);
            graphics.drawLine(4, 12, 4, 12);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        private TreeComputerIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(5, 4, 6, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 2, 8);
            graphics.drawLine(13, 2, 13, 8);
            graphics.drawLine(3, 1, 12, 1);
            graphics.drawLine(12, 9, 12, 9);
            graphics.drawLine(3, 9, 3, 9);
            graphics.drawLine(4, 4, 4, 7);
            graphics.drawLine(5, 3, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(5, 8, 10, 8);
            graphics.drawLine(1, 10, 14, 10);
            graphics.drawLine(14, 10, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 10, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(6, 12, 8, 12);
            graphics.drawLine(10, 12, 12, 12);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            boolean bl2 = buttonModel.isSelected();
            Color color = component.getBackground();
            Color color2 = component.getForeground();
            ColorUIResource colorUIResource = MetalLookAndFeel.getControlShadow();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getControlDarkShadow();
            Color color3 = MetalLookAndFeel.getControlHighlight();
            Color color4 = MetalLookAndFeel.getControlHighlight();
            Color color5 = color;
            if (!buttonModel.isEnabled()) {
                color3 = color4 = color;
                color2 = colorUIResource;
                colorUIResource2 = color2;
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                color5 = colorUIResource;
                color3 = color5;
            }
            graphics.translate(n2, n3);
            graphics.setColor(color5);
            graphics.fillRect(2, 2, 9, 9);
            graphics.setColor(colorUIResource2);
            graphics.drawLine(4, 0, 7, 0);
            graphics.drawLine(8, 1, 9, 1);
            graphics.drawLine(10, 2, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(10, 8, 10, 9);
            graphics.drawLine(9, 10, 8, 10);
            graphics.drawLine(7, 11, 4, 11);
            graphics.drawLine(3, 10, 2, 10);
            graphics.drawLine(1, 9, 1, 8);
            graphics.drawLine(0, 7, 0, 4);
            graphics.drawLine(1, 3, 1, 2);
            graphics.drawLine(2, 1, 3, 1);
            graphics.setColor(color3);
            graphics.drawLine(2, 9, 2, 8);
            graphics.drawLine(1, 7, 1, 4);
            graphics.drawLine(2, 2, 2, 3);
            graphics.drawLine(2, 2, 3, 2);
            graphics.drawLine(4, 1, 7, 1);
            graphics.drawLine(8, 2, 9, 2);
            graphics.setColor(color4);
            graphics.drawLine(10, 1, 10, 1);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 4, 12, 7);
            graphics.drawLine(11, 8, 11, 9);
            graphics.drawLine(10, 10, 10, 10);
            graphics.drawLine(9, 11, 8, 11);
            graphics.drawLine(7, 12, 4, 12);
            graphics.drawLine(3, 11, 2, 11);
            if (bl2) {
                graphics.setColor(color2);
                graphics.fillRect(4, 4, 4, 4);
                graphics.drawLine(4, 3, 7, 3);
                graphics.drawLine(8, 4, 8, 7);
                graphics.drawLine(7, 8, 4, 8);
                graphics.drawLine(3, 7, 3, 4);
            }
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            int n4 = this.getControlSize();
            boolean bl2 = buttonModel.isSelected();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    graphics.setColor(MetalLookAndFeel.getControlShadow());
                    graphics.fillRect(n2, n3, n4 - 1, n4 - 1);
                    MetalUtils.drawPressed3DBorder(graphics, n2, n3, n4, n4);
                } else {
                    MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n4);
                }
                graphics.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
            }
            if (buttonModel.isSelected()) {
                this.drawCheck(component, graphics, n2, n3);
            }
        }

        protected void drawCheck(Component component, Graphics graphics, int n2, int n3) {
            int n4 = this.getControlSize();
            graphics.fillRect(n2 + 3, n3 + 5, 2, n4 - 8);
            graphics.drawLine(n2 + (n4 - 4), n3 + 3, n2 + 5, n3 + (n4 - 6));
            graphics.drawLine(n2 + (n4 - 4), n3 + 4, n2 + 5, n3 + (n4 - 5));
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameMinimizeIcon(int n2) {
            this.iconSize = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(4, 11, this.iconSize - 13, this.iconSize - 13);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 10, this.iconSize - 10, this.iconSize - 11);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 10, this.iconSize - 12, this.iconSize - 12);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 8, this.iconSize - 10, this.iconSize - 10);
            graphics.drawRect(2, 9, this.iconSize - 12, this.iconSize - 12);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 9, this.iconSize - 11, this.iconSize - 11);
            graphics.drawLine(this.iconSize - 10, 10, this.iconSize - 10, 10);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(this.iconSize - 7, 3, 3, 5);
            graphics.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            graphics.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            graphics.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            graphics.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            graphics.drawLine(this.iconSize - 7, 8, this.iconSize - 3, 8);
            graphics.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        protected int iconSize = 16;

        public InternalFrameMaximizeIcon(int n2) {
            this.iconSize = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 7, this.iconSize - 10, this.iconSize - 10);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 5, this.iconSize - 7, this.iconSize - 7);
            graphics.drawRect(2, 6, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(3, this.iconSize - 5, this.iconSize - 9, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 5, 3);
            graphics.drawLine(this.iconSize - 7, 1, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 6, 1, this.iconSize - 2, 1);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(5, this.iconSize - 4, this.iconSize - 8, 9);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 4, 5);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 4, 6);
            graphics.drawLine(this.iconSize - 2, 7, this.iconSize - 1, 7);
            graphics.drawLine(this.iconSize - 1, 2, this.iconSize - 1, 6);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(3, this.iconSize - 4, this.iconSize - 3, 2);
            graphics.drawLine(3, this.iconSize - 3, this.iconSize - 2, 2);
            graphics.drawLine(4, this.iconSize - 3, 5, this.iconSize - 3);
            graphics.drawLine(this.iconSize - 7, 8, this.iconSize - 7, 9);
            graphics.drawLine(this.iconSize - 6, 2, this.iconSize - 4, 2);
            graphics.drawRect(this.iconSize - 3, 3, 1, 3);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        private InternalFrameDefaultMenuIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            ColorUIResource colorUIResource = MetalLookAndFeel.getWindowBackground();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(0, 0, 16, 16);
            graphics.setColor(colorUIResource);
            graphics.fillRect(2, 6, 13, 9);
            graphics.drawLine(2, 2, 2, 2);
            graphics.drawLine(5, 2, 5, 2);
            graphics.drawLine(8, 2, 8, 2);
            graphics.drawLine(11, 2, 11, 2);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(1, 1, 13, 13);
            graphics.drawLine(1, 0, 14, 0);
            graphics.drawLine(15, 1, 15, 14);
            graphics.drawLine(1, 15, 14, 15);
            graphics.drawLine(0, 1, 0, 14);
            graphics.drawLine(2, 5, 13, 5);
            graphics.drawLine(3, 3, 3, 3);
            graphics.drawLine(6, 3, 6, 3);
            graphics.drawLine(9, 3, 9, 3);
            graphics.drawLine(12, 3, 12, 3);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameAltMaximizeIcon(int n2) {
            this.iconSize = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 6, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 5, this.iconSize - 8, this.iconSize - 8);
            graphics.drawLine(1, this.iconSize - 2, 1, this.iconSize - 2);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 6, this.iconSize - 7, this.iconSize - 7);
            graphics.setColor(colorUIResource5);
            graphics.drawRect(3, 7, this.iconSize - 9, this.iconSize - 9);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 6, this.iconSize - 8, this.iconSize - 8);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(this.iconSize - 6, 8, this.iconSize - 6, 8);
            graphics.drawLine(this.iconSize - 9, 6, this.iconSize - 7, 8);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 6, 9, this.iconSize - 6, 9);
            graphics.setColor(colorUIResource);
            graphics.drawLine(this.iconSize - 9, 5, this.iconSize - 9, 5);
            graphics.setColor(colorUIResource3);
            graphics.fillRect(this.iconSize - 7, 3, 3, 5);
            graphics.drawLine(this.iconSize - 6, 5, this.iconSize - 3, 2);
            graphics.drawLine(this.iconSize - 6, 6, this.iconSize - 2, 2);
            graphics.drawLine(this.iconSize - 6, 7, this.iconSize - 3, 7);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(this.iconSize - 8, 2, this.iconSize - 7, 2);
            graphics.drawLine(this.iconSize - 8, 3, this.iconSize - 8, 7);
            graphics.drawLine(this.iconSize - 6, 4, this.iconSize - 3, 1);
            graphics.drawLine(this.iconSize - 4, 6, this.iconSize - 3, 6);
            graphics.setColor(colorUIResource6);
            graphics.drawLine(this.iconSize - 6, 3, this.iconSize - 6, 3);
            graphics.drawLine(this.iconSize - 4, 5, this.iconSize - 2, 3);
            graphics.drawLine(this.iconSize - 4, 8, this.iconSize - 3, 8);
            graphics.drawLine(this.iconSize - 2, 8, this.iconSize - 2, 7);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 16;

        public InternalFrameCloseIcon(int n2) {
            this.iconSize = n2;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControl();
            ColorUIResource colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource colorUIResource4 = MetalLookAndFeel.getBlack();
            ColorUIResource colorUIResource5 = MetalLookAndFeel.getWhite();
            ColorUIResource colorUIResource6 = MetalLookAndFeel.getWhite();
            if (jButton.getClientProperty("paintActive") != Boolean.TRUE) {
                colorUIResource2 = colorUIResource = MetalLookAndFeel.getControl();
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getControlShadow();
                    colorUIResource3 = colorUIResource4;
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                colorUIResource5 = colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource3 = colorUIResource4;
            }
            int n4 = this.iconSize / 2;
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(3, 3, this.iconSize - 6, this.iconSize - 6);
            graphics.setColor(colorUIResource4);
            graphics.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            graphics.drawRect(2, 2, this.iconSize - 5, this.iconSize - 5);
            graphics.setColor(colorUIResource6);
            graphics.drawRect(2, 2, this.iconSize - 3, this.iconSize - 3);
            graphics.setColor(colorUIResource3);
            graphics.drawRect(2, 2, this.iconSize - 4, this.iconSize - 4);
            graphics.drawLine(3, this.iconSize - 3, 3, this.iconSize - 3);
            graphics.drawLine(this.iconSize - 3, 3, this.iconSize - 3, 3);
            graphics.setColor(colorUIResource4);
            graphics.drawLine(4, 5, 5, 4);
            graphics.drawLine(4, this.iconSize - 6, this.iconSize - 6, 4);
            graphics.setColor(colorUIResource5);
            graphics.drawLine(6, this.iconSize - 5, this.iconSize - 5, 6);
            graphics.drawLine(n4, n4 + 2, n4 + 2, n4);
            graphics.drawLine(this.iconSize - 5, this.iconSize - 5, this.iconSize - 4, this.iconSize - 5);
            graphics.drawLine(this.iconSize - 5, this.iconSize - 4, this.iconSize - 5, this.iconSize - 4);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(5, 5, this.iconSize - 6, this.iconSize - 6);
            graphics.drawLine(6, 5, this.iconSize - 5, this.iconSize - 6);
            graphics.drawLine(5, 6, this.iconSize - 6, this.iconSize - 5);
            graphics.drawLine(5, this.iconSize - 5, this.iconSize - 5, 5);
            graphics.drawLine(5, this.iconSize - 6, this.iconSize - 6, 5);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    UIResource,
    Serializable {
        int iconSize = 7;

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            ColorUIResource colorUIResource = MetalLookAndFeel.getPrimaryControlHighlight();
            ColorUIResource colorUIResource2 = MetalLookAndFeel.getPrimaryControlInfo();
            ColorUIResource colorUIResource3 = buttonModel.isPressed() && buttonModel.isArmed() ? colorUIResource2 : MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.translate(n2, n3);
            graphics.setColor(colorUIResource3);
            graphics.drawLine(0, 1, 5, 6);
            graphics.drawLine(1, 0, 6, 5);
            graphics.drawLine(1, 1, 6, 6);
            graphics.drawLine(6, 1, 1, 6);
            graphics.drawLine(5, 0, 0, 5);
            graphics.drawLine(5, 1, 1, 5);
            graphics.setColor(colorUIResource);
            graphics.drawLine(6, 2, 5, 3);
            graphics.drawLine(2, 6, 3, 5);
            graphics.drawLine(6, 6, 6, 6);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class FileChooserUpFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserUpFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.drawLine(8, 13, 8, 16);
            graphics.drawLine(8, 9, 8, 9);
            graphics.drawLine(7, 10, 9, 10);
            graphics.drawLine(6, 11, 10, 11);
            graphics.drawLine(5, 12, 11, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserNewFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserListViewIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(10, 2, 13, 2);
            graphics.drawLine(10, 3, 10, 7);
            graphics.drawLine(11, 7, 14, 7);
            graphics.drawLine(14, 6, 14, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(10, 10, 13, 10);
            graphics.drawLine(10, 11, 10, 15);
            graphics.drawLine(11, 15, 14, 15);
            graphics.drawLine(14, 14, 14, 11);
            graphics.drawLine(8, 5, 8, 5);
            graphics.drawLine(16, 5, 16, 5);
            graphics.drawLine(8, 13, 8, 13);
            graphics.drawLine(16, 13, 16, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(11, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.drawRect(11, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(12, 4, 12, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.drawLine(12, 12, 12, 13);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserHomeFolderIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(8, 1, 1, 8);
            graphics.drawLine(8, 1, 15, 8);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 2, 12, 4);
            graphics.drawLine(3, 7, 3, 15);
            graphics.drawLine(13, 7, 13, 15);
            graphics.drawLine(4, 15, 12, 15);
            graphics.drawLine(6, 9, 6, 14);
            graphics.drawLine(10, 9, 10, 14);
            graphics.drawLine(7, 9, 9, 9);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(8, 2, 1, 1);
            graphics.fillRect(7, 3, 3, 1);
            graphics.fillRect(6, 4, 5, 1);
            graphics.fillRect(5, 5, 7, 1);
            graphics.fillRect(4, 6, 9, 2);
            graphics.drawLine(9, 12, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(4, 8, 12, 8);
            graphics.fillRect(4, 9, 2, 6);
            graphics.fillRect(11, 9, 2, 6);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        private FileChooserDetailViewIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(8, 5, 15, 5);
            graphics.drawLine(8, 13, 15, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.translate(-n2, -n3);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }
    }
}

