/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.colorchooser.SyntheticImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    private AbstractHSBImage palette;
    private AbstractHSBImage sliderPalette;
    private AbstractHSBImage satbrightImage;
    private AbstractHSBImage hueImage;
    private AbstractHSBImage huebrightImage;
    private AbstractHSBImage satImage;
    private AbstractHSBImage huesatImage;
    private AbstractHSBImage brightImage;
    private JSlider slider;
    private JSpinner hField;
    private JSpinner sField;
    private JSpinner bField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private boolean isAdjusting = false;
    private Point paletteSelection = new Point();
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private JRadioButton hRadio;
    private JRadioButton sRadio;
    private JRadioButton bRadio;
    private Image paletteImage;
    private Image sliderImage;
    private static final int PALETTE_DIMENSION = 200;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private int sliderType = 0;
    private static final int HUE_SLIDER = 0;
    private static final int SATURATION_SLIDER = 1;
    private static final int BRIGHTNESS_SLIDER = 2;

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                float[] fArray = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(mouseEvent.getX(), mouseEvent.getY(), fArray);
                DefaultHSBChooserPanel.this.updateHSB(fArray[0], fArray[1], fArray[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n2 = DefaultHSBChooserPanel.this.paletteLabel.getWidth();
                int n3 = DefaultHSBChooserPanel.this.paletteLabel.getHeight();
                int n4 = mouseEvent.getX();
                int n5 = mouseEvent.getY();
                if (n4 >= n2) {
                    n4 = n2 - 1;
                }
                if (n5 >= n3) {
                    n5 = n3 - 1;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                float[] fArray = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(n4, n5, fArray);
                DefaultHSBChooserPanel.this.updateHSB(fArray[0], fArray[1], fArray[2]);
            }
        });
    }

    private void updatePalette(float f2, float f3, float f4) {
        int n2 = 0;
        int n3 = 0;
        switch (this.sliderType) {
            case 0: {
                if (f2 != this.palette.getHue()) {
                    this.palette.setHue(f2);
                    this.palette.nextFrame(0);
                }
                n2 = 200 - (int)(f3 * 200.0f);
                n3 = 200 - (int)(f4 * 200.0f);
                break;
            }
            case 1: {
                if (f3 != this.palette.getSaturation()) {
                    this.palette.setSaturation(f3);
                    this.palette.nextFrame(0);
                }
                n2 = (int)(f2 * 200.0f);
                n3 = 200 - (int)(f4 * 200.0f);
                break;
            }
            case 2: {
                if (f4 != this.palette.getBrightness()) {
                    this.palette.setBrightness(f4);
                    this.palette.nextFrame(0);
                }
                n2 = (int)(f2 * 200.0f);
                n3 = 200 - (int)(f3 * 200.0f);
            }
        }
        this.paletteSelection.setLocation(n2, n3);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float f2, float f3, float f4) {
        if (this.sliderType != 0 && f2 != this.sliderPalette.getHue()) {
            this.sliderPalette.setHue(f2);
            this.sliderPalette.nextFrame(0);
        }
        float f5 = 0.0f;
        switch (this.sliderType) {
            case 0: {
                f5 = f2;
                break;
            }
            case 1: {
                f5 = f3;
                break;
            }
            case 2: {
                f5 = f4;
            }
        }
        this.slider.setValue(Math.round(f5 * (float)this.slider.getMaximum()));
    }

    private void updateHSBTextFields(float f2, float f3, float f4) {
        int n2 = Math.round(f2 * 359.0f);
        int n3 = Math.round(f3 * 100.0f);
        int n4 = Math.round(f4 * 100.0f);
        if ((Integer)this.hField.getValue() != n2) {
            this.hField.setValue(new Integer(n2));
        }
        if ((Integer)this.sField.getValue() != n3) {
            this.sField.setValue(new Integer(n3));
        }
        if ((Integer)this.bField.getValue() != n4) {
            this.bField.setValue(new Integer(n4));
        }
    }

    private void updateRGBTextFields(Color color) {
        this.redField.setText(String.valueOf(color.getRed()));
        this.greenField.setText(String.valueOf(color.getGreen()));
        this.blueField.setText(String.valueOf(color.getBlue()));
    }

    private void updateHSB(float f2, float f3, float f4) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(f2, f3, f4);
            this.updateSlider(f2, f3, f4);
            this.updateHSBTextFields(f2, f3, f4);
            Color color = Color.getHSBColor(f2, f3, f4);
            this.updateRGBTextFields(color);
            this.getColorSelectionModel().setSelectedColor(color);
            this.isAdjusting = false;
        }
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            float[] fArray = this.getHSBColorFromModel();
            this.updateHSB(fArray[0], fArray[1], fArray[2]);
        }
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
    }

    private float[] getHSBColorFromModel() {
        Color color = this.getColorFromModel();
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray;
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        JComponent jComponent = this.buildSliderPalettePanel();
        this.add((Component)jComponent, "Before");
        JPanel jPanel = new JPanel(new SmartGridLayout(1, 3));
        JComponent jComponent2 = this.buildHSBControls();
        jPanel.add(jComponent2);
        jPanel.add(new JLabel(" "));
        JComponent jComponent3 = this.buildRGBControls();
        jPanel.add(jComponent3);
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)jPanel, "Center");
    }

    private JComponent buildRGBControls() {
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        Color color = this.getColorFromModel();
        this.redField = new JTextField(String.valueOf(color.getRed()), 3);
        this.redField.setEditable(false);
        this.redField.setHorizontalAlignment(4);
        this.greenField = new JTextField(String.valueOf(color.getGreen()), 3);
        this.greenField.setEditable(false);
        this.greenField.setHorizontalAlignment(4);
        this.blueField = new JTextField(String.valueOf(color.getBlue()), 3);
        this.blueField.setEditable(false);
        this.blueField.setHorizontalAlignment(4);
        String string = UIManager.getString("ColorChooser.hsbRedText");
        String string2 = UIManager.getString("ColorChooser.hsbGreenText");
        String string3 = UIManager.getString("ColorChooser.hsbBlueText");
        jPanel.add(new JLabel(string));
        jPanel.add(this.redField);
        jPanel.add(new JLabel(string2));
        jPanel.add(this.greenField);
        jPanel.add(new JLabel(string3));
        jPanel.add(this.blueField);
        return jPanel;
    }

    private JComponent buildHSBControls() {
        String string = UIManager.getString("ColorChooser.hsbHueText");
        String string2 = UIManager.getString("ColorChooser.hsbSaturationText");
        String string3 = UIManager.getString("ColorChooser.hsbBrightnessText");
        RadioButtonHandler radioButtonHandler = new RadioButtonHandler();
        this.hRadio = new JRadioButton(string);
        this.hRadio.addActionListener(radioButtonHandler);
        this.hRadio.setSelected(true);
        this.sRadio = new JRadioButton(string2);
        this.sRadio.addActionListener(radioButtonHandler);
        this.bRadio = new JRadioButton(string3);
        this.bRadio.addActionListener(radioButtonHandler);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hRadio);
        buttonGroup.add(this.sRadio);
        buttonGroup.add(this.bRadio);
        float[] fArray = this.getHSBColorFromModel();
        this.hField = new JSpinner(new SpinnerNumberModel((int)(fArray[0] * 359.0f), 0, 359, 1));
        this.sField = new JSpinner(new SpinnerNumberModel((int)(fArray[1] * 100.0f), 0, 100, 1));
        this.bField = new JSpinner(new SpinnerNumberModel((int)(fArray[2] * 100.0f), 0, 100, 1));
        this.hField.addChangeListener(this);
        this.sField.addChangeListener(this);
        this.bField.addChangeListener(this);
        JPanel jPanel = new JPanel(new SmartGridLayout(2, 3));
        jPanel.add(this.hRadio);
        jPanel.add(this.hField);
        jPanel.add(this.sRadio);
        jPanel.add(this.sField);
        jPanel.add(this.bRadio);
        jPanel.add(this.bField);
        return jPanel;
    }

    private void setHueMode() {
        float[] fArray = this.getHSBColorFromModel();
        if (this.satbrightImage == null && this.hueImage == null) {
            this.satbrightImage = new SaturationBrightnessImage(200, 200, fArray[0]);
            this.hueImage = new HueImage(16, 200);
        } else {
            this.satbrightImage.setHue(fArray[0]);
        }
        this.setMode(0, 359, true, this.satbrightImage, this.hueImage);
    }

    private void setSaturationMode() {
        float[] fArray = this.getHSBColorFromModel();
        if (this.huebrightImage == null && this.satImage == null) {
            this.huebrightImage = new HueBrightnessImage(200, 200, fArray[0], fArray[1]);
            this.satImage = new SaturationImage(16, 200, fArray[0]);
        } else {
            this.huebrightImage.setHue(fArray[0]);
            this.huebrightImage.setBrightness(fArray[1]);
            this.satImage.setHue(fArray[0]);
        }
        this.setMode(1, 100, false, this.huebrightImage, this.satImage);
    }

    private void setBrightnessMode() {
        float[] fArray = this.getHSBColorFromModel();
        if (this.huesatImage == null && this.brightImage == null) {
            this.huesatImage = new HueSaturationImage(200, 200, fArray[0], fArray[2]);
            this.brightImage = new BrightnessImage(16, 200, fArray[0]);
        } else {
            this.huesatImage.setHue(fArray[0]);
            this.huesatImage.setBrightness(fArray[2]);
            this.brightImage.setHue(fArray[0]);
        }
        this.setMode(2, 100, false, this.huesatImage, this.brightImage);
    }

    private void setMode(int n2, int n3, boolean bl2, AbstractHSBImage abstractHSBImage, AbstractHSBImage abstractHSBImage2) {
        this.isAdjusting = true;
        this.sliderType = n2;
        this.slider.setInverted(bl2);
        this.slider.setMaximum(n3);
        this.palette = abstractHSBImage;
        if (this.paletteImage != null) {
            this.paletteImage.flush();
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPalette = abstractHSBImage2;
        if (this.sliderImage != null) {
            this.sliderImage.flush();
        }
        this.sliderImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderImage));
        this.isAdjusting = false;
    }

    protected JComponent buildSliderPalettePanel() {
        this.slider = new JSlider(1, 0, 359, 0);
        this.slider.setPaintTrack(false);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width, 215));
        this.slider.addChangeListener(this);
        this.paletteLabel = this.createPaletteLabel();
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.add(this.paletteLabel);
        jPanel.add(this.slider);
        jPanel.add(this.sliderPaletteLabel);
        this.setHueMode();
        return jPanel;
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(Color.white);
                graphics.drawOval(((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.x - 4, ((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.hsbNameText");
    }

    public int getMnemonic() {
        return AbstractColorChooserPanel.getInt("ColorChooser.hsbMnemonic", -1);
    }

    public int getDisplayedMnemonicIndex() {
        return AbstractColorChooserPanel.getInt("ColorChooser.hsbDisplayedMnemonicIndex", -1);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.slider) {
            boolean bl2 = this.slider.getModel().getValueIsAdjusting();
            if (!bl2 && !this.isAdjusting) {
                int n2 = this.slider.getValue();
                int n3 = this.slider.getMaximum();
                float f2 = (float)n2 / (float)n3;
                float[] fArray = this.getHSBColorFromModel();
                switch (this.sliderType) {
                    case 0: {
                        this.updateHSB(f2, fArray[1], fArray[2]);
                        break;
                    }
                    case 1: {
                        this.updateHSB(fArray[0], f2, fArray[2]);
                        break;
                    }
                    case 2: {
                        this.updateHSB(fArray[0], fArray[1], f2);
                    }
                }
            }
        } else if (changeEvent.getSource() instanceof JSpinner) {
            float f3 = ((Integer)this.hField.getValue()).floatValue() / 359.0f;
            float f4 = ((Integer)this.sField.getValue()).floatValue() / 100.0f;
            float f5 = ((Integer)this.bField.getValue()).floatValue() / 100.0f;
            this.updateHSB(f3, f4, f5);
        }
    }

    class HueImage
    extends AbstractHSBImage {
        public HueImage(int n2, int n3) {
            super(n2, n3, 0.0f, 1.0f, 1.0f);
        }

        protected boolean isStatic() {
            return true;
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = 1.0f / (float)this.height;
            fArray[0] = (float)n3 * f2;
            fArray[1] = this.s;
            fArray[2] = this.b;
        }
    }

    class SaturationImage
    extends AbstractHSBImage {
        protected int cachedY;
        protected int cachedColor;

        public SaturationImage(int n2, int n3, float f2) {
            super(n2, n3, f2, 1.0f, 1.0f);
            this.cachedY = -1;
            this.cachedColor = 0;
        }

        public int getRGBForLocation(int n2, int n3) {
            if (n3 != this.cachedY) {
                this.cachedY = n3;
                this.cachedColor = super.getRGBForLocation(n2, n3);
            }
            return this.cachedColor;
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = (float)n3 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s - f2;
            fArray[2] = this.b;
        }
    }

    class BrightnessImage
    extends AbstractHSBImage {
        protected int cachedY;
        protected int cachedColor;

        public BrightnessImage(int n2, int n3, float f2) {
            super(n2, n3, f2, 1.0f, 1.0f);
            this.cachedY = -1;
            this.cachedColor = 0;
        }

        public int getRGBForLocation(int n2, int n3) {
            if (n3 != this.cachedY) {
                this.cachedY = n3;
                this.cachedColor = super.getRGBForLocation(n2, n3);
            }
            return this.cachedColor;
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = (float)n3 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s;
            fArray[2] = this.b - f2;
        }
    }

    class HueSaturationImage
    extends AbstractHSBImage {
        public HueSaturationImage(int n2, int n3, float f2, float f3) {
            super(n2, n3, f2, 1.0f, f3);
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = (float)n3 / (float)this.height;
            float f3 = 1.0f / (float)this.width;
            fArray[0] = (float)n2 * f3;
            fArray[1] = 1.0f - f2;
            fArray[2] = this.b;
        }
    }

    class HueBrightnessImage
    extends AbstractHSBImage {
        public HueBrightnessImage(int n2, int n3, float f2, float f3) {
            super(n2, n3, f2, f3, 1.0f);
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = (float)n3 / (float)this.height;
            float f3 = 1.0f / (float)this.width;
            fArray[0] = (float)n2 * f3;
            fArray[1] = this.s;
            fArray[2] = 1.0f - f2;
        }
    }

    class SaturationBrightnessImage
    extends AbstractHSBImage {
        public SaturationBrightnessImage(int n2, int n3, float f2) {
            super(n2, n3, f2, 1.0f, 1.0f);
        }

        public void getHSBForLocation(int n2, int n3, float[] fArray) {
            float f2 = (float)n2 / (float)this.width;
            float f3 = (float)n3 / (float)this.height;
            fArray[0] = this.h;
            fArray[1] = this.s - f2;
            fArray[2] = this.b - f3;
        }
    }

    abstract class AbstractHSBImage
    extends SyntheticImage {
        protected float h;
        protected float s;
        protected float b;
        protected float[] hsb;
        protected boolean isDirty;

        protected AbstractHSBImage(int n2, int n3, float f2, float f3, float f4) {
            super(n2, n3);
            this.h = 0.0f;
            this.s = 0.0f;
            this.b = 0.0f;
            this.hsb = new float[3];
            this.isDirty = true;
            this.setHSB(f2, f3, f4);
            DefaultHSBChooserPanel.this.addHierarchyListener(new ThreadStopper());
        }

        public void setHSB(float f2, float f3, float f4) {
            this.setHue(f2);
            this.setSaturation(f3);
            this.setBrightness(f4);
        }

        public final void setHue(float f2) {
            this.h = f2;
        }

        public final void setSaturation(float f2) {
            this.s = f2;
        }

        public final void setBrightness(float f2) {
            this.b = f2;
        }

        public final float getHue() {
            return this.h;
        }

        public final float getSaturation() {
            return this.s;
        }

        public final float getBrightness() {
            return this.b;
        }

        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame(int n2) {
            this.isDirty = true;
            this.notifyAll();
        }

        public int getRGBForLocation(int n2, int n3) {
            this.getHSBForLocation(n2, n3, this.hsb);
            return Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        }

        public abstract void getHSBForLocation(int var1, int var2, float[] var3);

        public synchronized void addConsumer(ImageConsumer imageConsumer) {
            this.isDirty = true;
            super.addConsumer(imageConsumer);
        }

        public synchronized void removeConsumer(ImageConsumer imageConsumer) {
            super.removeConsumer(imageConsumer);
            this.isDirty = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void computeRow(int n2, int[] nArray) {
            if (n2 == 0) {
                AbstractHSBImage abstractHSBImage = this;
                synchronized (abstractHSBImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                    this.isDirty = false;
                }
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = this.getRGBForLocation(n3, n2);
                ++n3;
            }
        }

        class ThreadStopper
        implements HierarchyListener {
            ThreadStopper() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() | 4L) != 0L) {
                    if (DefaultHSBChooserPanel.this.isShowing()) {
                        AbstractHSBImage.this.setIsUseful(true);
                        AbstractHSBImage.this.isDirty = true;
                        AbstractHSBImage.this.restartProduction();
                    } else {
                        AbstractHSBImage.this.setIsUseful(false);
                        AbstractHSBImage.this.isDirty = true;
                        AbstractHSBImage abstractHSBImage = AbstractHSBImage.this;
                        synchronized (abstractHSBImage) {
                            AbstractHSBImage.this.notifyAll();
                        }
                    }
                }
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                JRadioButton jRadioButton = (JRadioButton)object;
                if (jRadioButton == DefaultHSBChooserPanel.this.hRadio) {
                    DefaultHSBChooserPanel.this.setHueMode();
                }
                if (jRadioButton == DefaultHSBChooserPanel.this.sRadio) {
                    DefaultHSBChooserPanel.this.setSaturationMode();
                }
                if (jRadioButton == DefaultHSBChooserPanel.this.bRadio) {
                    DefaultHSBChooserPanel.this.setBrightnessMode();
                }
                DefaultHSBChooserPanel.this.updateChooser();
                DefaultHSBChooserPanel.this.repaint();
            }
        }
    }
}

