/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.MidiInDeviceProvider;
import com.sun.media.sound.Printer;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private static Thread midiInThread = null;
    private static Vector devices = new Vector();
    ShortMessage shortMessage = new ShortMessage();
    private Vector transmitters = new Vector();

    MidiInDevice(MidiInDeviceProvider.MidiInDeviceInfo midiInDeviceInfo) {
        super(midiInDeviceInfo);
        if (Printer.trace) {
            Printer.trace(">> MidiInDevice CONSTRUCTOR");
        }
        if (Printer.trace) {
            Printer.trace("<< MidiInDevice CONSTRUCTOR completed");
        }
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        devices.addElement(this);
        if (midiInThread == null) {
            midiInThread = new Thread(this);
            midiInThread.start();
        }
        try {
            this.nStart(this.id);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            devices.removeElement(this);
            throw midiUnavailableException;
        }
    }

    synchronized void implClose() {
        int n2 = 0;
        while (n2 < this.transmitters.size()) {
            ((Transmitter)this.transmitters.elementAt(n2)).close();
            ++n2;
        }
        this.transmitters.removeAllElements();
        devices.removeElement(this);
        long l2 = this.id;
        this.id = 0L;
        this.nStop(l2);
        this.nClose(l2);
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        MidiInTransmitter midiInTransmitter = new MidiInTransmitter();
        this.transmitters.addElement(midiInTransmitter);
        return midiInTransmitter;
    }

    public void run() {
        while (!devices.isEmpty()) {
            this.nGetMessages();
        }
        midiInThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackShortMessage(int n2, int n3, int n4, long l2) {
        if (Printer.verbose) {
            Printer.verbose(">> MidiInDevice callbackShortMessage: status: " + n2 + " data1: " + n3 + " data2: " + n4 + " timeStamp: " + l2);
        }
        try {
            this.shortMessage.setMessage(n2, n3, n4);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
        Vector vector = this.transmitters;
        synchronized (vector) {
            if (Printer.verbose) {
                Printer.verbose(">> MidiInDevice callbackShortMessage: sending message: " + this.shortMessage.toString() + " timeStamp: " + l2);
            }
            int n5 = 0;
            while (n5 < this.transmitters.size()) {
                Receiver receiver = ((Transmitter)this.transmitters.elementAt(n5)).getReceiver();
                if (receiver != null) {
                    receiver.send(this.shortMessage, l2);
                }
                ++n5;
            }
        }
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nStart(long var1) throws MidiUnavailableException;

    private native void nStop(long var1);

    private native void nGetMessages();

    class MidiInTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        MidiInTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            MidiInDevice.this.transmitters.removeElement(this);
            this.open = false;
        }
    }
}

