'\" t
.\" Manual page created with latex2man on Mon Feb 27 18:26:41 EST 2012
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_GET\\_FPREG" "3" "27 February 2012" "Programming Library " "Programming Library "
.SH NAME
unw_get_fpreg
\-\- get contents of floating\-point register 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_get_fpreg(unw_cursor_t *cp,
unw_regnum_t
reg,
unw_fpreg_t *valp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_get_fpreg()
routine reads the value of floating\-point 
register reg
in the stack frame identified by cursor cp
and stores the value in the variable pointed to by valp\&.
.PP
The register numbering is target\-dependent and described in separate 
manual pages (e.g., libunwind\-ia64(3) for the IA\-64 target). 
Furthermore, the exact set of accessible registers may depend on the 
type of frame that cp
is referring to. For ordinary stack 
frames, it is normally possible to access only the preserved 
(``callee\-saved\&'') registers and frame\-related registers (such as the 
stack\-pointer). However, for signal frames (see 
unw_is_signal_frame(3)),
it is usually possible to access 
all registers. 
.PP
Note that unw_get_fpreg()
can only read the contents of 
floating\-point registers. See unw_get_fpreg(3)
for a way to 
read registers which fit in a single word. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_get_fpreg()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_get_fpreg()
is thread\-safe as well as safe to use 
from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 An attempt was made to read a register 
that is either invalid or not accessible in the current frame. 
.PP
In addition, unw_get_fpreg()
may return any error returned by 
the access_mem(),
access_reg(),
and 
access_fpreg()
call\-backs (see 
unw_create_addr_space(3)).
.PP
.SH SEE ALSO

.PP
libunwind(3),
libunwind\-ia64(3),
unw_get_reg(3),
unw_is_fpreg(3),
unw_is_signal_frame(3),
unw_set_fpreg(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
