/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.PaintEvent;
import java.awt.peer.ContainerPeer;

public class GtkContainerPeer
extends GtkComponentPeer
implements ContainerPeer {
    Container c;

    public GtkContainerPeer(Container c) {
        super(c);
        this.c = c;
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.awtComponent.validate();
    }

    public Graphics getGraphics() {
        if (GtkToolkit.useGraphics2D()) {
            return new GdkGraphics2D(this);
        }
        return new GdkGraphics(this);
    }

    public void handleEvent(AWTEvent event) {
        int id = event.getID();
        switch (id) {
            case 800: 
            case 801: {
                try {
                    Graphics g = this.getGraphics();
                    if (g == null) break;
                    g.setClip(((PaintEvent)event).getUpdateRect());
                    if (id == 800) {
                        this.awtComponent.paint(g);
                    } else {
                        this.awtComponent.update(g);
                    }
                    g.dispose();
                    break;
                }
                catch (InternalError e) {
                    System.err.println(e);
                }
            }
        }
    }

    public void beginLayout() {
    }

    public void endLayout() {
    }

    public boolean isPaintPending() {
        return false;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        Component[] components = ((Container)this.awtComponent).getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (comp.isBackgroundSet() || comp.getPeer() == null) continue;
            comp.getPeer().setBackground(c);
        }
    }
}

