/* basic_row.i: static functions for basic_row.c */
/*
 * Copyright (C) 2004 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


static 
void 
free_column_values(	GtkTreeModel * treemodel,
			GtkTreeIter *iter)
{
    gchar *old_text;
    int i,text_columns[]={
       NAME_COLUMN,
       MODE_COLUMN, 
       DATE_COLUMN, 
       GROUP_COLUMN, 
       OWNER_COLUMN, 
       SIZE_COLUMN, 
       -1
    };
    for (i=0; text_columns[i] != -1; i++) {
	gtk_tree_model_get (treemodel, iter, text_columns[i], &old_text, -1);
	g_free(old_text);
    }
}


 

static 
void 
erase_children(		GtkTreeModel * treemodel, 
			GtkTreeIter * target)
{
    GtkTreeIter iter;
    if(gtk_tree_model_iter_n_children(treemodel, target) < 1) return;
    while(gtk_tree_model_iter_children(treemodel, &iter, target))
    {
	erase_children(treemodel, &iter);
	free_column_values(treemodel,&iter);
	free_entry(treemodel,&iter,NULL);
	gtk_tree_store_remove((GtkTreeStore *) treemodel, &iter);
    }
    return;
}

static 
void
blank_column_values(	GtkTreeModel * treemodel,
			GtkTreeIter *iter)
{
    gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
	PIXBUF_COLUMN, NULL, 
	STYLE_COLUMN, PANGO_STYLE_NORMAL, 
	NAME_COLUMN, g_strdup(""), 
	SIZE_COLUMN,g_strdup(""),
	DATE_COLUMN,g_strdup(""),
	OWNER_COLUMN,g_strdup(""),
	GROUP_COLUMN,g_strdup(""),
	MODE_COLUMN,g_strdup(""),
	-1);
}

static
gboolean 
update_row_full(	GtkTreeModel * treemodel, 
		        GtkTreeIter * target, 
			tree_entry_t * en,
			gboolean new_row)
{
    struct group *g;
    struct passwd *p;
    const gchar *grupo, *owner, *tag, *mode_s, *date_s;
    gboolean is_editable=FALSE;

    if (!en || !target){
	g_warning("(!en || !target) not met");
	return FALSE;
    }
  
    if (!new_row) {
	int i,w[]={
	    MODE_COLUMN,
	    DATE_COLUMN,
	    GROUP_COLUMN,
	    OWNER_COLUMN,
	    SIZE_COLUMN,
	    -1};
	for (i=0; w[i] > 0; i++){
	    gchar *old_text;
	    gtk_tree_model_get (treemodel, target, w[i], &old_text, -1);
	    g_free(old_text);
	}
    }
    
    if(IS_DIR(en->type)) {
	 en->count = count_files(en->path);
	 tag = sizetag((off_t)-1, en->count);
    } else if(IS_FILE(en->type) || IS_NETFILE(en->subtype)) {
	 tag = sizetag((off_t)en->st->st_size, -1);
    } else {
	tag = "";
    }
    if(IS_DIR(en->type) || IS_FILE(en->type) || IS_NETFILE(en->subtype) ){
      if((g = getgrgid(en->st->st_gid)) != NULL)	{
	grupo = g_strdup(g->gr_name);
      } else {
	grupo = g_strdup_printf("%d",(int)en->st->st_gid);
      }
    
      if((p = getpwuid(en->st->st_uid)) != NULL){
	owner = p->pw_name;
      } else {
	owner = g_strdup_printf("%d",(int)en->st->st_uid);
      }
      mode_s=mode_string(en->st->st_mode);
      date_s=my_utf_string(time_to_string(en->st->st_mtime));
    } else {
      grupo=g_strdup("");
      owner=g_strdup("");
      mode_s="";
      date_s="";
    }
    tag=g_strdup(tag);
    mode_s=g_strdup(mode_s);
    date_s=g_strdup(date_s);
    
    /* all dupped above */ 
    gtk_tree_store_set((GtkTreeStore *) treemodel, target, 
	MODE_COLUMN, mode_s, 
	DATE_COLUMN, date_s, 
	GROUP_COLUMN, grupo, 
	OWNER_COLUMN, owner,
	SIZE_COLUMN, tag, 
	-1);
    /* tag editable rows */
    if (!(tree_details->preferences & DISABLE_EASY_EDIT)){
        is_editable=IS_PATH(en->type);
    }
    gtk_tree_store_set((GtkTreeStore *) treemodel, target,
	EDITABLE_COLUMN,is_editable,
	-1);
    return TRUE;
}


static 
void 
add_row_info(	GtkTreeModel *treemodel, 
		GtkTreeIter * iter, 
		tree_entry_t * en, 
		gchar *name)
{
    
    if(strcmp(name, "..Wastebasket") == 0 ){
	name = _("Wastebasket");
    }
    gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
		    NAME_COLUMN, g_strdup(my_utf_string(name)), 
		    ENTRY_COLUMN, (gpointer) en, 
		    STYLE_COLUMN, PANGO_STYLE_NORMAL, 
		    -1);

    if(IS_NODE(en->type,en->subtype))
    {
	insert_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
    }
    
    update_row_full(treemodel, iter, en, TRUE); /* the other columns... */    
    set_icon(treemodel,iter);
   
    /* row text colours */
    if(IS_XF_FSTAB(en->type)) {
	set_row_colours(treemodel, iter, NULL, FSTAB_COLOR);
    } else if (IS_TOP_BOOKMARK(en->subtype)) {
	set_row_colours(treemodel, iter, NULL, BOOKMARK_COLOR);	
    } else if (IS_TRASH_TYPE(en->type)) {
	set_row_colours(treemodel, iter, NULL, TRASH_COLOR);	
    } else if (IS_DIR(en->type)||IS_XF_NETSHARE(en->subtype)||IS_NETDIR(en->subtype)) {
	set_row_colours(treemodel, iter, NULL, DIR_COLOR);
    } else if(IS_EXE(en->type)) {
        set_row_colours(treemodel, iter, NULL, EXEC_COLOR);
    } else if(IS_XF_SOCK(en->type)) {
	set_row_colours(treemodel, iter, NULL, SOCK_COLOR);
    } else if(IS_XF_FIFO(en->type)) {
	set_row_colours(treemodel, iter, NULL, PIPE_COLOR);
    }	
    return;
}


static
int 
xfdir_compare(		const void *a, 
			const void *b)
{
	const dir_t *d1 = (const dir_t *)a;
	const dir_t *d2 = (const dir_t *)b;
	if (!d1 && !d2) return 0;
	if (!d1) return -1;
	if (!d2) return 1;
	/*return (entry_compare(GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID,d1->en,d2->en));*/
	/* XXX: without the hack, directories appear at
	 * the bottom instead of top when reload is pressed. 
	 * I have no idea why*/
	if (get_ascending()%3==2) /* hack...*/
 	  return (entry_compare(get_relative_sort_column(),d2->en,d1->en));
	else
	  return (entry_compare(get_relative_sort_column(),d1->en,d2->en));
}


