= Window Management
* ((<Window Management Overview>))
* ((<Methods for Window Management>))
  * ((<SDL::WM.caption>)) -- Gets the window title and icon name.
  * ((<SDL::WM.set_caption>)) -- Sets the window tile and icon name.
  * ((<SDL::WM.icon=>)) -- Sets the icon for the display window.
  * ((<SDL::WM.iconify>)) -- Iconify/Minimise the window
  * ((<SDL::WM.grab_input>)) -- Grabs mouse and keyboard input.

== Window Management Overview
SDL provides a small set of window management functions
which allow applications to change their title and toggle
from windowed mode to fullscreen (if available)

== Methods for Window Management

--- SDL::WM.caption

    Returns the window title and icon name as an array with two element.

    * See Also
      
      ((<SDL::WM.set_caption>))

--- SDL::WM.set_caption(title, icon)
--- SDL::WM.setCaption(title, icon)

    Sets the title-bar and icon name of the display window.

    * NOTES

      ((|title|)) and ((|icon|)) must be UTF8 or ASCII string.
      
      If Ruby/SDL m17n support is enabled, 
      ((|title|)) and ((|icon|)) are converted to UTF8 automatically.

    * See Also
      
      ((<SDL::WM.caption>)), ((<SDL::WM.icon=>))

--- SDL::WM.icon=(icon_image)

    Sets the icon for the display window. Win32 icons must be 32x32.
    
    This function must be called before the first call to 
    ((<SDL::Screen.open>)).
    ((|icon_image|)) should be an instance of ((<SDL::Surface>))


    EXAMPLE
      SDL::WM.icon = SDL::Surface.load_bmp("icon.bmp")

    * See Also
      
      ((<SDL.set_video_mode>)), ((<SDL::WM.caption>))

--- SDL::WM.iconify

    If the application is running in a window managed environment
    SDL attempts to iconify/minimise
    it. If this method is successful,
    the application will receive a ((<SDL::Event::APPACTIVE>))
    loss event.

    Raises ((<SDL::Error>)) on failure
--- SDL::WM.grab_input(mode)
--- SDL::WM.grabInput(mode)

    Grabbing means that the mouse is confined to the application window,
    and nearly all keyboard input is passed directly to the application,
    and not interpreted by a window manager, if any.
    
    You can use following three constants as ((|mode|)).
    * SDL::WM::GRAB_QUERY
    * SDL::WM::GRAB_OFF
    * SDL::WM::GRAB_ON
    
    When ((|mode|)) is SDL::WM::GRAB_QUERY, 
    the grab mode is not changed, but the current grab mode is returned.

    Returns the current/new mode.

