#!/usr/bin/env python
from setuptools import setup, find_packages
from os import path
import codecs
import re


def read(*parts):
    file_path = path.join(path.dirname(__file__), *parts)
    return codecs.open(file_path, encoding='utf-8').read()


def find_version(*parts):
    version_file = read(*parts)
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]", version_file, re.M)
    if version_match:
        return str(version_match.group(1))
    raise RuntimeError("Unable to find version string.")


setup(
    name='django-threadedcomments',
    version=find_version('threadedcomments', '__init__.py'),
    license='BSD',

    description='A simple yet flexible threaded commenting system.',
    long_description=read('README.rst'),
    keywords='django,comments,threading',

    author='Eric Florenzano',
    author_email='floguy@gmail.com',

    maintainer='Diederik van der Boor',
    maintainer_email='vdboor@edoburu.nl',

    url='https://github.com/HonzaKral/django-threadedcomments',
    download_url='https://github.com/HonzaKral/django-threadedcomments/zipball/master',

    packages=find_packages(exclude=('example*',)),
    include_package_data=True,

    zip_safe=False,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ]
)
