# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementExpressRouteGatewaysOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_list_by_subscription(self, resource_group):
        response = await self.client.express_route_gateways.list_by_subscription(
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_list_by_resource_group(self, resource_group):
        response = await self.client.express_route_gateways.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.express_route_gateways.begin_create_or_update(
                resource_group_name=resource_group.name,
                express_route_gateway_name="str",
                put_express_route_gateway_parameters={
                    "allowNonVirtualWanTraffic": bool,
                    "autoScaleConfiguration": {"bounds": {"max": 0, "min": 0}},
                    "etag": "str",
                    "expressRouteConnections": [
                        {
                            "name": "str",
                            "authorizationKey": "str",
                            "enableInternetSecurity": bool,
                            "enablePrivateLinkFastPath": bool,
                            "expressRouteCircuitPeering": {"id": "str"},
                            "expressRouteGatewayBypass": bool,
                            "id": "str",
                            "provisioningState": "str",
                            "routingConfiguration": {
                                "associatedRouteTable": {"id": "str"},
                                "inboundRouteMap": {"id": "str"},
                                "outboundRouteMap": {"id": "str"},
                                "propagatedRouteTables": {"ids": [{"id": "str"}], "labels": ["str"]},
                                "vnetRoutes": {
                                    "bgpConnections": [{"id": "str"}],
                                    "staticRoutes": [
                                        {"addressPrefixes": ["str"], "name": "str", "nextHopIpAddress": "str"}
                                    ],
                                    "staticRoutesConfig": {
                                        "propagateStaticRoutes": bool,
                                        "vnetLocalRouteOverrideCriteria": "str",
                                    },
                                },
                            },
                            "routingWeight": 0,
                        }
                    ],
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                    "virtualHub": {"id": "str"},
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_begin_update_tags(self, resource_group):
        response = await (
            await self.client.express_route_gateways.begin_update_tags(
                resource_group_name=resource_group.name,
                express_route_gateway_name="str",
                express_route_gateway_parameters={"tags": {"str": "str"}},
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_get(self, resource_group):
        response = await self.client.express_route_gateways.get(
            resource_group_name=resource_group.name,
            express_route_gateway_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_gateways_begin_delete(self, resource_group):
        response = await (
            await self.client.express_route_gateways.begin_delete(
                resource_group_name=resource_group.name,
                express_route_gateway_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
