# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._analytics_items_operations import (
    build_delete_request,
    build_get_request,
    build_list_request,
    build_put_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AnalyticsItemsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.applicationinsights.v2015_05_01.aio.ApplicationInsightsManagementClient`'s
        :attr:`analytics_items` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def list(
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        scope: Optional[Union[str, _models.ItemScope]] = None,
        type: Union[str, _models.ItemTypeParameter] = "none",
        include_content: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.ApplicationInsightsComponentAnalyticsItem]:
        """Gets a list of Analytics Items defined within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param scope: Enum indicating if this item definition is owned by a specific user or is shared
         between all users with access to the Application Insights component. Known values are: "shared"
         and "user". Default value is None.
        :type scope: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScope
        :param type: Enum indicating the type of the Analytics item. Known values are: "none", "query",
         "function", "folder", and "recent". Default value is "none".
        :type type: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemTypeParameter
        :param include_content: Flag indicating whether or not to return the content of each applicable
         item. If false, only return the item information. Default value is None.
        :type include_content: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of ApplicationInsightsComponentAnalyticsItem or the result of cls(response)
        :rtype:
         list[~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[List[_models.ApplicationInsightsComponentAnalyticsItem]] = kwargs.pop("cls", None)

        request = build_list_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            scope_path=scope_path,
            subscription_id=self._config.subscription_id,
            scope=scope,
            type=type,
            include_content=include_content,
            api_version=api_version,
            template_url=self.list.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[ApplicationInsightsComponentAnalyticsItem]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}"
    }

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentAnalyticsItem:
        """Gets a specific Analytics Items defined within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param id: The Id of a specific item defined in the Application Insights component. Default
         value is None.
        :type id: str
        :param name: The name of a specific item defined in the Application Insights component. Default
         value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationInsightsComponentAnalyticsItem or the result of cls(response)
        :rtype:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[_models.ApplicationInsightsComponentAnalyticsItem] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            scope_path=scope_path,
            subscription_id=self._config.subscription_id,
            id=id,
            name=name,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationInsightsComponentAnalyticsItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item"
    }

    @overload
    async def put(
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        item_properties: _models.ApplicationInsightsComponentAnalyticsItem,
        override_item: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentAnalyticsItem:
        """Adds or Updates a specific Analytics Item within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param item_properties: Properties that need to be specified to create a new item and add it to
         an Application Insights component. Required.
        :type item_properties:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem
        :param override_item: Flag indicating whether or not to force save an item. This allows
         overriding an item if it already exists. Default value is None.
        :type override_item: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationInsightsComponentAnalyticsItem or the result of cls(response)
        :rtype:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put(
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        item_properties: IO,
        override_item: Optional[bool] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentAnalyticsItem:
        """Adds or Updates a specific Analytics Item within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param item_properties: Properties that need to be specified to create a new item and add it to
         an Application Insights component. Required.
        :type item_properties: IO
        :param override_item: Flag indicating whether or not to force save an item. This allows
         overriding an item if it already exists. Default value is None.
        :type override_item: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationInsightsComponentAnalyticsItem or the result of cls(response)
        :rtype:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put(
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        item_properties: Union[_models.ApplicationInsightsComponentAnalyticsItem, IO],
        override_item: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.ApplicationInsightsComponentAnalyticsItem:
        """Adds or Updates a specific Analytics Item within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param item_properties: Properties that need to be specified to create a new item and add it to
         an Application Insights component. Is either a ApplicationInsightsComponentAnalyticsItem type
         or a IO type. Required.
        :type item_properties:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem or
         IO
        :param override_item: Flag indicating whether or not to force save an item. This allows
         overriding an item if it already exists. Default value is None.
        :type override_item: bool
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApplicationInsightsComponentAnalyticsItem or the result of cls(response)
        :rtype:
         ~azure.mgmt.applicationinsights.v2015_05_01.models.ApplicationInsightsComponentAnalyticsItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationInsightsComponentAnalyticsItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(item_properties, (IO, bytes)):
            _content = item_properties
        else:
            _json = self._serialize.body(item_properties, "ApplicationInsightsComponentAnalyticsItem")

        request = build_put_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            scope_path=scope_path,
            subscription_id=self._config.subscription_id,
            override_item=override_item,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.put.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationInsightsComponentAnalyticsItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    put.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        resource_name: str,
        scope_path: Union[str, _models.ItemScopePath],
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a specific Analytics Items defined within an Application Insights component.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param resource_name: The name of the Application Insights component resource. Required.
        :type resource_name: str
        :param scope_path: Enum indicating if this item definition is owned by a specific user or is
         shared between all users with access to the Application Insights component. Known values are:
         "analyticsItems" and "myanalyticsItems". Required.
        :type scope_path: str or ~azure.mgmt.applicationinsights.v2015_05_01.models.ItemScopePath
        :param id: The Id of a specific item defined in the Application Insights component. Default
         value is None.
        :type id: str
        :param name: The name of a specific item defined in the Application Insights component. Default
         value is None.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-05-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            resource_name=resource_name,
            scope_path=scope_path,
            subscription_id=self._config.subscription_id,
            id=id,
            name=name,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item"
    }
