# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SourceControlUpdateParameters(Model):
    """The parameters supplied to the update source control operation.

    :param branch: The repo branch of the source control.
    :type branch: str
    :param folder_path: The folder path of the source control. Path must be
     relative.
    :type folder_path: str
    :param auto_sync: The auto sync of the source control. Default is false.
    :type auto_sync: bool
    :param publish_runbook: The auto publish of the source control. Default is
     true.
    :type publish_runbook: bool
    :param security_token: The authorization token for the repo of the source
     control.
    :type security_token:
     ~azure.mgmt.automation.models.SourceControlSecurityTokenProperties
    :param description: The user description of the source control.
    :type description: str
    """

    _attribute_map = {
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'auto_sync': {'key': 'properties.autoSync', 'type': 'bool'},
        'publish_runbook': {'key': 'properties.publishRunbook', 'type': 'bool'},
        'security_token': {'key': 'properties.securityToken', 'type': 'SourceControlSecurityTokenProperties'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, *, branch: str=None, folder_path: str=None, auto_sync: bool=None, publish_runbook: bool=None, security_token=None, description: str=None, **kwargs) -> None:
        super(SourceControlUpdateParameters, self).__init__(**kwargs)
        self.branch = branch
        self.folder_path = folder_path
        self.auto_sync = auto_sync
        self.publish_runbook = publish_runbook
        self.security_token = security_token
        self.description = description
