from . import linalg
from .core import (
    Function,
    LazyArray,
    Variable,
    add,
    angle,
    arccos,
    arccosh,
    arcsin,
    arcsinh,
    arctan,
    arctanh,
    argsort,
    array,
    ascend,
    broadcast_to,
    clip,
    compute,
    concatenate,
    conj,
    cos,
    cosh,
    descend,
    diag,
    diagonal,
    einsum,
    empty,
    equal,
    exp,
    expand_dims,
    eye,
    flip,
    floordivide,
    get_source,
    identity,
    imag,
    kron,
    log,
    log2,
    log10,
    matmul,
    multiply,
    ones,
    permute_dims,
    prod,
    real,
    reshape,
    shared_intermediates,
    sign,
    sin,
    sinh,
    sort,
    split,
    sqrt,
    stack,
    take,
    take_along_axis,
    tan,
    tanh,
    tensordot,
    trace,
    transpose,
    truedivide,
    where,
    zeros,
)
from .core import abs_ as abs
from .core import complex_ as complex
from .core import max_ as max
from .core import min_ as min
from .core import sum_ as sum

__all__ = (
    "abs",
    "add",
    "angle",
    "arccos",
    "arccosh",
    "arcsin",
    "arcsinh",
    "arctan",
    "arctanh",
    "argsort",
    "array",
    "ascend",
    "broadcast_to",
    "clip",
    "complex",
    "compute",
    "concatenate",
    "conj",
    "conj",
    "cos",
    "cosh",
    "descend",
    "diag",
    "diagonal",
    "einsum",
    "empty",
    "equal",
    "exp",
    "expand_dims",
    "eye",
    "flip",
    "floordivide",
    "Function",
    "get_source",
    "identity",
    "imag",
    "kron",
    "LazyArray",
    "linalg",
    "log",
    "log10",
    "log2",
    "matmul",
    "max",
    "min",
    "multiply",
    "ones",
    "permute_dims",
    "prod",
    "real",
    "reshape",
    "shared_intermediates",
    "sign",
    "sin",
    "sinh",
    "sort",
    "split",
    "sqrt",
    "stack",
    "sum",
    "take",
    "take_along_axis",
    "tan",
    "tanh",
    "tensordot",
    "trace",
    "transpose",
    "truedivide",
    "Variable",
    "where",
    "zeros",
)


try:
    from opt_einsum.backends.dispatch import _aliases

    _aliases["autoray"] = "autoray.lazy"
except ImportError:  # pragma: no cover
    pass
