/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class ArrayGet
extends Procedure2
implements Inlineable,
Externalizable {
    Type element_type;

    public ArrayGet(Type element_type) {
        this.element_type = element_type;
    }

    public Object apply2(Object array, Object index) {
        Object value = Array.get(array, ((Number)index).intValue());
        return this.element_type.coerceToObject(value);
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        args[0].compile(comp, ArrayType.make(this.element_type));
        args[1].compile(comp, Type.int_type);
        CodeAttr code = comp.getCode();
        code.emitArrayLoad(this.element_type);
        target.compileFromStack(comp, this.element_type);
    }

    public Type getReturnType(Expression[] args) {
        return this.element_type;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element_type);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element_type = (Type)in.readObject();
    }
}

