/*
Copyright (c) 2007, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.net/yui/license.txt
version: 2.3.0
*/

YAHOO.widget.DataTable=function(elContainer,aColumnDefs,oDataSource,oConfigs){this._nIndex=YAHOO.widget.DataTable._nCount;this._sName="instance"+this._nIndex;this.id="yui-dt"+this._nIndex;this._initContainerEl(elContainer);if(!this._elContainer){return;}
this._initConfigs(oConfigs);this._initColumnSet(aColumnDefs);if(!this._oColumnSet){return;}
this._initRecordSet();if(!this._oRecordSet){return;}
this._initDataSource(oDataSource);if(!this._oDataSource){return;}
if(this._oDataSource.dataType==YAHOO.util.DataSource.TYPE_HTMLTABLE){this._oDataSource.sendRequest(this.get("initialRequest"),this._onDataReturnEnhanceTable,this);}
else{this._initTableEl();if(!this._elTable||!this._elThead||!this._elTbody){return;}
YAHOO.widget.DataTable.superclass.constructor.call(this,this._elContainer,this._oConfigs);if(this._oConfigs&&this._oConfigs.paginator){this.updatePaginator(this._oConfigs.paginator);}
this._oDataSource.sendRequest(this.get("initialRequest"),this.onDataReturnInitializeTable,this);}
this._initCellEditorEl();this._initColumnSort();this._initDomEvents();YAHOO.widget.DataTable._nCount++;};if(YAHOO.util.Element){YAHOO.lang.extend(YAHOO.widget.DataTable,YAHOO.util.Element);}
else{}
YAHOO.widget.DataTable.prototype.initAttributes=function(oConfigs){oConfigs=oConfigs||{};YAHOO.widget.DataTable.superclass.initAttributes.call(this,oConfigs);this.setAttributeConfig("summary",{value:null,validator:YAHOO.lang.isString,method:function(sSummary){this._elTable.summary=sSummary;}});this.setAttributeConfig("selectionMode",{value:"standard",validator:YAHOO.lang.isString});this.setAttributeConfig("initialRequest",{value:"",validator:YAHOO.lang.isString});this.setAttributeConfig("sortedBy",{value:null,validator:function(oNewSortedBy){return(oNewSortedBy&&(oNewSortedBy.constructor==Object)&&oNewSortedBy.key);},method:function(oNewSortedBy){var oOldSortedBy=this.get("sortedBy");if(oOldSortedBy&&(oOldSortedBy.constructor==Object)&&oOldSortedBy.key){var oldColumn=this._oColumnSet.getColumn(oOldSortedBy.key);var oldThEl=this.getThEl(oldColumn);YAHOO.util.Dom.removeClass(oldThEl,YAHOO.widget.DataTable.CLASS_ASC);YAHOO.util.Dom.removeClass(oldThEl,YAHOO.widget.DataTable.CLASS_DESC);}
var column=(oNewSortedBy.column)?oNewSortedBy.column:this._oColumnSet.getColumn(oNewSortedBy.key);if(column){var newClass=(oNewSortedBy.dir&&(oNewSortedBy.dir!="asc"))?YAHOO.widget.DataTable.CLASS_DESC:YAHOO.widget.DataTable.CLASS_ASC;YAHOO.util.Dom.addClass(this.id+"-col"+column.getId(),newClass);}}});this.setAttributeConfig("paginator",{value:{rowsPerPage:500,currentPage:1,startRecordIndex:0,totalRecords:0,totalPages:0,rowsThisPage:0,pageLinks:0,pageLinksStart:1,dropdownOptions:null,containers:[],dropdowns:[],links:[]},validator:function(oNewPaginator){if(oNewPaginator&&(oNewPaginator.constructor==Object)){if((oNewPaginator.rowsPerPage!==undefined)&&(oNewPaginator.currentPage!==undefined)&&(oNewPaginator.startRecordIndex!==undefined)&&(oNewPaginator.totalRecords!==undefined)&&(oNewPaginator.totalPages!==undefined)&&(oNewPaginator.rowsThisPage!==undefined)&&(oNewPaginator.pageLinks!==undefined)&&(oNewPaginator.pageLinksStart!==undefined)&&(oNewPaginator.dropdownOptions!==undefined)&&(oNewPaginator.containers!==undefined)&&(oNewPaginator.dropdowns!==undefined)&&(oNewPaginator.links!==undefined)){if(YAHOO.lang.isNumber(oNewPaginator.rowsPerPage)&&YAHOO.lang.isNumber(oNewPaginator.currentPage)&&YAHOO.lang.isNumber(oNewPaginator.startRecordIndex)&&YAHOO.lang.isNumber(oNewPaginator.totalRecords)&&YAHOO.lang.isNumber(oNewPaginator.totalPages)&&YAHOO.lang.isNumber(oNewPaginator.rowsThisPage)&&YAHOO.lang.isNumber(oNewPaginator.pageLinks)&&YAHOO.lang.isNumber(oNewPaginator.pageLinksStart)&&YAHOO.lang.isArray(oNewPaginator.dropdownOptions)&&YAHOO.lang.isArray(oNewPaginator.containers)&&YAHOO.lang.isArray(oNewPaginator.dropdowns)&&YAHOO.lang.isArray(oNewPaginator.links)){return true;}}}
return false;}});this.setAttributeConfig("paginated",{value:false,validator:YAHOO.lang.isBoolean,method:function(oParam){var oPaginator=this.get("paginator");var aContainerEls=oPaginator.containers;if(oParam){if(aContainerEls.length===0){var pag0=document.createElement("span");pag0.id=this.id+"-paginator0";YAHOO.util.Dom.addClass(pag0,YAHOO.widget.DataTable.CLASS_PAGINATOR);pag0=this._elContainer.insertBefore(pag0,this._elTable);aContainerEls.push(pag0);var pag1=document.createElement("span");pag1.id=this.id+"-paginator1";YAHOO.util.Dom.addClass(pag1,YAHOO.widget.DataTable.CLASS_PAGINATOR);pag1=this._elContainer.insertBefore(pag1,this._elTable.nextSibling);aContainerEls.push(pag1);this._configs.paginator.value.containers=[pag0,pag1];}
else{for(var i=0;i<aContainerEls.length;i++){aContainerEls[i].style.display="";}}
if(oPaginator.pageLinks>-1){var aLinkEls=oPaginator.links;if(aLinkEls.length===0){for(i=0;i<aContainerEls.length;i++){var linkEl=document.createElement("span");linkEl.id="yui-dt-pagselect"+i;linkEl=aContainerEls[i].appendChild(linkEl);YAHOO.util.Event.addListener(linkEl,"click",this._onPaginatorLinkClick,this);this._configs.paginator.value.links.push(linkEl);}}}
var dropdownOptions=oPaginator.dropdownOptions||[];for(i=0;i<aContainerEls.length;i++){var selectEl=document.createElement("select");YAHOO.util.Dom.addClass(selectEl,YAHOO.widget.DataTable.CLASS_DROPDOWN);selectEl=aContainerEls[i].appendChild(selectEl);selectEl.id="yui-dt-pagselect"+i;YAHOO.util.Event.addListener(selectEl,"change",this._onPaginatorDropdownChange,this);this._configs.paginator.value.dropdowns.push(selectEl);if(!oPaginator.dropdownOptions){selectEl.style.display="none";}}}
else{if(aContainerEls.length>0){for(i=0;i<aContainerEls.length;i++){aContainerEls[i].style.display="none";}}}}});this.setAttributeConfig("caption",{value:null,validator:YAHOO.lang.isString,method:function(sCaption){if(!this._elCaption){if(!this._elTable.firstChild){this._elCaption=this._elTable.appendChild(document.createElement("caption"));}
else{this._elCaption=this._elTable.insertBefore(document.createElement("caption"),this._elTable.firstChild);}}
this._elCaption.innerHTML=sCaption;}});this.setAttributeConfig("scrollable",{value:false,validator:function(oParam){return(YAHOO.lang.isBoolean(oParam)&&!YAHOO.lang.isString(this.get("caption")));},method:function(oParam){if(oParam){YAHOO.util.Dom.addClass(this._elContainer,YAHOO.widget.DataTable.CLASS_SCROLLABLE);YAHOO.util.Dom.addClass(this._elTbody,YAHOO.widget.DataTable.CLASS_SCROLLBODY);}
else{YAHOO.util.Dom.removeClass(this._elContainer,YAHOO.widget.DataTable.CLASS_SCROLLABLE);YAHOO.util.Dom.removeClass(this._elTbody,YAHOO.widget.DataTable.CLASS_SCROLLBODY);}}});};YAHOO.widget.DataTable.CLASS_TABLE="yui-dt-table";YAHOO.widget.DataTable.CLASS_HEADER="yui-dt-header";YAHOO.widget.DataTable.CLASS_BODY="yui-dt-body";YAHOO.widget.DataTable.CLASS_SCROLLBODY="yui-dt-scrollbody";YAHOO.widget.DataTable.CLASS_LABEL="yui-dt-label";YAHOO.widget.DataTable.CLASS_RESIZER="yui-dt-resizer";YAHOO.widget.DataTable.CLASS_EDITOR="yui-dt-editor";YAHOO.widget.DataTable.CLASS_PAGINATOR="yui-dt-paginator";YAHOO.widget.DataTable.CLASS_PAGE="yui-dt-page";YAHOO.widget.DataTable.CLASS_DEFAULT="yui-dt-default";YAHOO.widget.DataTable.CLASS_PREVIOUS="yui-dt-previous";YAHOO.widget.DataTable.CLASS_NEXT="yui-dt-next";YAHOO.widget.DataTable.CLASS_FIRST="yui-dt-first";YAHOO.widget.DataTable.CLASS_LAST="yui-dt-last";YAHOO.widget.DataTable.CLASS_EVEN="yui-dt-even";YAHOO.widget.DataTable.CLASS_ODD="yui-dt-odd";YAHOO.widget.DataTable.CLASS_SELECTED="yui-dt-selected";YAHOO.widget.DataTable.CLASS_HIGHLIGHTED="yui-dt-highlighted";YAHOO.widget.DataTable.CLASS_DISABLED="yui-dt-disabled";YAHOO.widget.DataTable.CLASS_EMPTY="yui-dt-empty";YAHOO.widget.DataTable.CLASS_LOADING="yui-dt-loading";YAHOO.widget.DataTable.CLASS_ERROR="yui-dt-error";YAHOO.widget.DataTable.CLASS_EDITABLE="yui-dt-editable";YAHOO.widget.DataTable.CLASS_SCROLLABLE="yui-dt-scrollable";YAHOO.widget.DataTable.CLASS_SORTABLE="yui-dt-sortable";YAHOO.widget.DataTable.CLASS_ASC="yui-dt-asc";YAHOO.widget.DataTable.CLASS_DESC="yui-dt-desc";YAHOO.widget.DataTable.CLASS_BUTTON="yui-dt-button";YAHOO.widget.DataTable.CLASS_DROPDOWN="yui-dt-dropdown";YAHOO.widget.DataTable.CLASS_CHECKBOX="yui-dt-checkbox";YAHOO.widget.DataTable.MSG_EMPTY="No records found.";YAHOO.widget.DataTable.MSG_LOADING="Loading data...";YAHOO.widget.DataTable.MSG_ERROR="Data error.";YAHOO.widget.DataTable._nCount=0;YAHOO.widget.DataTable.prototype._nIndex=null;YAHOO.widget.DataTable.prototype._nTrCount=0;YAHOO.widget.DataTable.prototype._sName=null;YAHOO.widget.DataTable.prototype._elContainer=null;YAHOO.widget.DataTable.prototype._elCaption=null;YAHOO.widget.DataTable.prototype._elTable=null;YAHOO.widget.DataTable.prototype._elThead=null;YAHOO.widget.DataTable.prototype._elTbody=null;YAHOO.widget.DataTable.prototype._elMsgTbody=null;YAHOO.widget.DataTable.prototype._elMsgTbodyRow=null;YAHOO.widget.DataTable.prototype._elMsgTbodyCell=null;YAHOO.widget.DataTable.prototype._oDataSource=null;YAHOO.widget.DataTable.prototype._oColumnSet=null;YAHOO.widget.DataTable.prototype._oRecordSet=null;YAHOO.widget.DataTable.prototype._sFirstLabelLinkId=null;YAHOO.widget.DataTable.prototype._sFirstTrId=null;YAHOO.widget.DataTable.prototype._sLastTrId=null;YAHOO.widget.DataTable.prototype._focusEl=function(el){el=el||this._elTable;setTimeout(function(){el.focus();},0);};YAHOO.widget.DataTable.prototype._initContainerEl=function(elContainer){this._elContainer=null;elContainer=YAHOO.util.Dom.get(elContainer);if(elContainer&&elContainer.tagName&&(elContainer.tagName.toLowerCase()=="div")){this._elContainer=elContainer;}};YAHOO.widget.DataTable.prototype._initConfigs=function(oConfigs){if(oConfigs){if(oConfigs.constructor!=Object){oConfigs=null;}
else if(YAHOO.lang.isBoolean(oConfigs.paginator)){}
this._oConfigs=oConfigs;}};YAHOO.widget.DataTable.prototype._initColumnSet=function(aColumnDefs){this._oColumnSet=null;if(YAHOO.lang.isArray(aColumnDefs)){this._oColumnSet=new YAHOO.widget.ColumnSet(aColumnDefs);}
else if(aColumnDefs instanceof YAHOO.widget.ColumnSet){this._oColumnSet=aColumnDefs;}};YAHOO.widget.DataTable.prototype._initDataSource=function(oDataSource){this._oDataSource=null;if(oDataSource&&(oDataSource instanceof YAHOO.util.DataSource)){this._oDataSource=oDataSource;}
else{var tmpTable=null;var tmpContainer=this._elContainer;if(tmpContainer.hasChildNodes()){var tmpChildren=tmpContainer.childNodes;for(i=0;i<tmpChildren.length;i++){if(tmpChildren[i].tagName&&tmpChildren[i].tagName.toLowerCase()=="table"){tmpTable=tmpChildren[i];break;}}
if(tmpTable){var tmpFieldsArray=[];for(i=0;i<this._oColumnSet.keys.length;i++){tmpFieldsArray.push({key:this._oColumnSet.keys[i].key});}
this._oDataSource=new YAHOO.util.DataSource(tmpTable);this._oDataSource.responseType=YAHOO.util.DataSource.TYPE_HTMLTABLE;this._oDataSource.responseSchema={fields:tmpFieldsArray};}}}};YAHOO.widget.DataTable.prototype._initRecordSet=function(){if(this._oRecordSet){this._oRecordSet.reset();}
else{this._oRecordSet=new YAHOO.widget.RecordSet();}};YAHOO.widget.DataTable.prototype._initTableEl=function(){YAHOO.util.Event.purgeElement(this._elContainer,true);this._elContainer.innerHTML="";this._elTable=this._elContainer.appendChild(document.createElement("table"));var elTable=this._elTable;elTable.tabIndex=0;elTable.id=this.id+"-table";YAHOO.util.Dom.addClass(elTable,YAHOO.widget.DataTable.CLASS_TABLE);this._initTheadEl(elTable,this._oColumnSet);var elMsgTbody=document.createElement("tbody");var elMsgRow=elMsgTbody.appendChild(document.createElement("tr"));YAHOO.util.Dom.addClass(elMsgRow,YAHOO.widget.DataTable.CLASS_FIRST);YAHOO.util.Dom.addClass(elMsgRow,YAHOO.widget.DataTable.CLASS_LAST);this._elMsgRow=elMsgRow;var elMsgCell=elMsgRow.appendChild(document.createElement("td"));elMsgCell.colSpan=this._oColumnSet.keys.length;YAHOO.util.Dom.addClass(elMsgCell,YAHOO.widget.DataTable.CLASS_FIRST);YAHOO.util.Dom.addClass(elMsgCell,YAHOO.widget.DataTable.CLASS_LAST);this._elMsgTd=elMsgCell;this._elMsgTbody=elTable.appendChild(elMsgTbody);this.showTableMessage(YAHOO.widget.DataTable.MSG_LOADING,YAHOO.widget.DataTable.CLASS_LOADING);this._elTbody=elTable.appendChild(document.createElement("tbody"));YAHOO.util.Dom.addClass(this._elTbody,YAHOO.widget.DataTable.CLASS_BODY);};YAHOO.widget.DataTable.prototype._initTheadEl=function(){var i,oColumn,colId;var oColumnSet=this._oColumnSet;this._sFirstLabelLinkId=null;var elThead=document.createElement("thead");var colTree=oColumnSet.tree;for(i=0;i<colTree.length;i++){var elTheadRow=elThead.appendChild(document.createElement("tr"));elTheadRow.id=this.id+"-hdrow"+i;var elTheadCell;for(var j=0;j<colTree[i].length;j++){oColumn=colTree[i][j];colId=oColumn.getId();elTheadCell=elTheadRow.appendChild(document.createElement("th"));elTheadCell.id=this.id+"-col"+colId;this._initThEl(elTheadCell,oColumn,i,j);}
if(i===0){YAHOO.util.Dom.addClass(elTheadRow,YAHOO.widget.DataTable.CLASS_FIRST);}
if(i===(colTree.length-1)){YAHOO.util.Dom.addClass(elTheadRow,YAHOO.widget.DataTable.CLASS_LAST);}}
this._elThead=this._elTable.appendChild(elThead);var aFirstHeaders=oColumnSet.headers[0].split(" ");var aLastHeaders=oColumnSet.headers[oColumnSet.headers.length-1].split(" ");for(i=0;i<aFirstHeaders.length;i++){YAHOO.util.Dom.addClass(YAHOO.util.Dom.get(this.id+"-col"+aFirstHeaders[i]),YAHOO.widget.DataTable.CLASS_FIRST);}
for(i=0;i<aLastHeaders.length;i++){YAHOO.util.Dom.addClass(YAHOO.util.Dom.get(this.id+"-col"+aLastHeaders[i]),YAHOO.widget.DataTable.CLASS_LAST);}
var foundDD=(YAHOO.util.DD)?true:false;var needDD=false;for(i=0;i<this._oColumnSet.keys.length;i++){oColumn=this._oColumnSet.keys[i];colId=oColumn.getId();var elTheadCellId=YAHOO.util.Dom.get(this.id+"-col"+colId);if(oColumn.resizeable){if(foundDD){if(!this.fixedWidth||(this.fixedWidth&&(oColumn.getKeyIndex()!=this._oColumnSet.keys.length-1))){var elThContainer=YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_HEADER,"div",elTheadCellId)[0];var elThResizer=elThContainer.appendChild(document.createElement("span"));elThResizer.id=this.id+"-resizer"+colId;YAHOO.util.Dom.addClass(elThResizer,YAHOO.widget.DataTable.CLASS_RESIZER);oColumn.ddResizer=new YAHOO.util.ColumnResizer(this,oColumn,elTheadCellId,elThResizer.id,elThResizer.id);var cancelClick=function(e){YAHOO.util.Event.stopPropagation(e);};YAHOO.util.Event.addListener(elThResizer,"click",cancelClick);}
if(this.fixedWidth){var elThLabel=(YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_LABEL,"span",elTheadCellId))[0];elThLabel.style.overflow="hidden";}}
else{needDD=true;}}}
if(needDD){}};YAHOO.widget.DataTable.prototype._initThEl=function(elTheadCell,oColumn,row,col){var index=this._nIndex;var colId=oColumn.getId();elTheadCell.yuiColumnId=colId;if(oColumn.abbr){elTheadCell.abbr=oColumn.abbr;}
if(oColumn.width){elTheadCell.style.width=oColumn.width;}
var aCustomClasses;if(YAHOO.lang.isString(oColumn.className)){aCustomClasses=[oColumn.className];}
else if(YAHOO.lang.isArray(oColumn.className)){aCustomClasses=oColumn.className;}
if(aCustomClasses){for(var i=0;i<aCustomClasses.length;i++){YAHOO.util.Dom.addClass(elTheadCell,aCustomClasses[i]);}}
YAHOO.util.Dom.addClass(elTheadCell,"yui-dt-col-"+oColumn.key);elTheadCell.innerHTML="";elTheadCell.rowSpan=oColumn.getRowspan();elTheadCell.colSpan=oColumn.getColspan();var elTheadContainer=elTheadCell.appendChild(document.createElement("div"));elTheadContainer.id=this.id+"-container"+colId;YAHOO.util.Dom.addClass(elTheadContainer,YAHOO.widget.DataTable.CLASS_HEADER);var elTheadLabel=elTheadContainer.appendChild(document.createElement("span"));elTheadLabel.id=this.id+"-label"+colId;YAHOO.util.Dom.addClass(elTheadLabel,YAHOO.widget.DataTable.CLASS_LABEL);var sLabel=YAHOO.lang.isValue(oColumn.label)?oColumn.label:oColumn.key;if(oColumn.sortable){YAHOO.util.Dom.addClass(elTheadCell,YAHOO.widget.DataTable.CLASS_SORTABLE);var sLabelLinkId=this.id+"-labellink"+colId;var sortLink="?key="+oColumn.key;elTheadLabel.innerHTML="<a id=\""+sLabelLinkId+"\" href=\""+sortLink+"\" title=\"Click to sort\" class=\""+YAHOO.widget.DataTable.CLASS_SORTABLE+"\">"+sLabel+"</a>";if(!this._sFirstLabelLinkId){this._sFirstLabelLinkId=sLabelLinkId;}}
else{elTheadLabel.innerHTML=sLabel;}};YAHOO.widget.DataTable.prototype._initCellEditorEl=function(){var elCellEditor=document.createElement("div");elCellEditor.id=this.id+"-celleditor";elCellEditor.style.display="none";YAHOO.util.Dom.addClass(elCellEditor,YAHOO.widget.DataTable.CLASS_EDITOR);elCellEditor=document.body.appendChild(elCellEditor);var oCellEditor={};oCellEditor.container=elCellEditor;oCellEditor.value=null;oCellEditor.isActive=false;this._oCellEditor=oCellEditor;this.subscribe("editorKeydownEvent",function(oArgs){var e=oArgs.event;var elTarget=YAHOO.util.Event.getTarget(e);if((e.keyCode==27)){this.cancelCellEditor();}});};YAHOO.widget.DataTable.prototype._initColumnSort=function(){this.subscribe("headerCellClickEvent",this.onEventSortColumn);};YAHOO.widget.DataTable.prototype._initDomEvents=function(){var elTable=this._elTable;var elThead=this._elThead;var elTbody=this._elTbody;var elContainer=this._elContainer;YAHOO.util.Event.addListener(document,"click",this._onDocumentClick,this);YAHOO.util.Event.addListener(document,"keydown",this._onDocumentKeydown,this);YAHOO.util.Event.addListener(elTable,"focus",this._onTableFocus,this);YAHOO.util.Event.addListener(elTable,"mouseover",this._onTableMouseover,this);YAHOO.util.Event.addListener(elTable,"mouseout",this._onTableMouseout,this);YAHOO.util.Event.addListener(elTable,"mousedown",this._onTableMousedown,this);YAHOO.util.Event.addListener(elTable,"keydown",this._onTableKeydown,this);YAHOO.util.Event.addListener(elTable,"keypress",this._onTableKeypress,this);YAHOO.util.Event.addListener(elTable,"dblclick",this._onTableDblclick,this);YAHOO.util.Event.addListener(elThead,"click",this._onTheadClick,this);YAHOO.util.Event.addListener(elTbody,"click",this._onTbodyClick,this);YAHOO.util.Event.addListener(elContainer,"scroll",this._onScroll,this);YAHOO.util.Event.addListener(elTbody,"scroll",this._onScroll,this);};YAHOO.widget.DataTable.prototype._addTrEl=function(oRecord,index){this.hideTableMessage();var append=(!YAHOO.lang.isNumber(index)||(index<0)||(index>=(this._elTbody.rows.length)))?true:false;var oColumnSet=this._oColumnSet;var oRecordSet=this._oRecordSet;var isSortedBy=this.get("sortedBy");var sortedColKeyIndex=null;var sortedDir,newClass;if(isSortedBy){sortedColKeyIndex=(isSortedBy.column)?isSortedBy.column.getKeyIndex():this._oColumnSet.getColumn(isSortedBy.key).getKeyIndex();sortedDir=isSortedBy.dir;newClass=(sortedDir==="desc")?YAHOO.widget.DataTable.CLASS_DESC:YAHOO.widget.DataTable.CLASS_ASC;}
var elRow=(append)?this._elTbody.appendChild(document.createElement("tr")):this._elTbody.insertBefore(document.createElement("tr"),this._elTbody.rows[index]);elRow.id=this.id+"-bdrow"+this._nTrCount;this._nTrCount++;elRow.yuiRecordId=oRecord.getId();for(var j=0;j<oColumnSet.keys.length;j++){var oColumn=oColumnSet.keys[j];var elCell=elRow.appendChild(document.createElement("td"));elCell.id=elRow.id+"-cell"+j;elCell.yuiColumnId=oColumn.getId();elCell.headers=oColumnSet.headers[j];elCell.yuiCellIndex=j;this.formatCell(elCell,oRecord,oColumn);if(j===0){YAHOO.util.Dom.addClass(elCell,YAHOO.widget.DataTable.CLASS_FIRST);}
else if(j===this._oColumnSet.keys.length-1){YAHOO.util.Dom.addClass(elCell,YAHOO.widget.DataTable.CLASS_LAST);}
YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_ASC);YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_DESC);if(j===sortedColKeyIndex){newClass=(sortedDir==="desc")?YAHOO.widget.DataTable.CLASS_DESC:YAHOO.widget.DataTable.CLASS_ASC;YAHOO.util.Dom.addClass(elCell,newClass);}
if(this.fixedWidth){elCell.style.overflow="hidden";}}
return elRow.id;};YAHOO.widget.DataTable.prototype._updateTrEl=function(elRow,oRecord){this.hideTableMessage();var isSortedBy=this.get("sortedBy");var sortedColKeyIndex=null;var sortedDir,newClass;if(isSortedBy){sortedColKeyIndex=(isSortedBy.column)?isSortedBy.column.getKeyIndex():this._oColumnSet.getColumn(isSortedBy.key).getKeyIndex();sortedDir=isSortedBy.dir;newClass=(sortedDir==="desc")?YAHOO.widget.DataTable.CLASS_DESC:YAHOO.widget.DataTable.CLASS_ASC;}
for(var j=0;j<elRow.cells.length;j++){var oColumn=this._oColumnSet.keys[j];var elCell=elRow.cells[j];this.formatCell(elCell,oRecord,oColumn);YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_ASC);YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_DESC);if(j===sortedColKeyIndex){YAHOO.util.Dom.addClass(elCell,newClass);}}
elRow.yuiRecordId=oRecord.getId();return elRow.id;};YAHOO.widget.DataTable.prototype._deleteTrEl=function(row){var rowIndex;if(!YAHOO.lang.isNumber(row)){rowIndex=YAHOO.util.Dom.get(row).sectionRowIndex;}
else{rowIndex=row;}
if(YAHOO.lang.isNumber(rowIndex)&&(rowIndex>-2)&&(rowIndex<this._elTbody.rows.length)){this._elTbody.deleteRow(rowIndex);return true;}
else{return false;}};YAHOO.widget.DataTable.prototype._setFirstRow=function(){var rowEl=this.getFirstTrEl();if(rowEl){if(this._sFirstTrId){YAHOO.util.Dom.removeClass(this._sFirstTrId,YAHOO.widget.DataTable.CLASS_FIRST);}
YAHOO.util.Dom.addClass(rowEl,YAHOO.widget.DataTable.CLASS_FIRST);this._sFirstTrId=rowEl.id;}
else{this._sFirstTrId=null;}};YAHOO.widget.DataTable.prototype._setLastRow=function(){var rowEl=this.getLastTrEl();if(rowEl){if(this._sLastTrId){YAHOO.util.Dom.removeClass(this._sLastTrId,YAHOO.widget.DataTable.CLASS_LAST);}
YAHOO.util.Dom.addClass(rowEl,YAHOO.widget.DataTable.CLASS_LAST);this._sLastTrId=rowEl.id;}
else{this._sLastTrId=null;}};YAHOO.widget.DataTable.prototype._setRowStripes=function(row,range){var allRows=this._elTbody.rows;var nStartIndex=0;var nEndIndex=allRows.length;if((row!==null)&&(row!==undefined)){var elStartRow=this.getTrEl(row);if(elStartRow){nStartIndex=elStartRow.sectionRowIndex;if(YAHOO.lang.isNumber(range)&&(range>1)){nEndIndex=nStartIndex+range;}}}
for(var i=nStartIndex;i<nEndIndex;i++){if(i%2){YAHOO.util.Dom.removeClass(allRows[i],YAHOO.widget.DataTable.CLASS_EVEN);YAHOO.util.Dom.addClass(allRows[i],YAHOO.widget.DataTable.CLASS_ODD);}
else{YAHOO.util.Dom.removeClass(allRows[i],YAHOO.widget.DataTable.CLASS_ODD);YAHOO.util.Dom.addClass(allRows[i],YAHOO.widget.DataTable.CLASS_EVEN);}}};YAHOO.widget.DataTable.prototype._onScroll=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(oSelf._oCellEditor.isActive){oSelf.fireEvent("editorBlurEvent",{editor:oSelf._oCellEditor});oSelf.cancelCellEditor();}
oSelf.fireEvent("tableScrollEvent",{event:e,target:elTarget});};YAHOO.widget.DataTable.prototype._onDocumentClick=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(!YAHOO.util.Dom.isAncestor(oSelf._elTable,elTarget)){oSelf.fireEvent("tableBlurEvent");if(oSelf._oCellEditor&&oSelf._oCellEditor.isActive){if(!YAHOO.util.Dom.isAncestor(oSelf._oCellEditor.container,elTarget)&&(oSelf._oCellEditor.container.id!==elTarget.id)){oSelf.fireEvent("editorBlurEvent",{editor:oSelf._oCellEditor});}}}};YAHOO.widget.DataTable.prototype._onDocumentKeydown=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(oSelf._oCellEditor&&oSelf._oCellEditor.isActive&&YAHOO.util.Dom.isAncestor(oSelf._oCellEditor.container,elTarget)){oSelf.fireEvent("editorKeydownEvent",{editor:oSelf._oCellEditor,event:e});}};YAHOO.widget.DataTable.prototype._onTableMouseover=function(e,oSelf){oSelf.fireEvent("tableFocusEvent");};YAHOO.widget.DataTable.prototype._onTableMouseover=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();while(elTarget&&(elTag!="table")){switch(elTag){case"body":break;case"a":break;case"td":oSelf.fireEvent("cellMouseoverEvent",{target:elTarget,event:e});break;case"span":if(YAHOO.util.Dom.hasClass(elTarget,YAHOO.widget.DataTable.CLASS_LABEL)){oSelf.fireEvent("headerLabelMouseoverEvent",{target:elTarget,event:e});}
break;case"th":oSelf.fireEvent("headerCellMouseoverEvent",{target:elTarget,event:e});break;case"tr":if(elTarget.parentNode.tagName.toLowerCase()=="thead"){oSelf.fireEvent("headerRowMouseoverEvent",{target:elTarget,event:e});}
else{oSelf.fireEvent("rowMouseoverEvent",{target:elTarget,event:e});}
break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableMouseoverEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onTableMouseout=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();while(elTarget&&(elTag!="table")){switch(elTag){case"body":break;case"a":break;case"td":oSelf.fireEvent("cellMouseoutEvent",{target:elTarget,event:e});break;case"span":if(YAHOO.util.Dom.hasClass(elTarget,YAHOO.widget.DataTable.CLASS_LABEL)){oSelf.fireEvent("headerLabelMouseoutEvent",{target:elTarget,event:e});}
break;case"th":oSelf.fireEvent("headerCellMouseoutEvent",{target:elTarget,event:e});break;case"tr":if(elTarget.parentNode.tagName.toLowerCase()=="thead"){oSelf.fireEvent("headerRowMouseoutEvent",{target:elTarget,event:e});}
else{oSelf.fireEvent("rowMouseoutEvent",{target:elTarget,event:e});}
break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableMouseoutEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onTableMousedown=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();while(elTarget&&(elTag!="table")){switch(elTag){case"body":break;case"a":break;case"td":oSelf.fireEvent("cellMousedownEvent",{target:elTarget,event:e});break;case"span":if(YAHOO.util.Dom.hasClass(elTarget,YAHOO.widget.DataTable.CLASS_LABEL)){oSelf.fireEvent("headerLabelMousedownEvent",{target:elTarget,event:e});}
break;case"th":oSelf.fireEvent("headerCellMousedownEvent",{target:elTarget,event:e});break;case"tr":if(elTarget.parentNode.tagName.toLowerCase()=="thead"){oSelf.fireEvent("headerRowMousedownEvent",{target:elTarget,event:e});}
else{oSelf.fireEvent("rowMousedownEvent",{target:elTarget,event:e});}
break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableMousedownEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onTableDblclick=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();while(elTarget&&(elTag!="table")){switch(elTag){case"body":break;case"td":oSelf.fireEvent("cellDblclickEvent",{target:elTarget,event:e});break;case"span":if(YAHOO.util.Dom.hasClass(elTarget,YAHOO.widget.DataTable.CLASS_LABEL)){oSelf.fireEvent("headerLabelDblclickEvent",{target:elTarget,event:e});}
break;case"th":oSelf.fireEvent("headerCellDblclickEvent",{target:elTarget,event:e});break;case"tr":if(elTarget.parentNode.tagName.toLowerCase()=="thead"){oSelf.fireEvent("headerRowDblclickEvent",{target:elTarget,event:e});}
else{oSelf.fireEvent("rowDblclickEvent",{target:elTarget,event:e});}
break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableDblclickEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onTableKeydown=function(e,oSelf){var bSHIFT=e.shiftKey;var elTarget=YAHOO.util.Event.getTarget(e);if(YAHOO.util.Dom.isAncestor(oSelf._elThead,elTarget)){return;}
var nKey=YAHOO.util.Event.getCharCode(e);if(nKey===9&&!bSHIFT&&(elTarget.id===oSelf._elTable.id)){if(oSelf._sFirstLabelLinkId){YAHOO.util.Event.stopEvent(e);oSelf._focusEl(YAHOO.util.Dom.get(oSelf._sFirstLabelLinkId));}
return;}
var lastSelectedId=oSelf._sLastSelectedId;var lastSelectedEl=YAHOO.util.Dom.get(lastSelectedId);if(lastSelectedEl&&oSelf.isSelected(lastSelectedEl)){if((nKey>36)&&(nKey<41)){YAHOO.util.Event.stopEvent(e);}
else{return;}
var sMode=oSelf.get("selectionMode");var allRows=oSelf._elTbody.rows;var anchorId=oSelf._sSelectionAnchorId;var anchorEl=YAHOO.util.Dom.get(anchorId);var newSelectedEl,trIndex,tdIndex,startIndex,endIndex,i,anchorPos;if(bSHIFT&&(sMode=="cellblock")){trIndex=lastSelectedEl.parentNode.sectionRowIndex;tdIndex=lastSelectedEl.yuiCellIndex;if(nKey==40){if(anchorEl.parentNode.sectionRowIndex>trIndex){anchorPos=1;}
else if(anchorEl.parentNode.sectionRowIndex<trIndex){anchorPos=-1;}
else{anchorPos=0;}
startIndex=Math.min(anchorEl.yuiCellIndex,tdIndex);endIndex=Math.max(anchorEl.yuiCellIndex,tdIndex);if(anchorPos<=0){if(trIndex<allRows.length-1){for(i=startIndex;i<=endIndex;i++){newSelectedEl=allRows[trIndex+1].cells[i];oSelf.selectCell(newSelectedEl);}
oSelf._sLastSelectedId=allRows[trIndex+1].cells[tdIndex].id;}}
else{for(i=startIndex;i<=endIndex;i++){oSelf.unselectCell(allRows[trIndex].cells[i]);}
oSelf._sLastSelectedId=allRows[trIndex+1].cells[tdIndex].id;}}
else if(nKey==38){if(anchorEl.parentNode.sectionRowIndex>trIndex){anchorPos=1;}
else if(anchorEl.parentNode.sectionRowIndex<trIndex){anchorPos=-1;}
else{anchorPos=0;}
startIndex=Math.min(anchorEl.yuiCellIndex,tdIndex);endIndex=Math.max(anchorEl.yuiCellIndex,tdIndex);if(anchorPos>=0){if(trIndex>0){for(i=startIndex;i<=endIndex;i++){newSelectedEl=allRows[trIndex-1].cells[i];oSelf.selectCell(newSelectedEl);}
oSelf._sLastSelectedId=allRows[trIndex-1].cells[tdIndex].id;}}
else{for(i=startIndex;i<=endIndex;i++){oSelf.unselectCell(allRows[trIndex].cells[i]);}
oSelf._sLastSelectedId=allRows[trIndex-1].cells[tdIndex].id;}}
else if(nKey==39){if(anchorEl.yuiCellIndex>tdIndex){anchorPos=1;}
else if(anchorEl.yuiCellIndex<tdIndex){anchorPos=-1;}
else{anchorPos=0;}
if(anchorPos<=0){if(tdIndex<allRows[trIndex].cells.length-1){startIndex=Math.min(anchorEl.parentNode.sectionRowIndex,trIndex);endIndex=Math.max(anchorEl.parentNode.sectionRowIndex,trIndex);for(i=startIndex;i<=endIndex;i++){newSelectedEl=allRows[i].cells[tdIndex+1];oSelf.selectCell(newSelectedEl);}
oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex+1].id;}}
else{startIndex=Math.min(anchorEl.parentNode.sectionRowIndex,trIndex);endIndex=Math.max(anchorEl.parentNode.sectionRowIndex,trIndex);for(i=startIndex;i<=endIndex;i++){oSelf.unselectCell(allRows[i].cells[tdIndex]);}
oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex+1].id;}}
else if(nKey==37){if(anchorEl.yuiCellIndex>tdIndex){anchorPos=1;}
else if(anchorEl.yuiCellIndex<tdIndex){anchorPos=-1;}
else{anchorPos=0;}
if(anchorPos>=0){if(tdIndex>0){startIndex=Math.min(anchorEl.parentNode.sectionRowIndex,trIndex);endIndex=Math.max(anchorEl.parentNode.sectionRowIndex,trIndex);for(i=startIndex;i<=endIndex;i++){newSelectedEl=allRows[i].cells[tdIndex-1];oSelf.selectCell(newSelectedEl);}
oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex-1].id;}}
else{startIndex=Math.min(anchorEl.parentNode.sectionRowIndex,trIndex);endIndex=Math.max(anchorEl.parentNode.sectionRowIndex,trIndex);for(i=startIndex;i<=endIndex;i++){oSelf.unselectCell(allRows[i].cells[tdIndex]);}
oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex-1].id;}}}
else if(bSHIFT&&(sMode=="cellrange")){trIndex=lastSelectedEl.parentNode.sectionRowIndex;tdIndex=lastSelectedEl.yuiCellIndex;if(anchorEl.parentNode.sectionRowIndex>trIndex){anchorPos=1;}
else if(anchorEl.parentNode.sectionRowIndex<trIndex){anchorPos=-1;}
else{anchorPos=0;}
if(nKey==40){if(anchorPos<=0){for(i=tdIndex+1;i<allRows[trIndex].cells.length;i++){newSelectedEl=allRows[trIndex].cells[i];oSelf.selectCell(newSelectedEl);}
if(trIndex<allRows.length-1){for(i=0;i<=tdIndex;i++){newSelectedEl=allRows[trIndex+1].cells[i];oSelf.selectCell(newSelectedEl);}}}
else{for(i=tdIndex;i<allRows[trIndex].cells.length;i++){oSelf.unselectCell(allRows[trIndex].cells[i]);}
for(i=0;i<tdIndex;i++){oSelf.unselectCell(allRows[trIndex+1].cells[i]);}
oSelf._sLastSelectedId=allRows[trIndex+1].cells[tdIndex].id;}}
else if(nKey==38){if(anchorPos>=0){for(i=tdIndex-1;i>-1;i--){newSelectedEl=allRows[trIndex].cells[i];oSelf.selectCell(newSelectedEl);}
if(trIndex>0){for(i=allRows[trIndex].cells.length-1;i>=tdIndex;i--){newSelectedEl=allRows[trIndex-1].cells[i];oSelf.selectCell(newSelectedEl);}}}
else{for(i=tdIndex;i>-1;i--){oSelf.unselectCell(allRows[trIndex].cells[i]);}
for(i=allRows[trIndex].cells.length-1;i>tdIndex;i--){oSelf.unselectCell(allRows[trIndex-1].cells[i]);}
oSelf._sLastSelectedId=allRows[trIndex-1].cells[tdIndex].id;}}
else if(nKey==39){if(anchorPos<0){if(tdIndex<allRows[trIndex].cells.length-1){newSelectedEl=allRows[trIndex].cells[tdIndex+1];oSelf.selectCell(newSelectedEl);}
else if(trIndex<allRows.length-1){newSelectedEl=allRows[trIndex+1].cells[0];oSelf.selectCell(newSelectedEl);}}
else if(anchorPos>0){oSelf.unselectCell(allRows[trIndex].cells[tdIndex]);if(tdIndex<allRows[trIndex].cells.length-1){oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex+1].id;}
else{oSelf._sLastSelectedId=allRows[trIndex+1].cells[0].id;}}
else{if(anchorEl.yuiCellIndex<=tdIndex){if(tdIndex<allRows[trIndex].cells.length-1){newSelectedEl=allRows[trIndex].cells[tdIndex+1];oSelf.selectCell(newSelectedEl);}
else if(trIndex<allRows.length-1){newSelectedEl=allRows[trIndex+1].cells[0];oSelf.selectCell(newSelectedEl);}}
else{oSelf.unselectCell(allRows[trIndex].cells[tdIndex]);oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex+1].id;}}}
else if(nKey==37){if(anchorPos<0){oSelf.unselectCell(allRows[trIndex].cells[tdIndex]);if(tdIndex>0){oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex-1].id;}
else{oSelf._sLastSelectedId=allRows[trIndex-1].cells[allRows[trIndex-1].cells.length-1].id;}}
else if(anchorPos>0){if(tdIndex>0){newSelectedEl=allRows[trIndex].cells[tdIndex-1];oSelf.selectCell(newSelectedEl);}
else if(trIndex>0){newSelectedEl=allRows[trIndex-1].cells[allRows[trIndex-1].cells.length-1];oSelf.selectCell(newSelectedEl);}}
else{if(anchorEl.yuiCellIndex>=tdIndex){if(tdIndex>0){newSelectedEl=allRows[trIndex].cells[tdIndex-1];oSelf.selectCell(newSelectedEl);}
else if(trIndex>0){newSelectedEl=allRows[trIndex-1].cells[allRows[trIndex-1].cells.length-1];oSelf.selectCell(newSelectedEl);}}
else{oSelf.unselectCell(allRows[trIndex].cells[tdIndex]);if(tdIndex>0){oSelf._sLastSelectedId=allRows[trIndex].cells[tdIndex-1].id;}
else{oSelf._sLastSelectedId=allRows[trIndex-1].cells[allRows[trIndex-1].cells.length-1].id;}}}}}
else if((sMode=="cellblock")||(sMode=="cellrange")||(sMode=="singlecell")){trIndex=lastSelectedEl.parentNode.sectionRowIndex;tdIndex=lastSelectedEl.yuiCellIndex;if(nKey==40){oSelf.unselectAllCells();if(trIndex<allRows.length-1){newSelectedEl=allRows[trIndex+1].cells[tdIndex];oSelf.selectCell(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectCell(newSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}
else if(nKey==38){oSelf.unselectAllCells();if(trIndex>0){newSelectedEl=allRows[trIndex-1].cells[tdIndex];oSelf.selectCell(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectCell(newSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}
else if(nKey==39){oSelf.unselectAllCells();if(tdIndex<lastSelectedEl.parentNode.cells.length-1){newSelectedEl=lastSelectedEl.parentNode.cells[tdIndex+1];oSelf.selectCell(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectCell(newSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}
else if(nKey==37){oSelf.unselectAllCells();if(tdIndex>0){newSelectedEl=lastSelectedEl.parentNode.cells[tdIndex-1];oSelf.selectCell(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectCell(newSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}}
else if(bSHIFT&&(sMode!="single")){trIndex=lastSelectedEl.sectionRowIndex;if(anchorEl.sectionRowIndex>trIndex){anchorPos=1;}
else if(anchorEl.sectionRowIndex<trIndex){anchorPos=-1;}
else{anchorPos=0;}
if(nKey==40){if(anchorPos<=0){if(trIndex<allRows.length-1){oSelf.selectRow(trIndex+1);}}
else{oSelf.unselectRow(lastSelectedEl);oSelf._sLastSelectedId=allRows[trIndex+1].id;}}
else if(nKey==38){if(anchorPos>=0){if(trIndex>0){oSelf.selectRow(trIndex-1);}}
else{oSelf.unselectRow(lastSelectedEl);oSelf._sLastSelectedId=allRows[trIndex-1].id;}}
else if(nKey==39){}
else if(nKey==37){}}
else{trIndex=lastSelectedEl.sectionRowIndex;if(nKey==40){oSelf.unselectAllRows();if(trIndex<allRows.length-1){newSelectedEl=allRows[trIndex+1];oSelf.selectRow(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectRow(lastSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}
else if(nKey==38){oSelf.unselectAllRows();if(trIndex>0){newSelectedEl=allRows[trIndex-1];oSelf.selectRow(newSelectedEl);}
else{newSelectedEl=lastSelectedEl;oSelf.selectRow(newSelectedEl);}
oSelf._sSelectionAnchorId=newSelectedEl.id;}
else if(nKey==39){}
else if(nKey==37){}}}};YAHOO.widget.DataTable.prototype._onTableKeypress=function(e,oSelf){var isMac=(navigator.userAgent.toLowerCase().indexOf("mac")!=-1);if(isMac){var nKey=YAHOO.util.Event.getCharCode(e);if(nKey==40){YAHOO.util.Event.stopEvent(e);}
else if(nKey==38){YAHOO.util.Event.stopEvent(e);}}};YAHOO.widget.DataTable.prototype._onTheadClick=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(oSelf._oCellEditor&&oSelf._oCellEditor.isActive){oSelf.fireEvent("editorBlurEvent",{editor:oSelf._oCellEditor});}
while(elTarget&&(elTag!="thead")){switch(elTag){case"body":break;case"span":if(YAHOO.util.Dom.hasClass(elTarget,YAHOO.widget.DataTable.CLASS_LABEL)){oSelf.fireEvent("headerLabelClickEvent",{target:elTarget,event:e});}
break;case"th":oSelf.fireEvent("headerCellClickEvent",{target:elTarget,event:e});break;case"tr":oSelf.fireEvent("headerRowClickEvent",{target:elTarget,event:e});break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableClickEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onTbodyClick=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(oSelf._oCellEditor&&oSelf._oCellEditor.isActive){oSelf.fireEvent("editorBlurEvent",{editor:oSelf._oCellEditor});}
while(elTarget&&(elTag!="table")){switch(elTag){case"body":break;case"input":if(elTarget.type.toLowerCase()=="checkbox"){oSelf.fireEvent("checkboxClickEvent",{target:elTarget,event:e});}
else if(elTarget.type.toLowerCase()=="radio"){oSelf.fireEvent("radioClickEvent",{target:elTarget,event:e});}
break;case"a":oSelf.fireEvent("linkClickEvent",{target:elTarget,event:e});break;case"button":oSelf.fireEvent("buttonClickEvent",{target:elTarget,event:e});break;case"td":oSelf.fireEvent("cellClickEvent",{target:elTarget,event:e});break;case"tr":oSelf.fireEvent("rowClickEvent",{target:elTarget,event:e});break;default:break;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}}
oSelf.fireEvent("tableClickEvent",{target:(elTarget||oSelf._elTable),event:e});};YAHOO.widget.DataTable.prototype._onPaginatorLinkClick=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var elTag=elTarget.tagName.toLowerCase();if(oSelf._oCellEditor&&oSelf._oCellEditor.isActive){oSelf.fireEvent("editorBlurEvent",{editor:oSelf._oCellEditor});}
while(elTarget&&(elTag!="table")){switch(elTag){case"body":return;case"a":YAHOO.util.Event.stopEvent(e);switch(elTarget.className){case YAHOO.widget.DataTable.CLASS_PAGE:oSelf.showPage(parseInt(elTarget.innerHTML,10));return;case YAHOO.widget.DataTable.CLASS_FIRST:oSelf.showPage(1);return;case YAHOO.widget.DataTable.CLASS_LAST:oSelf.showPage(oSelf.get("paginator").totalPages);return;case YAHOO.widget.DataTable.CLASS_PREVIOUS:oSelf.showPage(oSelf.get("paginator").currentPage-1);return;case YAHOO.widget.DataTable.CLASS_NEXT:oSelf.showPage(oSelf.get("paginator").currentPage+1);return;}
break;default:return;}
elTarget=elTarget.parentNode;if(elTarget){elTag=elTarget.tagName.toLowerCase();}
else{return;}}};YAHOO.widget.DataTable.prototype._onPaginatorDropdownChange=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);var newValue=elTarget[elTarget.selectedIndex].value;var newRowsPerPage=YAHOO.lang.isValue(parseInt(newValue,10))?parseInt(newValue,10):null;if(newRowsPerPage!==null){var newStartRecordIndex=(oSelf.get("paginator").currentPage-1)*newRowsPerPage;oSelf.updatePaginator({rowsPerPage:newRowsPerPage,startRecordIndex:newStartRecordIndex});oSelf.refreshView();}
else{}};YAHOO.widget.DataTable.prototype._onDropdownChange=function(e,oSelf){var elTarget=YAHOO.util.Event.getTarget(e);oSelf.fireEvent("dropdownChangeEvent",{event:e,target:elTarget});};YAHOO.widget.DataTable.prototype.toString=function(){return"DataTable "+this._sName;};YAHOO.widget.DataTable.prototype.getDataSource=function(){return this._oDataSource;};YAHOO.widget.DataTable.prototype.getColumnSet=function(){return this._oColumnSet;};YAHOO.widget.DataTable.prototype.getRecordSet=function(){return this._oRecordSet;};YAHOO.widget.DataTable.prototype.getCellEditor=function(){return this._oCellEditor;};YAHOO.widget.DataTable.prototype.getTableEl=function(){return this._elTable;};YAHOO.widget.DataTable.prototype.getTheadEl=function(){return this._elThead;};YAHOO.widget.DataTable.prototype.getTbodyEl=function(){return this._elTbody;};YAHOO.widget.DataTable.prototype.getBody=function(){return this.getTbodyEl();};YAHOO.widget.DataTable.prototype.getMsgTbodyEl=function(){return this._elMsgTbody;};YAHOO.widget.DataTable.prototype.getMsgTdEl=function(){return this._elMsgTd;};YAHOO.widget.DataTable.prototype.getTrEl=function(row){var allRows=this._elTbody.rows;if(row instanceof YAHOO.widget.Record){var nTrIndex=this.getTrIndex(row);return allRows[nTrIndex];}
else if(YAHOO.lang.isNumber(row)&&(row>-1)&&(row<allRows.length)){return allRows[row];}
else{var elRow;var el=YAHOO.util.Dom.get(row);if(el&&(el.ownerDocument==document)){if(el.tagName.toLowerCase()!="tr"){elRow=YAHOO.util.Dom.getAncestorByTagName(el,"tr");}
else{elRow=el;}
if(elRow&&(elRow.parentNode==this._elTbody)){return elRow;}}}
return null;};YAHOO.widget.DataTable.prototype.getRow=function(index){return this.getTrEl(index);};YAHOO.widget.DataTable.prototype.getFirstTrEl=function(){return this._elTbody.rows[0]||null;};YAHOO.widget.DataTable.prototype.getLastTrEl=function(){var allRows=this._elTbody.rows;if(allRows.length>0){return allRows[allRows.length-1]||null;}};YAHOO.widget.DataTable.prototype.getTdEl=function(cell){var elCell;var el=YAHOO.util.Dom.get(cell);if(el&&(el.ownerDocument==document)){if(el.tagName.toLowerCase()!="td"){elCell=YAHOO.util.Dom.getAncestorByTagName(el,"td");}
else{elCell=el;}
if(elCell&&(elCell.parentNode.parentNode==this._elTbody)){return elCell;}}
return null;};YAHOO.widget.DataTable.prototype.getThEl=function(header){var elHeader;if(header instanceof YAHOO.widget.Column){var oColumn=header;elHeader=YAHOO.util.Dom.get(this.id+"-col"+oColumn.getId());if(elHeader){return elHeader;}}
else{var el=YAHOO.util.Dom.get(header);if(el&&(el.ownerDocument==document)){if(el.tagName.toLowerCase()!="th"){elHeader=YAHOO.util.Dom.getAncestorByTagName(el,"th");}
else{elHeader=el;}
if(elHeader&&(elHeader.parentNode.parentNode==this._elThead)){return elHeader;}}}
return null;};YAHOO.widget.DataTable.prototype.getTrIndex=function(row){var nRecordIndex;if(row instanceof YAHOO.widget.Record){nRecordIndex=this._oRecordSet.getRecordIndex(row);}
else if(YAHOO.lang.isNumber(row)){nRecordIndex=row;}
if(YAHOO.lang.isNumber(nRecordIndex)){if(this.get("paginated")){var startRecordIndex=this.get("paginator").startRecordIndex;var endRecordIndex=startRecordIndex+this.get("paginator").rowsPerPage-1;if((nRecordIndex>=startRecordIndex)&&(nRecordIndex<=endRecordIndex)){return nRecordIndex-startRecordIndex;}
else{return null;}}
else{return nRecordIndex;}}
else{elRow=this.getTrEl(row);if(elRow&&(elRow.ownerDocument==document)&&(elRow.parentNode==this._elTbody)){return elRow.sectionRowIndex;}}
return null;};YAHOO.widget.DataTable.prototype.initializeTable=function(oData){this._oRecordSet.reset();var records=this._oRecordSet.addRecords(oData);this._unselectAllTrEls();this._unselectAllTdEls();this._aSelections=null;this._sLastSelectedId=null;this._sSelectionAnchorId=null;this.refreshView();this.fireEvent("initEvent");};YAHOO.widget.DataTable.prototype.refreshView=function(){var i,j,k,l,aRecords;var oPaginator=this.updatePaginator();if(this.get("paginated")){var rowsPerPage=oPaginator.rowsPerPage;var startRecordIndex=(oPaginator.currentPage-1)*rowsPerPage;aRecords=this._oRecordSet.getRecords(startRecordIndex,rowsPerPage);this.formatPaginators();}
else{aRecords=this._oRecordSet.getRecords();}
var elTbody=this._elTbody;var elRows=elTbody.rows;if(YAHOO.lang.isArray(aRecords)&&(aRecords.length>0)){this.hideTableMessage();var aSelectedRows=this.getSelectedRows();var aSelectedCells=this.getSelectedCells();var bReselect=(aSelectedRows.length>0)||(aSelectedCells.length>0);while(elTbody.hasChildNodes()&&(elRows.length>aRecords.length)){elTbody.deleteRow(-1);}
if(bReselect){this._unselectAllTrEls();this._unselectAllTdEls();}
for(i=0;i<elRows.length;i++){this._updateTrEl(elRows[i],aRecords[i]);}
for(i=elRows.length;i<aRecords.length;i++){this._addTrEl(aRecords[i]);}
var allRows=elTbody.rows;if(bReselect){for(j=0;j<allRows.length;j++){var thisRow=allRows[j];var sMode=this.get("selectionMode");if((sMode=="standard")||(sMode=="single")){for(k=0;k<aSelectedRows.length;k++){if(aSelectedRows[k]===thisRow.yuiRecordId){YAHOO.util.Dom.addClass(thisRow,YAHOO.widget.DataTable.CLASS_SELECTED);if(j===allRows.length-1){this._sLastSelectedId=thisRow.id;this._sSelectionAnchorId=thisRow.id;}}}}
else{for(k=0;k<thisRow.cells.length;k++){var thisCell=thisRow.cells[k];for(l=0;l<aSelectedCells.length;l++){if((aSelectedCells[l].recordId===thisRow.yuiRecordId)&&(aSelectedCells[l].columnId===thisCell.yuiColumnId)){YAHOO.util.Dom.addClass(thisCell,YAHOO.widget.DataTable.CLASS_SELECTED);if(k===thisRow.cells.length-1){this._sLastSelectedId=thisCell.id;this._sSelectionAnchorId=thisCell.id;}}}}}}}
this._setFirstRow();this._setLastRow();this._setRowStripes();this.fireEvent("refreshEvent");}
else{while(elTbody.hasChildNodes()){elTbody.deleteRow(-1);}
this.showTableMessage(YAHOO.widget.DataTable.MSG_EMPTY,YAHOO.widget.DataTable.CLASS_EMPTY);}};YAHOO.widget.DataTable.prototype.destroy=function(){YAHOO.util.Event.purgeElement(this._oCellEditor.container,true);document.body.removeChild(this._oCellEditor.container);var instanceName=this.toString();var elContainer=this._elContainer;this._oRecordSet.unsubscribeAll();this.unsubscribeAll();YAHOO.util.Event.purgeElement(elContainer,true);elContainer.innerHTML="";for(var param in this){if(this.hasOwnProperty(param)){this[param]=null;}}};YAHOO.widget.DataTable.prototype.showTableMessage=function(sHTML,sClassName){var elCell=this._elMsgTd;if(YAHOO.lang.isString(sHTML)){elCell.innerHTML=sHTML;}
if(YAHOO.lang.isString(sClassName)){YAHOO.util.Dom.addClass(elCell,sClassName);}
this._elMsgTbody.style.display="";this.fireEvent("tableMsgShowEvent",{html:sHTML,className:sClassName});};YAHOO.widget.DataTable.prototype.hideTableMessage=function(){if(this._elMsgTbody.style.display!="none"){this._elMsgTbody.style.display="none";this.fireEvent("tableMsgHideEvent");}};YAHOO.widget.DataTable.prototype.focus=function(){this._focusEl(this._elTable);};YAHOO.widget.DataTable.prototype.getRecordIndex=function(row){var nTrIndex;if(!YAHOO.lang.isNumber(row)){if(row instanceof YAHOO.widget.Record){return this._oRecordSet.getRecordIndex(row);}
else{var el=this.getTrEl(row);if(el){nTrIndex=el.sectionRowIndex;}}}
else{nTrIndex=row;}
if(YAHOO.lang.isNumber(nTrIndex)){if(this.get("paginated")){return this.get("paginator").startRecordIndex+nTrIndex;}
else{return nTrIndex;}}
return null;};YAHOO.widget.DataTable.prototype.getRecord=function(row){var nRecordIndex=row;if(!YAHOO.lang.isNumber(nRecordIndex)){var elRow=this.getTrEl(row);if(elRow){nRecordIndex=this.getRecordIndex(row);}}
if(YAHOO.lang.isNumber(nRecordIndex)){return this._oRecordSet.getRecord(nRecordIndex);}
return null;};YAHOO.widget.DataTable.prototype.getColumn=function(column){var nColumnIndex=column;if(!YAHOO.lang.isNumber(nColumnIndex)){var elCell=this.getTdEl(column);if(elCell){nColumnIndex=elCell.yuiColumnId;}
else{elCell=this.getThEl(column);if(elCell){nColumnIndex=elCell.yuiColumnId;}}}
if(YAHOO.lang.isNumber(nColumnIndex)){return this._oColumnSet.getColumn(nColumnIndex);}
return null;};YAHOO.widget.DataTable.prototype.sortColumn=function(oColumn){if(!oColumn){return;}
if(!oColumn instanceof YAHOO.widget.Column){return;}
if(oColumn.sortable){var sortDir=(oColumn.sortOptions&&oColumn.sortOptions.defaultOrder)?oColumn.sortOptions.defaultOrder:"asc";var oSortedBy=this.get("sortedBy");if(oSortedBy&&(oSortedBy.key===oColumn.key)){if(oSortedBy.dir){sortDir=(oSortedBy.dir=="asc")?"desc":"asc";}
else{sortDir=(sortDir=="asc")?"desc":"asc";}}
var sortFnc=(oColumn.sortOptions&&YAHOO.lang.isFunction(oColumn.sortOptions.sortFunction))?oColumn.sortOptions.sortFunction:function(a,b,desc){var sorted=YAHOO.util.Sort.compare(a.getData(oColumn.key),b.getData(oColumn.key),desc);if(sorted===0){return YAHOO.util.Sort.compare(a.getId(),b.getId(),desc);}
else{return sorted;}};var desc=(sortDir=="desc")?true:false;this._oRecordSet.sortRecords(sortFnc,desc);this.set("sortedBy",{key:oColumn.key,dir:sortDir,column:oColumn});this.updatePaginator({currentPage:1});this.refreshView();this.fireEvent("columnSortEvent",{column:oColumn,dir:sortDir});}
else{}};YAHOO.widget.DataTable.prototype.addRow=function(oData,index){if(oData&&(oData.constructor==Object)){var oRecord=this._oRecordSet.addRecord(oData,index);if(oRecord){var nTrIndex=this.getTrIndex(oRecord);if(YAHOO.lang.isNumber(nTrIndex)){if(this.get("paginated")){this.refreshView();}
else{var newTrId=this._addTrEl(oRecord,nTrIndex);if(newTrId){var append=(YAHOO.lang.isNumber(nTrIndex)&&(nTrIndex==this._elTbody.rows.length-1))?true:false;if(append){if((this._elTbody.rows.length-1)%2){YAHOO.util.Dom.addClass(newTrId,YAHOO.widget.DataTable.CLASS_ODD);}
else{YAHOO.util.Dom.addClass(newTrId,YAHOO.widget.DataTable.CLASS_EVEN);}}
else{this._setRowStripes(nTrIndex);}
if(append){this._setLastRow();}
else if(YAHOO.lang.isNumber(index)&&(nTrIndex===0)){this._setFirstRow();}}}}
else{this.updatePaginator();}
this.fireEvent("rowAddEvent",{record:oRecord});nTrIndex=(YAHOO.lang.isValue(nTrIndex))?nTrIndex:"n/a";return;}}};YAHOO.widget.DataTable.prototype.addRows=function(aData,index){if(YAHOO.lang.isArray(aData)){var i;if(YAHOO.lang.isNumber(index)){for(i=aData.length-1;i>-1;i--){this.addRow(aData[i],index);}}
else{for(i=0;i<aData.length;i++){this.addRow(aData[i]);}}}
else{}};YAHOO.widget.DataTable.prototype.updateRow=function(row,oData){var oldRecord,updatedRecord,elRow;if((row instanceof YAHOO.widget.Record)||(YAHOO.lang.isNumber(row))){oldRecord=this._oRecordSet.getRecord(row);elRow=this.getTrEl(oldRecord);}
else{elRow=this.getTrEl(row);if(elRow){oldRecord=this._oRecordSet.getRecord(this.getRecordIndex(elRow));}}
if(oldRecord){var oRecordData=oldRecord.getData();var oldData={};for(var param in oRecordData){oldData[param]=oRecordData[param];}
updatedRecord=this._oRecordSet.updateRecord(oldRecord,oData);}
else{return;}
if(elRow){this._updateTrEl(elRow,updatedRecord);}
this.fireEvent("rowUpdateEvent",{record:updatedRecord,oldData:oldData});};YAHOO.widget.DataTable.prototype.deleteRow=function(row){var nRecordIndex=null;if(YAHOO.lang.isNumber(row)){nRecordIndex=row;}
else{var elRow=YAHOO.util.Dom.get(row);elRow=this.getTrEl(elRow);if(elRow){nRecordIndex=this.getRecordIndex(elRow);}}
if(nRecordIndex!==null){var oRecord=this._oRecordSet.getRecord(nRecordIndex);if(oRecord){var nRecordId=oRecord.getId();var tracker=this._aSelections||[];for(var j=0;j<tracker.length;j++){if((YAHOO.lang.isNumber(tracker[j])&&(tracker[j]===nRecordId))||((tracker[j].constructor==Object)&&(tracker[j].recordId===nRecordId))){tracker.splice(j,1);}}
var oRecordData=oRecord.getData();var oData={};for(var param in oRecordData){oData[param]=oRecordData[param];}
this._oRecordSet.deleteRecord(nRecordIndex);var nTrIndex=this.getTrIndex(nRecordIndex);if(YAHOO.lang.isNumber(nTrIndex)){var isLast=(nTrIndex==this.getLastTrEl().sectionRowIndex)?true:false;this._deleteTrEl(nTrIndex);if(this._elTbody.rows.length===0){this.showTableMessage(YAHOO.widget.DataTable.MSG_EMPTY,YAHOO.widget.DataTable.CLASS_EMPTY);}
else{if(nTrIndex===0){this._setFirstRow();}
if(isLast){this._setLastRow();}
if(nTrIndex!=this._elTbody.rows.length){this._setRowStripes(nTrIndex);}}}
this.fireEvent("rowDeleteEvent",{recordIndex:nRecordIndex,oldData:oData,trElIndex:nTrIndex});}}
else{}};YAHOO.widget.DataTable.prototype.deleteRows=function(row,count){var nRecordIndex=null;if(YAHOO.lang.isNumber(row)){nRecordIndex=row;}
else{var elRow=YAHOO.util.Dom.get(row);elRow=this.getTrEl(elRow);if(elRow){nRecordIndex=this.getRecordIndex(elRow);}}
if(nRecordIndex!==null){if(count&&YAHOO.lang.isNumber(count)){var startIndex=(count>0)?nRecordIndex+count-1:nRecordIndex;var endIndex=(count>0)?nRecordIndex:nRecordIndex+count+1;for(var i=startIndex;i>endIndex-1;i--){this.deleteRow(i);}}
else{this.deleteRow(nRecordIndex);}}
else{}};YAHOO.widget.DataTable.prototype.formatCell=function(elCell,oRecord,oColumn){if(!(oRecord instanceof YAHOO.widget.Record)){oRecord=this.getRecord(elCell);}
if(!(oColumn instanceof YAHOO.widget.Column)){oColumn=this._oColumnSet.getColumn(elCell.yuiColumnId);}
if(oRecord&&oColumn){var oData=oRecord.getData(oColumn.key);var fnFormatter;if(YAHOO.lang.isString(oColumn.formatter)){switch(oColumn.formatter){case"button":fnFormatter=YAHOO.widget.DataTable.formatButton;break;case"checkbox":fnFormatter=YAHOO.widget.DataTable.formatCheckbox;break;case"currency":fnFormatter=YAHOO.widget.DataTable.formatCurrency;break;case"date":fnFormatter=YAHOO.widget.DataTable.formatDate;break;case"dropdown":fnFormatter=YAHOO.widget.DataTable.formatDropdown;break;case"email":fnFormatter=YAHOO.widget.DataTable.formatEmail;break;case"link":fnFormatter=YAHOO.widget.DataTable.formatLink;break;case"number":fnFormatter=YAHOO.widget.DataTable.formatNumber;break;case"radio":fnFormatter=YAHOO.widget.DataTable.formatRadio;break;case"text":fnFormatter=YAHOO.widget.DataTable.formatText;break;case"textarea":fnFormatter=YAHOO.widget.DataTable.formatTextarea;break;case"textbox":fnFormatter=YAHOO.widget.DataTable.formatTextbox;break;case"html":break;default:fnFormatter=null;}}
else if(YAHOO.lang.isFunction(oColumn.formatter)){fnFormatter=oColumn.formatter;}
if(fnFormatter){fnFormatter.call(this,elCell,oRecord,oColumn,oData);}
else{elCell.innerHTML=(YAHOO.lang.isValue(oData))?oData.toString():"";}
var aCustomClasses=null;if(YAHOO.lang.isString(oColumn.className)){aCustomClasses=[oColumn.className];}
else if(YAHOO.lang.isArray(oColumn.className)){aCustomClasses=oColumn.className;}
if(aCustomClasses){for(var i=0;i<aCustomClasses.length;i++){YAHOO.util.Dom.addClass(elCell,aCustomClasses[i]);}}
YAHOO.util.Dom.addClass(elCell,"yui-dt-col-"+oColumn.key);if(oColumn.editor){YAHOO.util.Dom.addClass(elCell,YAHOO.widget.DataTable.CLASS_EDITABLE);}
this.fireEvent("cellFormatEvent",{record:oRecord,key:oColumn.key,el:elCell});}
else{}};YAHOO.widget.DataTable.formatButton=function(el,oRecord,oColumn,oData){var sValue=YAHOO.lang.isValue(oData)?oData:"Click";el.innerHTML="<button type=\"button\" class=\""+
YAHOO.widget.DataTable.CLASS_BUTTON+"\">"+sValue+"</button>";};YAHOO.widget.DataTable.formatCheckbox=function(el,oRecord,oColumn,oData){var bChecked=oData;bChecked=(bChecked)?" checked":"";el.innerHTML="<input type=\"checkbox\""+bChecked+" class=\""+YAHOO.widget.DataTable.CLASS_CHECKBOX+"\">";};YAHOO.widget.DataTable.formatCurrency=function(el,oRecord,oColumn,oData){if(YAHOO.lang.isNumber(oData)){var nAmount=oData;var markup;nAmount=Math.round(nAmount*100)/100;markup="$"+nAmount;var dotIndex=markup.indexOf(".");if(dotIndex<0){markup+=".00";}
else{while(dotIndex>markup.length-3){markup+="0";}}
el.innerHTML=markup;}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatDate=function(el,oRecord,oColumn,oData){var oDate=oData;if(oDate instanceof Date){el.innerHTML=(oDate.getMonth()+1)+"/"+oDate.getDate()+"/"+oDate.getFullYear();}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatDropdown=function(el,oRecord,oColumn,oData){var selectedValue=(YAHOO.lang.isValue(oData))?oData:oRecord.getData(oColumn.key);var options=(YAHOO.lang.isArray(oColumn.dropdownOptions))?oColumn.dropdownOptions:null;var selectEl;var collection=el.getElementsByTagName("select");if(collection.length===0){selectEl=document.createElement("select");YAHOO.util.Dom.addClass(selectEl,YAHOO.widget.DataTable.CLASS_DROPDOWN);selectEl=el.appendChild(selectEl);YAHOO.util.Event.addListener(selectEl,"change",oDataTable._onDropdownChange,oDataTable);}
selectEl=collection[0];if(selectEl){selectEl.innerHTML="";if(options){for(var i=0;i<options.length;i++){var option=options[i];var optionEl=document.createElement("option");optionEl.value=(YAHOO.lang.isValue(option.value))?option.value:option;optionEl.innerHTML=(YAHOO.lang.isValue(option.text))?option.text:option;optionEl=selectEl.appendChild(optionEl);}}
else{selectEl.innerHTML="<option value=\""+selectedValue+"\">"+selectedValue+"</option>";}}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatEmail=function(el,oRecord,oColumn,oData){if(YAHOO.lang.isString(oData)){el.innerHTML="<a href=\"mailto:"+oData+"\">"+oData+"</a>";}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatLink=function(el,oRecord,oColumn,oData){if(YAHOO.lang.isString(oData)){el.innerHTML="<a href=\""+oData+"\">"+oData+"</a>";}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatNumber=function(el,oRecord,oColumn,oData){if(YAHOO.lang.isNumber(oData)){el.innerHTML=oData;}
else{el.innerHTML=YAHOO.lang.isValue(oData)?oData:"";}};YAHOO.widget.DataTable.formatRadio=function(el,oRecord,oColumn,oData){var bChecked=oData;bChecked=(bChecked)?" checked":"";el.innerHTML="<input type=\"radio\""+bChecked+" name=\""+oColumn.getId()+"-radio\""+" class=\""+YAHOO.widget.DataTable.CLASS_CHECKBOX+"\">";};YAHOO.widget.DataTable.formatText=function(el,oRecord,oColumn,oData){var value=(YAHOO.lang.isValue(oRecord.getData(oColumn.key)))?oRecord.getData(oColumn.key):"";el.innerHTML=value.toString().replace(/&/g,"&#38;").replace(/</g,"&#60;").replace(/>/g,"&#62;");};YAHOO.widget.DataTable.formatTextarea=function(el,oRecord,oColumn,oData){var value=(YAHOO.lang.isValue(oRecord.getData(oColumn.key)))?oRecord.getData(oColumn.key):"";var markup="<textarea>"+value+"</textarea>";el.innerHTML=markup;};YAHOO.widget.DataTable.formatTextbox=function(el,oRecord,oColumn,oData){var value=(YAHOO.lang.isValue(oRecord.getData(oColumn.key)))?oRecord.getData(oColumn.key):"";var markup="<input type=\"text\" value=\""+value+"\">";el.innerHTML=markup;};YAHOO.widget.DataTable.prototype.updatePaginator=function(oNewValues){var oValidPaginator=this.get("paginator");for(var param in oNewValues){if(oValidPaginator.hasOwnProperty(param)){oValidPaginator[param]=oNewValues[param];}}
oValidPaginator.totalRecords=this._oRecordSet.getLength();oValidPaginator.rowsThisPage=Math.min(oValidPaginator.rowsPerPage,oValidPaginator.totalRecords);oValidPaginator.totalPages=Math.ceil(oValidPaginator.totalRecords/oValidPaginator.rowsThisPage);if(isNaN(oValidPaginator.totalPages)){oValidPaginator.totalPages=0;}
this.set("paginator",oValidPaginator);return this.get("paginator");};YAHOO.widget.DataTable.prototype.showPage=function(nPage){if(!YAHOO.lang.isNumber(nPage)||(nPage<1)||(nPage>this.get("paginator").totalPages)){nPage=1;}
this.updatePaginator({currentPage:nPage});this.refreshView();};YAHOO.widget.DataTable.prototype.formatPaginators=function(){var pag=this.get("paginator");var dropdownEnabled=false;if(pag.pageLinks>-1){for(var i=0;i<pag.links.length;i++){this.formatPaginatorLinks(pag.links[i],pag.currentPage,pag.pageLinksStart,pag.pageLinks,pag.totalPages);}}
for(i=0;i<pag.dropdowns.length;i++){if(pag.dropdownOptions){dropdownEnabled=true;this.formatPaginatorDropdown(pag.dropdowns[i],pag.dropdownOptions);}
else{pag.dropdowns[i].style.display="none";}}
if(dropdownEnabled&&navigator.userAgent.toLowerCase().indexOf("opera")!=-1){document.body.style+='';}};YAHOO.widget.DataTable.prototype.formatPaginatorDropdown=function(elDropdown,dropdownOptions){if(elDropdown&&(elDropdown.ownerDocument==document)){while(elDropdown.firstChild){elDropdown.removeChild(elDropdown.firstChild);}
for(var j=0;j<dropdownOptions.length;j++){var dropdownOption=dropdownOptions[j];var optionEl=document.createElement("option");optionEl.value=(YAHOO.lang.isValue(dropdownOption.value))?dropdownOption.value:dropdownOption;optionEl.innerHTML=(YAHOO.lang.isValue(dropdownOption.text))?dropdownOption.text:dropdownOption;optionEl=elDropdown.appendChild(optionEl);}
var options=elDropdown.options;if(options.length){for(var i=options.length-1;i>-1;i--){if((this.get("paginator").rowsPerPage+"")===options[i].value){options[i].selected=true;}}}
elDropdown.style.display="";return;}};YAHOO.widget.DataTable.prototype.formatPaginatorLinks=function(elContainer,nCurrentPage,nPageLinksStart,nPageLinksLength,nTotalPages){if(elContainer&&(elContainer.ownerDocument==document)&&YAHOO.lang.isNumber(nCurrentPage)&&YAHOO.lang.isNumber(nPageLinksStart)&&YAHOO.lang.isNumber(nTotalPages)){var bIsFirstPage=(nCurrentPage==1)?true:false;var bIsLastPage=(nCurrentPage==nTotalPages)?true:false;var sFirstLinkMarkup=(bIsFirstPage)?" <span class=\""+YAHOO.widget.DataTable.CLASS_DISABLED+" "+YAHOO.widget.DataTable.CLASS_FIRST+"\">&lt;&lt;</span> ":" <a href=\"#\" class=\""+YAHOO.widget.DataTable.CLASS_FIRST+"\">&lt;&lt;</a> ";var sPrevLinkMarkup=(bIsFirstPage)?" <span class=\""+YAHOO.widget.DataTable.CLASS_DISABLED+" "+YAHOO.widget.DataTable.CLASS_PREVIOUS+"\">&lt;</span> ":" <a href=\"#\" class=\""+YAHOO.widget.DataTable.CLASS_PREVIOUS+"\">&lt;</a> ";var sNextLinkMarkup=(bIsLastPage)?" <span class=\""+YAHOO.widget.DataTable.CLASS_DISABLED+" "+YAHOO.widget.DataTable.CLASS_NEXT+"\">&gt;</span> ":" <a href=\"#\" class=\""+YAHOO.widget.DataTable.CLASS_NEXT+"\">&gt;</a> ";var sLastLinkMarkup=(bIsLastPage)?" <span class=\""+YAHOO.widget.DataTable.CLASS_DISABLED+" "+YAHOO.widget.DataTable.CLASS_LAST+"\">&gt;&gt;</span> ":" <a href=\"#\" class=\""+YAHOO.widget.DataTable.CLASS_LAST+"\">&gt;&gt;</a> ";var sMarkup=sFirstLinkMarkup+sPrevLinkMarkup;var nMaxLinks=nTotalPages;var nFirstLink=1;var nLastLink=nTotalPages;if(nPageLinksLength>0){nMaxLinks=(nPageLinksStart+nPageLinksLength<nTotalPages)?nPageLinksStart+nPageLinksLength-1:nTotalPages;nFirstLink=(nCurrentPage-Math.floor(nMaxLinks/2)>0)?nCurrentPage-Math.floor(nMaxLinks/2):1;nLastLink=(nCurrentPage+Math.floor(nMaxLinks/2)<=nTotalPages)?nCurrentPage+Math.floor(nMaxLinks/2):nTotalPages;if(nFirstLink===1){nLastLink=nMaxLinks;}
else if(nLastLink===nTotalPages){nFirstLink=nTotalPages-nMaxLinks+1;}
if(nLastLink-nFirstLink===nMaxLinks){nLastLink--;}}
for(var i=nFirstLink;i<=nLastLink;i++){if(i!=nCurrentPage){sMarkup+=" <a href=\"#\" class=\""+YAHOO.widget.DataTable.CLASS_PAGE+"\">"+i+"</a> ";}
else{sMarkup+=" <span class=\""+YAHOO.widget.DataTable.CLASS_SELECTED+"\">"+i+"</span>";}}
sMarkup+=sNextLinkMarkup+sLastLinkMarkup;elContainer.innerHTML=sMarkup;return;}};YAHOO.widget.DataTable.prototype._sLastHighlightedCellId=null;YAHOO.widget.DataTable.prototype._sLastHighlightedRowId=null;YAHOO.widget.DataTable.prototype._aSelections=null;YAHOO.widget.DataTable.prototype._sLastSelectedId=null;YAHOO.widget.DataTable.prototype._sSelectionAnchorId=null;YAHOO.widget.DataTable.prototype._unselectAllTrEls=function(){var selectedRows=YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_SELECTED,"tr",this._elTbody);YAHOO.util.Dom.removeClass(selectedRows,YAHOO.widget.DataTable.CLASS_SELECTED);};YAHOO.widget.DataTable.prototype.getSelectedTrEls=function(){return YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_SELECTED,"tr",this._elTbody);};YAHOO.widget.DataTable.prototype.selectRow=function(row){var elRow=this.getTrEl(row);if(elRow){var oRecord=this.getRecord(elRow);if(oRecord){var tracker=this._aSelections||[];var nRecordId=oRecord.getId();if(tracker.indexOf&&(tracker.indexOf(nRecordId)>-1)){tracker.splice(tracker.indexOf(nRecordId),1);}
else{for(var j=0;j<tracker.length;j++){if(tracker[j]===nRecordId){tracker.splice(j,1);}}}
tracker.push(nRecordId);this._sLastSelectedId=elRow.id;if(!this._sSelectionAnchorId){this._sSelectionAnchorId=elRow.id;}
this._aSelections=tracker;YAHOO.util.Dom.addClass(elRow,YAHOO.widget.DataTable.CLASS_SELECTED);this.fireEvent("rowSelectEvent",{record:oRecord,el:elRow});return;}}};YAHOO.widget.DataTable.prototype.select=function(els){if(!YAHOO.lang.isArray(els)){els=[els];}
for(var i=0;i<els.length;i++){this.selectRow(els[i]);}};YAHOO.widget.DataTable.prototype.unselectRow=function(row){var elRow=this.getTrEl(row);if(elRow){var oRecord=this.getRecord(elRow);if(oRecord){var tracker=this._aSelections||[];var nRecordId=oRecord.getId();var bFound=false;if(tracker.indexOf&&(tracker.indexOf(nRecordId)>-1)){tracker.splice(tracker.indexOf(nRecordId),1);bFound=true;}
else{for(var j=0;j<tracker.length;j++){if(tracker[j]===nRecordId){tracker.splice(j,1);bFound=true;}}}
if(bFound){this._aSelections=tracker;YAHOO.util.Dom.removeClass(elRow,YAHOO.widget.DataTable.CLASS_SELECTED);this.fireEvent("rowUnselectEvent",{record:oRecord,el:elRow});return;}}}};YAHOO.widget.DataTable.prototype.unselectAllRows=function(){var tracker=this._aSelections||[];for(var j=0;j<tracker.length;j++){if(YAHOO.lang.isNumber(tracker[j])){tracker.splice(j,1);}}
this._aSelections=tracker;this._unselectAllTrEls();this.fireEvent("unselectAllRowsEvent");};YAHOO.widget.DataTable.prototype._unselectAllTdEls=function(){var selectedCells=YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_SELECTED,"td",this._elTbody);YAHOO.util.Dom.removeClass(selectedCells,YAHOO.widget.DataTable.CLASS_SELECTED);};YAHOO.widget.DataTable.prototype.getSelectedTdEls=function(){return YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_SELECTED,"td",this._elTbody);};YAHOO.widget.DataTable.prototype.selectCell=function(cell){var elCell=this.getTdEl(cell);if(elCell){var oRecord=this.getRecord(elCell);var nColumnId=elCell.yuiColumnId;if(oRecord&&YAHOO.lang.isNumber(nColumnId)){var tracker=this._aSelections||[];var nRecordId=oRecord.getId();for(var j=0;j<tracker.length;j++){if((tracker[j].recordId===nRecordId)&&(tracker[j].columnId===nColumnId)){tracker.splice(j,1);}}
tracker.push({recordId:nRecordId,columnId:nColumnId});this._aSelections=tracker;this._sLastSelectedId=elCell.id;if(!this._sSelectionAnchorId){this._sSelectionAnchorId=elCell.id;}
YAHOO.util.Dom.addClass(elCell,YAHOO.widget.DataTable.CLASS_SELECTED);this.fireEvent("cellSelectEvent",{record:oRecord,key:this._oColumnSet.getColumn(nColumnId).key,el:elCell});return;}}};YAHOO.widget.DataTable.prototype.unselectCell=function(cell){var elCell=this.getTdEl(cell);if(elCell){var oRecord=this.getRecord(elCell);var nColumnId=elCell.yuiColumnId;if(oRecord&&YAHOO.lang.isNumber(nColumnId)){var tracker=this._aSelections||[];var id=oRecord.getId();for(var j=0;j<tracker.length;j++){if((tracker[j].recordId===id)&&(tracker[j].columnId===nColumnId)){tracker.splice(j,1);this._aSelections=tracker;YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_SELECTED);this.fireEvent("cellUnselectEvent",{record:oRecord,key:this._oColumnSet.getColumn(nColumnId).key,el:elCell});return;}}}}};YAHOO.widget.DataTable.prototype.unselectAllCells=function(){var tracker=this._aSelections||[];for(var j=0;j<tracker.length;j++){if(tracker[j].constructor==Object){tracker.splice(j,1);}}
this._aSelections=tracker;this._unselectAllTdEls();this.fireEvent("unselectAllCellsEvent");};YAHOO.widget.DataTable.prototype.isSelected=function(el){return YAHOO.util.Dom.hasClass(el,YAHOO.widget.DataTable.CLASS_SELECTED);};YAHOO.widget.DataTable.prototype.getSelectedRows=function(){var aSelectedRows=[];var tracker=this._aSelections||[];for(var j=0;j<tracker.length;j++){if(YAHOO.lang.isNumber(tracker[j])){aSelectedRows.push(tracker[j]);}}
return aSelectedRows;};YAHOO.widget.DataTable.prototype.getSelectedCells=function(){var aSelectedCells=[];var tracker=this._aSelections||[];for(var j=0;j<tracker.length;j++){if(tracker[j]&&(tracker[j].constructor==Object)){aSelectedCells.push({recordId:tracker[j].recordId,columnId:tracker[j].columnId});}}
return aSelectedCells;};YAHOO.widget.DataTable.prototype.highlightRow=function(row){var elRow=this.getTrEl(row);if(elRow){if(this._sLastHighlightedRowId){YAHOO.util.Dom.removeClass(this._sLastHighlightedRowId,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);}
var oRecord=this.getRecord(elRow);YAHOO.util.Dom.addClass(elRow,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);this._sLastHighlightedRowId=elRow.id;this.fireEvent("rowHighlightEvent",{record:oRecord,el:elRow});return;}};YAHOO.widget.DataTable.prototype.unhighlightRow=function(row){var elRow=this.getTrEl(row);if(elRow){var oRecord=this.getRecord(elRow);YAHOO.util.Dom.removeClass(elRow,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);this.fireEvent("rowUnhighlightEvent",{record:oRecord,el:elRow});return;}};YAHOO.widget.DataTable.prototype.highlightCell=function(cell){var elCell=this.getTdEl(cell);if(elCell){if(this._sLastHighlightedCellId){YAHOO.util.Dom.removeClass(this._sLastHighlightedCellId,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);}
var oRecord=this.getRecord(elCell);YAHOO.util.Dom.addClass(elCell,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);this._sLastHighlightedCellId=elCell.id;this.fireEvent("cellHighlightEvent",{record:oRecord,key:this._oColumnSet.getColumn(elCell.yuiColumnId).key,el:elCell});return;}};YAHOO.widget.DataTable.prototype.unhighlightCell=function(cell){var elCell=this.getTdEl(cell);if(elCell){var oRecord=this.getRecord(elCell);YAHOO.util.Dom.removeClass(elCell,YAHOO.widget.DataTable.CLASS_HIGHLIGHTED);this.fireEvent("cellUnhighlightEvent",{record:oRecord,key:this._oColumnSet.getColumn(elCell.yuiColumnId).key,el:elCell});return;}};YAHOO.widget.DataTable.prototype.showCellEditor=function(elCell,oRecord,oColumn){elCell=YAHOO.util.Dom.get(elCell);if(elCell&&(elCell.ownerDocument===document)){if(!oRecord||!(oRecord instanceof YAHOO.widget.Record)){oRecord=this.getRecord(elCell);}
if(!oColumn||!(oColumn instanceof YAHOO.widget.Column)){oColumn=this.getColumn(elCell);}
if(oRecord&&oColumn){var oCellEditor=this._oCellEditor;if(oCellEditor.isActive){this.cancelCellEditor();}
if(!oColumn.editor){return;}
oCellEditor.cell=elCell;oCellEditor.record=oRecord;oCellEditor.column=oColumn;oCellEditor.validator=(oColumn.editorOptions&&YAHOO.lang.isFunction(oColumn.editorOptions.validator))?oColumn.editorOptions.validator:null;oCellEditor.value=oRecord.getData(oColumn.key);var elContainer=oCellEditor.container;var x=YAHOO.util.Dom.getX(elCell);var y=YAHOO.util.Dom.getY(elCell);if(isNaN(x)||isNaN(y)){x=elCell.offsetLeft+
YAHOO.util.Dom.getX(this._elTable)-
this._elTbody.scrollLeft;y=elCell.offsetTop+
YAHOO.util.Dom.getY(this._elTable)-
this._elTbody.scrollTop+
this._elThead.offsetHeight;}
elContainer.style.left=x+"px";elContainer.style.top=y+"px";elContainer.style.display="";var fnEditor;if(YAHOO.lang.isString(oColumn.editor)){switch(oColumn.editor){case"checkbox":fnEditor=YAHOO.widget.DataTable.editCheckbox;break;case"date":fnEditor=YAHOO.widget.DataTable.editDate;break;case"dropdown":fnEditor=YAHOO.widget.DataTable.editDropdown;break;case"radio":fnEditor=YAHOO.widget.DataTable.editRadio;break;case"textarea":fnEditor=YAHOO.widget.DataTable.editTextarea;break;case"textbox":fnEditor=YAHOO.widget.DataTable.editTextbox;break;default:fnEditor=null;}}
else if(YAHOO.lang.isFunction(oColumn.editor)){fnEditor=oColumn.editor;}
if(fnEditor){fnEditor(this._oCellEditor,this);if(!oColumn.editorOptions||!oColumn.editorOptions.disableBtns){this.showCellEditorBtns(elContainer);}
this.doBeforeShowCellEditor(this._oCellEditor);oCellEditor.isActive=true;this.fireEvent("editorShowEvent",{editor:oCellEditor});return;}}}};YAHOO.widget.DataTable.prototype.doBeforeShowCellEditor=function(oCellEditor){};YAHOO.widget.DataTable.prototype.showCellEditorBtns=function(elContainer){var elBtnsDiv=elContainer.appendChild(document.createElement("div"));YAHOO.util.Dom.addClass(elBtnsDiv,YAHOO.widget.DataTable.CLASS_BUTTON);var elSaveBtn=elBtnsDiv.appendChild(document.createElement("button"));YAHOO.util.Dom.addClass(elSaveBtn,YAHOO.widget.DataTable.CLASS_DEFAULT);elSaveBtn.innerHTML="OK";YAHOO.util.Event.addListener(elSaveBtn,"click",this.saveCellEditor,this,true);var elCancelBtn=elBtnsDiv.appendChild(document.createElement("button"));elCancelBtn.innerHTML="Cancel";YAHOO.util.Event.addListener(elCancelBtn,"click",this.cancelCellEditor,this,true);};YAHOO.widget.DataTable.prototype.resetCellEditor=function(){var elContainer=this._oCellEditor.container;elContainer.style.display="none";YAHOO.util.Event.purgeElement(elContainer,true);elContainer.innerHTML="";this._oCellEditor.value=null;this._oCellEditor.isActive=false;};YAHOO.widget.DataTable.prototype.saveCellEditor=function(){if(this._oCellEditor.isActive){var newData=this._oCellEditor.value;var oldData=this._oCellEditor.record.getData(this._oCellEditor.column.key);if(this._oCellEditor.validator){this._oCellEditor.value=this._oCellEditor.validator.call(this,newData,oldData);if(this._oCellEditor.value===null){this.resetCellEditor();this.fireEvent("editorRevertEvent",{editor:this._oCellEditor,oldData:oldData,newData:newData});return;}}
this._oRecordSet.updateKey(this._oCellEditor.record,this._oCellEditor.column.key,this._oCellEditor.value);this.formatCell(this._oCellEditor.cell);this.resetCellEditor();this.fireEvent("editorSaveEvent",{editor:this._oCellEditor,oldData:oldData,newData:newData});}
else{}};YAHOO.widget.DataTable.prototype.cancelCellEditor=function(){if(this._oCellEditor.isActive){this.resetCellEditor();this.fireEvent("editorCancelEvent",{editor:this._oCellEditor});}
else{}};YAHOO.widget.DataTable.editCheckbox=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var aCheckedValues=oRecord.getData(oColumn.key);if(!YAHOO.lang.isArray(aCheckedValues)){aCheckedValues=[aCheckedValues];}
if(oColumn.editorOptions&&YAHOO.lang.isArray(oColumn.editorOptions.checkboxOptions)){var checkboxOptions=oColumn.editorOptions.checkboxOptions;var checkboxValue,checkboxId,elLabel,j,k;for(j=0;j<checkboxOptions.length;j++){checkboxValue=YAHOO.lang.isValue(checkboxOptions[j].label)?checkboxOptions[j].label:checkboxOptions[j];checkboxId=oSelf.id+"-editor-checkbox"+j;elContainer.innerHTML+="<input type=\"checkbox\""+" name=\""+oSelf.id+"-editor-checkbox\""+" value=\""+checkboxValue+"\""+" id=\""+checkboxId+"\">";elLabel=elContainer.appendChild(document.createElement("label"));elLabel.htmlFor=checkboxId;elLabel.innerHTML=checkboxValue;}
var aCheckboxEls=[];var checkboxEl;for(j=0;j<checkboxOptions.length;j++){checkboxEl=YAHOO.util.Dom.get(oSelf.id+"-editor-checkbox"+j);aCheckboxEls.push(checkboxEl);for(k=0;k<aCheckedValues.length;k++){if(checkboxEl.value===aCheckedValues[k]){checkboxEl.checked=true;}}
if(j===0){oSelf._focusEl(checkboxEl);}}
for(j=0;j<checkboxOptions.length;j++){checkboxEl=YAHOO.util.Dom.get(oSelf.id+"-editor-checkbox"+j);YAHOO.util.Event.addListener(checkboxEl,"click",function(){var aNewValues=[];for(var m=0;m<aCheckboxEls.length;m++){if(aCheckboxEls[m].checked){aNewValues.push(aCheckboxEls[m].value);}}
oSelf._oCellEditor.value=aNewValues;oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});});}}};YAHOO.widget.DataTable.editDate=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var value=oRecord.getData(oColumn.key);if(YAHOO.widget.Calendar){var selectedValue=(value.getMonth()+1)+"/"+value.getDate()+"/"+value.getFullYear();var calContainer=elContainer.appendChild(document.createElement("div"));calContainer.id="yui-dt-"+oSelf._nIndex+"-col"+oColumn.getKeyIndex()+"-dateContainer";var calendar=new YAHOO.widget.Calendar("yui-dt-"+oSelf._nIndex+"-col"+oColumn.getKeyIndex()+"-date",calContainer.id,{selected:selectedValue,pagedate:value});calendar.render();calContainer.style.cssFloat="none";calendar.selectEvent.subscribe(function(type,args,obj){oSelf._oCellEditor.value=new Date(args[0][0][0],args[0][0][1]-1,args[0][0][2]);});oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});}
else{}};YAHOO.widget.DataTable.editDropdown=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var value=oRecord.getData(oColumn.key);var elDropdown=elContainer.appendChild(document.createElement("select"));var dropdownOptions=(oColumn.editorOptions&&YAHOO.lang.isArray(oColumn.editorOptions.dropdownOptions))?oColumn.editorOptions.dropdownOptions:[];for(var j=0;j<dropdownOptions.length;j++){var dropdownOption=dropdownOptions[j];var elOption=document.createElement("option");elOption.value=(YAHOO.lang.isValue(dropdownOption.value))?dropdownOption.value:dropdownOption;elOption.innerHTML=(YAHOO.lang.isValue(dropdownOption.text))?dropdownOption.text:dropdownOption;elOption=elDropdown.appendChild(elOption);if(value===elDropdown.options[j].value){elDropdown.options[j].selected=true;}}
YAHOO.util.Event.addListener(elDropdown,"change",function(){oSelf._oCellEditor.value=elDropdown[elDropdown.selectedIndex].value;oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});});oSelf._focusEl(elDropdown);};YAHOO.widget.DataTable.editRadio=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var value=oRecord.getData(oColumn.key);if(oColumn.editorOptions&&YAHOO.lang.isArray(oColumn.editorOptions.radioOptions)){var radioOptions=oColumn.editorOptions.radioOptions;var radioValue,radioId,elLabel,j;for(j=0;j<radioOptions.length;j++){radioValue=YAHOO.lang.isValue(radioOptions[j].label)?radioOptions[j].label:radioOptions[j];radioId=oSelf.id+"-editor-radio"+j;elContainer.innerHTML+="<input type=\"radio\""+" name=\""+oSelf.id+"-editor-radio\""+" value=\""+radioValue+"\""+" id=\""+radioId+"\">";elLabel=elContainer.appendChild(document.createElement("label"));elLabel.htmlFor=radioId;elLabel.innerHTML=radioValue;}
for(j=0;j<radioOptions.length;j++){var radioEl=YAHOO.util.Dom.get(oSelf.id+"-editor-radio"+j);if(value===radioEl.value){radioEl.checked=true;oSelf._focusEl(radioEl);}
YAHOO.util.Event.addListener(radioEl,"click",function(){oSelf._oCellEditor.value=this.value;oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});});}}};YAHOO.widget.DataTable.editTextarea=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var value=oRecord.getData(oColumn.key);var elTextarea=elContainer.appendChild(document.createElement("textarea"));elTextarea.style.width=elCell.offsetWidth+"px";elTextarea.style.height="3em";elTextarea.value=YAHOO.lang.isValue(value)?value:"";YAHOO.util.Event.addListener(elTextarea,"keyup",function(){oSelf._oCellEditor.value=elTextarea.value;oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});});elTextarea.focus();elTextarea.select();};YAHOO.widget.DataTable.editTextbox=function(oEditor,oSelf){var elCell=oEditor.cell;var oRecord=oEditor.record;var oColumn=oEditor.column;var elContainer=oEditor.container;var value=YAHOO.lang.isValue(oRecord.getData(oColumn.key))?oRecord.getData(oColumn.key):"";var elTextbox=elContainer.appendChild(document.createElement("input"));elTextbox.type="text";elTextbox.style.width=elCell.offsetWidth+"px";elTextbox.value=value;YAHOO.util.Event.addListener(elTextbox,"keyup",function(){oSelf._oCellEditor.value=elTextbox.value;oSelf.fireEvent("editorUpdateEvent",{editor:oSelf._oCellEditor});});elTextbox.focus();elTextbox.select();};YAHOO.widget.DataTable.validateNumber=function(oData){var number=oData*1;if(YAHOO.lang.isNumber(number)){return number;}
else{return null;}};YAHOO.widget.DataTable.prototype.doBeforeLoadData=function(sRequest,oResponse){return true;};YAHOO.widget.DataTable.prototype.onEventSortColumn=function(oArgs){var evt=oArgs.event;var target=oArgs.target;YAHOO.util.Event.stopEvent(evt);var el=this.getThEl(target)||this.getTdEl(target);if(el&&YAHOO.lang.isNumber(el.yuiColumnId)){this.sortColumn(this._oColumnSet.getColumn(el.yuiColumnId));}
else{}};YAHOO.widget.DataTable.prototype.onEventSelectRow=function(oArgs){var sMode=this.get("selectionMode");if((sMode=="singlecell")||(sMode=="cellblock")||(sMode=="cellrange")){return;}
var evt=oArgs.event;var elTarget=oArgs.target;var bSHIFT=evt.shiftKey;var bCTRL=evt.ctrlKey;var i,nAnchorTrIndex;var elTargetRow=this.getTrEl(elTarget);if(elTargetRow){var allRows=this._elTbody.rows;var nTargetTrIndex=elTargetRow.sectionRowIndex;var elAnchorRow=YAHOO.util.Dom.get(this._sSelectionAnchorId);if((sMode!="single")&&bSHIFT&&bCTRL){if(elAnchorRow&&YAHOO.lang.isNumber(elAnchorRow.sectionRowIndex)){nAnchorTrIndex=elAnchorRow.sectionRowIndex;if(this.isSelected(elAnchorRow)){if(nAnchorTrIndex<nTargetTrIndex){for(i=nAnchorTrIndex+1;i<=nTargetTrIndex;i++){if(!this.isSelected(allRows[i])){this.selectRow(allRows[i]);}}}
else{for(i=nAnchorTrIndex-1;i>=nTargetTrIndex;i--){if(!this.isSelected(allRows[i])){this.selectRow(allRows[i]);}}}}
else{if(nAnchorTrIndex<nTargetTrIndex){for(i=nAnchorTrIndex+1;i<=nTargetTrIndex-1;i++){if(this.isSelected(allRows[i])){this.unselectRow(allRows[i]);}}}
else{for(i=nTargetTrIndex+1;i<=nAnchorTrIndex-1;i++){if(this.isSelected(allRows[i])){this.unselectRow(allRows[i]);}}}
this.selectRow(elTargetRow);}}
else{this._sSelectionAnchorId=elTargetRow.id;if(this.isSelected(elTargetRow)){this.unselectRow(elTargetRow);}
else{this.selectRow(elTargetRow);}}}
else if((sMode!="single")&&bSHIFT){this.unselectAllRows();if(elAnchorRow&&YAHOO.lang.isNumber(elAnchorRow.sectionRowIndex)){nAnchorTrIndex=elAnchorRow.sectionRowIndex;if(nAnchorTrIndex<nTargetTrIndex){for(i=nAnchorTrIndex;i<=nTargetTrIndex;i++){this.selectRow(allRows[i]);}}
else{for(i=nAnchorTrIndex;i>=nTargetTrIndex;i--){this.selectRow(allRows[i]);}}}
else{this._sSelectionAnchorId=elTargetRow.id;this.selectRow(elTargetRow);}}
else if((sMode!="single")&&bCTRL){this._sSelectionAnchorId=elTargetRow.id;if(this.isSelected(elTargetRow)){this.unselectRow(elTargetRow);}
else{this.selectRow(elTargetRow);}}
else if(sMode=="single"){this.unselectAllRows();this.selectRow(elTargetRow);}
else{this._sSelectionAnchorId=elTargetRow.id;this.unselectAllRows();this.selectRow(elTargetRow);}
YAHOO.util.Event.stopEvent(evt);var sel;if(window.getSelection){sel=window.getSelection();}
else if(document.getSelection){sel=document.getSelection();}
else if(document.selection){sel=document.selection;}
if(sel){if(sel.empty){sel.empty();}
else if(sel.removeAllRanges){sel.removeAllRanges();}
else if(sel.collapse){sel.collapse();}}}
else{}};YAHOO.widget.DataTable.prototype.onEventSelectCell=function(oArgs){var sMode=this.get("selectionMode");if((sMode=="standard")||(sMode=="single")){return;}
var evt=oArgs.event;var elTarget=oArgs.target;var bSHIFT=evt.shiftKey;var bCTRL=evt.ctrlKey;var i,j,nAnchorTrIndex,nAnchorTdIndex,currentRow,startIndex,endIndex;var elTargetCell=this.getTdEl(elTarget);if(elTargetCell){var elTargetRow=this.getTrEl(elTargetCell);var allRows=this._elTbody.rows;var nTargetTrIndex=elTargetRow.sectionRowIndex;var nTargetTdIndex=elTarget.yuiCellIndex;var elAnchorCell=YAHOO.util.Dom.get(this._sSelectionAnchorId);if((sMode!="singlecell")&&bSHIFT&&bCTRL){if(elAnchorCell&&YAHOO.lang.isNumber(elAnchorCell.yuiCellIndex)){nAnchorTrIndex=elAnchorCell.parentNode.sectionRowIndex;nAnchorTdIndex=elAnchorCell.yuiCellIndex;if(this.isSelected(elAnchorCell)){if(nAnchorTrIndex==nTargetTrIndex){if(nAnchorTdIndex<nTargetTdIndex){for(i=nAnchorTdIndex+1;i<=nTargetTdIndex;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}}
else if(nTargetTdIndex<nAnchorTdIndex){for(i=nTargetTdIndex;i<nAnchorTdIndex;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}}}
else if(nAnchorTrIndex<nTargetTrIndex){if(sMode=="cellrange"){for(i=nAnchorTdIndex+1;i<allRows[nAnchorTrIndex].cells.length;i++){this.selectCell(allRows[nAnchorTrIndex].cells[i]);}
for(i=nAnchorTrIndex+1;i<nTargetTrIndex;i++){for(j=0;j<allRows[i].cells.length;j++){this.selectCell(allRows[i].cells[j]);}}
for(i=0;i<=nTargetTdIndex;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}}
else if(sMode=="cellblock"){startIndex=Math.min(nAnchorTdIndex,nTargetTdIndex);endIndex=Math.max(nAnchorTdIndex,nTargetTdIndex);for(i=nAnchorTrIndex;i<=nTargetTrIndex;i++){for(j=startIndex;j<=endIndex;j++){this.selectCell(allRows[i].cells[j]);}}}}
else{if(sMode=="cellrange"){for(i=nTargetTdIndex;i<allRows[nTargetTrIndex].cells.length;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}
for(i=nTargetTrIndex+1;i<nAnchorTrIndex;i++){for(j=0;j<allRows[i].cells.length;j++){this.selectCell(allRows[i].cells[j]);}}
for(i=0;i<nAnchorTdIndex;i++){this.selectCell(allRows[nAnchorTrIndex].cells[i]);}}
else if(sMode=="cellblock"){startIndex=Math.min(nAnchorTdIndex,nTargetTdIndex);endIndex=Math.max(nAnchorTdIndex,nTargetTdIndex);for(i=nAnchorTrIndex;i>=nTargetTrIndex;i--){for(j=endIndex;j>=startIndex;j--){this.selectCell(allRows[i].cells[j]);}}}}}
else{if(nAnchorTrIndex==nTargetTrIndex){if(nAnchorTdIndex<nTargetTdIndex){for(i=nAnchorTdIndex+1;i<nTargetTdIndex;i++){this.unselectCell(allRows[nTargetTrIndex].cells[i]);}}
else if(nTargetTdIndex<nAnchorTdIndex){for(i=nTargetTdIndex+1;i<nAnchorTdIndex;i++){this.unselectCell(allRows[nTargetTrIndex].cells[i]);}}}
if(nAnchorTrIndex<nTargetTrIndex){for(i=nAnchorTrIndex;i<=nTargetTrIndex;i++){currentRow=allRows[i];for(j=0;j<currentRow.cells.length;j++){if(currentRow.sectionRowIndex==nAnchorTrIndex){if(j>nAnchorTdIndex){this.unselectCell(currentRow.cells[j]);}}
else if(currentRow.sectionRowIndex==nTargetTrIndex){if(j<nTargetTdIndex){this.unselectCell(currentRow.cells[j]);}}
else{this.unselectCell(currentRow.cells[j]);}}}}
else{for(i=nTargetTrIndex;i<=nAnchorTrIndex;i++){currentRow=allRows[i];for(j=0;j<currentRow.cells.length;j++){if(currentRow.sectionRowIndex==nTargetTrIndex){if(j>nTargetTdIndex){this.unselectCell(currentRow.cells[j]);}}
else if(currentRow.sectionRowIndex==nAnchorTrIndex){if(j<nAnchorTdIndex){this.unselectCell(currentRow.cells[j]);}}
else{this.unselectCell(currentRow.cells[j]);}}}}
this.selectCell(elTargetCell);}}
else{this._sSelectionAnchorId=elTargetCell.id;if(this.isSelected(elTargetCell)){this.unselectCell(elTargetCell);}
else{this.selectCell(elTargetCell);}}}
else if((sMode!="singlecell")&&bSHIFT){this.unselectAllCells();if(elAnchorCell&&YAHOO.lang.isNumber(elAnchorCell.yuiCellIndex)){nAnchorTrIndex=elAnchorCell.parentNode.sectionRowIndex;nAnchorTdIndex=elAnchorCell.yuiCellIndex;if(nAnchorTrIndex==nTargetTrIndex){if(nAnchorTdIndex<nTargetTdIndex){for(i=nAnchorTdIndex;i<=nTargetTdIndex;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}}
else if(nTargetTdIndex<nAnchorTdIndex){for(i=nTargetTdIndex;i<=nAnchorTdIndex;i++){this.selectCell(allRows[nTargetTrIndex].cells[i]);}}}
else if(nAnchorTrIndex<nTargetTrIndex){if(sMode=="cellrange"){for(i=nAnchorTrIndex;i<=nTargetTrIndex;i++){currentRow=allRows[i];for(j=0;j<currentRow.cells.length;j++){if(currentRow.sectionRowIndex==nAnchorTrIndex){if(j>=nAnchorTdIndex){this.selectCell(currentRow.cells[j]);}}
else if(currentRow.sectionRowIndex==nTargetTrIndex){if(j<=nTargetTdIndex){this.selectCell(currentRow.cells[j]);}}
else{this.selectCell(currentRow.cells[j]);}}}}
else if(sMode=="cellblock"){startIndex=Math.min(nAnchorTdIndex,nTargetTdIndex);endIndex=Math.max(nAnchorTdIndex,nTargetTdIndex);for(i=nAnchorTrIndex;i<=nTargetTrIndex;i++){for(j=startIndex;j<=endIndex;j++){this.selectCell(allRows[i].cells[j]);}}
this._sLastSelectedId=allRows[nTargetTrIndex].cells[nTargetTdIndex].id;}}
else{if(sMode=="cellrange"){for(i=nTargetTrIndex;i<=nAnchorTrIndex;i++){currentRow=allRows[i];for(j=0;j<currentRow.cells.length;j++){if(currentRow.sectionRowIndex==nTargetTrIndex){if(j>=nTargetTdIndex){this.selectCell(currentRow.cells[j]);}}
else if(currentRow.sectionRowIndex==nAnchorTrIndex){if(j<=nAnchorTdIndex){this.selectCell(currentRow.cells[j]);}}
else{this.selectCell(currentRow.cells[j]);}}}}
else if(sMode=="cellblock"){startIndex=Math.min(nAnchorTdIndex,nTargetTdIndex);endIndex=Math.max(nAnchorTdIndex,nTargetTdIndex);for(i=nTargetTrIndex;i<=nAnchorTrIndex;i++){for(j=startIndex;j<=endIndex;j++){this.selectCell(allRows[i].cells[j]);}}
this._sLastSelectedId=allRows[nTargetTrIndex].cells[nTargetTdIndex].id;}}}
else{this._sSelectionAnchorId=elTargetCell.id;this.selectCell(elTargetCell);}}
else if((sMode!="singlecell")&&bCTRL){this._sSelectionAnchorId=elTargetCell.id;if(this.isSelected(elTargetCell)){this.unselectCell(elTargetCell);}
else{this.selectCell(elTargetCell);}}
else{this._sSelectionAnchorId=elTargetCell.id;this.unselectAllCells();this.selectCell(elTargetCell);}
YAHOO.util.Event.stopEvent(evt);var sel;if(window.getSelection){sel=window.getSelection();}
else if(document.getSelection){sel=document.getSelection();}
else if(document.selection){sel=document.selection;}
if(sel){if(sel.empty){sel.empty();}
else if(sel.removeAllRanges){sel.removeAllRanges();}
else if(sel.collapse){sel.collapse();}}}
else{}};YAHOO.widget.DataTable.prototype.onEventHighlightRow=function(oArgs){var evt=oArgs.event;var elTarget=oArgs.target;this.highlightRow(elTarget);};YAHOO.widget.DataTable.prototype.onEventUnhighlightRow=function(oArgs){var evt=oArgs.event;var elTarget=oArgs.target;this.unhighlightRow(elTarget);};YAHOO.widget.DataTable.prototype.onEventHighlightCell=function(oArgs){var evt=oArgs.event;var elTarget=oArgs.target;this.highlightCell(elTarget);};YAHOO.widget.DataTable.prototype.onEventUnhighlightCell=function(oArgs){var evt=oArgs.event;var elTarget=oArgs.target;this.unhighlightCell(elTarget);};YAHOO.widget.DataTable.prototype.onEventFormatCell=function(oArgs){var evt=oArgs.event;var target=oArgs.target;var elTag=target.tagName.toLowerCase();var elCell=this.getTdEl(target);if(elCell&&YAHOO.lang.isNumber(elCell.yuiColumnId)){var oColumn=this._oColumnSet.getColumn(elCell.yuiColumnId);this.formatCell(elCell,this.getRecord(elCell),oColumn);}
else{}};YAHOO.widget.DataTable.prototype.onEventShowCellEditor=function(oArgs){var evt=oArgs.event;var target=oArgs.target;var elTag=target.tagName.toLowerCase();var elCell=this.getTdEl(target);if(elCell){this.showCellEditor(elCell);}
else{}};YAHOO.widget.DataTable.prototype.onEventEditCell=function(oArgs){this.onEventShowCellEditor(oArgs);};YAHOO.widget.DataTable.prototype.onEventSaveCellEditor=function(oArgs){this.saveCellEditor();};YAHOO.widget.DataTable.prototype._onDataReturnEnhanceTable=function(sRequest,oResponse){var ok=this.doBeforeLoadData(sRequest,oResponse);if(ok&&oResponse&&!oResponse.error&&YAHOO.lang.isArray(oResponse.results)){this._oRecordSet.addRecords(oResponse.results);this._initTableEl();if(!this._elTable||!this._elThead||!this._elTbody){return;}
YAHOO.widget.DataTable.superclass.constructor.call(this,this._elContainer,this._oConfigs);if(this._oConfigs.paginator){this.updatePaginator(this._oConfigs.paginator);}
this.refreshView();}
else if(ok&&oResponse.error){this.showTableMessage(YAHOO.widget.DataTable.MSG_ERROR,YAHOO.widget.DataTable.CLASS_ERROR);}
else if(ok){this.showTableMessage(YAHOO.widget.DataTable.MSG_EMPTY,YAHOO.widget.DataTable.CLASS_EMPTY);}};YAHOO.widget.DataTable.prototype.onDataReturnInitializeTable=function(sRequest,oResponse){this.fireEvent("dataReturnEvent",{request:sRequest,response:oResponse});var ok=this.doBeforeLoadData(sRequest,oResponse);if(ok&&oResponse&&!oResponse.error&&YAHOO.lang.isArray(oResponse.results)){this.initializeTable(oResponse.results);}
else if(ok&&oResponse.error){this.showTableMessage(YAHOO.widget.DataTable.MSG_ERROR,YAHOO.widget.DataTable.CLASS_ERROR);}
else if(ok){this.showTableMessage(YAHOO.widget.DataTable.MSG_EMPTY,YAHOO.widget.DataTable.CLASS_EMPTY);}};YAHOO.widget.DataTable.prototype.onDataReturnReplaceRows=function(sRequest,oResponse){this.onDataReturnInitializeTable(sRequest,oResponse);};YAHOO.widget.DataTable.prototype.onDataReturnAppendRows=function(sRequest,oResponse){this.fireEvent("dataReturnEvent",{request:sRequest,response:oResponse});var ok=this.doBeforeLoadData(sRequest,oResponse);if(ok&&oResponse&&!oResponse.error&&YAHOO.lang.isArray(oResponse.results)){this.addRows(oResponse.results);}
else if(ok&&oResponse.error){this.showTableMessage(YAHOO.widget.DataTable.MSG_ERROR,YAHOO.widget.DataTable.CLASS_ERROR);}};YAHOO.widget.DataTable.prototype.onDataReturnInsertRows=function(sRequest,oResponse){this.fireEvent("dataReturnEvent",{request:sRequest,response:oResponse});var ok=this.doBeforeLoadData(sRequest,oResponse);if(ok&&oResponse&&!oResponse.error&&YAHOO.lang.isArray(oResponse.results)){this.addRows(oResponse.results,0);}
else if(ok&&oResponse.error){this.showTableMessage(YAHOO.widget.DataTable.MSG_ERROR,YAHOO.widget.DataTable.CLASS_ERROR);}};YAHOO.widget.ColumnSet=function(aHeaders){this._sName="instance"+YAHOO.widget.ColumnSet._nCount;var tree=[];var flat=[];var keys=[];var headers=[];var nodeDepth=-1;var parseColumns=function(nodeList,parent){nodeDepth++;if(!tree[nodeDepth]){tree[nodeDepth]=[];}
for(var j=0;j<nodeList.length;j++){var currentNode=nodeList[j];var oColumn=new YAHOO.widget.Column(currentNode);flat.push(oColumn);if(parent){oColumn.parent=parent;}
if(YAHOO.lang.isArray(currentNode.children)){oColumn.children=currentNode.children;var terminalChildNodes=0;var countTerminalChildNodes=function(ancestor){var descendants=ancestor.children;for(var k=0;k<descendants.length;k++){if(YAHOO.lang.isArray(descendants[k].children)){countTerminalChildNodes(descendants[k]);}
else{terminalChildNodes++;}}};countTerminalChildNodes(currentNode);oColumn._colspan=terminalChildNodes;var currentChildren=currentNode.children;for(var k=0;k<currentChildren.length;k++){var child=currentChildren[k];if(oColumn.className&&(child.className===undefined)){child.className=oColumn.className;}
if(oColumn.editor&&(child.editor===undefined)){child.editor=oColumn.editor;}
if(oColumn.editorOptions&&(child.editorOptions===undefined)){child.editorOptions=oColumn.editorOptions;}
if(oColumn.formatter&&(child.formatter===undefined)){child.formatter=oColumn.formatter;}
if(oColumn.resizeable&&(child.resizeable===undefined)){child.resizeable=oColumn.resizeable;}
if(oColumn.sortable&&(child.sortable===undefined)){child.sortable=oColumn.sortable;}
if(oColumn.width&&(child.width===undefined)){child.width=oColumn.width;}
if(oColumn.type&&(child.type===undefined)){child.type=oColumn.type;}
if(oColumn.type&&!oColumn.formatter){oColumn.formatter=oColumn.type;}
if(oColumn.text&&!YAHOO.lang.isValue(oColumn.label)){oColumn.label=oColumn.text;}
if(oColumn.parser){}
if(oColumn.sortOptions&&((oColumn.sortOptions.ascFunction)||(oColumn.sortOptions.descFunction))){}}
if(!tree[nodeDepth+1]){tree[nodeDepth+1]=[];}
parseColumns(currentChildren,oColumn);}
else{oColumn._nKeyIndex=keys.length;oColumn._colspan=1;keys.push(oColumn);}
tree[nodeDepth].push(oColumn);}
nodeDepth--;};if(YAHOO.lang.isArray(aHeaders)){parseColumns(aHeaders);}
var parseTreeForRowspan=function(tree){var maxRowDepth=1;var currentRow;var currentColumn;var countMaxRowDepth=function(row,tmpRowDepth){tmpRowDepth=tmpRowDepth||1;for(var n=0;n<row.length;n++){var col=row[n];if(YAHOO.lang.isArray(col.children)){tmpRowDepth++;countMaxRowDepth(col.children,tmpRowDepth);tmpRowDepth--;}
else{if(tmpRowDepth>maxRowDepth){maxRowDepth=tmpRowDepth;}}}};for(var m=0;m<tree.length;m++){currentRow=tree[m];countMaxRowDepth(currentRow);for(var p=0;p<currentRow.length;p++){currentColumn=currentRow[p];if(!YAHOO.lang.isArray(currentColumn.children)){currentColumn._rowspan=maxRowDepth;}
else{currentColumn._rowspan=1;}}
maxRowDepth=1;}};parseTreeForRowspan(tree);var recurseAncestorsForHeaders=function(i,oColumn){headers[i].push(oColumn._nId);if(oColumn.parent){recurseAncestorsForHeaders(i,oColumn.parent);}};for(var i=0;i<keys.length;i++){headers[i]=[];recurseAncestorsForHeaders(i,keys[i]);headers[i]=headers[i].reverse();headers[i]=headers[i].join(" ");}
this.tree=tree;this.flat=flat;this.keys=keys;this.headers=headers;YAHOO.widget.ColumnSet._nCount++;};YAHOO.widget.ColumnSet._nCount=0;YAHOO.widget.ColumnSet.prototype._sName=null;YAHOO.widget.ColumnSet.prototype.tree=null;YAHOO.widget.ColumnSet.prototype.flat=null;YAHOO.widget.ColumnSet.prototype.keys=null;YAHOO.widget.ColumnSet.prototype.headers=null;YAHOO.widget.ColumnSet.prototype.toString=function(){return"ColumnSet "+this._sName;};YAHOO.widget.ColumnSet.prototype.getColumn=function(column){var allColumns=this.flat;if(YAHOO.lang.isNumber(column)){for(var i=0;i<allColumns.length;i++){if(allColumns[i]._nId===column){return allColumns[i];}}}
else if(YAHOO.lang.isString(column)){for(i=0;i<allColumns.length;i++){if(allColumns[i].key===column){return allColumns[i];}}}
return null;};YAHOO.widget.Column=function(oConfigs){this._nId=YAHOO.widget.Column._nCount;this._sName="Column instance"+this._nId;if(oConfigs&&(oConfigs.constructor==Object)){for(var sConfig in oConfigs){if(sConfig){this[sConfig]=oConfigs[sConfig];}}}
if(!YAHOO.lang.isValue(this.key)){this.key="yui-dt-column"+this._nId;}
YAHOO.widget.Column._nCount++;};YAHOO.widget.Column._nCount=0;YAHOO.widget.Column.prototype._sName=null;YAHOO.widget.Column.prototype._nId=null;YAHOO.widget.Column.prototype._nKeyIndex=null;YAHOO.widget.Column.prototype._colspan=1;YAHOO.widget.Column.prototype._rowspan=1;YAHOO.widget.Column.prototype._parent=null;YAHOO.widget.Column.prototype._width=null;YAHOO.widget.Column.prototype._minWidth=null;YAHOO.widget.Column.prototype.key=null;YAHOO.widget.Column.prototype.label=null;YAHOO.widget.Column.prototype.abbr=null;YAHOO.widget.Column.prototype.children=null;YAHOO.widget.Column.prototype.width=null;YAHOO.widget.Column.prototype.className=null;YAHOO.widget.Column.prototype.formatter=null;YAHOO.widget.Column.prototype.editor=null;YAHOO.widget.Column.prototype.editorOptions=null;YAHOO.widget.Column.prototype.resizeable=false;YAHOO.widget.Column.prototype.sortable=false;YAHOO.widget.Column.prototype.sortOptions=null;YAHOO.widget.Column.prototype.toString=function(){return this._sName;};YAHOO.widget.Column.prototype.getId=function(){return this._nId;};YAHOO.widget.Column.prototype.getKeyIndex=function(){return this._nKeyIndex;};YAHOO.widget.Column.prototype.getParent=function(){return this._parent;};YAHOO.widget.Column.prototype.getColspan=function(){return this._colspan;};YAHOO.widget.Column.prototype.getColSpan=function(){return this.getColspan();};YAHOO.widget.Column.prototype.getRowspan=function(){return this._rowspan;};YAHOO.widget.Column.prototype.getIndex=function(){return this.getKeyIndex();};YAHOO.widget.Column.prototype.format=function(){};YAHOO.widget.Column.formatCheckbox=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatCheckbox(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatCurrency=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatCurrency(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatDate=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatDate(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatEmail=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatEmail(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatLink=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatLink(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatNumber=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatNumber(elCell,oRecord,oColumn,oData);};YAHOO.widget.Column.formatSelect=function(elCell,oRecord,oColumn,oData){YAHOO.widget.DataTable.formatDropdown(elCell,oRecord,oColumn,oData);};YAHOO.util.Sort={compare:function(a,b,desc){if((a===null)||(typeof a=="undefined")){if((b===null)||(typeof b=="undefined")){return 0;}
else{return 1;}}
else if((b===null)||(typeof b=="undefined")){return-1;}
if(a.constructor==String){a=a.toLowerCase();}
if(b.constructor==String){b=b.toLowerCase();}
if(a<b){return(desc)?1:-1;}
else if(a>b){return(desc)?-1:1;}
else{return 0;}}};YAHOO.util.ColumnResizer=function(oDataTable,oColumn,elThead,sHandleId,sGroup,oConfig){if(oDataTable&&oColumn&&elThead&&sHandleId){this.datatable=oDataTable;this.column=oColumn;this.cell=elThead;this.init(sHandleId,sGroup,oConfig);this.setYConstraint(0,0);}
else{}};if(YAHOO.util.DD){YAHOO.extend(YAHOO.util.ColumnResizer,YAHOO.util.DD);}
YAHOO.util.ColumnResizer.prototype.onMouseDown=function(e){this.startWidth=this.cell.offsetWidth;this.startPos=YAHOO.util.Dom.getX(this.getDragEl());if(this.datatable.fixedWidth){var cellLabel=YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_LABEL,"span",this.cell)[0];this.minWidth=cellLabel.offsetWidth+6;var sib=this.cell.nextSibling;var sibCellLabel=YAHOO.util.Dom.getElementsByClassName(YAHOO.widget.DataTable.CLASS_LABEL,"span",sib)[0];this.sibMinWidth=sibCellLabel.offsetWidth+6;var left=((this.startWidth-this.minWidth)<0)?0:(this.startWidth-this.minWidth);var right=((sib.offsetWidth-this.sibMinWidth)<0)?0:(sib.offsetWidth-this.sibMinWidth);this.setXConstraint(left,right);}};YAHOO.util.ColumnResizer.prototype.onMouseUp=function(e){var resizeStyle=YAHOO.util.Dom.get(this.handleElId).style;resizeStyle.left="auto";resizeStyle.right=0;resizeStyle.marginRight="-6px";resizeStyle.width="6px";this.datatable.fireEvent("columnResizeEvent",{column:this.column,target:this.cell});};YAHOO.util.ColumnResizer.prototype.onDrag=function(e){var newPos=YAHOO.util.Dom.getX(this.getDragEl());var offsetX=newPos-this.startPos;var newWidth=this.startWidth+offsetX;if(newWidth<this.minWidth){newWidth=this.minWidth;}
var oDataTable=this.datatable;var elCell=this.cell;if(oDataTable.fixedWidth){var sib=elCell.nextSibling;var sibnewwidth=sib.offsetWidth-offsetX;if(sibnewwidth<this.sibMinWidth){sibnewwidth=this.sibMinWidth;}
for(var i=0;i<oDataTable._oColumnSet.length;i++){}
sib.style.width=sibnewwidth;elCell.style.width=newWidth+"px";}
else{elCell.style.width=newWidth+"px";}};YAHOO.widget.RecordSet=function(data){this._sName="RecordSet instance"+YAHOO.widget.RecordSet._nCount;YAHOO.widget.RecordSet._nCount++;this._records=[];this._length=0;if(data){if(YAHOO.lang.isArray(data)){this.addRecords(data);}
else if(data.constructor==Object){this.addRecord(data);}}
this.createEvent("recordAddEvent");this.createEvent("recordsAddEvent");this.createEvent("recordUpdateEvent");this.createEvent("recordDeleteEvent");this.createEvent("recordsDeleteEvent");this.createEvent("resetEvent");this.createEvent("keyUpdateEvent");};if(YAHOO.util.EventProvider){YAHOO.augment(YAHOO.widget.RecordSet,YAHOO.util.EventProvider);}
else{}
YAHOO.widget.RecordSet._nCount=0;YAHOO.widget.RecordSet.prototype._sName=null;YAHOO.widget.RecordSet.prototype._nRecordCount=0;YAHOO.widget.RecordSet.prototype._length=null;YAHOO.widget.RecordSet.prototype._addRecord=function(oData,index){var oRecord=new YAHOO.widget.Record(oData);oRecord._nId=this._nRecordCount;this._nRecordCount++;if(YAHOO.lang.isNumber(index)&&(index>-1)){this._records.splice(index,0,oRecord);}
else{index=this.getLength();this._records.push(oRecord);}
this._length++;return oRecord;};YAHOO.widget.RecordSet.prototype._deleteRecord=function(index,range){if(!YAHOO.lang.isNumber(range)||(range<0)){range=1;}
this._records.splice(index,range);this._length=this._length-range;};YAHOO.widget.RecordSet.prototype.toString=function(){return this._sName;};YAHOO.widget.RecordSet.prototype.getLength=function(){return this._length;};YAHOO.widget.RecordSet.prototype.getRecord=function(index){if(YAHOO.lang.isNumber(index)){return this._records[index];}
return null;};YAHOO.widget.RecordSet.prototype.getRecords=function(index,range){if(!YAHOO.lang.isNumber(index)){return this._records;}
if(!YAHOO.lang.isNumber(range)){return this._records.slice(index);}
return this._records.slice(index,index+range);};YAHOO.widget.RecordSet.prototype.getRecordIndex=function(oRecord){for(var i=this._records.length-1;i>-1;i--){if(oRecord.getId()===this._records[i].getId()){return i;}}
return null;};YAHOO.widget.RecordSet.prototype.addRecord=function(oData,index){if(oData&&(oData.constructor==Object)){var oRecord=this._addRecord(oData,index);this.fireEvent("recordAddEvent",{record:oRecord,data:oData});return oRecord;}
else{return null;}};YAHOO.widget.RecordSet.prototype.addRecords=function(aData,index){if(YAHOO.lang.isArray(aData)){var newRecords=[];for(var i=0;i<aData.length;i++){if(aData[i]&&(aData[i].constructor==Object)){var record=this._addRecord(aData[i],index);newRecords.push(record);}}
this.fireEvent("recordsAddEvent",{records:newRecords,data:aData});return newRecords;}
else if(aData&&(aData.constructor==Object)){var oRecord=this._addRecord(aData);this.fireEvent("recordsAddEvent",{records:[oRecord],data:aData});return oRecord;}
else{}};YAHOO.widget.RecordSet.prototype.updateRecord=function(record,oData){var oRecord=null;if(YAHOO.lang.isNumber(record)){oRecord=this._records[record];}
else if(record instanceof YAHOO.widget.Record){oRecord=record;}
if(oRecord&&oData&&(oData.constructor==Object)){var oldData={};for(var key in oRecord._oData){oldData[key]=oRecord._oData[key];}
oRecord._oData=oData;this.fireEvent("recordUpdateEvent",{record:oRecord,newData:oData,oldData:oldData});return oRecord;}
else{return null;}};YAHOO.widget.RecordSet.prototype.updateKey=function(record,sKey,oData){var oRecord;if(YAHOO.lang.isNumber(record)){oRecord=this._records[record];}
if(record instanceof YAHOO.widget.Record){oRecord=record;var oldData=null;var keyValue=oRecord._oData[sKey];if(keyValue&&keyValue.constructor==Object){oldData={};for(var key in keyValue){oldData[key]=keyValue[key];}}
else{oldData=keyValue;}
oRecord._oData[sKey]=oData;this.fireEvent("keyUpdateEvent",{record:oRecord,key:sKey,newData:oData,oldData:oldData});}
else{}};YAHOO.widget.RecordSet.prototype.replaceRecords=function(data){this.reset();return this.addRecords(data);};YAHOO.widget.RecordSet.prototype.sortRecords=function(fnSort,desc){return this._records.sort(function(a,b){return fnSort(a,b,desc);});};YAHOO.widget.RecordSet.prototype.deleteRecord=function(index){if(YAHOO.lang.isNumber(index)&&(index>-1)&&(index<this.getLength())){var oRecordData=this.getRecord(index).getData();var oData={};for(var key in oRecordData){oData[key]=oRecordData[key];}
this._deleteRecord(index);this.fireEvent("recordDeleteEvent",{data:oData,index:index});return oData;}
else{return null;}};YAHOO.widget.RecordSet.prototype.deleteRecords=function(index,range){if(!YAHOO.lang.isNumber(range)){range=1;}
if(YAHOO.lang.isNumber(index)&&(index>-1)&&(index<this.getLength())){var recordsToDelete=this.getRecords(index,range);var deletedData=[];for(var i=0;i<recordsToDelete.length;i++){var oData={};for(var key in recordsToDelete[i]){oData[key]=recordsToDelete[i][key];}
deletedData.push(oData);}
this._deleteRecord(index,range);this.fireEvent("recordsDeleteEvent",{data:deletedData,index:index});}
else{}};YAHOO.widget.RecordSet.prototype.reset=function(){this._records=[];this._length=0;this.fireEvent("resetEvent");};YAHOO.widget.Record=function(oLiteral){this._oData={};if(oLiteral&&(oLiteral.constructor==Object)){for(var sKey in oLiteral){this._oData[sKey]=oLiteral[sKey];}}};YAHOO.widget.Record.prototype._nId=null;YAHOO.widget.Record.prototype._oData=null;YAHOO.widget.Record.prototype.getId=function(){return this._nId;};YAHOO.widget.Record.prototype.getData=function(sKey){if(YAHOO.lang.isString(sKey)){return this._oData[sKey];}
else{return this._oData;}};YAHOO.register("datatable",YAHOO.widget.DataTable,{version:"2.3.0",build:"442"});