/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.FloatingPointConverter;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue NEGATIVE_ZERO = new DoubleValue(-0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;
    static Pattern nonExponentialPattern = Pattern.compile("(-?[0-9])([0-9]+?)(0*)\\.([0-9]*)");

    public DoubleValue(CharSequence val) throws ValidationException {
        try {
            this.value = Value.stringToNumber(val);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Cannot convert string " + Err.wrap(val, 4) + " to a double");
        }
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.DOUBLE;
    }

    public DoubleValue(double value, AtomicType type) {
        this.value = value;
        this.typeLabel = type;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DoubleValue v = new DoubleValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DOUBLE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value > -2.147483648E9 && this.value < 2.147483647E9) {
            return (int)this.value;
        }
        return new Double(this.value).hashCode();
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0.0 && !Double.isNaN(this.value);
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.effectiveBooleanValue());
            }
            case 517: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                if (Double.isNaN(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert double NaN to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (Double.isInfinite(this.value)) {
                    ValidationFailure err = new ValidationFailure("Cannot convert double INF to an integer");
                    err.setErrorCode("FOCA0002");
                    return err;
                }
                if (this.value > 9.223372036854776E18 || this.value < -9.223372036854776E18) {
                    return new BigIntegerValue(new BigDecimal(this.value).toBigInteger());
                }
                return Int64Value.makeIntegerValue((long)this.value);
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                ConversionResult iv = this.convertPrimitive(BuiltInAtomicType.INTEGER, validate, context);
                if (iv instanceof ValidationFailure) {
                    return iv;
                }
                return ((IntegerValue)iv).convertPrimitive(requiredType, validate, context);
            }
            case 515: {
                try {
                    return new DecimalValue(this.value);
                }
                catch (ValidationException e) {
                    return new ValidationFailure(e);
                }
            }
            case 516: {
                return new FloatValue((float)this.value);
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert double to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getPrimitiveStringValue() {
        return DoubleValue.doubleToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        return FloatingPointConverter.appendDoubleExponential(fsb, this.value);
    }

    public static CharSequence doubleToString(double value) {
        return FloatingPointConverter.appendDouble(new FastStringBuffer(16), value);
    }

    public NumericValue negate() {
        return new DoubleValue(-this.value);
    }

    public NumericValue floor() {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue ceiling() {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue round() {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value >= -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        double factor = Math.pow(10.0, scale + 1);
        double d = Math.abs(this.value * factor);
        if (Double.isInfinite(d)) {
            BigDecimal dec = new BigDecimal(this.value);
            dec = dec.setScale(scale, 6);
            return new DoubleValue(dec.doubleValue());
        }
        double rem = d % 10.0;
        d = rem > 5.0 ? (d += 10.0 - rem) : (rem < 5.0 ? (d -= rem) : (d % 20.0 == 15.0 ? (d += 5.0) : (d -= 5.0)));
        d /= factor;
        if (this.value < 0.0) {
            d = 0.0 - d;
        }
        return new DoubleValue(d);
    }

    public double signum() {
        if (Double.isNaN(this.value)) {
            return this.value;
        }
        if (this.value > 0.0) {
            return 1.0;
        }
        if (this.value == 0.0) {
            return 0.0;
        }
        return -1.0;
    }

    public boolean isWholeNumber() {
        return this.value == Math.floor(this.value) && !Double.isInfinite(this.value);
    }

    public NumericValue abs() {
        if (this.value > 0.0) {
            return this;
        }
        return new DoubleValue(Math.abs(this.value));
    }

    public int compareTo(long other) {
        double otherDouble = other;
        if (this.value == otherDouble) {
            return 0;
        }
        if (this.value < otherDouble) {
            return -1;
        }
        return 1;
    }

    public Comparable getSchemaComparable() {
        return new Double(this.value);
    }

    public boolean isIdentical(Value v) {
        return v instanceof DoubleValue && DoubleSortComparer.getInstance().comparesEqual(this, (DoubleValue)v);
    }

    public static void printInternalForm(double d) {
        System.err.println("==== Double " + d + " ====");
        long bits = Double.doubleToLongBits(d);
        System.err.println("Internal form: " + Long.toHexString(bits));
        if (bits == 0x7FF0000000000000L) {
            System.err.println("+Infinity");
        } else if (bits == -4503599627370496L) {
            System.err.println("-Infinity");
        } else if (bits == 9221120237041090560L) {
            System.err.println("NaN");
        } else {
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exponent = e - 1075;
            System.err.println("Sign: " + s);
            System.err.println("Raw Exponent: " + e);
            System.err.println("Exponent: " + exponent);
            System.err.println("Significand: " + m);
            BigDecimal dec = BigDecimal.valueOf(m);
            dec = exponent > 0 ? dec.multiply(new BigDecimal(BigInteger.valueOf(2L).pow(exponent))) : dec.divide(new BigDecimal(BigInteger.valueOf(2L).pow(-exponent)), 6);
            System.err.println("Exact value: " + (s > 0 ? "" : "-") + dec);
        }
    }

    public static void main(String[] args) {
        DoubleValue.printInternalForm(0.01);
        System.err.println("3e0 : " + new DoubleValue(3.0).isWholeNumber());
        System.err.println("3e1 : " + new DoubleValue(30.0).isWholeNumber());
        System.err.println("3e-1 : " + new DoubleValue(0.3).isWholeNumber());
        System.err.println("1e0 : " + new DoubleValue(1.0).isWholeNumber());
        System.err.println("1 - 20");
        DoubleValue.printInternalForm(1.0);
        DoubleValue.printInternalForm(2.0);
        DoubleValue.printInternalForm(3.0);
        DoubleValue.printInternalForm(4.0);
        DoubleValue.printInternalForm(5.0);
        DoubleValue.printInternalForm(6.0);
        DoubleValue.printInternalForm(7.0);
        DoubleValue.printInternalForm(8.0);
        DoubleValue.printInternalForm(9.0);
        DoubleValue.printInternalForm(10.0);
        DoubleValue.printInternalForm(11.0);
        DoubleValue.printInternalForm(12.0);
        DoubleValue.printInternalForm(13.0);
        DoubleValue.printInternalForm(14.0);
        DoubleValue.printInternalForm(15.0);
        DoubleValue.printInternalForm(16.0);
        DoubleValue.printInternalForm(17.0);
        DoubleValue.printInternalForm(18.0);
        DoubleValue.printInternalForm(19.0);
        DoubleValue.printInternalForm(20.0);
        System.err.println("3.0000001");
        DoubleValue.printInternalForm(3.0000001);
        System.err.println("1");
        DoubleValue.printInternalForm(1.0);
        System.err.println("1.00000001");
        DoubleValue.printInternalForm(1.00000001);
        System.err.println("0.9999999e0");
        DoubleValue.printInternalForm(0.9999999);
    }
}

