/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaSignal* sig,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaSignal* sig,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaObjectTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static ValaCCodeExpression* vala_gsignal_module_emit_signal (ValaGSignalModule* self,
                                                      ValaSignal* sig,
                                                      ValaMemberAccess* expr,
                                                      ValaExpression* detail_expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static GType vala_gsignal_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaSignal* sig,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	{
		ValaList* _p_list = NULL;
		gint _p_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _p_index = 0;
		_p_list = params;
		_tmp6_ = _p_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaParameter* p = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			const gchar* _tmp13_;
			ValaParameter* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_p_index = _p_index + 1;
			_tmp9_ = _p_index;
			_tmp10_ = _p_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _p_list;
			_tmp12_ = vala_list_get (_tmp11_, _p_index);
			p = (ValaParameter*) _tmp12_;
			_tmp13_ = ret;
			_tmp14_ = p;
			_tmp15_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_replace (_tmp16_, ",", "_");
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("%s_%s", _tmp13_, _tmp18_);
			_g_free0 (ret);
			ret = _tmp19_;
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp20_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp21_ = _tmp20_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp21_)) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = ret;
		_tmp23_ = g_strconcat (_tmp22_, "_POINTER", NULL);
		_g_free0 (ret);
		ret = _tmp23_;
	} else {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == 0) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = ret;
			_tmp27_ = g_strconcat (_tmp26_, "_VOID", NULL);
			_g_free0 (ret);
			ret = _tmp27_;
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_type_symbol (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_type_symbol (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_type_symbol (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							_tmp22_ = vala_data_type_get_type_symbol (t);
							_tmp23_ = _tmp22_;
							st = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct);
							_tmp24_ = st;
							if (vala_struct_is_simple_type (_tmp24_)) {
								ValaTypeSymbol* _tmp25_;
								ValaTypeSymbol* _tmp26_;
								gchar* _tmp27_;
								_tmp25_ = vala_data_type_get_type_symbol (t);
								_tmp26_ = _tmp25_;
								_tmp27_ = vala_get_ccode_name ((ValaCodeNode*) _tmp26_);
								result = _tmp27_;
								return result;
							} else {
								gchar* _tmp28_;
								_tmp28_ = g_strdup ("gpointer");
								result = _tmp28_;
								return result;
							}
						} else {
							ValaTypeSymbol* _tmp29_;
							ValaTypeSymbol* _tmp30_;
							_tmp29_ = vala_data_type_get_type_symbol (t);
							_tmp30_ = _tmp29_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp31_;
								ValaTypeSymbol* _tmp32_;
								ValaEnum* _tmp33_;
								gboolean _tmp34_;
								gboolean _tmp35_;
								_tmp31_ = vala_data_type_get_type_symbol (t);
								_tmp32_ = _tmp31_;
								en = G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_ENUM, ValaEnum);
								_tmp33_ = en;
								_tmp34_ = vala_enum_get_is_flags (_tmp33_);
								_tmp35_ = _tmp34_;
								if (_tmp35_) {
									gchar* _tmp36_;
									_tmp36_ = g_strdup ("guint");
									result = _tmp36_;
									return result;
								} else {
									gchar* _tmp37_;
									_tmp37_ = g_strdup ("gint");
									result = _tmp37_;
									return result;
								}
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("gpointer");
									result = _tmp38_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp39_;
										_tmp39_ = g_strdup ("gpointer");
										result = _tmp39_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp40_;
											_tmp40_ = g_strdup ("gpointer");
											result = _tmp40_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean first = FALSE;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	first = TRUE;
	{
		ValaList* _p_list = NULL;
		gint _p_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_p_list = params;
		_tmp3_ = _p_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* p = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = vala_list_get (_tmp8_, _p_index);
			p = (ValaParameter*) _tmp9_;
			if (first) {
				const gchar* _tmp10_;
				ValaParameter* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp10_ = signature;
				_tmp11_ = p;
				_tmp12_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
				_g_free0 (signature);
				signature = _tmp14_;
				_g_free0 (_tmp13_);
				first = FALSE;
			} else {
				const gchar* _tmp15_;
				ValaParameter* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp15_ = signature;
				_tmp16_ = p;
				_tmp17_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup_printf ("%s,%s", _tmp15_, _tmp18_);
				_g_free0 (signature);
				signature = _tmp19_;
				_g_free0 (_tmp18_);
			}
			_vala_code_node_unref0 (p);
		}
	}
	_tmp20_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp21_ = _tmp20_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp21_)) {
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		if (first) {
			_tmp22_ = "POINTER";
		} else {
			_tmp22_ = ",POINTER";
		}
		_tmp23_ = signature;
		_tmp24_ = g_strconcat (_tmp23_, _tmp22_, NULL);
		_g_free0 (signature);
		signature = _tmp24_;
	} else {
		gint _tmp25_;
		gint _tmp26_;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == 0) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = signature;
			_tmp28_ = g_strconcat (_tmp27_, "VOID", NULL);
			_g_free0 (signature);
			signature = _tmp28_;
		}
	}
	result = signature;
	return result;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	ValaTargetValue* _tmp8_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	ValaTargetValue* _tmp11_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeConstant* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaTargetValue* _tmp26_;
	ValaCCodeExpression* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaTargetValue* _tmp29_;
	ValaCCodeExpression* _tmp30_;
	ValaCCodeExpression* _tmp31_;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp1_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp2_);
		_tmp4_ = (ValaCCodeExpression*) _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_expression_get_value_type (detail_expr);
	_tmp6_ = _tmp5_;
	_tmp7_ = TRUE;
	_tmp8_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp6_, FALSE, node, &_tmp7_);
	detail_value = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = detail_value;
	vala_list_insert ((ValaList*) _tmp10_, 0, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	ccall = _tmp15_;
	_tmp16_ = ccall;
	_tmp17_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = ccall;
	_tmp20_ = vala_get_cvalue (detail_expr);
	vala_ccode_function_call_add_argument (_tmp19_, _tmp20_);
	_tmp21_ = ccall;
	_tmp22_ = vala_ccode_constant_new ("NULL");
	_tmp23_ = _tmp22_;
	vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = detail_value;
	_tmp27_ = vala_get_cvalue_ (_tmp26_);
	_tmp28_ = ccall;
	vala_ccode_function_add_assignment (_tmp25_, _tmp27_, (ValaCCodeExpression*) _tmp28_);
	_tmp29_ = detail_value;
	_tmp30_ = vala_get_cvalue_ (_tmp29_);
	_tmp31_ = _vala_ccode_node_ref0 (_tmp30_);
	result = _tmp31_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_cvalue (detail_expr);
	_tmp1_ = _vala_ccode_node_ref0 (_tmp0_);
	detail_cexpr = _tmp1_;
	_tmp2_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression (_tmp2_)) {
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeIdentifier* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		_tmp3_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp4_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp5_;
		_vala_ccode_node_unref0 (_tmp4_);
	} else {
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		_tmp6_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
	}
	_tmp9_ = detail_ccall;
	_tmp10_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}

static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCCodeEnum* _tmp1_;
	ValaList* params = NULL;
	ValaList* _tmp15_;
	ValaDataType* _tmp33_;
	ValaDataType* _tmp34_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp1_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp3_ = _tmp2_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		ValaCCodeEnumValue* _tmp14_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_ccode_enum_value_new (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_ccode_enum_add_value (_tmp4_, _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp15_;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp16_;
		gint _p_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _p_index = 0;
		_tmp16_ = params;
		_p_list = _tmp16_;
		_tmp17_ = _p_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_p_size = _tmp19_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaParameter* p = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaParameter* _tmp24_;
			ValaCCodeFile* _tmp25_;
			GHashFunc _tmp26_;
			GEqualFunc _tmp27_;
			GEqualFunc _tmp28_;
			ValaHashMap* _tmp29_;
			ValaHashMap* _tmp30_;
			ValaCCodeParameter* _tmp31_;
			ValaCCodeParameter* _tmp32_;
			_p_index = _p_index + 1;
			_tmp20_ = _p_index;
			_tmp21_ = _p_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _p_list;
			_tmp23_ = vala_list_get (_tmp22_, _p_index);
			p = (ValaParameter*) _tmp23_;
			_tmp24_ = p;
			_tmp25_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp26_ = g_direct_hash;
			_tmp27_ = g_direct_equal;
			_tmp28_ = g_direct_equal;
			_tmp29_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp26_, _tmp27_, _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp24_, _tmp25_, (ValaMap*) _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_vala_ccode_node_unref0 (_tmp32_);
			_vala_map_unref0 (_tmp30_);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp33_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp34_ = _tmp33_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp34_)) {
		ValaList* _tmp35_;
		ValaVoidType* _tmp36_;
		ValaVoidType* _tmp37_;
		_tmp35_ = params;
		_tmp36_ = vala_void_type_new (NULL);
		_tmp37_ = _tmp36_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp35_, (ValaDataType*) _tmp37_);
		_vala_code_node_unref0 (_tmp37_);
	} else {
		ValaList* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		_tmp38_ = params;
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp40_ = _tmp39_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp38_, _tmp40_);
	}
}

static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaSignal* sig,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaCCodeFunctionDeclarator* _tmp112_;
	ValaCCodeParameter* _tmp113_;
	ValaCCodeParameter* _tmp114_;
	ValaCCodeFunction* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	ValaCCodeFunctionDeclarator* _tmp119_;
	ValaCCodeTypeDefinition* _tmp120_;
	ValaCCodeTypeDefinition* _tmp121_;
	ValaCCodeFunction* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	ValaCCodeVariableDeclarator* _tmp126_;
	ValaCCodeVariableDeclarator* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeCastExpression* _tmp132_;
	ValaCCodeCastExpression* _tmp133_;
	ValaCCodeVariableDeclarator* _tmp134_;
	ValaCCodeVariableDeclarator* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	ValaCCodeFunction* _tmp137_;
	ValaCCodeVariableDeclarator* _tmp138_;
	ValaCCodeVariableDeclarator* _tmp139_;
	ValaCCodeFunction* _tmp140_;
	ValaCCodeFunction* _tmp141_;
	ValaCCodeVariableDeclarator* _tmp142_;
	ValaCCodeVariableDeclarator* _tmp143_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp144_ = FALSE;
	ValaTypeSymbol* _tmp145_;
	ValaTypeSymbol* _tmp146_;
	ValaCCodeIdentifier* _tmp166_;
	ValaCCodeIdentifier* _tmp167_;
	ValaCCodeFunctionCall* _tmp168_;
	ValaCCodeFunctionCall* _tmp169_;
	ValaCCodeIdentifier* _tmp170_;
	ValaCCodeIdentifier* _tmp171_;
	gchar* _tmp172_;
	gchar* _tmp173_;
	ValaCCodeConstant* _tmp174_;
	ValaCCodeConstant* _tmp175_;
	ValaCCodeBinaryExpression* _tmp176_;
	ValaCCodeBinaryExpression* _tmp177_;
	ValaCCodeFunction* _tmp178_;
	ValaCCodeFunction* _tmp179_;
	ValaCCodeFunctionCall* _tmp180_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp181_;
	ValaCCodeIdentifier* _tmp182_;
	ValaCCodeMemberAccess* _tmp183_;
	ValaCCodeMemberAccess* _tmp184_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp185_;
	ValaCCodeIdentifier* _tmp186_;
	ValaCCodeMemberAccess* _tmp187_;
	ValaCCodeMemberAccess* _tmp188_;
	ValaCCodeMemberAccess* _tmp189_;
	ValaCCodeMemberAccess* _tmp190_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp191_;
	ValaCCodeConstant* _tmp192_;
	ValaCCodeFunctionCall* _tmp193_;
	ValaCCodeFunctionCall* _tmp194_;
	ValaCCodeFunctionCall* _tmp195_;
	ValaCCodeIdentifier* _tmp196_;
	ValaCCodeIdentifier* _tmp197_;
	ValaCCodeFunction* _tmp198_;
	ValaCCodeFunction* _tmp199_;
	ValaCCodeFunctionCall* _tmp200_;
	ValaCCodeFunction* _tmp201_;
	ValaCCodeFunction* _tmp202_;
	ValaCCodeIdentifier* _tmp203_;
	ValaCCodeIdentifier* _tmp204_;
	ValaCCodeMemberAccess* _tmp205_;
	ValaCCodeFunction* _tmp206_;
	ValaCCodeFunction* _tmp207_;
	ValaCCodeIdentifier* _tmp208_;
	ValaCCodeIdentifier* _tmp209_;
	ValaCCodeMemberAccess* _tmp210_;
	ValaCCodeFunction* _tmp211_;
	ValaCCodeFunction* _tmp212_;
	ValaCCodeFunction* _tmp213_;
	ValaCCodeFunction* _tmp214_;
	ValaCCodeIdentifier* _tmp215_;
	ValaCCodeIdentifier* _tmp216_;
	ValaCCodeMemberAccess* _tmp217_;
	ValaCCodeFunction* _tmp218_;
	ValaCCodeFunction* _tmp219_;
	ValaCCodeIdentifier* _tmp220_;
	ValaCCodeIdentifier* _tmp221_;
	ValaCCodeMemberAccess* _tmp222_;
	ValaCCodeFunction* _tmp223_;
	ValaCCodeFunction* _tmp224_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp225_;
	ValaCCodeIdentifier* _tmp226_;
	ValaCCodeIdentifier* _tmp227_;
	ValaCCodeIdentifier* _tmp228_;
	ValaCCodeIdentifier* _tmp229_;
	ValaCCodeIdentifier* _tmp230_;
	ValaCCodeMemberAccess* _tmp231_;
	ValaCCodeMemberAccess* _tmp232_;
	ValaCCodeConditionalExpression* _tmp233_;
	ValaCCodeConditionalExpression* _tmp234_;
	gchar* _tmp235_;
	gchar* _tmp236_;
	ValaCCodeCastExpression* _tmp237_;
	ValaCCodeCastExpression* _tmp238_;
	ValaCCodeFunction* _tmp239_;
	ValaCCodeFunction* _tmp240_;
	ValaCCodeIdentifier* _tmp241_;
	ValaCCodeIdentifier* _tmp242_;
	ValaCCodeCastExpression* _tmp243_;
	ValaCCodeIdentifier* _tmp244_;
	ValaCCodeIdentifier* _tmp245_;
	ValaCCodeFunctionCall* _tmp246_;
	ValaCCodeFunctionCall* _tmp247_;
	ValaCCodeIdentifier* _tmp248_;
	ValaCCodeIdentifier* _tmp249_;
	ValaDataType* _tmp372_;
	ValaDataType* _tmp373_;
	ValaCCodeFunctionCall* _tmp390_;
	ValaCCodeIdentifier* _tmp391_;
	ValaCCodeIdentifier* _tmp392_;
	gboolean _tmp393_ = FALSE;
	ValaTypeSymbol* _tmp394_;
	ValaTypeSymbol* _tmp395_;
	ValaCCodeFile* _tmp424_;
	ValaCCodeFunction* _tmp425_;
	ValaCCodeFile* _tmp426_;
	ValaCCodeFunction* _tmp427_;
	ValaSet* _tmp428_;
	const gchar* _tmp429_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		gint _p_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _p_index = 0;
		_p_list = params;
		_tmp37_ = _p_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_p_size = _tmp39_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			ValaParameter* p = NULL;
			ValaList* _tmp42_;
			gpointer _tmp43_;
			ValaCCodeFunctionDeclarator* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			ValaParameter* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			ValaCCodeParameter* _tmp50_;
			ValaCCodeParameter* _tmp51_;
			gint _tmp52_;
			ValaParameter* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_p_index = _p_index + 1;
			_tmp40_ = _p_index;
			_tmp41_ = _p_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _p_list;
			_tmp43_ = vala_list_get (_tmp42_, _p_index);
			p = (ValaParameter*) _tmp43_;
			_tmp44_ = callback_decl;
			_tmp45_ = g_strdup_printf ("arg_%d", n_params);
			_tmp46_ = _tmp45_;
			_tmp47_ = p;
			_tmp48_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_ccode_parameter_new (_tmp46_, _tmp49_);
			_tmp51_ = _tmp50_;
			vala_ccode_function_declarator_add_parameter (_tmp44_, _tmp51_);
			_vala_ccode_node_unref0 (_tmp51_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp46_);
			_tmp52_ = n_params;
			n_params = _tmp52_ + 1;
			_tmp53_ = p;
			_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) _tmp53_);
			_tmp55_ = _tmp54_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp56_;
				ValaDataType* _tmp57_;
				ValaDataType* _tmp58_;
				ValaArrayType* _tmp59_;
				gchar* length_ctype = NULL;
				ValaParameter* _tmp60_;
				gchar* _tmp61_;
				_tmp56_ = p;
				_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp59_;
				_tmp60_ = p;
				_tmp61_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp60_);
				length_ctype = _tmp61_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp62_ = FALSE;
						_tmp62_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp64_;
							gint _tmp65_;
							gint _tmp66_;
							ValaCCodeFunctionDeclarator* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							const gchar* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							ValaCCodeParameter* _tmp72_;
							gint _tmp73_;
							if (!_tmp62_) {
								gint _tmp63_;
								_tmp63_ = j;
								j = _tmp63_ + 1;
							}
							_tmp62_ = FALSE;
							_tmp64_ = array_type;
							_tmp65_ = vala_array_type_get_rank (_tmp64_);
							_tmp66_ = _tmp65_;
							if (!(j < _tmp66_)) {
								break;
							}
							_tmp67_ = callback_decl;
							_tmp68_ = g_strdup_printf ("arg_%d", n_params);
							_tmp69_ = _tmp68_;
							_tmp70_ = length_ctype;
							_tmp71_ = vala_ccode_parameter_new (_tmp69_, _tmp70_);
							_tmp72_ = _tmp71_;
							vala_ccode_function_declarator_add_parameter (_tmp67_, _tmp72_);
							_vala_ccode_node_unref0 (_tmp72_);
							_g_free0 (_tmp69_);
							_tmp73_ = n_params;
							n_params = _tmp73_ + 1;
						}
					}
				}
				_g_free0 (length_ctype);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				_tmp74_ = p;
				_tmp75_ = vala_variable_get_variable_type ((ValaVariable*) _tmp74_);
				_tmp76_ = _tmp75_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					ValaDelegateType* _tmp80_;
					ValaDelegate* _tmp81_;
					ValaDelegate* _tmp82_;
					gboolean _tmp83_;
					gboolean _tmp84_;
					_tmp77_ = p;
					_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) _tmp77_);
					_tmp79_ = _tmp78_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp80_ = delegate_type;
					_tmp81_ = vala_delegate_type_get_delegate_symbol (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = vala_delegate_get_has_target (_tmp82_);
					_tmp84_ = _tmp83_;
					if (_tmp84_) {
						ValaCCodeFunctionDeclarator* _tmp85_;
						gchar* _tmp86_;
						gchar* _tmp87_;
						ValaDataType* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						ValaCCodeParameter* _tmp91_;
						ValaCCodeParameter* _tmp92_;
						gint _tmp93_;
						ValaDelegateType* _tmp94_;
						_tmp85_ = callback_decl;
						_tmp86_ = g_strdup_printf ("arg_%d", n_params);
						_tmp87_ = _tmp86_;
						_tmp88_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
						_tmp89_ = vala_get_ccode_name ((ValaCodeNode*) _tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = vala_ccode_parameter_new (_tmp87_, _tmp90_);
						_tmp92_ = _tmp91_;
						vala_ccode_function_declarator_add_parameter (_tmp85_, _tmp92_);
						_vala_ccode_node_unref0 (_tmp92_);
						_g_free0 (_tmp90_);
						_g_free0 (_tmp87_);
						_tmp93_ = n_params;
						n_params = _tmp93_ + 1;
						_tmp94_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp94_)) {
							ValaCCodeFunctionDeclarator* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							ValaDelegateType* _tmp98_;
							gchar* _tmp99_;
							gchar* _tmp100_;
							ValaCCodeParameter* _tmp101_;
							ValaCCodeParameter* _tmp102_;
							gint _tmp103_;
							_tmp95_ = callback_decl;
							_tmp96_ = g_strdup_printf ("arg_%d", n_params);
							_tmp97_ = _tmp96_;
							_tmp98_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
							_tmp99_ = vala_get_ccode_name ((ValaCodeNode*) _tmp98_);
							_tmp100_ = _tmp99_;
							_tmp101_ = vala_ccode_parameter_new (_tmp97_, _tmp100_);
							_tmp102_ = _tmp101_;
							vala_ccode_function_declarator_add_parameter (_tmp95_, _tmp102_);
							_vala_ccode_node_unref0 (_tmp102_);
							_g_free0 (_tmp100_);
							_g_free0 (_tmp97_);
							_tmp103_ = n_params;
							n_params = _tmp103_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
	}
	_tmp104_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp105_ = _tmp104_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp105_)) {
		ValaCCodeFunctionDeclarator* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		ValaCCodeParameter* _tmp109_;
		ValaCCodeParameter* _tmp110_;
		gint _tmp111_;
		_tmp106_ = callback_decl;
		_tmp107_ = g_strdup_printf ("arg_%d", n_params);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_ccode_parameter_new (_tmp108_, "gpointer");
		_tmp110_ = _tmp109_;
		vala_ccode_function_declarator_add_parameter (_tmp106_, _tmp110_);
		_vala_ccode_node_unref0 (_tmp110_);
		_g_free0 (_tmp108_);
		_tmp111_ = n_params;
		n_params = _tmp111_ + 1;
	}
	_tmp112_ = callback_decl;
	_tmp113_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp114_ = _tmp113_;
	vala_ccode_function_declarator_add_parameter (_tmp112_, _tmp114_);
	_vala_ccode_node_unref0 (_tmp114_);
	_tmp115_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp118_ = _tmp117_;
	_tmp119_ = callback_decl;
	_tmp120_ = vala_ccode_type_definition_new (_tmp118_, (ValaCCodeDeclarator*) _tmp119_);
	_tmp121_ = _tmp120_;
	vala_ccode_function_add_statement (_tmp116_, (ValaCCodeNode*) _tmp121_);
	_vala_ccode_node_unref0 (_tmp121_);
	_g_free0 (_tmp118_);
	_tmp122_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp125_ = _tmp124_;
	_tmp126_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp127_ = _tmp126_;
	vala_ccode_function_add_declaration (_tmp123_, _tmp125_, (ValaCCodeDeclarator*) _tmp127_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp127_);
	_g_free0 (_tmp125_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("closure");
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp131_, "GCClosure *");
	_tmp133_ = _tmp132_;
	_tmp134_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp133_, NULL);
	_tmp135_ = _tmp134_;
	vala_ccode_function_add_declaration (_tmp129_, "GCClosure *", (ValaCCodeDeclarator*) _tmp135_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp135_);
	_vala_ccode_node_unref0 (_tmp133_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp136_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp137_ = _tmp136_;
	_tmp138_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp139_ = _tmp138_;
	vala_ccode_function_add_declaration (_tmp137_, "gpointer", (ValaCCodeDeclarator*) _tmp139_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp139_);
	_tmp140_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp143_ = _tmp142_;
	vala_ccode_function_add_declaration (_tmp141_, "gpointer", (ValaCCodeDeclarator*) _tmp143_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp143_);
	_tmp145_ = vala_data_type_get_type_symbol (return_type);
	_tmp146_ = _tmp145_;
	if (_tmp146_ != NULL) {
		_tmp144_ = TRUE;
	} else {
		_tmp144_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp144_) {
		ValaCCodeFunction* _tmp147_;
		ValaCCodeFunction* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		ValaCCodeVariableDeclarator* _tmp151_;
		ValaCCodeVariableDeclarator* _tmp152_;
		ValaCCodeIdentifier* _tmp153_;
		ValaCCodeIdentifier* _tmp154_;
		ValaCCodeFunctionCall* _tmp155_;
		ValaCCodeFunctionCall* _tmp156_;
		ValaCCodeIdentifier* _tmp157_;
		ValaCCodeIdentifier* _tmp158_;
		ValaCCodeConstant* _tmp159_;
		ValaCCodeConstant* _tmp160_;
		ValaCCodeBinaryExpression* _tmp161_;
		ValaCCodeBinaryExpression* _tmp162_;
		ValaCCodeFunction* _tmp163_;
		ValaCCodeFunction* _tmp164_;
		ValaCCodeFunctionCall* _tmp165_;
		_tmp147_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp152_ = _tmp151_;
		vala_ccode_function_add_declaration (_tmp148_, _tmp150_, (ValaCCodeDeclarator*) _tmp152_, 0);
		_vala_ccode_node_unref0 (_tmp152_);
		_g_free0 (_tmp150_);
		_tmp153_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp154_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp155_;
		_vala_ccode_node_unref0 (_tmp154_);
		_tmp156_ = fc;
		_tmp157_ = vala_ccode_identifier_new ("return_value");
		_tmp158_ = _tmp157_;
		_tmp159_ = vala_ccode_constant_new ("NULL");
		_tmp160_ = _tmp159_;
		_tmp161_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp158_, (ValaCCodeExpression*) _tmp160_);
		_tmp162_ = _tmp161_;
		vala_ccode_function_call_add_argument (_tmp156_, (ValaCCodeExpression*) _tmp162_);
		_vala_ccode_node_unref0 (_tmp162_);
		_vala_ccode_node_unref0 (_tmp160_);
		_vala_ccode_node_unref0 (_tmp158_);
		_tmp163_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp164_ = _tmp163_;
		_tmp165_ = fc;
		vala_ccode_function_add_expression (_tmp164_, (ValaCCodeExpression*) _tmp165_);
	}
	_tmp166_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp167_ = _tmp166_;
	_tmp168_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp167_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp168_;
	_vala_ccode_node_unref0 (_tmp167_);
	_tmp169_ = fc;
	_tmp170_ = vala_ccode_identifier_new ("n_param_values");
	_tmp171_ = _tmp170_;
	_tmp172_ = g_strdup_printf ("%i", n_params);
	_tmp173_ = _tmp172_;
	_tmp174_ = vala_ccode_constant_new (_tmp173_);
	_tmp175_ = _tmp174_;
	_tmp176_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp171_, (ValaCCodeExpression*) _tmp175_);
	_tmp177_ = _tmp176_;
	vala_ccode_function_call_add_argument (_tmp169_, (ValaCCodeExpression*) _tmp177_);
	_vala_ccode_node_unref0 (_tmp177_);
	_vala_ccode_node_unref0 (_tmp175_);
	_g_free0 (_tmp173_);
	_vala_ccode_node_unref0 (_tmp171_);
	_tmp178_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp179_ = _tmp178_;
	_tmp180_ = fc;
	vala_ccode_function_add_expression (_tmp179_, (ValaCCodeExpression*) _tmp180_);
	_tmp181_ = vala_ccode_identifier_new ("closure");
	_tmp182_ = _tmp181_;
	_tmp183_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp182_, "data", TRUE);
	_tmp184_ = _tmp183_;
	_vala_ccode_node_unref0 (_tmp182_);
	data = _tmp184_;
	_tmp185_ = vala_ccode_identifier_new ("param_values");
	_tmp186_ = _tmp185_;
	_tmp187_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp186_, "data[0]", TRUE);
	_tmp188_ = _tmp187_;
	_tmp189_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp188_, "v_pointer", FALSE);
	_tmp190_ = _tmp189_;
	_vala_ccode_node_unref0 (_tmp188_);
	_vala_ccode_node_unref0 (_tmp186_);
	param = _tmp190_;
	_tmp191_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp192_ = _tmp191_;
	_tmp193_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp192_);
	_tmp194_ = _tmp193_;
	_vala_ccode_node_unref0 (_tmp192_);
	cond = _tmp194_;
	_tmp195_ = cond;
	_tmp196_ = vala_ccode_identifier_new ("closure");
	_tmp197_ = _tmp196_;
	vala_ccode_function_call_add_argument (_tmp195_, (ValaCCodeExpression*) _tmp197_);
	_vala_ccode_node_unref0 (_tmp197_);
	_tmp198_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp199_ = _tmp198_;
	_tmp200_ = cond;
	vala_ccode_function_open_if (_tmp199_, (ValaCCodeExpression*) _tmp200_);
	_tmp201_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp202_ = _tmp201_;
	_tmp203_ = vala_ccode_identifier_new ("data1");
	_tmp204_ = _tmp203_;
	_tmp205_ = data;
	vala_ccode_function_add_assignment (_tmp202_, (ValaCCodeExpression*) _tmp204_, (ValaCCodeExpression*) _tmp205_);
	_vala_ccode_node_unref0 (_tmp204_);
	_tmp206_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp207_ = _tmp206_;
	_tmp208_ = vala_ccode_identifier_new ("data2");
	_tmp209_ = _tmp208_;
	_tmp210_ = param;
	vala_ccode_function_add_assignment (_tmp207_, (ValaCCodeExpression*) _tmp209_, (ValaCCodeExpression*) _tmp210_);
	_vala_ccode_node_unref0 (_tmp209_);
	_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp212_ = _tmp211_;
	vala_ccode_function_add_else (_tmp212_);
	_tmp213_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp214_ = _tmp213_;
	_tmp215_ = vala_ccode_identifier_new ("data1");
	_tmp216_ = _tmp215_;
	_tmp217_ = param;
	vala_ccode_function_add_assignment (_tmp214_, (ValaCCodeExpression*) _tmp216_, (ValaCCodeExpression*) _tmp217_);
	_vala_ccode_node_unref0 (_tmp216_);
	_tmp218_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp219_ = _tmp218_;
	_tmp220_ = vala_ccode_identifier_new ("data2");
	_tmp221_ = _tmp220_;
	_tmp222_ = data;
	vala_ccode_function_add_assignment (_tmp219_, (ValaCCodeExpression*) _tmp221_, (ValaCCodeExpression*) _tmp222_);
	_vala_ccode_node_unref0 (_tmp221_);
	_tmp223_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp224_ = _tmp223_;
	vala_ccode_function_close (_tmp224_);
	_tmp225_ = vala_ccode_identifier_new ("marshal_data");
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_ccode_identifier_new ("marshal_data");
	_tmp228_ = _tmp227_;
	_tmp229_ = vala_ccode_identifier_new ("cc");
	_tmp230_ = _tmp229_;
	_tmp231_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp230_, "callback", TRUE);
	_tmp232_ = _tmp231_;
	_tmp233_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp226_, (ValaCCodeExpression*) _tmp228_, (ValaCCodeExpression*) _tmp232_);
	_tmp234_ = _tmp233_;
	_tmp235_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp236_ = _tmp235_;
	_tmp237_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp234_, _tmp236_);
	_tmp238_ = _tmp237_;
	_g_free0 (_tmp236_);
	_vala_ccode_node_unref0 (_tmp234_);
	_vala_ccode_node_unref0 (_tmp232_);
	_vala_ccode_node_unref0 (_tmp230_);
	_vala_ccode_node_unref0 (_tmp228_);
	_vala_ccode_node_unref0 (_tmp226_);
	c_assign_rhs = _tmp238_;
	_tmp239_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp240_ = _tmp239_;
	_tmp241_ = vala_ccode_identifier_new ("callback");
	_tmp242_ = _tmp241_;
	_tmp243_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp240_, (ValaCCodeExpression*) _tmp242_, (ValaCCodeExpression*) _tmp243_);
	_vala_ccode_node_unref0 (_tmp242_);
	_tmp244_ = vala_ccode_identifier_new ("callback");
	_tmp245_ = _tmp244_;
	_tmp246_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp245_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp246_;
	_vala_ccode_node_unref0 (_tmp245_);
	_tmp247_ = fc;
	_tmp248_ = vala_ccode_identifier_new ("data1");
	_tmp249_ = _tmp248_;
	vala_ccode_function_call_add_argument (_tmp247_, (ValaCCodeExpression*) _tmp249_);
	_vala_ccode_node_unref0 (_tmp249_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		gint _p_size = 0;
		ValaList* _tmp250_;
		gint _tmp251_;
		gint _tmp252_;
		gint _p_index = 0;
		_p_list = params;
		_tmp250_ = _p_list;
		_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
		_tmp252_ = _tmp251_;
		_p_size = _tmp252_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp253_;
			gint _tmp254_;
			ValaParameter* p = NULL;
			ValaList* _tmp255_;
			gpointer _tmp256_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			ValaParameter* _tmp257_;
			ValaParameterDirection _tmp258_;
			ValaParameterDirection _tmp259_;
			ValaCCodeFunctionCall* _tmp281_;
			ValaCCodeIdentifier* _tmp282_;
			ValaCCodeIdentifier* _tmp283_;
			gchar* _tmp284_;
			gchar* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeBinaryExpression* _tmp288_;
			ValaCCodeBinaryExpression* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			gint _tmp292_;
			ValaParameter* _tmp293_;
			ValaDataType* _tmp294_;
			ValaDataType* _tmp295_;
			_p_index = _p_index + 1;
			_tmp253_ = _p_index;
			_tmp254_ = _p_size;
			if (!(_tmp253_ < _tmp254_)) {
				break;
			}
			_tmp255_ = _p_list;
			_tmp256_ = vala_list_get (_tmp255_, _p_index);
			p = (ValaParameter*) _tmp256_;
			_tmp257_ = p;
			_tmp258_ = vala_parameter_get_direction (_tmp257_);
			_tmp259_ = _tmp258_;
			if (_tmp259_ != VALA_PARAMETER_DIRECTION_IN) {
				ValaCCodeIdentifier* _tmp260_;
				ValaCCodeIdentifier* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				_tmp260_ = vala_ccode_identifier_new ("g_value_get_pointer");
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp261_);
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp262_;
				_vala_ccode_node_unref0 (_tmp261_);
			} else {
				gboolean _tmp263_ = FALSE;
				ValaParameter* _tmp264_;
				ValaDataType* _tmp265_;
				ValaDataType* _tmp266_;
				_tmp264_ = p;
				_tmp265_ = vala_variable_get_variable_type ((ValaVariable*) _tmp264_);
				_tmp266_ = _tmp265_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp266_, VALA_TYPE_VALUE_TYPE)) {
					ValaParameter* _tmp267_;
					ValaDataType* _tmp268_;
					ValaDataType* _tmp269_;
					gboolean _tmp270_;
					gboolean _tmp271_;
					_tmp267_ = p;
					_tmp268_ = vala_variable_get_variable_type ((ValaVariable*) _tmp267_);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_data_type_get_nullable (_tmp269_);
					_tmp271_ = _tmp270_;
					_tmp263_ = _tmp271_;
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaCCodeIdentifier* _tmp272_;
					ValaCCodeIdentifier* _tmp273_;
					ValaCCodeFunctionCall* _tmp274_;
					_tmp272_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp273_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp274_;
					_vala_ccode_node_unref0 (_tmp273_);
				} else {
					ValaParameter* _tmp275_;
					ValaDataType* _tmp276_;
					ValaDataType* _tmp277_;
					ValaCCodeExpression* _tmp278_;
					ValaCCodeExpression* _tmp279_;
					ValaCCodeFunctionCall* _tmp280_;
					_tmp275_ = p;
					_tmp276_ = vala_variable_get_variable_type ((ValaVariable*) _tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_ccode_base_module_get_value_getter_function ((ValaCCodeBaseModule*) self, _tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_function_call_new (_tmp279_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp280_;
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
			_tmp281_ = inner_fc;
			_tmp282_ = vala_ccode_identifier_new ("param_values");
			_tmp283_ = _tmp282_;
			_tmp284_ = g_strdup_printf ("%i", i);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_identifier_new (_tmp285_);
			_tmp287_ = _tmp286_;
			_tmp288_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp283_, (ValaCCodeExpression*) _tmp287_);
			_tmp289_ = _tmp288_;
			vala_ccode_function_call_add_argument (_tmp281_, (ValaCCodeExpression*) _tmp289_);
			_vala_ccode_node_unref0 (_tmp289_);
			_vala_ccode_node_unref0 (_tmp287_);
			_g_free0 (_tmp285_);
			_vala_ccode_node_unref0 (_tmp283_);
			_tmp290_ = fc;
			_tmp291_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp290_, (ValaCCodeExpression*) _tmp291_);
			_tmp292_ = i;
			i = _tmp292_ + 1;
			_tmp293_ = p;
			_tmp294_ = vala_variable_get_variable_type ((ValaVariable*) _tmp293_);
			_tmp295_ = _tmp294_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp295_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp296_;
				ValaDataType* _tmp297_;
				ValaDataType* _tmp298_;
				ValaArrayType* _tmp299_;
				gchar* length_value_function = NULL;
				ValaArrayType* _tmp300_;
				ValaDataType* _tmp301_;
				ValaDataType* _tmp302_;
				ValaTypeSymbol* _tmp303_;
				ValaTypeSymbol* _tmp304_;
				gchar* _tmp305_;
				gboolean _tmp306_ = FALSE;
				const gchar* _tmp307_;
				_tmp296_ = p;
				_tmp297_ = vala_variable_get_variable_type ((ValaVariable*) _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp298_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp299_;
				_tmp300_ = array_type;
				_tmp301_ = vala_array_type_get_length_type (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_data_type_get_type_symbol (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp304_);
				length_value_function = _tmp305_;
				_tmp307_ = length_value_function;
				if (_tmp307_ != NULL) {
					const gchar* _tmp308_;
					_tmp308_ = length_value_function;
					_tmp306_ = g_strcmp0 (_tmp308_, "") != 0;
				} else {
					_tmp306_ = FALSE;
				}
				_vala_assert (_tmp306_, "length_value_function != null && length_value_function != \"\"");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp309_ = FALSE;
						_tmp309_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp311_;
							gint _tmp312_;
							gint _tmp313_;
							const gchar* _tmp314_;
							ValaCCodeIdentifier* _tmp315_;
							ValaCCodeIdentifier* _tmp316_;
							ValaCCodeFunctionCall* _tmp317_;
							ValaCCodeFunctionCall* _tmp318_;
							ValaCCodeIdentifier* _tmp319_;
							ValaCCodeIdentifier* _tmp320_;
							gchar* _tmp321_;
							gchar* _tmp322_;
							ValaCCodeIdentifier* _tmp323_;
							ValaCCodeIdentifier* _tmp324_;
							ValaCCodeBinaryExpression* _tmp325_;
							ValaCCodeBinaryExpression* _tmp326_;
							ValaCCodeFunctionCall* _tmp327_;
							ValaCCodeFunctionCall* _tmp328_;
							gint _tmp329_;
							if (!_tmp309_) {
								gint _tmp310_;
								_tmp310_ = j;
								j = _tmp310_ + 1;
							}
							_tmp309_ = FALSE;
							_tmp311_ = array_type;
							_tmp312_ = vala_array_type_get_rank (_tmp311_);
							_tmp313_ = _tmp312_;
							if (!(j < _tmp313_)) {
								break;
							}
							_tmp314_ = length_value_function;
							_tmp315_ = vala_ccode_identifier_new (_tmp314_);
							_tmp316_ = _tmp315_;
							_tmp317_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp316_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp317_;
							_vala_ccode_node_unref0 (_tmp316_);
							_tmp318_ = inner_fc;
							_tmp319_ = vala_ccode_identifier_new ("param_values");
							_tmp320_ = _tmp319_;
							_tmp321_ = g_strdup_printf ("%i", i);
							_tmp322_ = _tmp321_;
							_tmp323_ = vala_ccode_identifier_new (_tmp322_);
							_tmp324_ = _tmp323_;
							_tmp325_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp320_, (ValaCCodeExpression*) _tmp324_);
							_tmp326_ = _tmp325_;
							vala_ccode_function_call_add_argument (_tmp318_, (ValaCCodeExpression*) _tmp326_);
							_vala_ccode_node_unref0 (_tmp326_);
							_vala_ccode_node_unref0 (_tmp324_);
							_g_free0 (_tmp322_);
							_vala_ccode_node_unref0 (_tmp320_);
							_tmp327_ = fc;
							_tmp328_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp327_, (ValaCCodeExpression*) _tmp328_);
							_tmp329_ = i;
							i = _tmp329_ + 1;
						}
					}
				}
				_g_free0 (length_value_function);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp330_;
				ValaDataType* _tmp331_;
				ValaDataType* _tmp332_;
				_tmp330_ = p;
				_tmp331_ = vala_variable_get_variable_type ((ValaVariable*) _tmp330_);
				_tmp332_ = _tmp331_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp332_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp333_;
					ValaDataType* _tmp334_;
					ValaDataType* _tmp335_;
					ValaDelegateType* _tmp336_;
					ValaDelegate* _tmp337_;
					ValaDelegate* _tmp338_;
					gboolean _tmp339_;
					gboolean _tmp340_;
					_tmp333_ = p;
					_tmp334_ = vala_variable_get_variable_type ((ValaVariable*) _tmp333_);
					_tmp335_ = _tmp334_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp336_ = delegate_type;
					_tmp337_ = vala_delegate_type_get_delegate_symbol (_tmp336_);
					_tmp338_ = _tmp337_;
					_tmp339_ = vala_delegate_get_has_target (_tmp338_);
					_tmp340_ = _tmp339_;
					if (_tmp340_) {
						ValaCCodeIdentifier* _tmp341_;
						ValaCCodeIdentifier* _tmp342_;
						ValaCCodeFunctionCall* _tmp343_;
						ValaCCodeFunctionCall* _tmp344_;
						ValaCCodeIdentifier* _tmp345_;
						ValaCCodeIdentifier* _tmp346_;
						gchar* _tmp347_;
						gchar* _tmp348_;
						ValaCCodeIdentifier* _tmp349_;
						ValaCCodeIdentifier* _tmp350_;
						ValaCCodeBinaryExpression* _tmp351_;
						ValaCCodeBinaryExpression* _tmp352_;
						ValaCCodeFunctionCall* _tmp353_;
						ValaCCodeFunctionCall* _tmp354_;
						gint _tmp355_;
						ValaDelegateType* _tmp356_;
						_tmp341_ = vala_ccode_identifier_new ("g_value_get_pointer");
						_tmp342_ = _tmp341_;
						_tmp343_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp342_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp343_;
						_vala_ccode_node_unref0 (_tmp342_);
						_tmp344_ = inner_fc;
						_tmp345_ = vala_ccode_identifier_new ("param_values");
						_tmp346_ = _tmp345_;
						_tmp347_ = g_strdup_printf ("%i", i);
						_tmp348_ = _tmp347_;
						_tmp349_ = vala_ccode_identifier_new (_tmp348_);
						_tmp350_ = _tmp349_;
						_tmp351_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp346_, (ValaCCodeExpression*) _tmp350_);
						_tmp352_ = _tmp351_;
						vala_ccode_function_call_add_argument (_tmp344_, (ValaCCodeExpression*) _tmp352_);
						_vala_ccode_node_unref0 (_tmp352_);
						_vala_ccode_node_unref0 (_tmp350_);
						_g_free0 (_tmp348_);
						_vala_ccode_node_unref0 (_tmp346_);
						_tmp353_ = fc;
						_tmp354_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp353_, (ValaCCodeExpression*) _tmp354_);
						_tmp355_ = i;
						i = _tmp355_ + 1;
						_tmp356_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp356_)) {
							ValaCCodeIdentifier* _tmp357_;
							ValaCCodeIdentifier* _tmp358_;
							ValaCCodeFunctionCall* _tmp359_;
							ValaCCodeFunctionCall* _tmp360_;
							ValaCCodeIdentifier* _tmp361_;
							ValaCCodeIdentifier* _tmp362_;
							gchar* _tmp363_;
							gchar* _tmp364_;
							ValaCCodeIdentifier* _tmp365_;
							ValaCCodeIdentifier* _tmp366_;
							ValaCCodeBinaryExpression* _tmp367_;
							ValaCCodeBinaryExpression* _tmp368_;
							ValaCCodeFunctionCall* _tmp369_;
							ValaCCodeFunctionCall* _tmp370_;
							gint _tmp371_;
							_tmp357_ = vala_ccode_identifier_new ("g_value_get_pointer");
							_tmp358_ = _tmp357_;
							_tmp359_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp358_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp359_;
							_vala_ccode_node_unref0 (_tmp358_);
							_tmp360_ = inner_fc;
							_tmp361_ = vala_ccode_identifier_new ("param_values");
							_tmp362_ = _tmp361_;
							_tmp363_ = g_strdup_printf ("%i", i);
							_tmp364_ = _tmp363_;
							_tmp365_ = vala_ccode_identifier_new (_tmp364_);
							_tmp366_ = _tmp365_;
							_tmp367_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp362_, (ValaCCodeExpression*) _tmp366_);
							_tmp368_ = _tmp367_;
							vala_ccode_function_call_add_argument (_tmp360_, (ValaCCodeExpression*) _tmp368_);
							_vala_ccode_node_unref0 (_tmp368_);
							_vala_ccode_node_unref0 (_tmp366_);
							_g_free0 (_tmp364_);
							_vala_ccode_node_unref0 (_tmp362_);
							_tmp369_ = fc;
							_tmp370_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp369_, (ValaCCodeExpression*) _tmp370_);
							_tmp371_ = i;
							i = _tmp371_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp372_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp373_ = _tmp372_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp373_)) {
		ValaCCodeFunctionCall* inner_fc = NULL;
		ValaCCodeIdentifier* _tmp374_;
		ValaCCodeIdentifier* _tmp375_;
		ValaCCodeFunctionCall* _tmp376_;
		ValaCCodeFunctionCall* _tmp377_;
		ValaCCodeFunctionCall* _tmp378_;
		ValaCCodeIdentifier* _tmp379_;
		ValaCCodeIdentifier* _tmp380_;
		gchar* _tmp381_;
		gchar* _tmp382_;
		ValaCCodeIdentifier* _tmp383_;
		ValaCCodeIdentifier* _tmp384_;
		ValaCCodeBinaryExpression* _tmp385_;
		ValaCCodeBinaryExpression* _tmp386_;
		ValaCCodeFunctionCall* _tmp387_;
		ValaCCodeFunctionCall* _tmp388_;
		gint _tmp389_;
		_tmp374_ = vala_ccode_identifier_new ("g_value_get_pointer");
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp375_);
		_tmp377_ = _tmp376_;
		_vala_ccode_node_unref0 (_tmp375_);
		inner_fc = _tmp377_;
		_tmp378_ = inner_fc;
		_tmp379_ = vala_ccode_identifier_new ("param_values");
		_tmp380_ = _tmp379_;
		_tmp381_ = g_strdup_printf ("%i", i);
		_tmp382_ = _tmp381_;
		_tmp383_ = vala_ccode_identifier_new (_tmp382_);
		_tmp384_ = _tmp383_;
		_tmp385_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp380_, (ValaCCodeExpression*) _tmp384_);
		_tmp386_ = _tmp385_;
		vala_ccode_function_call_add_argument (_tmp378_, (ValaCCodeExpression*) _tmp386_);
		_vala_ccode_node_unref0 (_tmp386_);
		_vala_ccode_node_unref0 (_tmp384_);
		_g_free0 (_tmp382_);
		_vala_ccode_node_unref0 (_tmp380_);
		_tmp387_ = fc;
		_tmp388_ = inner_fc;
		vala_ccode_function_call_add_argument (_tmp387_, (ValaCCodeExpression*) _tmp388_);
		_tmp389_ = i;
		i = _tmp389_ + 1;
		_vala_ccode_node_unref0 (inner_fc);
	}
	_tmp390_ = fc;
	_tmp391_ = vala_ccode_identifier_new ("data2");
	_tmp392_ = _tmp391_;
	vala_ccode_function_call_add_argument (_tmp390_, (ValaCCodeExpression*) _tmp392_);
	_vala_ccode_node_unref0 (_tmp392_);
	_tmp394_ = vala_data_type_get_type_symbol (return_type);
	_tmp395_ = _tmp394_;
	if (_tmp395_ != NULL) {
		_tmp393_ = TRUE;
	} else {
		_tmp393_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp393_) {
		ValaCCodeFunction* _tmp396_;
		ValaCCodeFunction* _tmp397_;
		ValaCCodeIdentifier* _tmp398_;
		ValaCCodeIdentifier* _tmp399_;
		ValaCCodeFunctionCall* _tmp400_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp412_;
		ValaCCodeIdentifier* _tmp413_;
		ValaCCodeIdentifier* _tmp414_;
		ValaCCodeFunctionCall* _tmp415_;
		ValaCCodeIdentifier* _tmp416_;
		ValaCCodeIdentifier* _tmp417_;
		ValaCCodeFunction* _tmp418_;
		ValaCCodeFunction* _tmp419_;
		ValaCCodeFunctionCall* _tmp420_;
		_tmp396_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp397_ = _tmp396_;
		_tmp398_ = vala_ccode_identifier_new ("v_return");
		_tmp399_ = _tmp398_;
		_tmp400_ = fc;
		vala_ccode_function_add_assignment (_tmp397_, (ValaCCodeExpression*) _tmp399_, (ValaCCodeExpression*) _tmp400_);
		_vala_ccode_node_unref0 (_tmp399_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
			gboolean _tmp401_;
			gboolean _tmp402_;
			_tmp401_ = vala_data_type_get_nullable (return_type);
			_tmp402_ = _tmp401_;
			if (_tmp402_) {
				ValaCCodeIdentifier* _tmp403_;
				ValaCCodeIdentifier* _tmp404_;
				ValaCCodeFunctionCall* _tmp405_;
				_tmp403_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp404_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp405_;
				_vala_ccode_node_unref0 (_tmp404_);
			} else {
				ValaCCodeExpression* _tmp406_;
				ValaCCodeExpression* _tmp407_;
				ValaCCodeFunctionCall* _tmp408_;
				_tmp406_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, return_type);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_function_call_new (_tmp407_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp408_;
				_vala_ccode_node_unref0 (_tmp407_);
			}
		} else {
			ValaCCodeExpression* _tmp409_;
			ValaCCodeExpression* _tmp410_;
			ValaCCodeFunctionCall* _tmp411_;
			_tmp409_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, return_type);
			_tmp410_ = _tmp409_;
			_tmp411_ = vala_ccode_function_call_new (_tmp410_);
			_vala_ccode_node_unref0 (set_fc);
			set_fc = _tmp411_;
			_vala_ccode_node_unref0 (_tmp410_);
		}
		_tmp412_ = set_fc;
		_tmp413_ = vala_ccode_identifier_new ("return_value");
		_tmp414_ = _tmp413_;
		vala_ccode_function_call_add_argument (_tmp412_, (ValaCCodeExpression*) _tmp414_);
		_vala_ccode_node_unref0 (_tmp414_);
		_tmp415_ = set_fc;
		_tmp416_ = vala_ccode_identifier_new ("v_return");
		_tmp417_ = _tmp416_;
		vala_ccode_function_call_add_argument (_tmp415_, (ValaCCodeExpression*) _tmp417_);
		_vala_ccode_node_unref0 (_tmp417_);
		_tmp418_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp419_ = _tmp418_;
		_tmp420_ = set_fc;
		vala_ccode_function_add_expression (_tmp419_, (ValaCCodeExpression*) _tmp420_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp421_;
		ValaCCodeFunction* _tmp422_;
		ValaCCodeFunctionCall* _tmp423_;
		_tmp421_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp422_ = _tmp421_;
		_tmp423_ = fc;
		vala_ccode_function_add_expression (_tmp422_, (ValaCCodeExpression*) _tmp423_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp424_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp425_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp424_, _tmp425_);
	_tmp426_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp427_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp426_, _tmp427_);
	_tmp428_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp429_ = signature;
	vala_collection_add ((ValaCollection*) _tmp428_, _tmp429_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaObjectTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* csignew = NULL;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	gchar** flags = NULL;
	gchar** _tmp23_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	ValaVersionAttribute* _tmp34_;
	ValaVersionAttribute* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	ValaCCodeFunctionCall* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaMethod* _tmp45_;
	ValaMethod* _tmp46_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeConstant* _tmp80_;
	ValaCCodeConstant* _tmp81_;
	ValaCCodeFunctionCall* _tmp82_;
	ValaCCodeConstant* _tmp83_;
	ValaCCodeConstant* _tmp84_;
	ValaList* params = NULL;
	ValaList* _tmp85_;
	gchar* marshaller = NULL;
	ValaDataType* _tmp86_;
	ValaDataType* _tmp87_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeIdentifier* _tmp99_;
	gboolean _tmp100_ = FALSE;
	ValaDataType* _tmp101_;
	ValaDataType* _tmp102_;
	gint params_len = 0;
	ValaDataType* _tmp175_;
	ValaDataType* _tmp176_;
	ValaCCodeFunctionCall* _tmp178_;
	gchar* _tmp179_;
	gchar* _tmp180_;
	ValaCCodeConstant* _tmp181_;
	ValaCCodeConstant* _tmp182_;
	ValaDataType* _tmp295_;
	ValaDataType* _tmp296_;
	ValaCCodeIdentifier* _tmp300_;
	const gchar* _tmp301_;
	ValaCCodeExpression* _tmp302_;
	ValaCCodeExpression* _tmp303_;
	ValaCCodeFunctionCall* _tmp304_;
	ValaCCodeAssignment* _tmp305_;
	ValaCCodeExpression* _tmp306_;
	ValaCCodeExpression* result;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1_ = vala_signal_get_default_handler (sig);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_signal_get_is_virtual (sig);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		ValaCCodeIdentifier* _tmp5_;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		_tmp5_ = vala_ccode_identifier_new ("g_signal_new");
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
		_vala_ccode_node_unref0 (csignew);
		csignew = _tmp7_;
		_vala_ccode_node_unref0 (_tmp6_);
	} else {
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		_tmp8_ = vala_ccode_identifier_new ("g_signal_new_class_handler");
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp9_);
		_vala_ccode_node_unref0 (csignew);
		csignew = _tmp10_;
		_vala_ccode_node_unref0 (_tmp9_);
	}
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("\"%s\"", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_ccode_constant_new (_tmp15_);
	_tmp17_ = _tmp16_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp17_);
	_vala_ccode_node_unref0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp18_ = csignew;
	_tmp19_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_identifier_new (_tmp20_);
	_tmp22_ = _tmp21_;
	vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp23_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp23_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp24_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp24_;
	_tmp25_ = run_type;
	if (g_strcmp0 (_tmp25_, "first") == 0) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp26_);
	} else {
		const gchar* _tmp27_;
		_tmp27_ = run_type;
		if (g_strcmp0 (_tmp27_, "cleanup") == 0) {
			gchar* _tmp28_;
			_tmp28_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp28_);
		} else {
			gchar* _tmp29_;
			_tmp29_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp29_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp30_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp32_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar* _tmp33_;
		_tmp33_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_version_attribute_get_deprecated (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		gchar* _tmp38_;
		_tmp38_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp38_);
	}
	_tmp39_ = csignew;
	_tmp40_ = flags;
	_tmp40__length1 = flags_length1;
	_tmp41_ = _vala_g_strjoinv (" | ", _tmp40_, (gint) _tmp40__length1);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_ccode_constant_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_ccode_function_call_add_argument (_tmp39_, (ValaCCodeExpression*) _tmp44_);
	_vala_ccode_node_unref0 (_tmp44_);
	_g_free0 (_tmp42_);
	_tmp45_ = vala_signal_get_default_handler (sig);
	_tmp46_ = _tmp45_;
	if (_tmp46_ == NULL) {
		ValaCCodeFunctionCall* _tmp47_;
		ValaCCodeConstant* _tmp48_;
		ValaCCodeConstant* _tmp49_;
		_tmp47_ = csignew;
		_tmp48_ = vala_ccode_constant_new ("0");
		_tmp49_ = _tmp48_;
		vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
		_vala_ccode_node_unref0 (_tmp49_);
	} else {
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp50_ = vala_signal_get_is_virtual (sig);
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			ValaCCodeFunctionCall* struct_offset = NULL;
			ValaCCodeIdentifier* _tmp52_;
			ValaCCodeIdentifier* _tmp53_;
			ValaCCodeFunctionCall* _tmp54_;
			ValaCCodeFunctionCall* _tmp55_;
			ValaCCodeFunctionCall* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeIdentifier* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeFunctionCall* _tmp61_;
			ValaMethod* _tmp62_;
			ValaMethod* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			ValaCCodeIdentifier* _tmp67_;
			ValaCCodeFunctionCall* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			_tmp52_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp53_);
			_tmp55_ = _tmp54_;
			_vala_ccode_node_unref0 (_tmp53_);
			struct_offset = _tmp55_;
			_tmp56_ = struct_offset;
			_tmp57_ = vala_get_ccode_type_name (type);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_ccode_identifier_new (_tmp58_);
			_tmp60_ = _tmp59_;
			vala_ccode_function_call_add_argument (_tmp56_, (ValaCCodeExpression*) _tmp60_);
			_vala_ccode_node_unref0 (_tmp60_);
			_g_free0 (_tmp58_);
			_tmp61_ = struct_offset;
			_tmp62_ = vala_signal_get_default_handler (sig);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_get_ccode_vfunc_name (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_ccode_identifier_new (_tmp65_);
			_tmp67_ = _tmp66_;
			vala_ccode_function_call_add_argument (_tmp61_, (ValaCCodeExpression*) _tmp67_);
			_vala_ccode_node_unref0 (_tmp67_);
			_g_free0 (_tmp65_);
			_tmp68_ = csignew;
			_tmp69_ = struct_offset;
			vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp69_);
			_vala_ccode_node_unref0 (struct_offset);
		} else {
			ValaCCodeFunctionCall* _tmp70_;
			ValaMethod* _tmp71_;
			ValaMethod* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			ValaCCodeIdentifier* _tmp75_;
			ValaCCodeIdentifier* _tmp76_;
			ValaCCodeCastExpression* _tmp77_;
			ValaCCodeCastExpression* _tmp78_;
			_tmp70_ = csignew;
			_tmp71_ = vala_signal_get_default_handler (sig);
			_tmp72_ = _tmp71_;
			_tmp73_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_ccode_identifier_new (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp76_, "GCallback");
			_tmp78_ = _tmp77_;
			vala_ccode_function_call_add_argument (_tmp70_, (ValaCCodeExpression*) _tmp78_);
			_vala_ccode_node_unref0 (_tmp78_);
			_vala_ccode_node_unref0 (_tmp76_);
			_g_free0 (_tmp74_);
		}
	}
	_tmp79_ = csignew;
	_tmp80_ = vala_ccode_constant_new ("NULL");
	_tmp81_ = _tmp80_;
	vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
	_vala_ccode_node_unref0 (_tmp81_);
	_tmp82_ = csignew;
	_tmp83_ = vala_ccode_constant_new ("NULL");
	_tmp84_ = _tmp83_;
	vala_ccode_function_call_add_argument (_tmp82_, (ValaCCodeExpression*) _tmp84_);
	_vala_ccode_node_unref0 (_tmp84_);
	_tmp85_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp85_;
	_tmp86_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp87_ = _tmp86_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp87_)) {
		ValaList* _tmp88_;
		ValaVoidType* _tmp89_;
		ValaVoidType* _tmp90_;
		gchar* _tmp91_;
		_tmp88_ = params;
		_tmp89_ = vala_void_type_new (NULL);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp88_, (ValaDataType*) _tmp90_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp91_;
		_vala_code_node_unref0 (_tmp90_);
	} else {
		ValaList* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		gchar* _tmp95_;
		_tmp92_ = params;
		_tmp93_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp92_, _tmp94_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp95_;
	}
	_tmp96_ = marshaller;
	_tmp97_ = vala_ccode_identifier_new (_tmp96_);
	marshal_arg = _tmp97_;
	_tmp98_ = csignew;
	_tmp99_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp98_, (ValaCCodeExpression*) _tmp99_);
	_tmp101_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp102_ = _tmp101_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp102_, VALA_TYPE_POINTER_TYPE)) {
		_tmp100_ = TRUE;
	} else {
		ValaDataType* _tmp103_;
		ValaDataType* _tmp104_;
		_tmp103_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp104_ = _tmp103_;
		_tmp100_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp100_) {
		ValaCCodeFunctionCall* _tmp105_;
		ValaCCodeConstant* _tmp106_;
		ValaCCodeConstant* _tmp107_;
		_tmp105_ = csignew;
		_tmp106_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp107_ = _tmp106_;
		vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
		_vala_ccode_node_unref0 (_tmp107_);
	} else {
		ValaDataType* _tmp108_;
		ValaDataType* _tmp109_;
		_tmp108_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp109_ = _tmp108_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp110_;
			ValaCCodeConstant* _tmp111_;
			ValaCCodeConstant* _tmp112_;
			_tmp110_ = csignew;
			_tmp111_ = vala_ccode_constant_new ("G_TYPE_ERROR");
			_tmp112_ = _tmp111_;
			vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
			_vala_ccode_node_unref0 (_tmp112_);
		} else {
			gboolean _tmp113_ = FALSE;
			ValaDataType* _tmp114_;
			ValaDataType* _tmp115_;
			_tmp114_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp115_ = _tmp114_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp116_;
				ValaDataType* _tmp117_;
				gboolean _tmp118_;
				gboolean _tmp119_;
				_tmp116_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp117_ = _tmp116_;
				_tmp118_ = vala_data_type_get_nullable (_tmp117_);
				_tmp119_ = _tmp118_;
				_tmp113_ = _tmp119_;
			} else {
				_tmp113_ = FALSE;
			}
			if (_tmp113_) {
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeConstant* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				_tmp120_ = csignew;
				_tmp121_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp122_ = _tmp121_;
				vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
				_vala_ccode_node_unref0 (_tmp122_);
			} else {
				ValaDataType* _tmp123_;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				_tmp123_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_data_type_get_type_symbol (_tmp124_);
				_tmp126_ = _tmp125_;
				if (_tmp126_ == NULL) {
					ValaCCodeFunctionCall* _tmp127_;
					ValaCCodeConstant* _tmp128_;
					ValaCCodeConstant* _tmp129_;
					_tmp127_ = csignew;
					_tmp128_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp129_ = _tmp128_;
					vala_ccode_function_call_add_argument (_tmp127_, (ValaCCodeExpression*) _tmp129_);
					_vala_ccode_node_unref0 (_tmp129_);
				} else {
					ValaDataType* _tmp130_;
					ValaDataType* _tmp131_;
					_tmp130_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp131_ = _tmp130_;
					if (vala_data_type_is_real_non_null_struct_type (_tmp131_)) {
						ValaCCodeFunctionCall* _tmp132_;
						ValaCCodeConstant* _tmp133_;
						ValaCCodeConstant* _tmp134_;
						_tmp132_ = csignew;
						_tmp133_ = vala_ccode_constant_new ("G_TYPE_NONE");
						_tmp134_ = _tmp133_;
						vala_ccode_function_call_add_argument (_tmp132_, (ValaCCodeExpression*) _tmp134_);
						_vala_ccode_node_unref0 (_tmp134_);
					} else {
						ValaCCodeFunctionCall* _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						ValaTypeSymbol* _tmp138_;
						ValaTypeSymbol* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						ValaCCodeConstant* _tmp142_;
						ValaCCodeConstant* _tmp143_;
						_tmp135_ = csignew;
						_tmp136_ = vala_callable_get_return_type ((ValaCallable*) sig);
						_tmp137_ = _tmp136_;
						_tmp138_ = vala_data_type_get_type_symbol (_tmp137_);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = vala_ccode_constant_new (_tmp141_);
						_tmp143_ = _tmp142_;
						vala_ccode_function_call_add_argument (_tmp135_, (ValaCCodeExpression*) _tmp143_);
						_vala_ccode_node_unref0 (_tmp143_);
						_g_free0 (_tmp141_);
					}
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp144_;
		gint _param_size = 0;
		ValaList* _tmp145_;
		gint _tmp146_;
		gint _tmp147_;
		gint _param_index = 0;
		_tmp144_ = params;
		_param_list = _tmp144_;
		_tmp145_ = _param_list;
		_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
		_tmp147_ = _tmp146_;
		_param_size = _tmp147_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp148_;
			gint _tmp149_;
			ValaParameter* param = NULL;
			ValaList* _tmp150_;
			gpointer _tmp151_;
			gint _tmp152_;
			ValaParameter* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			_param_index = _param_index + 1;
			_tmp148_ = _param_index;
			_tmp149_ = _param_size;
			if (!(_tmp148_ < _tmp149_)) {
				break;
			}
			_tmp150_ = _param_list;
			_tmp151_ = vala_list_get (_tmp150_, _param_index);
			param = (ValaParameter*) _tmp151_;
			_tmp152_ = params_len;
			params_len = _tmp152_ + 1;
			_tmp153_ = param;
			_tmp154_ = vala_variable_get_variable_type ((ValaVariable*) _tmp153_);
			_tmp155_ = _tmp154_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_ARRAY_TYPE)) {
				ValaParameter* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				gint _tmp159_;
				gint _tmp160_;
				_tmp156_ = param;
				_tmp157_ = vala_variable_get_variable_type ((ValaVariable*) _tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp160_ = _tmp159_;
				params_len += _tmp160_;
			} else {
				ValaParameter* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				_tmp161_ = param;
				_tmp162_ = vala_variable_get_variable_type ((ValaVariable*) _tmp161_);
				_tmp163_ = _tmp162_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp164_;
					ValaDataType* _tmp165_;
					ValaDataType* _tmp166_;
					ValaDelegateType* _tmp167_;
					ValaDelegate* _tmp168_;
					ValaDelegate* _tmp169_;
					gboolean _tmp170_;
					gboolean _tmp171_;
					_tmp164_ = param;
					_tmp165_ = vala_variable_get_variable_type ((ValaVariable*) _tmp164_);
					_tmp166_ = _tmp165_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp167_ = delegate_type;
					_tmp168_ = vala_delegate_type_get_delegate_symbol (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = vala_delegate_get_has_target (_tmp169_);
					_tmp171_ = _tmp170_;
					if (_tmp171_) {
						gint _tmp172_;
						ValaDelegateType* _tmp173_;
						_tmp172_ = params_len;
						params_len = _tmp172_ + 1;
						_tmp173_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp173_)) {
							gint _tmp174_;
							_tmp174_ = params_len;
							params_len = _tmp174_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp175_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp176_ = _tmp175_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp176_)) {
		gint _tmp177_;
		_tmp177_ = params_len;
		params_len = _tmp177_ + 1;
	}
	_tmp178_ = csignew;
	_tmp179_ = g_strdup_printf ("%d", params_len);
	_tmp180_ = _tmp179_;
	_tmp181_ = vala_ccode_constant_new (_tmp180_);
	_tmp182_ = _tmp181_;
	vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp182_);
	_vala_ccode_node_unref0 (_tmp182_);
	_g_free0 (_tmp180_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp183_;
		gint _param_size = 0;
		ValaList* _tmp184_;
		gint _tmp185_;
		gint _tmp186_;
		gint _param_index = 0;
		_tmp183_ = params;
		_param_list = _tmp183_;
		_tmp184_ = _param_list;
		_tmp185_ = vala_collection_get_size ((ValaCollection*) _tmp184_);
		_tmp186_ = _tmp185_;
		_param_size = _tmp186_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp187_;
			gint _tmp188_;
			ValaParameter* param = NULL;
			ValaList* _tmp189_;
			gpointer _tmp190_;
			ValaParameter* _tmp191_;
			ValaDataType* _tmp192_;
			ValaDataType* _tmp193_;
			_param_index = _param_index + 1;
			_tmp187_ = _param_index;
			_tmp188_ = _param_size;
			if (!(_tmp187_ < _tmp188_)) {
				break;
			}
			_tmp189_ = _param_list;
			_tmp190_ = vala_list_get (_tmp189_, _param_index);
			param = (ValaParameter*) _tmp190_;
			_tmp191_ = param;
			_tmp192_ = vala_variable_get_variable_type ((ValaVariable*) _tmp191_);
			_tmp193_ = _tmp192_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp193_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp194_;
				ValaDataType* _tmp195_;
				ValaDataType* _tmp196_;
				ValaArrayType* _tmp197_;
				ValaArrayType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				ValaTypeSymbol* _tmp201_;
				ValaTypeSymbol* _tmp202_;
				ValaDataType* _tmp203_;
				ValaTypeSymbol* _tmp204_;
				ValaTypeSymbol* _tmp205_;
				ValaArrayType* _tmp212_;
				ValaDataType* _tmp213_;
				ValaDataType* _tmp214_;
				ValaTypeSymbol* _tmp215_;
				ValaTypeSymbol* _tmp216_;
				gchar* length_type_id = NULL;
				ValaArrayType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaDataType* _tmp219_;
				ValaTypeSymbol* _tmp220_;
				ValaTypeSymbol* _tmp221_;
				gchar* _tmp222_;
				_tmp194_ = param;
				_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) _tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp196_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp197_;
				_tmp198_ = array_type;
				_tmp199_ = vala_array_type_get_element_type (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_data_type_get_type_symbol (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp204_ = vala_data_type_get_type_symbol (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp202_ == _tmp205_) {
					ValaCCodeFunctionCall* _tmp206_;
					ValaCCodeConstant* _tmp207_;
					ValaCCodeConstant* _tmp208_;
					_tmp206_ = csignew;
					_tmp207_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp208_ = _tmp207_;
					vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp208_);
					_vala_ccode_node_unref0 (_tmp208_);
				} else {
					ValaCCodeFunctionCall* _tmp209_;
					ValaCCodeConstant* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					_tmp209_ = csignew;
					_tmp210_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp211_ = _tmp210_;
					vala_ccode_function_call_add_argument (_tmp209_, (ValaCCodeExpression*) _tmp211_);
					_vala_ccode_node_unref0 (_tmp211_);
				}
				_tmp212_ = array_type;
				_tmp213_ = vala_array_type_get_length_type (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_data_type_get_type_symbol (_tmp214_);
				_tmp216_ = _tmp215_;
				_vala_assert (vala_get_ccode_has_type_id (_tmp216_), "get_ccode_has_type_id (array_type.length_type.type_symbol)");
				_tmp217_ = array_type;
				_tmp218_ = vala_array_type_get_length_type (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_data_type_get_type_symbol (_tmp219_);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp221_);
				length_type_id = _tmp222_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp223_ = FALSE;
						_tmp223_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp225_;
							gint _tmp226_;
							gint _tmp227_;
							ValaCCodeFunctionCall* _tmp228_;
							const gchar* _tmp229_;
							ValaCCodeConstant* _tmp230_;
							ValaCCodeConstant* _tmp231_;
							if (!_tmp223_) {
								gint _tmp224_;
								_tmp224_ = i;
								i = _tmp224_ + 1;
							}
							_tmp223_ = FALSE;
							_tmp225_ = array_type;
							_tmp226_ = vala_array_type_get_rank (_tmp225_);
							_tmp227_ = _tmp226_;
							if (!(i < _tmp227_)) {
								break;
							}
							_tmp228_ = csignew;
							_tmp229_ = length_type_id;
							_tmp230_ = vala_ccode_constant_new (_tmp229_);
							_tmp231_ = _tmp230_;
							vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp231_);
							_vala_ccode_node_unref0 (_tmp231_);
						}
					}
				}
				_g_free0 (length_type_id);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp232_;
				ValaDataType* _tmp233_;
				ValaDataType* _tmp234_;
				_tmp232_ = param;
				_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) _tmp232_);
				_tmp234_ = _tmp233_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaCCodeFunctionCall* _tmp238_;
					ValaCCodeConstant* _tmp239_;
					ValaCCodeConstant* _tmp240_;
					ValaDelegateType* _tmp241_;
					ValaDelegate* _tmp242_;
					ValaDelegate* _tmp243_;
					gboolean _tmp244_;
					gboolean _tmp245_;
					_tmp235_ = param;
					_tmp236_ = vala_variable_get_variable_type ((ValaVariable*) _tmp235_);
					_tmp237_ = _tmp236_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp237_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp238_ = csignew;
					_tmp239_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp240_ = _tmp239_;
					vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
					_vala_ccode_node_unref0 (_tmp240_);
					_tmp241_ = delegate_type;
					_tmp242_ = vala_delegate_type_get_delegate_symbol (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_delegate_get_has_target (_tmp243_);
					_tmp245_ = _tmp244_;
					if (_tmp245_) {
						ValaCCodeFunctionCall* _tmp246_;
						ValaCCodeConstant* _tmp247_;
						ValaCCodeConstant* _tmp248_;
						ValaDelegateType* _tmp249_;
						_tmp246_ = csignew;
						_tmp247_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp248_ = _tmp247_;
						vala_ccode_function_call_add_argument (_tmp246_, (ValaCCodeExpression*) _tmp248_);
						_vala_ccode_node_unref0 (_tmp248_);
						_tmp249_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp249_)) {
							ValaCCodeFunctionCall* _tmp250_;
							ValaCCodeConstant* _tmp251_;
							ValaCCodeConstant* _tmp252_;
							_tmp250_ = csignew;
							_tmp251_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp252_ = _tmp251_;
							vala_ccode_function_call_add_argument (_tmp250_, (ValaCCodeExpression*) _tmp252_);
							_vala_ccode_node_unref0 (_tmp252_);
						}
					}
				} else {
					gboolean _tmp253_ = FALSE;
					gboolean _tmp254_ = FALSE;
					ValaParameter* _tmp255_;
					ValaDataType* _tmp256_;
					ValaDataType* _tmp257_;
					_tmp255_ = param;
					_tmp256_ = vala_variable_get_variable_type ((ValaVariable*) _tmp255_);
					_tmp257_ = _tmp256_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_POINTER_TYPE)) {
						_tmp254_ = TRUE;
					} else {
						ValaParameter* _tmp258_;
						ValaDataType* _tmp259_;
						ValaDataType* _tmp260_;
						_tmp258_ = param;
						_tmp259_ = vala_variable_get_variable_type ((ValaVariable*) _tmp258_);
						_tmp260_ = _tmp259_;
						_tmp254_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp254_) {
						_tmp253_ = TRUE;
					} else {
						ValaParameter* _tmp261_;
						ValaParameterDirection _tmp262_;
						ValaParameterDirection _tmp263_;
						_tmp261_ = param;
						_tmp262_ = vala_parameter_get_direction (_tmp261_);
						_tmp263_ = _tmp262_;
						_tmp253_ = _tmp263_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp253_) {
						ValaCCodeFunctionCall* _tmp264_;
						ValaCCodeConstant* _tmp265_;
						ValaCCodeConstant* _tmp266_;
						_tmp264_ = csignew;
						_tmp265_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp266_ = _tmp265_;
						vala_ccode_function_call_add_argument (_tmp264_, (ValaCCodeExpression*) _tmp266_);
						_vala_ccode_node_unref0 (_tmp266_);
					} else {
						ValaParameter* _tmp267_;
						ValaDataType* _tmp268_;
						ValaDataType* _tmp269_;
						_tmp267_ = param;
						_tmp268_ = vala_variable_get_variable_type ((ValaVariable*) _tmp267_);
						_tmp269_ = _tmp268_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp269_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp270_;
							ValaCCodeConstant* _tmp271_;
							ValaCCodeConstant* _tmp272_;
							_tmp270_ = csignew;
							_tmp271_ = vala_ccode_constant_new ("G_TYPE_ERROR");
							_tmp272_ = _tmp271_;
							vala_ccode_function_call_add_argument (_tmp270_, (ValaCCodeExpression*) _tmp272_);
							_vala_ccode_node_unref0 (_tmp272_);
						} else {
							gboolean _tmp273_ = FALSE;
							ValaParameter* _tmp274_;
							ValaDataType* _tmp275_;
							ValaDataType* _tmp276_;
							_tmp274_ = param;
							_tmp275_ = vala_variable_get_variable_type ((ValaVariable*) _tmp274_);
							_tmp276_ = _tmp275_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp276_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp277_;
								ValaDataType* _tmp278_;
								ValaDataType* _tmp279_;
								gboolean _tmp280_;
								gboolean _tmp281_;
								_tmp277_ = param;
								_tmp278_ = vala_variable_get_variable_type ((ValaVariable*) _tmp277_);
								_tmp279_ = _tmp278_;
								_tmp280_ = vala_data_type_get_nullable (_tmp279_);
								_tmp281_ = _tmp280_;
								_tmp273_ = _tmp281_;
							} else {
								_tmp273_ = FALSE;
							}
							if (_tmp273_) {
								ValaCCodeFunctionCall* _tmp282_;
								ValaCCodeConstant* _tmp283_;
								ValaCCodeConstant* _tmp284_;
								_tmp282_ = csignew;
								_tmp283_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp284_ = _tmp283_;
								vala_ccode_function_call_add_argument (_tmp282_, (ValaCCodeExpression*) _tmp284_);
								_vala_ccode_node_unref0 (_tmp284_);
							} else {
								ValaCCodeFunctionCall* _tmp285_;
								ValaParameter* _tmp286_;
								ValaDataType* _tmp287_;
								ValaDataType* _tmp288_;
								ValaTypeSymbol* _tmp289_;
								ValaTypeSymbol* _tmp290_;
								gchar* _tmp291_;
								gchar* _tmp292_;
								ValaCCodeConstant* _tmp293_;
								ValaCCodeConstant* _tmp294_;
								_tmp285_ = csignew;
								_tmp286_ = param;
								_tmp287_ = vala_variable_get_variable_type ((ValaVariable*) _tmp286_);
								_tmp288_ = _tmp287_;
								_tmp289_ = vala_data_type_get_type_symbol (_tmp288_);
								_tmp290_ = _tmp289_;
								_tmp291_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp290_);
								_tmp292_ = _tmp291_;
								_tmp293_ = vala_ccode_constant_new (_tmp292_);
								_tmp294_ = _tmp293_;
								vala_ccode_function_call_add_argument (_tmp285_, (ValaCCodeExpression*) _tmp294_);
								_vala_ccode_node_unref0 (_tmp294_);
								_g_free0 (_tmp292_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp295_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp296_ = _tmp295_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp296_)) {
		ValaCCodeFunctionCall* _tmp297_;
		ValaCCodeConstant* _tmp298_;
		ValaCCodeConstant* _tmp299_;
		_tmp297_ = csignew;
		_tmp298_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp299_ = _tmp298_;
		vala_ccode_function_call_add_argument (_tmp297_, (ValaCCodeExpression*) _tmp299_);
		_vala_ccode_node_unref0 (_tmp299_);
	}
	_tmp300_ = marshal_arg;
	_tmp301_ = marshaller;
	vala_ccode_identifier_set_name (_tmp300_, _tmp301_);
	_tmp302_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp303_ = _tmp302_;
	_tmp304_ = csignew;
	_tmp305_ = vala_ccode_assignment_new (_tmp303_, (ValaCCodeExpression*) _tmp304_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp306_ = (ValaCCodeExpression*) _tmp305_;
	_vala_ccode_node_unref0 (_tmp303_);
	result = _tmp306_;
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}

static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaCodeNode* _tmp7_;
	ValaCodeNode* _tmp8_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		return;
	}
	_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* detail_expr = NULL;
		ValaList* _tmp13_;
		gpointer _tmp14_;
		ValaSignal* _tmp15_;
		ValaMemberAccess* _tmp16_;
		ValaExpression* _tmp17_;
		ValaCCodeExpression* _tmp18_;
		ValaCCodeExpression* _tmp19_;
		_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp10_ = _tmp9_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp11_ = vala_element_access_get_container (expr);
		_tmp12_ = _tmp11_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp13_ = vala_element_access_get_indices (expr);
		_tmp14_ = vala_list_get (_tmp13_, 0);
		detail_expr = (ValaExpression*) _tmp14_;
		_tmp15_ = sig;
		_tmp16_ = ma;
		_tmp17_ = detail_expr;
		_tmp18_ = vala_gsignal_module_emit_signal (self, _tmp15_, _tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		vala_set_cvalue ((ValaExpression*) expr, _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		_vala_code_node_unref0 (detail_expr);
	} else {
	}
}

static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_type_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}

static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSignal* sig = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSignal* _tmp4_;
	ValaCCodeExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		return;
	}
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp3_ = _tmp2_;
	sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SIGNAL, ValaSignal);
	_tmp4_ = sig;
	_tmp5_ = vala_gsignal_module_emit_signal (self, _tmp4_, expr, NULL);
	_tmp6_ = _tmp5_;
	vala_set_cvalue ((ValaExpression*) expr, _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
}

static ValaCCodeExpression*
vala_gsignal_module_emit_signal (ValaGSignalModule* self,
                                 ValaSignal* sig,
                                 ValaMemberAccess* expr,
                                 ValaExpression* detail_expr)
{
	ValaCCodeExpression* pub_inst = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp6_ = FALSE;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_;
	gboolean _tmp42_;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	pub_inst = NULL;
	_tmp0_ = vala_member_access_get_inner (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		ValaCCodeExpression* _tmp5_;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_get_cvalue (_tmp3_);
		_tmp5_ = _vala_ccode_node_ref0 (_tmp4_);
		_vala_ccode_node_unref0 (pub_inst);
		pub_inst = _tmp5_;
	}
	_tmp7_ = vala_member_access_get_inner (expr);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_BASE_ACCESS)) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = vala_signal_get_is_virtual (sig);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMethod* m = NULL;
		ValaMethod* _tmp11_;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		ValaClass* base_class = NULL;
		ValaMethod* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaClass* _tmp17_;
		ValaCCodeFunctionCall* vcast = NULL;
		ValaClass* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaClass* _tmp26_;
		ValaClass* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeIdentifier* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaMethod* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		ValaCCodeMemberAccess* _tmp38_;
		_tmp11_ = vala_signal_get_default_handler (sig);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (_tmp12_);
		m = _tmp13_;
		_tmp14_ = m;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass));
		base_class = _tmp17_;
		_tmp18_ = base_class;
		_tmp19_ = vala_get_ccode_class_type_function (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_ccode_identifier_new (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_vala_ccode_node_unref0 (_tmp22_);
		_g_free0 (_tmp20_);
		vcast = _tmp24_;
		_tmp25_ = vcast;
		_tmp26_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup_printf ("%s_parent_class", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_ccode_identifier_new (_tmp31_);
		_tmp33_ = _tmp32_;
		vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp33_);
		_vala_ccode_node_unref0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_tmp34_ = vcast;
		_tmp35_ = m;
		_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp34_, _tmp37_);
		result = (ValaCCodeExpression*) _tmp38_;
		_vala_ccode_node_unref0 (vcast);
		_vala_code_node_unref0 (base_class);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (pub_inst);
		return result;
	}
	_tmp41_ = vala_symbol_get_external_package ((ValaSymbol*) sig);
	_tmp42_ = _tmp41_;
	if (!_tmp42_) {
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceFile* _tmp45_;
		ValaSourceFile* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaSourceReference* _tmp48_;
		ValaSourceFile* _tmp49_;
		ValaSourceFile* _tmp50_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_source_reference_get_file (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_source_reference_get_file (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp40_ = _tmp46_ == _tmp50_;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		_tmp39_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		ValaCCodeFunctionCall* _tmp55_;
		ValaCCodeExpression* _tmp56_;
		ValaCCodeFunctionCall* _tmp57_;
		ValaCCodeExpression* _tmp58_;
		ValaCCodeExpression* _tmp59_;
		_tmp51_ = vala_ccode_identifier_new ("g_signal_emit");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp52_);
		_tmp54_ = _tmp53_;
		_vala_ccode_node_unref0 (_tmp52_);
		ccall = _tmp54_;
		_tmp55_ = ccall;
		_tmp56_ = pub_inst;
		vala_ccode_function_call_add_argument (_tmp55_, _tmp56_);
		_tmp57_ = ccall;
		_tmp58_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
		_tmp59_ = _tmp58_;
		vala_ccode_function_call_add_argument (_tmp57_, _tmp59_);
		_vala_ccode_node_unref0 (_tmp59_);
		if (detail_expr == NULL) {
			ValaCCodeFunctionCall* _tmp60_;
			ValaCCodeConstant* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			_tmp60_ = ccall;
			_tmp61_ = vala_ccode_constant_new ("0");
			_tmp62_ = _tmp61_;
			vala_ccode_function_call_add_argument (_tmp60_, (ValaCCodeExpression*) _tmp62_);
			_vala_ccode_node_unref0 (_tmp62_);
		} else {
			ValaCCodeFunctionCall* _tmp63_;
			ValaCCodeExpression* _tmp64_;
			ValaCCodeExpression* _tmp65_;
			_tmp63_ = ccall;
			_tmp64_ = vala_gsignal_module_get_detail_cexpression (self, detail_expr, (ValaCodeNode*) expr);
			_tmp65_ = _tmp64_;
			vala_ccode_function_call_add_argument (_tmp63_, _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
		}
		result = (ValaCCodeExpression*) ccall;
		_vala_ccode_node_unref0 (pub_inst);
		return result;
	} else {
		if (vala_get_ccode_has_emitter (sig)) {
			gchar* emitter_func = NULL;
			ValaMethod* _tmp66_;
			ValaMethod* _tmp67_;
			ValaCCodeFunctionCall* ccall = NULL;
			const gchar* _tmp93_;
			ValaCCodeIdentifier* _tmp94_;
			ValaCCodeIdentifier* _tmp95_;
			ValaCCodeFunctionCall* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* _tmp98_;
			ValaCCodeExpression* _tmp99_;
			_tmp66_ = vala_signal_get_emitter (sig);
			_tmp67_ = _tmp66_;
			if (_tmp67_ != NULL) {
				gboolean _tmp68_ = FALSE;
				gboolean _tmp69_;
				gboolean _tmp70_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				gchar* _tmp84_;
				_tmp69_ = vala_symbol_get_external_package ((ValaSymbol*) sig);
				_tmp70_ = _tmp69_;
				if (!_tmp70_) {
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					ValaSourceFile* _tmp73_;
					ValaSourceFile* _tmp74_;
					ValaSourceReference* _tmp75_;
					ValaSourceReference* _tmp76_;
					ValaSourceFile* _tmp77_;
					ValaSourceFile* _tmp78_;
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_source_reference_get_file (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
					_tmp76_ = _tmp75_;
					_tmp77_ = vala_source_reference_get_file (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp68_ = _tmp74_ != _tmp78_;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					ValaMethod* _tmp79_;
					ValaMethod* _tmp80_;
					ValaCCodeFile* _tmp81_;
					_tmp79_ = vala_signal_get_emitter (sig);
					_tmp80_ = _tmp79_;
					_tmp81_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp80_, _tmp81_);
				}
				_tmp82_ = vala_signal_get_emitter (sig);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp83_, NULL);
				_g_free0 (emitter_func);
				emitter_func = _tmp84_;
			} else {
				ValaTypeSymbol* sym = NULL;
				ValaSymbol* _tmp85_;
				ValaSymbol* _tmp86_;
				ValaTypeSymbol* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				_tmp85_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
				_tmp86_ = _tmp85_;
				sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
				_tmp87_ = sym;
				_tmp88_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp87_, NULL);
				_tmp89_ = _tmp88_;
				_tmp90_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) sig, NULL);
				_tmp91_ = _tmp90_;
				_tmp92_ = g_strdup_printf ("%s_%s", _tmp89_, _tmp91_);
				_g_free0 (emitter_func);
				emitter_func = _tmp92_;
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
			}
			_tmp93_ = emitter_func;
			_tmp94_ = vala_ccode_identifier_new (_tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp95_);
			_tmp97_ = _tmp96_;
			_vala_ccode_node_unref0 (_tmp95_);
			ccall = _tmp97_;
			_tmp98_ = ccall;
			_tmp99_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp98_, _tmp99_);
			result = (ValaCCodeExpression*) ccall;
			_g_free0 (emitter_func);
			_vala_ccode_node_unref0 (pub_inst);
			return result;
		} else {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp100_;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeFunctionCall* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeExpression* _tmp105_;
			_tmp100_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp101_);
			_tmp103_ = _tmp102_;
			_vala_ccode_node_unref0 (_tmp101_);
			ccall = _tmp103_;
			_tmp104_ = ccall;
			_tmp105_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp104_, _tmp105_);
			if (detail_expr == NULL) {
				ValaCCodeFunctionCall* _tmp106_;
				ValaCCodeConstant* _tmp107_;
				ValaCCodeConstant* _tmp108_;
				_tmp106_ = ccall;
				_tmp107_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
				_tmp108_ = _tmp107_;
				vala_ccode_function_call_add_argument (_tmp106_, (ValaCCodeExpression*) _tmp108_);
				_vala_ccode_node_unref0 (_tmp108_);
			} else {
				ValaCCodeFunctionCall* _tmp109_;
				ValaCCodeExpression* _tmp110_;
				ValaCCodeExpression* _tmp111_;
				_tmp109_ = ccall;
				_tmp110_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, detail_expr, (ValaCodeNode*) expr);
				_tmp111_ = _tmp110_;
				vala_ccode_function_call_add_argument (_tmp109_, _tmp111_);
				_vala_ccode_node_unref0 (_tmp111_);
			}
			result = (ValaCCodeExpression*) ccall;
			_vala_ccode_node_unref0 (pub_inst);
			return result;
		}
	}
}

static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	gpointer _tmp24_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp25_;
	ValaMethod* _tmp26_;
	ValaMethod* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gboolean after = FALSE;
	ValaMethodType* _tmp30_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp35_;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaCCodeExpression* _tmp38_;
	ValaCCodeExpression* _tmp39_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_callable_expression_get_call ((ValaCallableExpression*) expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
	_tmp24_ = vala_list_get (_tmp23_, 0);
	handler = (ValaExpression*) _tmp24_;
	_tmp25_ = method_type;
	_tmp26_ = vala_method_type_get_method_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
	_tmp29_ = _tmp28_;
	disconnect = g_strcmp0 (_tmp29_, "disconnect") == 0;
	_tmp30_ = method_type;
	_tmp31_ = vala_method_type_get_method_symbol (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
	_tmp34_ = _tmp33_;
	after = g_strcmp0 (_tmp34_, "connect_after") == 0;
	_tmp35_ = sig;
	_tmp36_ = signal_access;
	_tmp37_ = handler;
	_tmp38_ = vala_gsignal_module_connect_signal (self, _tmp35_, _tmp36_, _tmp37_, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp38_;
	_tmp39_ = cexpr;
	vala_set_cvalue ((ValaExpression*) expr, _tmp39_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}

static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp64_;
	ValaExpression* _tmp65_;
	ValaExpression* _tmp66_;
	ValaCCodeFunctionCall* _tmp159_;
	ValaCCodeExpression* _tmp160_;
	ValaCCodeCastExpression* _tmp161_;
	ValaCCodeCastExpression* _tmp162_;
	gboolean _tmp163_ = FALSE;
	ValaMethod* _tmp164_;
	gboolean _tmp238_ = FALSE;
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
			_vala_code_node_unref0 (dt);
			dt = NULL;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		gboolean _tmp26_ = FALSE;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			ValaMethod* _tmp29_;
			_tmp29_ = m;
			if (_tmp29_ != NULL) {
				ValaMethod* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp30_ = m;
				_tmp31_ = vala_method_get_closure (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp28_ = _tmp32_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				_tmp27_ = TRUE;
			} else {
				gboolean _tmp33_ = FALSE;
				ValaDelegateType* _tmp34_;
				_tmp34_ = dt;
				if (_tmp34_ != NULL) {
					ValaDelegateType* _tmp35_;
					gboolean _tmp36_;
					gboolean _tmp37_;
					_tmp35_ = dt;
					_tmp36_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp35_);
					_tmp37_ = _tmp36_;
					_tmp33_ = _tmp37_;
				} else {
					_tmp33_ = FALSE;
				}
				_tmp27_ = _tmp33_;
			}
			_tmp26_ = _tmp27_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("g_signal_connect_data");
			_g_free0 (connect_func);
			connect_func = _tmp38_;
		} else {
			gboolean _tmp39_ = FALSE;
			ValaMethod* _tmp40_;
			_tmp40_ = m;
			if (_tmp40_ != NULL) {
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				_tmp39_ = vala_gsignal_module_in_gobject_instance (self, _tmp41_);
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				gchar* _tmp42_;
				_tmp42_ = g_strdup ("g_signal_connect_object");
				_g_free0 (connect_func);
				connect_func = _tmp42_;
			} else {
				if (!after) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					gchar* _tmp44_;
					_tmp44_ = g_strdup ("g_signal_connect_after");
					_g_free0 (connect_func);
					connect_func = _tmp44_;
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("VALA_UNSUPPORTED");
			_g_free0 (connect_func);
			connect_func = _tmp45_;
		} else {
			gchar* _tmp46_;
			_tmp46_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		}
	}
	_tmp47_ = connect_func;
	_tmp48_ = vala_ccode_identifier_new (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp49_);
	_tmp51_ = _tmp50_;
	_vala_ccode_node_unref0 (_tmp49_);
	ccall = _tmp51_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp52_;
		ValaElementAccess* _tmp53_;
		ValaExpression* _tmp54_;
		ValaExpression* _tmp55_;
		ValaMemberAccess* _tmp56_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp57_;
		ValaList* _tmp58_;
		gpointer _tmp59_;
		ValaExpression* _tmp60_;
		ValaCCodeExpression* _tmp61_;
		_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp52_;
		_tmp53_ = ea;
		_tmp54_ = vala_element_access_get_container (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp56_;
		_tmp57_ = ea;
		_tmp58_ = vala_element_access_get_indices (_tmp57_);
		_tmp59_ = vala_list_get (_tmp58_, 0);
		detail_expr = (ValaExpression*) _tmp59_;
		_tmp60_ = detail_expr;
		_tmp61_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp60_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp61_;
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp62_;
		ValaCCodeExpression* _tmp63_;
		_tmp62_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp62_;
		_tmp63_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp63_;
	}
	_tmp64_ = ma;
	_tmp65_ = vala_member_access_get_inner (_tmp64_);
	_tmp66_ = _tmp65_;
	if (_tmp66_ != NULL) {
		ValaCCodeFunctionCall* _tmp67_;
		ValaMemberAccess* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaCCodeExpression* _tmp71_;
		ValaCCodeExpression* _tmp72_;
		_tmp67_ = ccall;
		_tmp68_ = ma;
		_tmp69_ = vala_member_access_get_inner (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp70_);
		_tmp72_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp67_, _tmp72_);
		_vala_ccode_node_unref0 (_tmp72_);
	} else {
		ValaCCodeFunctionCall* _tmp73_;
		ValaCCodeExpression* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		_tmp73_ = ccall;
		_tmp74_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp75_ = _tmp74_;
		vala_ccode_function_call_add_argument (_tmp73_, _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		ValaCCodeConstant* _tmp81_;
		ValaCCodeConstant* _tmp82_;
		_tmp76_ = ccall;
		_tmp77_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strdup_printf ("\"%s\"", _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_ccode_constant_new (_tmp80_);
		_tmp82_ = _tmp81_;
		vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp82_);
		_vala_ccode_node_unref0 (_tmp82_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp83_;
			ValaCCodeExpression* _tmp84_;
			_tmp83_ = ccall;
			_tmp84_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp83_, _tmp84_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp91_;
			ValaLocalVariable* _tmp92_;
			ValaLocalVariable* _tmp93_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp94_;
			ValaCCodeIdentifier* _tmp95_;
			ValaCCodeFunctionCall* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* _tmp98_;
			ValaCCodeExpression* _tmp99_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp100_;
			ValaSymbol* _tmp101_;
			ValaTypeSymbol* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaTypeSymbol* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeFunctionCall* _tmp109_;
			ValaLocalVariable* _tmp110_;
			const gchar* _tmp111_;
			const gchar* _tmp112_;
			ValaCCodeExpression* _tmp113_;
			ValaCCodeExpression* _tmp114_;
			ValaCCodeUnaryExpression* _tmp115_;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunctionCall* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaLocalVariable* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeExpression* _tmp144_;
			ValaCCodeExpression* _tmp145_;
			ValaLocalVariable* _tmp146_;
			ValaCCodeFunctionCall* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp85_;
				ValaCCodeConstant* _tmp86_;
				ValaCCodeConstant* _tmp87_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp87_ = _tmp86_;
				vala_ccode_function_call_add_argument (_tmp85_, (ValaCCodeExpression*) _tmp87_);
				_vala_ccode_node_unref0 (_tmp87_);
			} else {
				ValaCCodeFunctionCall* _tmp88_;
				ValaCCodeConstant* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				_tmp88_ = ccall;
				_tmp89_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_add_argument (_tmp88_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
			}
			_tmp91_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp92_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp91_, TRUE, NULL, FALSE);
			temp_decl = _tmp92_;
			_tmp93_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp93_, FALSE);
			_tmp94_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp95_);
			_tmp97_ = _tmp96_;
			_vala_ccode_node_unref0 (_tmp95_);
			parse_call = _tmp97_;
			_tmp98_ = parse_call;
			_tmp99_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp98_, _tmp99_);
			_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp101_ = _tmp100_;
			_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp102_;
			_tmp103_ = parse_call;
			_tmp104_ = decl_type;
			_tmp105_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			vala_ccode_function_call_add_argument (_tmp103_, (ValaCCodeExpression*) _tmp108_);
			_vala_ccode_node_unref0 (_tmp108_);
			_g_free0 (_tmp106_);
			_tmp109_ = parse_call;
			_tmp110_ = temp_decl;
			_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp114_);
			_tmp116_ = _tmp115_;
			vala_ccode_function_call_add_argument (_tmp109_, (ValaCCodeExpression*) _tmp116_);
			_vala_ccode_node_unref0 (_tmp116_);
			_vala_ccode_node_unref0 (_tmp114_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp117_;
				ValaCCodeConstant* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeConstant* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				_tmp117_ = parse_call;
				_tmp118_ = vala_ccode_constant_new ("NULL");
				_tmp119_ = _tmp118_;
				vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
				_vala_ccode_node_unref0 (_tmp119_);
				_tmp120_ = parse_call;
				_tmp121_ = vala_ccode_constant_new ("FALSE");
				_tmp122_ = _tmp121_;
				vala_ccode_function_call_add_argument (_tmp120_, (ValaCCodeExpression*) _tmp122_);
				_vala_ccode_node_unref0 (_tmp122_);
			} else {
				ValaDataType* _tmp123_;
				ValaLocalVariable* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaCCodeFunctionCall* _tmp126_;
				ValaLocalVariable* _tmp127_;
				const gchar* _tmp128_;
				const gchar* _tmp129_;
				ValaCCodeExpression* _tmp130_;
				ValaCCodeExpression* _tmp131_;
				ValaCCodeUnaryExpression* _tmp132_;
				ValaCCodeUnaryExpression* _tmp133_;
				ValaCCodeFunctionCall* _tmp134_;
				ValaCCodeConstant* _tmp135_;
				ValaCCodeConstant* _tmp136_;
				_tmp123_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp124_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp123_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp124_;
				_tmp125_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp125_, FALSE);
				_tmp126_ = parse_call;
				_tmp127_ = detail_temp_decl;
				_tmp128_ = vala_symbol_get_name ((ValaSymbol*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp131_);
				_tmp133_ = _tmp132_;
				vala_ccode_function_call_add_argument (_tmp126_, (ValaCCodeExpression*) _tmp133_);
				_vala_ccode_node_unref0 (_tmp133_);
				_vala_ccode_node_unref0 (_tmp131_);
				_tmp134_ = parse_call;
				_tmp135_ = vala_ccode_constant_new ("TRUE");
				_tmp136_ = _tmp135_;
				vala_ccode_function_call_add_argument (_tmp134_, (ValaCCodeExpression*) _tmp136_);
				_vala_ccode_node_unref0 (_tmp136_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = parse_call;
			vala_ccode_function_add_expression (_tmp138_, (ValaCCodeExpression*) _tmp139_);
			_tmp140_ = ccall;
			_tmp141_ = temp_decl;
			_tmp142_ = vala_symbol_get_name ((ValaSymbol*) _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_call_add_argument (_tmp140_, _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp146_ = detail_temp_decl;
			if (_tmp146_ == NULL) {
				ValaCCodeFunctionCall* _tmp147_;
				ValaCCodeConstant* _tmp148_;
				ValaCCodeConstant* _tmp149_;
				_tmp147_ = ccall;
				_tmp148_ = vala_ccode_constant_new ("0");
				_tmp149_ = _tmp148_;
				vala_ccode_function_call_add_argument (_tmp147_, (ValaCCodeExpression*) _tmp149_);
				_vala_ccode_node_unref0 (_tmp149_);
			} else {
				ValaCCodeFunctionCall* _tmp150_;
				ValaLocalVariable* _tmp151_;
				const gchar* _tmp152_;
				const gchar* _tmp153_;
				ValaCCodeExpression* _tmp154_;
				ValaCCodeExpression* _tmp155_;
				_tmp150_ = ccall;
				_tmp151_ = detail_temp_decl;
				_tmp152_ = vala_symbol_get_name ((ValaSymbol*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp153_);
				_tmp155_ = _tmp154_;
				vala_ccode_function_call_add_argument (_tmp150_, _tmp155_);
				_vala_ccode_node_unref0 (_tmp155_);
			}
			_tmp156_ = ccall;
			_tmp157_ = vala_ccode_constant_new ("NULL");
			_tmp158_ = _tmp157_;
			vala_ccode_function_call_add_argument (_tmp156_, (ValaCCodeExpression*) _tmp158_);
			_vala_ccode_node_unref0 (_tmp158_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp159_ = ccall;
	_tmp160_ = vala_get_cvalue (handler);
	_tmp161_ = vala_ccode_cast_expression_new (_tmp160_, "GCallback");
	_tmp162_ = _tmp161_;
	vala_ccode_function_call_add_argument (_tmp159_, (ValaCCodeExpression*) _tmp162_);
	_vala_ccode_node_unref0 (_tmp162_);
	_tmp164_ = m;
	if (_tmp164_ != NULL) {
		ValaMethod* _tmp165_;
		gboolean _tmp166_;
		gboolean _tmp167_;
		_tmp165_ = m;
		_tmp166_ = vala_method_get_closure (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp163_ = _tmp167_;
	} else {
		_tmp163_ = FALSE;
	}
	if (_tmp163_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp168_;
		ValaCCodeExpression* _tmp169_ = NULL;
		ValaCCodeExpression* _tmp170_;
		ValaCCodeExpression* _tmp171_;
		ValaCCodeFunctionCall* _tmp172_;
		ValaCCodeExpression* _tmp173_;
		ValaCCodeCastExpression* _tmp174_;
		ValaCCodeCastExpression* _tmp175_;
		_tmp168_ = ccall;
		_tmp170_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp169_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp169_;
		_tmp171_ = _tmp170_;
		vala_ccode_function_call_add_argument (_tmp168_, _tmp171_);
		_vala_ccode_node_unref0 (_tmp171_);
		_tmp172_ = ccall;
		_tmp173_ = handler_destroy_notify;
		_tmp174_ = vala_ccode_cast_expression_new (_tmp173_, "GClosureNotify");
		_tmp175_ = _tmp174_;
		vala_ccode_function_call_add_argument (_tmp172_, (ValaCCodeExpression*) _tmp175_);
		_vala_ccode_node_unref0 (_tmp175_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeConstant* _tmp177_;
			ValaCCodeConstant* _tmp178_;
			_tmp176_ = ccall;
			_tmp177_ = vala_ccode_constant_new ("0");
			_tmp178_ = _tmp177_;
			vala_ccode_function_call_add_argument (_tmp176_, (ValaCCodeExpression*) _tmp178_);
			_vala_ccode_node_unref0 (_tmp178_);
		} else {
			ValaCCodeFunctionCall* _tmp179_;
			ValaCCodeConstant* _tmp180_;
			ValaCCodeConstant* _tmp181_;
			_tmp179_ = ccall;
			_tmp180_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp181_ = _tmp180_;
			vala_ccode_function_call_add_argument (_tmp179_, (ValaCCodeExpression*) _tmp181_);
			_vala_ccode_node_unref0 (_tmp181_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp182_ = FALSE;
		ValaMethod* _tmp183_;
		_tmp183_ = m;
		if (_tmp183_ != NULL) {
			ValaMethod* _tmp184_;
			ValaMemberBinding _tmp185_;
			ValaMemberBinding _tmp186_;
			_tmp184_ = m;
			_tmp185_ = vala_method_get_binding (_tmp184_);
			_tmp186_ = _tmp185_;
			_tmp182_ = _tmp186_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp182_ = FALSE;
		}
		if (_tmp182_) {
			gboolean _tmp202_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp187_;
				ValaMemberAccess* _tmp188_;
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				_tmp187_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp187_;
				_tmp188_ = right_ma;
				_tmp189_ = vala_member_access_get_inner (_tmp188_);
				_tmp190_ = _tmp189_;
				if (_tmp190_ != NULL) {
					ValaCCodeFunctionCall* _tmp191_;
					ValaMemberAccess* _tmp192_;
					ValaExpression* _tmp193_;
					ValaExpression* _tmp194_;
					ValaCCodeExpression* _tmp195_;
					_tmp191_ = ccall;
					_tmp192_ = right_ma;
					_tmp193_ = vala_member_access_get_inner (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_get_cvalue (_tmp194_);
					vala_ccode_function_call_add_argument (_tmp191_, _tmp195_);
				} else {
					ValaCCodeFunctionCall* _tmp196_;
					ValaCCodeExpression* _tmp197_;
					ValaCCodeExpression* _tmp198_;
					_tmp196_ = ccall;
					_tmp197_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp198_ = _tmp197_;
					vala_ccode_function_call_add_argument (_tmp196_, _tmp198_);
					_vala_ccode_node_unref0 (_tmp198_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					ValaCCodeExpression* _tmp201_;
					_tmp199_ = ccall;
					_tmp200_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp201_ = _tmp200_;
					vala_ccode_function_call_add_argument (_tmp199_, _tmp201_);
					_vala_ccode_node_unref0 (_tmp201_);
				}
			}
			if (!disconnect) {
				ValaMethod* _tmp203_;
				_tmp203_ = m;
				_tmp202_ = vala_gsignal_module_in_gobject_instance (self, _tmp203_);
			} else {
				_tmp202_ = FALSE;
			}
			if (_tmp202_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp204_;
					ValaCCodeConstant* _tmp205_;
					ValaCCodeConstant* _tmp206_;
					_tmp204_ = ccall;
					_tmp205_ = vala_ccode_constant_new ("0");
					_tmp206_ = _tmp205_;
					vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp206_);
					_vala_ccode_node_unref0 (_tmp206_);
				} else {
					ValaCCodeFunctionCall* _tmp207_;
					ValaCCodeConstant* _tmp208_;
					ValaCCodeConstant* _tmp209_;
					_tmp207_ = ccall;
					_tmp208_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp209_ = _tmp208_;
					vala_ccode_function_call_add_argument (_tmp207_, (ValaCCodeExpression*) _tmp209_);
					_vala_ccode_node_unref0 (_tmp209_);
				}
			}
		} else {
			gboolean _tmp210_ = FALSE;
			ValaDelegateType* _tmp211_;
			_tmp211_ = dt;
			if (_tmp211_ != NULL) {
				ValaDelegateType* _tmp212_;
				ValaDelegate* _tmp213_;
				ValaDelegate* _tmp214_;
				gboolean _tmp215_;
				gboolean _tmp216_;
				_tmp212_ = dt;
				_tmp213_ = vala_delegate_type_get_delegate_symbol (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp215_ = vala_delegate_get_has_target (_tmp214_);
				_tmp216_ = _tmp215_;
				_tmp210_ = _tmp216_;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp217_;
				ValaCCodeExpression* _tmp218_ = NULL;
				ValaCCodeExpression* _tmp219_;
				ValaCCodeExpression* _tmp220_;
				gboolean _tmp221_ = FALSE;
				_tmp217_ = ccall;
				_tmp219_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp218_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp218_;
				_tmp220_ = _tmp219_;
				vala_ccode_function_call_add_argument (_tmp217_, _tmp220_);
				_vala_ccode_node_unref0 (_tmp220_);
				if (!disconnect) {
					ValaDelegateType* _tmp222_;
					gboolean _tmp223_;
					gboolean _tmp224_;
					_tmp222_ = dt;
					_tmp223_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp222_);
					_tmp224_ = _tmp223_;
					_tmp221_ = _tmp224_;
				} else {
					_tmp221_ = FALSE;
				}
				if (_tmp221_) {
					ValaCCodeFunctionCall* _tmp225_;
					ValaCCodeExpression* _tmp226_;
					ValaCCodeCastExpression* _tmp227_;
					ValaCCodeCastExpression* _tmp228_;
					_tmp225_ = ccall;
					_tmp226_ = handler_destroy_notify;
					_tmp227_ = vala_ccode_cast_expression_new (_tmp226_, "GClosureNotify");
					_tmp228_ = _tmp227_;
					vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp228_);
					_vala_ccode_node_unref0 (_tmp228_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp229_;
						ValaCCodeConstant* _tmp230_;
						ValaCCodeConstant* _tmp231_;
						_tmp229_ = ccall;
						_tmp230_ = vala_ccode_constant_new ("0");
						_tmp231_ = _tmp230_;
						vala_ccode_function_call_add_argument (_tmp229_, (ValaCCodeExpression*) _tmp231_);
						_vala_ccode_node_unref0 (_tmp231_);
					} else {
						ValaCCodeFunctionCall* _tmp232_;
						ValaCCodeConstant* _tmp233_;
						ValaCCodeConstant* _tmp234_;
						_tmp232_ = ccall;
						_tmp233_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp234_ = _tmp233_;
						vala_ccode_function_call_add_argument (_tmp232_, (ValaCCodeExpression*) _tmp234_);
						_vala_ccode_node_unref0 (_tmp234_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp235_;
				ValaCCodeConstant* _tmp236_;
				ValaCCodeConstant* _tmp237_;
				_tmp235_ = ccall;
				_tmp236_ = vala_ccode_constant_new ("NULL");
				_tmp237_ = _tmp236_;
				vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp237_);
				_vala_ccode_node_unref0 (_tmp237_);
			}
		}
	}
	if (disconnect) {
		_tmp238_ = TRUE;
	} else {
		ValaCodeNode* _tmp239_;
		ValaCodeNode* _tmp240_;
		_tmp239_ = vala_code_node_get_parent_node (expr);
		_tmp240_ = _tmp239_;
		_tmp238_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp238_) {
		ValaCCodeFunction* _tmp241_;
		ValaCCodeFunction* _tmp242_;
		ValaCCodeFunctionCall* _tmp243_;
		_tmp241_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = ccall;
		vala_ccode_function_add_expression (_tmp242_, (ValaCCodeExpression*) _tmp243_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp244_;
		ValaLocalVariable* _tmp245_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp246_;
		const gchar* _tmp247_;
		const gchar* _tmp248_;
		ValaCCodeExpression* _tmp249_;
		ValaLocalVariable* _tmp250_;
		ValaCCodeFunction* _tmp251_;
		ValaCCodeFunction* _tmp252_;
		ValaCCodeExpression* _tmp253_;
		ValaCCodeFunctionCall* _tmp254_;
		_tmp244_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp245_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp244_, TRUE, NULL, FALSE);
		temp_var = _tmp245_;
		_tmp246_ = temp_var;
		_tmp247_ = vala_symbol_get_name ((ValaSymbol*) _tmp246_);
		_tmp248_ = _tmp247_;
		_tmp249_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp248_);
		temp_ref = _tmp249_;
		_tmp250_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp250_, FALSE);
		_tmp251_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp252_ = _tmp251_;
		_tmp253_ = temp_ref;
		_tmp254_ = ccall;
		vala_ccode_function_add_assignment (_tmp252_, _tmp253_, (ValaCCodeExpression*) _tmp254_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
}

ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}

ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}

static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass,
                                gpointer klass_data)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaObjectTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}

static void
vala_gsignal_module_instance_init (ValaGSignalModule * self,
                                   gpointer klass)
{
}

static GType
vala_gsignal_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
	GType vala_gsignal_module_type_id;
	vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	return vala_gsignal_module_type_id;
}

GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__once = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__once)) {
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = vala_gsignal_module_get_type_once ();
		g_once_init_leave (&vala_gsignal_module_type_id__once, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

