# Largest Contentful Paint Changes in M81

## Changes in Chrome 81
Prior to Chrome 81, the Largest Contentful Paint (LCP) reporting logic for the
[Chrome User Experience Report](https://developers.google.com/web/tools/chrome-user-experience-report)
had a bug: if the largest image on the page was still loading, but the largest
contentful paint on the page was text, the largest contentful paint would be
recorded as the text. As of M81, it will be recorded as the largest image,
unless the largest image does not finish loading before user input or the page
is hidden, in which case LCP will not be recorded. [The source code of the change
can be seen here](https://chromium-review.googlesource.com/c/chromium/src/+/1998826).

## How does this affect a site's metrics?

This only affects a site's metrics in the
[Chrome User Experience Report](https://developers.google.com/web/tools/chrome-user-experience-report).
Sites doing measurement using the [largest-contentful-paint API](https://wicg.github.io/largest-contentful-paint/)
are unaffected.

Sites with very slow loading images which are smaller than the largest text
block on the page will have additional LCP measures which would not have been
previously reported. Generally these are slower-loading pages, so the site's
overall metrics may shift higher.

We do not see an impact from this change in our overall metrics, so we believe
the effect on most sites will be minimal.

## When were users affected?

Most users were updated to Chrome 81 the week of April 20.