/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection.annotation;

import android.databinding.Bindable;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.annotation.AnnotationAnalyzer;
import android.databinding.tool.reflection.annotation.AnnotationClass;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

class AnnotationField
extends ModelField {
    final VariableElement mField;
    final TypeElement mDeclaredClass;

    public AnnotationField(TypeElement declaredClass, VariableElement field) {
        this.mDeclaredClass = declaredClass;
        this.mField = field;
    }

    public String toString() {
        return this.mField.toString();
    }

    @Override
    public boolean isBindable() {
        return this.mField.getAnnotation(Bindable.class) != null;
    }

    @Override
    public String getName() {
        return this.mField.getSimpleName().toString();
    }

    @Override
    public boolean isPublic() {
        return this.mField.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public boolean isStatic() {
        return this.mField.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isFinal() {
        return this.mField.getModifiers().contains((Object)Modifier.FINAL);
    }

    @Override
    public ModelClass getFieldType() {
        return new AnnotationClass(this.mField.asType());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotationField) {
            AnnotationField that = (AnnotationField)obj;
            return this.mDeclaredClass.equals(that.mDeclaredClass) && AnnotationAnalyzer.get().getTypeUtils().isSameType(this.mField.asType(), that.mField.asType());
        }
        return false;
    }
}

