 /*************************************************************
 *  
 *          I R I S P L O T   ---------- gplot1.c
 *
 *    Copyright (C) 1989 Maorong Zou
 *
 *************************************************************/

#include <stdio.h>
#include "math.h"
#include "graph.h"
#include "graph1.h"

#define max(x,y)  ( (x) > (y) ? (x) : (y))
#define ABS(x)  ((x)>0?(x):(-(x)))

char *malloc();
char *strcpy(),*strcat();
int   strlen();

/***********************************************************/
struct uaxes *get_axes();
extern int plot3d;
/***********************************************************/

struct an_object *objects;
struct a_graph   *graph;
struct an_object *add_an_object();
float  *material_table;
int    num_graphs;
int    show_wire;
int    obj_table[45];
char   *m_string[45];
oview  pview;

static struct an_object *c_object;
static float xmin,xmax,ymin,ymax,zmin,zmax;
static int   center = 0;
/***********************************************************************/

read_attr()
{
  char  menu_string[7000];
  FILE   *fp1,*fopen();
  int    int_nn,i,kk,jj,k,j;
  float  xx,yy,zz;

  show_wire = 0;
  kk = 1; jj = 0;
  if( (fp1 = fopen(".Irisplot.Attr","r")) == NULL) 
    {
      (void) fprintf(stderr,"No description file\n");
      exit(0);
    }
  if( (fscanf(fp1,"%d",&plot3d)) == EOF)
    {
      (void)fprintf(stderr,"Empty description file\n");
      exit(0);
    };

  while( ( fscanf(fp1, "%f",&xx)) != EOF)
    {
      if(xx == (float) FINALSTRUCTURE)
	{
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) light_off();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) zbuffer_off();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) depthcue_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) box_on();	  
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) slice_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) doublebuffer_off();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) image_saving_on(int_nn);
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) bulb_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) coor_axes_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) big_box_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) base_on();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) togle_to_wire_frame();
	  (void)fscanf(fp1,"%d",&int_nn); if(int_nn) 
	    togle_to_show_normal_for_surface();
	}
      else if(xx == (float) BEGIN_AN_OBJECT)
	{
	  c_object = add_an_object(); 
	  (void)fscanf(fp1,"%f",&yy);
	  int_nn = (int)yy - 2;
	  c_object->num_action = int_nn;
	  c_object->actions = (float *)malloc((unsigned int)
					      int_nn * sizeof(float));
	  (void)fscanf(fp1,"%f",&yy);
	  obj_table[kk++] = ((yy > 0.0) ? ((int)yy) : 1);
	  for(i = 0; i < int_nn; i++)
	    {
	      (void)fscanf(fp1,"%f",&yy);
	      *(c_object->actions+i) = yy;
	    }
	  (void)fscanf(fp1,"%s",menu_string);
	  m_string[++jj] = (char *)
	    malloc((unsigned int) (strlen(menu_string) -1) *
		   sizeof(char));
	  menu_string[strlen(menu_string)-2] = '\0';
	  (void)strcpy(m_string[jj],menu_string+1);
	}
      else if(xx == (float) BEGIN_MATERIAL_DEFINITIONS)
	{
	  (void)fscanf(fp1,"%f",&yy);
	  int_nn = (int)yy;
	  material_table = (float *) malloc((unsigned int)
					    int_nn * sizeof(float));
	  for(i = 0; i < int_nn; i++)
	    {
	      (void)fscanf(fp1,"%f",&yy);
	      *(material_table + i) = yy;
	    }
	}
      else if(xx == (float) BEGIN_GRAPHS)
	{
      	  (void)fscanf(fp1,"%f",&yy);
	  int_nn = (int)yy;
	  num_graphs = (int)yy;
	  graph = (struct a_graph *)malloc( (unsigned int) int_nn *
					   sizeof( struct a_graph));
	  for(i = 0; i < int_nn; i++)
	    {
	      (void)fscanf(fp1,"%f",&yy);
	      graph[i].type = (int)yy;
	      (void)fscanf(fp1,"%f",&yy);
	      graph[i].data_type = (int)yy;
	      yy = (float)(graph[i].type);
	      if(yy == (float)SURFACE)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.surface.sample = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.surface.sample1 = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.surface.is_wire = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.surface.oren = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.surface.uaxes)=get_axes(fp1,(int)yy);
		}
	      else if(yy == (float)CURVE)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.curve.sample = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.curve.sample1 = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.curve.color = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.curve.style = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.curve.uaxes)=get_axes(fp1,(int)yy);
		}
#ifdef HAVE_F77
	      else if(yy == (float)CONTOUR)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.contour.n_cs = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.contour.nn_cs =(int)yy;
		  graph[i].picture.contour.npts =
		    (int **)malloc( (unsigned int)
				   (graph[i].picture.contour.n_cs )*
				   sizeof(int *));
		  for(j=0; j < graph[i].picture.contour.n_cs; j++)
		    {
		      (void)fscanf(fp1,"%f",&yy);
		      *( graph[i].picture.contour.npts	+ j)
			= (int *)malloc((unsigned int) (((int)yy) + 1)
					* sizeof(int));
		      *( *( graph[i].picture.contour.npts+j)) 
			= (int) yy;
		      for(k=0; k< (int)yy; k++)
			{
			  (void)fscanf(fp1,"%f",&zz);			  
			  *( *( graph[i].picture.contour.npts+j) +k+1)
			    = (int)zz;
			}
		    }
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.contour.uaxes)=get_axes(fp1,(int)yy);
		}
#endif
	      else if((int)yy == MAP)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.map.sample = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.map.color = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.map.uaxes)=get_axes(fp1,(int)yy);
		}
	      else if((int)yy == EQN)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.eqn.sample = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.eqn.color = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.eqn.uaxes)=get_axes(fp1,(int)yy);
		}
	      else if((int)yy == TMESH)
		{
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.tmesh.sample = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.tmesh.sample1 = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  graph[i].picture.tmesh.oren = (int)yy;
		  (void)fscanf(fp1,"%f",&yy);
		  (graph[i].picture.tmesh.uaxes)=get_axes(fp1,(int)yy);
		}
	      else
		{
		  (void)fprintf(stderr,"Bad description file,\
type reset and try again.\n");
		  exit(0);
		}
	    }
	}
      else if( xx == (float)SET_VIEW)
	{
	  (void)fscanf(fp1,"%d",&int_nn); pview.window_position[0] = int_nn;
	  (void)fscanf(fp1,"%d",&int_nn); pview.window_position[1] = int_nn;
	  (void)fscanf(fp1,"%d",&int_nn); pview.window_position[2] = int_nn;
	  (void)fscanf(fp1,"%d",&int_nn); pview.window_position[3] = int_nn;
	  (void)fscanf(fp1,"%f",&yy); pview.proj_type = (int) yy; 
	  
	  if( pview.proj_type == ORTHOGONAL ||pview.proj_type == PERSPECTIVE)
	    {
	      (void)fscanf(fp1,"%f",&yy); pview.vx = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.vy = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.vz = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.px = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.py = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.pz = yy;	      
	      (void)fscanf(fp1,"%f",&yy); pview.twist = (short) yy;	      
	    }
	  if( pview.proj_type == ORTHOGONAL)
	    {
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.left = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.right = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.bottom = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.top = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.near = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.o.far = yy;
	    }
	  else if( pview.proj_type == PERSPECTIVE)
	    {
	      (void)fscanf(fp1,"%f",&yy); pview.projections.p.fovy = (short)yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.p.aspect = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.p.pnear = yy;
	      (void)fscanf(fp1,"%f",&yy); pview.projections.p.pfar = yy;
	    }

	  (void)fscanf(fp1,"%f",&yy); xmin= pview.xmin = yy;
	  (void)fscanf(fp1,"%f",&yy); xmax= pview.xmax = yy;
	  (void)fscanf(fp1,"%f",&yy); ymin= pview.ymin = yy;
	  (void)fscanf(fp1,"%f",&yy); ymax= pview.ymax = yy;
	  (void)fscanf(fp1,"%f",&yy); zmin= pview.zmin = yy;
	  (void)fscanf(fp1,"%f",&yy); zmax= pview.zmax = yy;
	  
	}
      else if( xx == (float) OBJMENU)
	{
	  (void)fscanf(fp1,"%s",menu_string);
	  m_string[0] = 
	    (char *)malloc((unsigned int) (strlen(menu_string)-1)*
			   sizeof(char));
	  menu_string[strlen(menu_string)-2] = '\0';
	  (void)strcpy(m_string[0],menu_string+1);
	}
      else if( xx == (float) CENTER)
	{
	  (void)fscanf(fp1,"%f",&yy);
	  if(yy) center = 1;
	  else center = 0;
	}
      else
	{
	  (void)fprintf(stderr,"Description file skew up, type 'reset' and try again.\n");
	  exit(0);
	}
    }
  obj_table[0] = jj;
}
/*************************************************************/
struct uaxes *get_axes(fpt,ok)
     FILE *fpt; int ok;
{
  struct uaxes *axes;
  float xx;
  if(ok == 0) return( (struct uaxes *)0);
  axes = (struct uaxes *)malloc( (sizeof(struct uaxes)) );
  (void)fscanf(fpt,"%f",&xx); axes->ox = xx;
  (void)fscanf(fpt,"%f",&xx); axes->oy = xx;
  (void)fscanf(fpt,"%f",&xx); axes->oz = xx;
  (void)fscanf(fpt,"%f",&xx); axes->xx = xx;
  (void)fscanf(fpt,"%f",&xx); axes->xy = xx;
  (void)fscanf(fpt,"%f",&xx); axes->xz = xx;
  (void)fscanf(fpt,"%f",&xx); axes->yx = xx;
  (void)fscanf(fpt,"%f",&xx); axes->yy = xx;
  (void)fscanf(fpt,"%f",&xx); axes->yz = xx;
  (void)fscanf(fpt,"%f",&xx); axes->zx = xx;
  (void)fscanf(fpt,"%f",&xx); axes->zy = xx;
  (void)fscanf(fpt,"%f",&xx); axes->zz = xx;
  (void)fscanf(fpt,"%f",&xx); axes->ticmarks = (int)xx;
  return(axes);
}
/*************************************************************/
read_data()
{
  FILE   *fp,*fopen();
  float  xx,yy,zz,ww,cen_x,cen_y,cen_z;
  int    i,j,kk,l,k;
  char temp_lin[32];
  struct uaxes *axes;
  
  if( (fp  = fopen(".Irisplot.Data","r")) == NULL)
    {
      (void) fprintf(stderr,"\tNo data file.\n");
      exit(0);
    }

  if(center)
    {
      cen_x = 0.5*(xmax +xmin);
      cen_y = 0.5*(ymax +ymin);
      cen_z = 0.5*(zmax +zmin);
      pview.xmax = pview.xmax - cen_x;
      pview.xmin = pview.xmin - cen_x;
      pview.ymax = pview.ymax - cen_y;
      pview.ymin = pview.ymin - cen_y;
      pview.zmax = pview.zmax - cen_z;
      pview.zmin = pview.zmin - cen_z;
    }
  else
    {
      cen_x = 0.0; cen_y = 0.0; cen_z = 0.0;
    }

  for(kk = 0; kk <  num_graphs; kk++)
    {
      axes = (struct uaxes *)0;

      if(graph[kk].data_type == GRID_DATA) 
	{
	  if(graph[kk].type == SURFACE) 
	    {
	      axes = graph[kk].picture.surface.uaxes;
	      graph[kk].picture.surface.sx = 
		(float ***) malloc( (unsigned int)
				   (graph[kk].picture.surface.sample)* 
				   sizeof(float **));
	      graph[kk].picture.surface.snx = 
		(float ***) malloc( (unsigned int)
				   (graph[kk].picture.surface.sample)* 
				   sizeof(float **));
	      for( i = 0; i < graph[kk].picture.surface.sample; i++)
		{
		  graph[kk].picture.surface.sx[i]=
		    (float **)malloc( (unsigned int) 
				     (graph[kk].picture.surface.sample1)*
				     sizeof(float *));
		  graph[kk].picture.surface.snx[i]=
		    (float **)malloc((unsigned int)
				     (graph[kk].picture.surface.sample1)*
				     sizeof(float *));
		  for(j = 0; j < graph[kk].picture.surface.sample1; j++) 
		    {
		      graph[kk].picture.surface.sx[i][j]=
			(float *) malloc( (unsigned int) 3* sizeof(float));
		      graph[kk].picture.surface.snx[i][j]=
			(float *) malloc( (unsigned int) 3* sizeof(float));
		    }
		}
	      for(i = 0; i < graph[kk].picture.surface.sample; i++)
		{
		  for(j = 0; j <graph[kk].picture.surface.sample1;j++) 
		    {
		      (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
		      graph[kk].picture.surface.sx[i][j][0] = xx - cen_x;
		      graph[kk].picture.surface.sx[i][j][1] = yy - cen_y;
		      graph[kk].picture.surface.sx[i][j][2] = zz - cen_z;
		    }
		}
	      compute_normal1(kk);
	      
	      graph[kk].picture.surface.cx = 
		(float **)malloc((unsigned int) 4* sizeof(float *));
	      for(i = 0; i < 4; i++)
		graph[kk].picture.surface.cx[i] = 
		  (float *)malloc( (unsigned int)3* sizeof(float));
	      graph[kk].picture.surface.cx[0][0] =
		graph[kk].picture.surface.sx[0][0][0];
	      graph[kk].picture.surface.cx[0][1] =
		graph[kk].picture.surface.sx[0][0][1];
	      graph[kk].picture.surface.cx[1][0] = 
		graph[kk].picture.surface.sx
		  [graph[kk].picture.surface.sample-1][0][0];
					 
	      graph[kk].picture.surface.cx[1][1] =
		graph[kk].picture.surface.sx
		  [graph[kk].picture.surface.sample-1][0][1];
	      graph[kk].picture.surface.cx[2][0] = 
	       graph[kk].picture.surface.sx[graph[kk].picture.surface.sample-1]
		 [graph[kk].picture.surface.sample1-1][0];
	      graph[kk].picture.surface.cx[2][1] = 
	       graph[kk].picture.surface.sx[graph[kk].picture.surface.sample-1]
		 [graph[kk].picture.surface.sample1-1][1];
	      graph[kk].picture.surface.cx[3][0] = 
		graph[kk].picture.surface.sx
		  [0][graph[kk].picture.surface.sample1-1][0];
	      graph[kk].picture.surface.cx[3][1] = 
		graph[kk].picture.surface.sx
		  [0][graph[kk].picture.surface.sample1-1][1];
	      graph[kk].picture.surface.cx[0][2] = 
		graph[kk].picture.surface.cx[1][2] = 
		  graph[kk].picture.surface.cx[2][2] =
		    graph[kk].picture.surface.cx[3][2] = 1.3*(zmin - cen_z);
	    }
	  else  if(graph[kk].type == CURVE)
	    {
	      axes = graph[kk].picture.curve.uaxes;
	      graph[kk].picture.curve.cx = 
		(float ***) malloc( (unsigned int) 
				   (graph[kk].picture.curve.sample1) *
				   sizeof(float **));
	      for(j = 0; j < graph[kk].picture.curve.sample1; j++)
		{
		  *( graph[kk].picture.curve.cx +j) = 
		    (float **)malloc((unsigned int)
				     graph[kk].picture.curve.sample 
				     * sizeof(float *));
		  for(i = 0; i < graph[kk].picture.curve.sample; i++)
		    *( *(graph[kk].picture.curve.cx +j) +i)=
		      (float *) malloc( (unsigned int) 3* sizeof(float)); 
		}
	      for(i = 0; i < graph[kk].picture.curve.sample1; i++)
		{
		  for(j = 0; j < graph[kk].picture.curve.sample; j++)
		    {
		      (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
		      graph[kk].picture.curve.cx[i][j][0] = xx - cen_x;
		      graph[kk].picture.curve.cx[i][j][1] = yy - cen_y;
		      graph[kk].picture.curve.cx[i][j][2] = zz - cen_z;	      
		    }
		}
	    }
#ifdef HAVE_F77
	  else if(graph[kk].type == CONTOUR)
	    {
	      float x_temp,y_temp,z_temp;
	      axes = graph[kk].picture.contour.uaxes;
	      graph[kk].picture.contour.cx = 
		(float **)malloc((unsigned int) 8* sizeof(float *));
	      for(i = 0; i < 8; i++)
		graph[kk].picture.contour.cx[i] = 
		  (float *)malloc( (unsigned int)3* sizeof(float));
	      for(i = 0; i < 4; i++)
		{
		  (void)fscanf(fp,"%f %f %f",&x_temp,&y_temp,&z_temp);
		  graph[kk].picture.contour.cx[i][0] =
		    graph[kk].picture.contour.cx[i+4][0] = x_temp -cen_x; 
		  graph[kk].picture.contour.cx[i][1] = 
		    graph[kk].picture.contour.cx[i+4][1] = y_temp - cen_y;
		  graph[kk].picture.contour.cx[i][2] = z_temp - cen_z;	    
		  graph[kk].picture.contour.cx[i+4][2] = z_temp - cen_z;
		}
	      k = 0;
	      graph[kk].picture.contour.sx = 
		(float ***) malloc( (unsigned int) 
				   (graph[kk].picture.contour.nn_cs) *
				   sizeof(float **));
	      for(i = 0; i < graph[kk].picture.contour.n_cs; i++)
		{
		  for(l = 0; l < (graph[kk].picture.contour.npts)[i][0]; l++)
		    {
		      graph[kk].picture.contour.sx[k] = 
			(float **)malloc((unsigned int)
					 ((graph[kk].picture.contour.npts)
					  [i][l+1]*
					  sizeof(float *)));
		      for(j = 0; j < (graph[kk].picture.contour.npts)
			  [i][l+1]; j++)
			graph[kk].picture.contour.sx[k][j] =
			  (float *)malloc((unsigned int)( 3*sizeof(float )));
		      for(j = 0; 
			  j < (graph[kk].picture.contour.npts)[i][l+1]; j++)
			{
			  (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
			  graph[kk].picture.contour.sx[k][j][0] = xx - cen_x;
			  graph[kk].picture.contour.sx[k][j][1] = yy - cen_y;
			  graph[kk].picture.contour.sx[k][j][2] = zz - cen_z;
			}
		      k++;
		    }
		}
	    }
#endif
	  else  if(graph[kk].type == MAP)
	    {
	      axes = graph[kk].picture.map.uaxes;
	      graph[kk].picture.map.cx = (float **)
		malloc( (unsigned int) 
		       (graph[kk].picture.map.sample)*sizeof(float *));
	      for(i = 0; i < graph[kk].picture.map.sample; i++)
		graph[kk].picture.map.cx[i]=
		  (float *) malloc( (unsigned int) 3* sizeof(float));	  
	      for(i = 0; i < graph[kk].picture.map.sample; i++)
		{
		  (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
		  graph[kk].picture.map.cx[i][0] = xx - cen_x;
		  graph[kk].picture.map.cx[i][1] = yy - cen_y;
		  graph[kk].picture.map.cx[i][2] = zz - cen_z;	      
		}	  
	    }
	  else  if(graph[kk].type == EQN)
	    {
	      axes = graph[kk].picture.eqn.uaxes;
	      graph[kk].picture.eqn.cx = (float **)
		malloc( (unsigned int) 
		       (graph[kk].picture.eqn.sample)*sizeof(float *));
	      for(i = 0; i < graph[kk].picture.eqn.sample; i++)
		graph[kk].picture.eqn.cx[i]=
		  (float *) malloc( (unsigned int) 3* sizeof(float));	  
	      for(i = 0; i < graph[kk].picture.eqn.sample; i++)
		{
		  (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
		  graph[kk].picture.eqn.cx[i][0] = xx - cen_x;
		  graph[kk].picture.eqn.cx[i][1] = yy - cen_y;
		  graph[kk].picture.eqn.cx[i][2] = zz - cen_z;	      
		}	  
	    }
	  if(graph[kk].type == TMESH)
	    {
	      axes = graph[kk].picture.tmesh.uaxes;
	      graph[kk].picture.tmesh.sx = 
		(float ***) malloc( (unsigned int)
				   (graph[kk].picture.tmesh.sample)*
				   sizeof(float **));
	      graph[kk].picture.tmesh.snx = 
		(float ***) malloc( (unsigned int)
				   (graph[kk].picture.tmesh.sample)* 
				   sizeof(float **));
	      for( i = 0; i < graph[kk].picture.tmesh.sample; i++)
		{
		  graph[kk].picture.tmesh.sx[i]=
		    (float **)malloc( (unsigned int) 
				     (graph[kk].picture.tmesh.sample1)*
				     sizeof(float *));
		  graph[kk].picture.tmesh.snx[i]=
		    (float **)malloc((unsigned int)
				     (graph[kk].picture.tmesh.sample1)*
				     sizeof(float *));
		  for(j = 0; j < graph[kk].picture.tmesh.sample1; j++) 
		    {
		      graph[kk].picture.tmesh.sx[i][j]=
			(float *) malloc( (unsigned int) 3* sizeof(float));
		      graph[kk].picture.tmesh.snx[i][j]=
			(float *) malloc( (unsigned int) 3* sizeof(float));
		    }
		}
	      for(i = 0; i < graph[kk].picture.tmesh.sample; i++)
		{
		  for(j = 0; j <graph[kk].picture.tmesh.sample1;j++) 
		    {
		      (void) fscanf(fp,"%f %f %f",&xx,&yy,&zz);
		      graph[kk].picture.tmesh.sx[i][j][0] = xx - cen_x;
		      graph[kk].picture.tmesh.sx[i][j][1] = yy - cen_y;
		      graph[kk].picture.tmesh.sx[i][j][2] = zz - cen_z;
		    }
		}
	      compute_normal_tmesh1(kk);
	    }
	  (void)fgets(temp_lin,31,fp);   /* skip the newline */
	}
      else if(graph[kk].data_type == FEA_POLYGON)
	{
	  read_fea_polygon(kk,fp,cen_x,cen_y,cen_z);
	}
      else if(graph[kk].data_type == CVN_DATA)
	{
	  char c, line[128];
	  register struct a_cvn_point **t_cvn;
	  register int samp;
	  if(graph[kk].type == SURFACE)
	    {
	      axes = graph[kk].picture.surface.uaxes;
	      graph[kk].picture.surface.cvn = (struct a_cvn_point *)NULL;
	      t_cvn = &(graph[kk].picture.surface.cvn);
	      samp = graph[kk].picture.surface.sample;
	    }
	  else if(graph[kk].type == CURVE)
	    {
	      axes = graph[kk].picture.curve.uaxes;
	      graph[kk].picture.curve.cvn = (struct a_cvn_point *)NULL;
	      t_cvn = &(graph[kk].picture.curve.cvn);
	      samp = graph[kk].picture.curve.sample;
	    }
	  for(i = 0; i < samp; i++)
	    {
	      (*t_cvn) = (struct a_cvn_point *)
		malloc((unsigned)sizeof(struct a_cvn_point));
	      (*t_cvn)->next = (struct a_cvn_point *)NULL;
	      (void)fgets(line,127,fp);
	      c = line[0];
	      (*t_cvn)->c = c;
	      if(c == 'c' || c == 'v' || c == 'n')
		{
		  (*t_cvn)->x = (float *)
		    malloc((unsigned)3*sizeof(float));
		  (void)sscanf((line+2),"%f %f %f",&xx,&yy,&zz);
		  if(c == 'v')
		    {
		      (*t_cvn)->x[0] = xx - cen_x;
		      (*t_cvn)->x[1] = yy - cen_y;
		      (*t_cvn)->x[2] = zz - cen_z;
		    }
		  else
		    {
		      (*t_cvn)->x[0] = xx;
		      (*t_cvn)->x[1] = yy;
		      (*t_cvn)->x[2] = zz;
		    }
		}
	      else  if(c == 'a')
		{
		  (*t_cvn)->x = (float *)
		    malloc((unsigned)4*sizeof(float));
		  (void)sscanf((line+2),"%f %f %f %f", &xx,&yy,&zz,&ww);
		  (*t_cvn)->x[0] = xx;
		  (*t_cvn)->x[1] = yy;
		  (*t_cvn)->x[2] = zz;
		  (*t_cvn)->x[3] = ww;
		}
	      t_cvn = &( (*t_cvn)->next);
	    }
	}
      else if(graph[kk].data_type == POLYGON_DATA)      
	{
	  float xxx1,yyy1,zzz1;
	  register struct a_polygon **t_p;
	  int temp_i,samp,normal_defined,bbb;
	  char line[129];

	  if(graph[kk].type == SURFACE)
	    {
	      axes = graph[kk].picture.surface.uaxes;
	      graph[kk].picture.surface.poly = (struct a_polygon *)NULL;
	      t_p = &(graph[kk].picture.surface.poly);
	      samp = graph[kk].picture.surface.sample;
	    }
	  else if(graph[kk].type == CURVE)
	    {
	      axes = graph[kk].picture.curve.uaxes;
	      graph[kk].picture.curve.poly = (struct a_polygon *)NULL;
	      t_p = &(graph[kk].picture.curve.poly);
	      samp = graph[kk].picture.curve.sample;
	    }
	  for(i = 0; i < samp; i++)
	    {
	      normal_defined = 0; bbb = 0;
	      (*t_p) = (struct a_polygon *)
		malloc((unsigned) sizeof(struct a_polygon));
	      (void) fscanf(fp,"%d",&temp_i);
	      (void)fgets(line,128,fp);
	      (*t_p)->num_points = temp_i;
	      (*t_p)->points = (float **)
		malloc((unsigned)temp_i*sizeof(float *));
	      if(graph[kk].type == SURFACE)
		(*t_p)->norm = (float **)
		  malloc((unsigned)temp_i*sizeof(float *));		
	      for(j = 0; j < temp_i;j++)
		{
		  *((*t_p)->points + j) = (float *)
		    malloc((unsigned)3*sizeof(float));
		  if(graph[kk].type == SURFACE)
		   *((*t_p)->norm + j) = (float *)
		    malloc((unsigned)3*sizeof(float));
		}
	      for(j = 0; j < temp_i; j++)
		{
		  (void)fgets(line,128,fp);
		  bbb = sscanf(line,"%f %f %f %f %f %f",&xx,&yy,&zz,&xxx1,
			       &yyy1,&zzz1);
		  (*t_p)->points[j][0] = xx - cen_x;
		  (*t_p)->points[j][1] = yy - cen_y;
		  (*t_p)->points[j][2] = zz - cen_z;
		  if(graph[kk].type == SURFACE)
		    {
		      if(bbb == 6 || normal_defined)
			{
			  normal_defined = 1;
			  (*t_p)->norm[j][0] = xxx1;
			  (*t_p)->norm[j][1] = yyy1;
			  (*t_p)->norm[j][2] = zzz1;
			}
		    }
		}
	      if(graph[kk].type == SURFACE && !normal_defined)
		polygon_normal( (*t_p)->points,(*t_p)->norm,temp_i,
			       (float)(graph[kk].picture.surface.oren));
	      i += temp_i;
	      t_p = &( (*t_p)->next);
	    }
	}
      if(axes != (struct uaxes *)0)
	centerlize_axes(axes,cen_x,cen_y,cen_z);
    }
  (void)fclose(fp);
}
/**************************************************************/

struct an_object 
  *add_an_object()
    {
  register struct an_object **t_obj;
  
  t_obj = &objects;
  while(*t_obj) 
    t_obj = &( (*t_obj)->next);

  if( !(*t_obj = 
	(struct an_object *)malloc( (unsigned int) sizeof(struct an_object)))) 
    {
      (void) fprintf(stderr,"\tOut of memory.\n");
      exit(0);
    }
  (*t_obj)->actions = (float *) 0;
  (*t_obj)->num_action = 0;
  (*t_obj)->next = (struct an_object *) 0;
  return(*t_obj);
}
/*********************************************************************/

compute_normal1(kk)
     int kk;
{
  float norm,tx,ty,tz,x,y,z,nx,ny,nz,oren;
  float ***sx, ***snx;
  int i,j;

  if(graph[kk].type != SURFACE)
    return;

  oren = (float) (graph[kk].picture.surface.oren);
  sx=(graph[kk].picture.surface.sx);
  snx=(graph[kk].picture.surface.snx);

  for(i = 0; i < graph[kk].picture.surface.sample -1;i++) 
    {
      for(j = 0; j < graph[kk].picture.surface.sample1 -1;j++) 
	{
	  x=(sx[i][j+1][0])-  (sx[i][j][0]) ;
	  y=(sx[i][j+1][1])-  (sx[i][j][1]) ;
	  z=(sx[i][j+1][2])-  (sx[i][j][2]) ;
	  tx=(sx[i+1][j][0])- (sx[i][j][0]) ;
	  ty=(sx[i+1][j][1])- (sx[i][j][1]) ;
	  tz=(sx[i+1][j][2])- (sx[i][j][2]) ;

	  nx = y * tz - z * ty;
	  ny = z * tx - x * tz;
	  nz = x * ty - y * tx;
	  norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);

	  if( ABS( norm) > 0.0) 
	    {
	      snx[i][j][0] = nx /norm;
	      snx[i][j][1] = ny /norm;
	      snx[i][j][2] = nz /norm;
	    }
	  else
	    {
	      /*
	       * ????
	       */
	      if(i > 0)
		{
		  snx[i][j][0] = snx[i-1][j][0];
		  snx[i][j][1] = snx[i-1][j][1];
		  snx[i][j][2] = snx[i-1][j][2];
		}
	      else if(j > 0)
		{
		  snx[i][j][0] = snx[i][j-1][0];
		  snx[i][j][1] = snx[i][j-1][1];
		  snx[i][j][2] = snx[i][j-1][2];
		}
	      else
		{
		  /* may introduce bug */
		  x=(sx[i+1][j+2][0])-  (sx[i+1][j+1][0]) ;
		  y=(sx[i+1][j+2][1])-  (sx[i+1][j+1][1]) ;
		  z=(sx[i+1][j+2][2])-  (sx[i+1][j+1][2]) ;
		  tx=(sx[i+2][j+1][0])- (sx[i+1][j+1][0]) ;
		  ty=(sx[i+2][j+1][1])- (sx[i+1][j+1][1]) ;
		  tz=(sx[i+2][j+1][2])- (sx[i+1][j+1][2]) ;

		  nx = y * tz - z * ty;
		  ny = z * tx - x * tz;
		  nz = x * ty - y * tx;
		  norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
		  if( ABS( norm) > 0.0) 
		    {
		      snx[i][j][0] = nx /norm;
		      snx[i][j][1] = ny /norm;
		      snx[i][j][2] = nz /norm;
		    }
		  else
		    {
		      snx[i][j][0] = 0.0;
		      snx[i][j][1] = 0.0;
		      snx[i][j][2] = 1.0;
		    }
		}
	    }
	}
    }

  i = graph[kk].picture.surface.sample -1;
  for(j = 0; j < graph[kk].picture.surface.sample1-1;j++)
    {
      x = (sx[i-1][j][0]) - (sx[i][j][0]) ;
      y = (sx[i-1][j][1]) - (sx[i][j][1]) ;
      z = (sx[i-1][j][2]) - (sx[i][j][2]) ;
      tx=(sx[i][j+1][0]) - (sx[i][j][0]) ;
      ty=(sx[i][j+1][1]) - (sx[i][j][1]) ;
      tz=(sx[i][j+1][2]) - (sx[i][j][2]) ;

      nx = y * tz - z * ty;
      ny = z * tx - x * tz;
      nz = x * ty - y *tx;
      norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
      if( ABS( norm) > 0.0) 
	{
	  snx[i][j][0] = nx /norm;
	  snx[i][j][1] = ny /norm;
	  snx[i][j][2] = nz /norm;
	}
      else
	{
	  snx[i][j][0] = snx[i-1][j][0];
	  snx[i][j][1] = snx[i-1][j][1];
	  snx[i][j][2] = snx[i-1][j][2];
	}
    }
    j = graph[kk].picture.surface.sample1 - 1;
    for(i = 0; i < graph[kk].picture.surface.sample - 1;i++)
    {
      x = (sx[i+1][j][0]) - (sx[i][j][0]) ;
      y = (sx[i+1][j][1]) - (sx[i][j][1]) ;
      z = (sx[i+1][j][2]) - (sx[i][j][2]) ;
      tx =(sx[i][j-1][0]) - (sx[i][j][0]) ;
      ty =(sx[i][j-1][1]) - (sx[i][j][1]) ;
      tz =(sx[i][j-1][2]) - (sx[i][j][2]) ;

      nx = y * tz - z * ty;
      ny = z * tx - x * tz;
      nz = x * ty - y *tx;
      norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
      if( ABS( norm) > 0.0) 
	{
	  snx[i][j][0] = nx /norm;
	  snx[i][j][1] = ny /norm;
	  snx[i][j][2] = nz /norm;
	}
      else
	{
	  snx[i][j][0] = snx[i][j-1][0];
	  snx[i][j][1] = snx[i][j-1][1];
	  snx[i][j][2] = snx[i][j-1][2];
	}
    }
  /*
   * the last one
   */
  i = graph[kk].picture.surface.sample - 1;
  j = graph[kk].picture.surface.sample1 - 1;         
  x = (sx[i][j-1][0]) - (sx[i][j][0]) ;
  y = (sx[i][j-1][1]) - (sx[i][j][1]) ;
  z = (sx[i][j-1][2]) - (sx[i][j][2]) ;
  tx =(sx[i-1][j][0]) - (sx[i][j][0]) ;
  ty =(sx[i-1][j][1]) - (sx[i][j][1]) ;
  tz =(sx[i-1][j][2]) - (sx[i][j][2]) ;
  nx = y * tz - z * ty;
  ny = z * tx - x * tz;
  nz = x * ty - y *tx;
  norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
  if( ABS( norm) > 0.0) 
    {
      snx[i][j][0] = nx /norm;
      snx[i][j][1] = ny /norm;
      snx[i][j][2] = nz /norm;
    }
  else
    {
      snx[i][j][0] = snx[i-1][j-1][0];
      snx[i][j][1] = snx[i-1][j-1][1];
      snx[i][j][2] = snx[i-1][j-1][2];
    }
}

/****************************************************************************/

compute_normal_tmesh1(mm)
     int mm;
{
  float norm,tx,ty,tz,x,y,z,nx,ny,nz,oren;
  float ***sx,***snx;
  int i,j,kk;

  if(graph[mm].type != TMESH)
    return;

  oren = (float)(graph[mm].picture.tmesh.oren);
  sx = graph[mm].picture.tmesh.sx;
  snx = graph[mm].picture.tmesh.snx;
  for(i = 0; i < graph[mm].picture.tmesh.sample; i++) 
    {
      kk = 0;
      for(j = 0; j < graph[mm].picture.tmesh.sample1 -2;j++) 
	{
	  x = (sx[i][j+1][0])-  (sx[i][j][0]) ;
	  y = (sx[i][j+1][1])-  (sx[i][j][1]) ;
	  z = (sx[i][j+1][2])-  (sx[i][j][2]) ;
	  tx =(sx[i][j+2][0])-  (sx[i][j][0]) ;
	  ty =(sx[i][j+2][1])-  (sx[i][j][1]) ;
	  tz =(sx[i][j+2][2])-  (sx[i][j][2]) ;

	  nx = y * tz - z * ty;
	  ny = z * tx - x * tz;
	  nz = x * ty - y *tx;
	  if(!kk) 
	    {
	      norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
	      kk = 1;
	    }
	  else  
	    {
	      norm = oren * fsqrt( nx * nx + ny * ny + nz * nz);
	      kk = 0;
	    }
	      
	  if( ABS( norm) > 0.0) 
	    {
	      snx[i][j][0] = nx /norm;
	      snx[i][j][1] = ny /norm;
	      snx[i][j][2] = nz /norm;
	    }
	  else
	    {
	      /*
	       *  ?????
	       */
	      snx[i][j][0] = 0.0;
	      snx[i][j][1] = 0.0;
	      snx[i][j][2] = 1.0;
	    }
	}
      j = graph[mm].picture.tmesh.sample1 - 2;
      x = (sx[i][j-1][0]) - (sx[i][j][0]) ;
      y = (sx[i][j-1][1]) - (sx[i][j][1]) ;
      z = (sx[i][j-1][2]) - (sx[i][j][2]) ;
      tx =(sx[i][j+1][0]) - (sx[i][j][0]) ;
      ty =(sx[i][j+1][1]) - (sx[i][j][1]) ;
      tz =(sx[i][j+1][2]) - (sx[i][j][2]) ;

      nx = y * tz - z * ty;
      ny = z * tx - x * tz;
      nz = x * ty - y *tx;
      if(!kk) 
	{
	  norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
	  kk = 1;
	}
      else 
	{
	  norm =  oren * fsqrt( nx * nx + ny * ny + nz * nz);
	  kk = 0;
	}
      if( ABS( norm) > 0.0) 
	{
	  snx[i][j][0] = nx /norm;
	  snx[i][j][1] = ny /norm;
	  snx[i][j][2] = nz /norm;
	}
      else
	{
	  snx[i][j][0] = 0.0;
	  snx[i][j][1] = 0.0;
	  snx[i][j][2] = 1.0;
	}
      j = graph[mm].picture.tmesh.sample1 - 1;
      x = (sx[i][j-1][0]) - (sx[i][j][0]) ;
      y = (sx[i][j-1][1]) - (sx[i][j][1]) ;
      z = (sx[i][j-1][2]) - (sx[i][j][2]) ;
      tx =(sx[i][j-2][0]) - (sx[i][j][0]) ;
      ty =(sx[i][j-2][1]) - (sx[i][j][1]) ;
      tz =(sx[i][j-2][2]) - (sx[i][j][2]) ;

      nx = y * tz - z * ty;
      ny = z * tx - x * tz;
      nz = x * ty - y *tx;
      if(!kk)
	norm =  oren * fsqrt( nx * nx + ny * ny + nz * nz);
      else
	norm = - oren * fsqrt( nx * nx + ny * ny + nz * nz);
	  
      if( ABS( norm) > 0.0) 
	{
	  snx[i][j][0] = nx /norm;
	  snx[i][j][1] = ny /norm;
	  snx[i][j][2] = nz /norm;
	}
      else
	{
	  snx[i][j][0] = 0.0;
	  snx[i][j][1] = 0.0;
	  snx[i][j][2] = 1.0;
	}
    }
}
/****************************************************************************/
polygon_normal(ff,tt,nn,oren)
     float **ff,**tt,oren;
     int nn;
{
  register int i;
  float x0,y5,z0,xx0,yy5,zz0,nx,ny,nz;
  for(i=0; i<nn;i++)
    {
      if(i >= 1 && i <= nn-2)
	{
	  x0 = ff[i+1][0] - ff[i][0];
	  y5 = ff[i+1][1] - ff[i][1];
	  z0 = ff[i+1][2] - ff[i][2];
	  xx0 = ff[i-1][0] - ff[i][0];
	  yy5 = ff[i-1][1] - ff[i][1];
	  zz0 = ff[i-1][2] - ff[i][2];
	}
      else if(i == 0)
	{
	  x0 = ff[i+1][0] - ff[i][0];
	  y5 = ff[i+1][1] - ff[i][1];
	  z0 = ff[i+1][2] - ff[i][2];
	  xx0 = - ff[i][0] + ff[nn-1][0];
	  yy5 = - ff[i][1] + ff[nn-1][1];
	  zz0 = - ff[i][2] + ff[nn-1][2];
	}
      else if(i == nn-1)
	{
	  x0 = ff[0][0] - ff[i][0];
	  y5 = ff[0][1] - ff[i][1];
	  z0 = ff[0][2] - ff[i][2];
	  xx0 = ff[i-1][0] - ff[i][0];
	  yy5 = ff[i-1][1] - ff[i][1];
	  zz0 = ff[i-1][2] - ff[i][2];
	}
      nx = y5 * zz0 - z0 * yy5;
      ny = z0 * xx0 - x0 * zz0;
      nz = x0 * yy5 - y5 * xx0;
      xx0 = oren * fsqrt(nx *nx + ny * ny + nz * nz);
      if( fabs(xx0)>= 0.0)
	{
	  tt[i][0] = nx /xx0;
	  tt[i][1] = ny /xx0;
	  tt[i][2] = nz /xx0;
	}
      else
	{
	  tt[i][0] = 0.0;
	  tt[i][1] = 0.0;
	  tt[i][2] = 1.0;
	}
    }
}
/******************************************************************/
compute_normal(kk,ll)
     int kk,ll;
{
  int i,j;
  float x0,y5,z0;

  if(graph[kk].data_type == GRID_DATA)
    {
      float ***snx;
      snx = graph[kk].picture.surface.snx;
      for(i=0; i < graph[kk].picture.surface.sample;i++)
	{
	  for(j=0; j < graph[kk].picture.surface.sample1;j++)
	    {
	      x0 = snx[i][j][0];
	      y5 = snx[i][j][1];
	      z0 = snx[i][j][2];
	      if(ll)
		{
		  snx[i][j][0] = -1.0 + 2.0* x0;
		  snx[i][j][1] = -1.0 + 2.0* y5;
		  snx[i][j][2] = -1.0 + 2.0* z0;
		}
	      else
		{
		  snx[i][j][0] = 0.5 *(1.0 + x0);
		  snx[i][j][1] = 0.5 *(1.0 + y5);
		  snx[i][j][2] = 0.5 *(1.0 + z0);
		}
	    }
	}
    }
  else  if(graph[kk].data_type == POLYGON_DATA)
    {
      struct a_polygon *t_p;
      t_p = graph[kk].picture.surface.poly;
      while(t_p)
	{
	  for(i = 0; i < t_p->num_points; i++)
	    {
	      x0 = t_p->norm[i][0];
	      y5 = t_p->norm[i][1];
	      z0 = t_p->norm[i][2];
	      if(ll)
		{
		  t_p->norm[i][0] = -1.0 + 2.0 * x0;
		  t_p->norm[i][1] = -1.0 + 2.0 * y5;
		  t_p->norm[i][2] = -1.0 + 2.0 * z0;
		}
	      else
		{
		  t_p->norm[i][0] = 0.5 *( 1.0 + x0);
		  t_p->norm[i][1] = 0.5 *( 1.0 + y5);
		  t_p->norm[i][2] = 0.5 *( 1.0 + z0);
		}
	    }
	  t_p = t_p->next;
	}
    }
  else  if(graph[kk].data_type == CVN_DATA)
    {
      struct a_cvn_point *t_cvn;
      t_cvn = graph[kk].picture.surface.cvn;
      while(t_cvn)
	{
	  if( (t_cvn->c) == 'n')
	    {
	      x0 = t_cvn->x[0];
	      y5 = t_cvn->x[1];
	      z0 = t_cvn->x[2];
	      if(ll)
		{
		  t_cvn->x[0] = -1.0 + 2.0 * x0;
		  t_cvn->x[1] = -1.0 + 2.0 * y5;
		  t_cvn->x[2] = -1.0 + 2.0 * z0;
		}
	      else
		{
		  t_cvn->x[0] =  0.5 *( 1.0 + x0);
		  t_cvn->x[1] =  0.5 *( 1.0 + y5);
		  t_cvn->x[2] =  0.5 *( 1.0 + z0);
		}
	    }
	  t_cvn = t_cvn->next;
	}
    }
  else  if(graph[kk].data_type == FEA_POLYGON)
    {
      struct fea_poly **temp;
      temp = &(graph[kk].picture.surface.fea_poly);
      while( (*temp)) {
	for(j=0; j < (*temp)->nv;j++) {
	  x0 = (*temp)->nx[j][0];
	  y5 = (*temp)->nx[j][1];
	  z0 = (*temp)->nx[j][2];
	  if(ll)
	    {
	      (*temp)->nx[j][0] = -1.0 + 2.0 * x0;
	      (*temp)->nx[j][1] = -1.0 + 2.0 * y5;
	      (*temp)->nx[j][2] = -1.0 + 2.0 * z0;
	    }
	  else
	    {
	      (*temp)->nx[j][0] = 0.5*(1.0+x0);
	      (*temp)->nx[j][1] = 0.5*(1.0+y5);
	      (*temp)->nx[j][2] = 0.5*(1.0+z0);
	    }
	}
	temp  = &( (*temp)-> next);
      }
    }
}
/******************************************************************/
compute_normal_tmesh(mm,ll)
     int mm,ll;
{
  float x0,y5,z0;
  float ***snx;
  int i,j;

  snx = graph[mm].picture.tmesh.snx;
  for(i = 0; i < graph[mm].picture.tmesh.sample; i++) 
    {
      for(j = 0; j < graph[mm].picture.tmesh.sample1;j++) 
	{
	  x0 = snx[i][j][0];
	  y5 = snx[i][j][1];
	  z0 = snx[i][j][2];
	  if(ll)
	    {
	      snx[i][j][0] = -1.0 + 2.0 * x0;	      
	      snx[i][j][1] = -1.0 + 2.0 * y5;	      
	      snx[i][j][2] = -1.0 + 2.0 * z0;	      
	    }
	  else
	    {
	      snx[i][j][0] = 0.5 *(1.0 + x0);
	      snx[i][j][1] = 0.5 *(1.0 + y5);
	      snx[i][j][2] = 0.5 *(1.0 + z0);
	    }
	}
    }
}
/***********************************************************************/
read_fea_polygon(kk,fp,cen_x,cen_y,cen_z)
     int kk; FILE *fp;
     float cen_x,cen_y,cen_z;
{
  struct fea_poly **temp;
  struct uaxes *axes;
  float xx,yy,zz,xx1,yy1,zz1;
  float x0,y5,z0,xx0,yy5,zz0,oren,nx,ny,nz;
  int i,j,k,l,nv,np,num_lines,jj,normal_defined,bbb,start_index;
  char line[129];

  oren = 1.0;
  axes = (struct uaxes *)0;
  if(graph[kk].type == SURFACE)
    {
      axes =  graph[kk].picture.surface.uaxes;
      oren = (float) ( graph[kk].picture.surface.oren);
      num_lines = graph[kk].picture.surface.sample;
      (graph[kk].picture.surface.fea_poly) = (struct fea_poly *)NULL;
      temp = &(graph[kk].picture.surface.fea_poly);
    }
  else
    {
      axes =  graph[kk].picture.surface.uaxes;
      num_lines = graph[kk].picture.curve.sample;
      (graph[kk].picture.curve.fea_poly) = (struct fea_poly *)NULL;
      temp = &(graph[kk].picture.curve.fea_poly);
    }
  jj = 0;
  while(jj < num_lines)
    {
      normal_defined = 0; bbb = 0; start_index = 1;
      (void)fgets(line,128,fp);
      (void)sscanf(line,"%d %d",&nv,&np); jj++; 
      (*temp ) = (struct fea_poly *)
	malloc((unsigned) sizeof(struct fea_poly));
      (*temp)->x = (float **)malloc((unsigned)nv * sizeof(float *));
      (*temp)->nx = (float **)malloc((unsigned)nv * sizeof(float *));
      (*temp)->nv = nv;        (*temp)->np = np; 
      (*temp)->nn = (int **)malloc((unsigned)np*sizeof(int *));
      (*temp)->next = (struct fea_poly *) NULL;

      for(i = 0; i < nv; i++)
	{
	  ((*temp)->x[i]) = (float *)malloc((unsigned) 3 * sizeof(float));
	  ((*temp)->nx[i]) = (float *)malloc((unsigned) 3 * sizeof(float));
	  for(j=0;j<3;j++)
	    (*temp)->nx[i][j] = 0.0;
	}

      for(i = 0; i < nv; i++)
	{
	  (void)fgets(line,128,fp); jj++;
	  bbb = sscanf(line,"%f %f %f %f %f %f",&xx,&yy,&zz,&xx1,&yy1,&zz1);
	  (*temp)->x[i][0] = xx - cen_x;
	  (*temp)->x[i][1] = yy - cen_y;
	  (*temp)->x[i][2] = zz - cen_z;
	  if(bbb == 6 || normal_defined)
	    {
	      normal_defined = 1;
	      (*temp)->nx[i][0] = xx1;
	      (*temp)->nx[i][1] = yy1;
	      (*temp)->nx[i][2] = zz1;
	    }
	}
      for(i = 0; i < np; i++)
	{
	  (void)fscanf(fp,"%d",&j);
	  (*temp)->nn[i] = (int *)malloc((unsigned)(j+1)*sizeof(int));
	  (*temp)->nn[i][0] = j;
	  for(k = 0; k < j; k++)
	    {
	      (void)fscanf(fp,"%d",&l);
	      if(l < start_index) start_index = l;
	      (*temp)->nn[i][k+1] = l;
	    }
	  jj++;
	}
      /*
       * check the vertex index, can be start at 0 or 1 or ...
       */
      if(start_index > 0)
	{
	  for(i = 0; i < np; i++)
	    {
	      for(k = 0; k < (*temp)->nn[i][0]; k++)
		(*temp)->nn[i][k+1] -= start_index;
	    }
	}
      for(i = 0; i < np; i++) 
	{
	  j = (*temp)->nn[i][0];
	  if(!normal_defined) {
	    for(k = 0; k < j; k++) {
	      if( k == 0)
		{
		  x0 = (*temp)->x[(*temp)->nn[i][2]][0]
		    -  (*temp)->x[(*temp)->nn[i][1]][0];
		  y5 = (*temp)->x[(*temp)->nn[i][2]][1]
		    -  (*temp)->x[(*temp)->nn[i][1]][1];
		  z0 = (*temp)->x[(*temp)->nn[i][2]][2]
		    -  (*temp)->x[(*temp)->nn[i][1]][2];
		  xx0 = (*temp)->x[(*temp)->nn[i][j]][0]
		    -  (*temp)->x[(*temp)->nn[i][1]][0];
		  yy5 = (*temp)->x[(*temp)->nn[i][j]][1]
		    -  (*temp)->x[(*temp)->nn[i][1]][1];
		  zz0 = (*temp)->x[(*temp)->nn[i][j]][2]
		    -  (*temp)->x[(*temp)->nn[i][1]][2];
		}
	      else if(k == j-1)
		{
		  x0 = (*temp)->x[(*temp)->nn[i][1]][0]
		    -  (*temp)->x[(*temp)->nn[i][j]][0];
		  y5 = (*temp)->x[(*temp)->nn[i][1]][1]
		    -  (*temp)->x[(*temp)->nn[i][j]][1];
		  z0 = (*temp)->x[(*temp)->nn[i][1]][2]
		    -  (*temp)->x[(*temp)->nn[i][j]][2];
		  xx0 = (*temp)->x[(*temp)->nn[i][j-1]][0]
		    -  (*temp)->x[(*temp)->nn[i][j]][0];
		  yy5 = (*temp)->x[(*temp)->nn[i][j-1]][1]
		    -  (*temp)->x[(*temp)->nn[i][j]][1];
		  zz0 = (*temp)->x[(*temp)->nn[i][j-1]][2]
		    -  (*temp)->x[(*temp)->nn[i][j]][2];
		}
	      else
		{
		  x0 = (*temp)->x[(*temp)->nn[i][k+2]][0]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][0];
		  y5 = (*temp)->x[(*temp)->nn[i][k+2]][1]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][1];
		  z0 = (*temp)->x[(*temp)->nn[i][k+2]][2]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][2];
		  xx0 = (*temp)->x[(*temp)->nn[i][k]][0]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][0];
		  yy5 = (*temp)->x[(*temp)->nn[i][k]][1]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][1];
		  zz0 = (*temp)->x[(*temp)->nn[i][k]][2]
		    -  (*temp)->x[(*temp)->nn[i][k+1]][2];
		}
	      nx = y5 * zz0 - z0 * yy5;
	      ny = z0 * xx0 - x0 * zz0;
	      nz = x0 * yy5 - y5 * xx0;
	      xx0 = oren * fsqrt(nx *nx + ny * ny + nz * nz);
	      if( fabs(xx0)>= 0.0)
		{
		  nx /= xx0; ny /= xx0, nz /= xx0;
		}
	      else
		{
		  nx = 0.0; ny = 0.0; nz = 1.0;
		}
	      nx += (*temp)->nx[ (*temp)->nn[i][k+1]][0] ;
	      ny += (*temp)->nx[ (*temp)->nn[i][k+1]][1] ;
	      nz += (*temp)->nx[ (*temp)->nn[i][k+1]][2] ;
	      xx0 = fsqrt(nx *nx + ny * ny + nz * nz);
	      if( fabs(xx0)>= 0.0)
		{	  
		  (*temp)->nx[ (*temp)->nn[i][k+1]][0] = nx / xx0;
		  (*temp)->nx[ (*temp)->nn[i][k+1]][1] = ny / xx0;
		  (*temp)->nx[ (*temp)->nn[i][k+1]][2] = nz / xx0;
		}
	      else
		{
		  (*temp)->nx[ (*temp)->nn[i][k+1]][0] = 0.0;
		  (*temp)->nx[ (*temp)->nn[i][k+1]][1] = 0.0;
		  (*temp)->nx[ (*temp)->nn[i][k+1]][2] = 1.0;
		}
	    }
	  }
	}
      (void)fgets(line, 100, fp);
      temp = &( (*temp)->next);
    }
  if(axes != (struct uaxes *)0)
    centerlize_axes(axes,cen_x,cen_y,cen_z);

}
/*******************************************************************/
toggle_color_mode(kk,rand_t,what)
     int kk,rand_t,what;
{
  int i,j;

  if(graph[kk].data_type == GRID_DATA)
    {
      j = 0;
      for(i=0; i < graph[kk].picture.surface.sample;i++) {
	for(j=0; j < graph[kk].picture.surface.sample1;j++) {
	  if( !(i%3) || !(j%3)) {
	    if(!what)
	      set_rgb_color(graph[kk].picture.surface.snx[i][j],rand_t);
	    else
	      back_to_normal(graph[kk].picture.surface.snx[i][j],rand_t);
	  }
	}
      }
    }
  else  if(graph[kk].data_type == POLYGON_DATA)
    {
      struct a_polygon *t_p;
      t_p = graph[kk].picture.surface.poly;
      while(t_p)
	{
	  for(i = 0; i < t_p->num_points; i++) {
	    if( !((i+1)%3)) {
	      if(!what)
		set_rgb_color( t_p->norm[i],rand_t);
	      else
		back_to_normal( t_p->norm[i],rand_t);
	    }
	  }
	  t_p = t_p->next;
	}
    }
  else  if(graph[kk].data_type == CVN_DATA)
    {
      struct a_cvn_point *t_cvn;
      int done_flag = 1;
      t_cvn = graph[kk].picture.surface.cvn;
      while(t_cvn)
	{
	  if( ((t_cvn->c) == 'n'))
	    {
	      if(!(done_flag%4)) {
		if(!what)
		  set_rgb_color( t_cvn->x,rand_t);
		else
		  back_to_normal( t_cvn->x,rand_t);
	      }
	      done_flag++;
	    }
	  else if( t_cvn->c == 'p')
	    done_flag = 1;
	  t_cvn = t_cvn->next;
	}
    }
  else  if(graph[kk].data_type == FEA_POLYGON)
    {
      struct fea_poly **temp;
      temp = &(graph[kk].picture.surface.fea_poly);
      while( (*temp))
	{
	for(j=0; j < (*temp)->nv;j++) {
	  if( !( (j+1)%4)) {
	    if(!what)
	      set_rgb_color( (*temp)->nx[j], rand_t);
	    else
	      back_to_normal( (*temp)->nx[j], rand_t);
	  }
	}
	temp  = &( (*temp)-> next);
      }
    }
}
/******************************************************************/
toggle_color_mode_tmesh(mm,rand_t,what)
     int mm,rand_t,what;
{
  int i,j;

  for(i = 0; i < graph[mm].picture.tmesh.sample; i++) 
    {
      for(j = 0; j < graph[mm].picture.tmesh.sample1; j++){
	if(!( j % 3)) 
	  {
	    if(!what)
	      set_rgb_color( graph[mm].picture.tmesh.snx[i][j],rand_t);
	    else
	      back_to_normal( graph[mm].picture.tmesh.snx[i][j],rand_t);
	  }
      }
    }
}
/***********************************************************************/
back_to_normal(ff,c_flag)
     float *ff; int c_flag;
{
  float x0,y5,z0;

  x0 = ff[0]; y5 = ff[1]; z0 = ff[2];

  if(c_flag == 1)
    {
      ff[0] = (x0 - 0.99) * 10000.0;
      ff[1] = 10000.0 * y5;
      ff[2] = 10000.0 * z0;
    }
  else if(c_flag == 2)
    {
      ff[0] = 10000.0 * x0;
      ff[1] = 10000.0 * (y5 - 0.99);
      ff[2] = 10000.0 * z0;
    }
  else if(c_flag == 3)
    {
      ff[0] = 10000.0 * x0;
      ff[1] = 10000.0 * y5;
      ff[2] = 10000.0 * (z0 - 0.99);
    }
  else if(c_flag == 4)
    {
      ff[0] = 10000.0 * (x0 - 0.99);
      ff[1] = 10000.0 * (y5 - 0.99);
      ff[2] = 10000.0 * z0;
    }
    else if(c_flag == 5)
    {
      ff[0] = 10000.0 * (x0 - 0.99);
      ff[1] = 10000.0 * y5;
      ff[2] = 10000.0 * (z0 - 0.99);
    }
  else if(c_flag == 6)
    {
      ff[0] = 10000.0 * x0;
      ff[1] = 10000.0 * (y5 - 0.99);
      ff[2] = 10000.0 * (z0 - 0.99);
    }
  else if(c_flag == 7)
    {
      ff[0] = 10000.0 * (x0 - 0.99);
      ff[1] = 10000.0 * (y5 - 0.99);
      ff[2] = 10000.0 * (z0 - 0.99);
    }
}
/********************************************************/
set_rgb_color(ff,c_flag)
     float *ff; int c_flag;
{
  float x0,y5,z0;

  x0 = ff[0]; y5 = ff[1]; z0 = ff[2];

  if(c_flag == 1)
    {
      ff[0] = 0.99 + 0.0001 * x0;
      ff[1] = 0.0001 * y5;
      ff[2] = 0.0001 * z0;
    }
  else if(c_flag == 2)
    {
      ff[0] = 0.0001 * x0;
      ff[1] = 0.99 + 0.0001 * y5;
      ff[2] = 0.0001 * z0;
    }
  else if(c_flag == 3)
    {
      ff[0] = 0.0001 * x0;
      ff[1] = 0.0001 * y5;
      ff[2] = 0.99 + 0.0001 * z0;
    }
  else if(c_flag == 4)
    {
      ff[0] = 0.99 + 0.0001 * x0;
      ff[1] = 0.99 + 0.0001 * y5;
      ff[2] = 0.0001 * z0;
    }
    else if(c_flag == 5)
    {
      ff[0] = 0.99 + 0.0001 * x0;
      ff[1] = 0.0001 * y5;
      ff[2] = 0.99 + 0.0001 * z0;
    }
  else if(c_flag == 6)
    {
      ff[0] = 0.0001 * x0;
      ff[1] = 0.99 + 0.0001 * y5;
      ff[2] = 0.99 + 0.0001 * z0;
    }
  else if(c_flag == 7)
    {
      ff[0] = 0.99 + 0.0001 * x0;
      ff[1] = 0.99 + 0.0001 * y5;
      ff[2] = 0.99 + 0.0001 * z0;
    }
}
/********************************************************/
centerlize_axes(axes,cen_x,cen_y,cen_z)
     struct uaxes *axes;
     float cen_x,cen_y,cen_z;
{
  if(axes == (struct uaxes *)0) return;

  axes->ox -= cen_x;
  axes->oy -= cen_y;
  axes->oz -= cen_z;

  axes->xx -= cen_x;
  axes->xy -= cen_y;
  axes->xz -= cen_z;

  axes->yx -= cen_x;
  axes->yy -= cen_y;
  axes->yz -= cen_z;

  axes->zx -= cen_x;
  axes->zy -= cen_y;
  axes->zz -= cen_z;
}
/**************************************************************/
