/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.io;

import java.io.IOException;
import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryReader;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.file.visitor.ResourceJavaReferenceCollector;

public class ResourceFileDataEntryReader
implements DataEntryReader {
    private final ResourceFileVisitor resourceFileVisitor;
    private final DataEntryFilter adaptedDataEntryFilter;

    public ResourceFileDataEntryReader(ResourceFileVisitor resourceFileVisitor) {
        this(resourceFileVisitor, null);
    }

    public ResourceFileDataEntryReader(ResourceFileVisitor resourceFileVisitor, DataEntryFilter adaptedDataEntryFilter) {
        this.resourceFileVisitor = resourceFileVisitor;
        this.adaptedDataEntryFilter = adaptedDataEntryFilter;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        if (!dataEntry.isDirectory()) {
            ResourceFile resourceFile = new ResourceFile(dataEntry.getName(), 0L);
            if (this.adaptedDataEntryFilter != null && this.adaptedDataEntryFilter.accepts(dataEntry)) {
                ResourceJavaReferenceCollector resourceJavaReferenceCollector = new ResourceJavaReferenceCollector();
                resourceJavaReferenceCollector.read(dataEntry);
                resourceFile.references = resourceJavaReferenceCollector.getReferences();
            }
            this.resourceFileVisitor.visitResourceFile(resourceFile);
        }
    }
}

