/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.reference;

import java.util.Comparator;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmLocalVariableLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;

public class JvmReferenceAbstractState
extends JvmAbstractState<SetAbstractState<Reference>> {
    public JvmReferenceAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<SetAbstractState<Reference>> frame, JvmHeapAbstractState<SetAbstractState<Reference>> heap, MapAbstractState<String, SetAbstractState<Reference>> staticFields) {
        super(programLocation, frame, heap, staticFields);
    }

    @Override
    public SetAbstractState<Reference> getVariableOrDefault(int index, SetAbstractState<Reference> defaultState) {
        if (index < this.frame.getLocalVariables().size()) {
            return super.getVariableOrDefault(index, defaultState);
        }
        return new SetAbstractState<Reference>(new Reference(this.getMethodEntryNode(), new JvmLocalVariableLocation(index)));
    }

    @Override
    public SetAbstractState<Reference> getStaticOrDefault(String fqn, SetAbstractState<Reference> defaultState) {
        if (this.staticFields.containsKey(fqn)) {
            return super.getStaticOrDefault(fqn, defaultState);
        }
        return new SetAbstractState<Reference>(new Reference(JvmUnknownCfaNode.INSTANCE, new JvmStaticFieldLocation(fqn)));
    }

    @Override
    public SetAbstractState<Reference> getFieldOrDefault(SetAbstractState<Reference> object, String descriptor, SetAbstractState<Reference> defaultValue) {
        return super.getFieldOrDefault(object, descriptor, defaultValue);
    }

    @Override
    public JvmReferenceAbstractState join(JvmAbstractState<SetAbstractState<Reference>> abstractState) {
        JvmReferenceAbstractState answer = new JvmReferenceAbstractState(this.programLocation.equals(abstractState.getProgramLocation()) ? this.programLocation : topLocation, this.frame.join(abstractState.getFrame()), this.heap.join(abstractState.getHeap()), this.staticFields.join(abstractState.getStaticFields()));
        return this.equals(answer) ? this : answer;
    }

    @Override
    public JvmReferenceAbstractState copy() {
        return new JvmReferenceAbstractState(this.programLocation, (JvmFrameAbstractState<SetAbstractState<Reference>>)this.frame.copy(), (JvmHeapAbstractState<SetAbstractState<Reference>>)this.heap.copy(), (MapAbstractState<String, SetAbstractState<Reference>>)this.staticFields.copy());
    }

    private JvmCfaNode getMethodEntryNode() {
        JvmCfaNode result = this.programLocation;
        while (result.getOffset() != 0) {
            result = result.getEnteringEdges().stream().map(JvmCfaEdge::getSource).min(Comparator.comparingInt(JvmCfaNode::getOffset)).get();
        }
        return result;
    }
}

