/* anchor.tsx generated by @compiled/babel-plugin v0.36.1 */
import _extends from "@babel/runtime/helpers/extends";
import _typeof from "@babel/runtime/helpers/typeof";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["href", "children", "onClick", "interactionName", "componentName", "analyticsContext", "aria-label", "aria-labelledby", "style", "target", "testId", "xcss", "newWindowLabel"],
  _excluded2 = ["className"];
import "./anchor.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
import { forwardRef, useCallback, useContext } from 'react';
import { cx } from '@compiled/react';
import invariant from 'tiny-invariant';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next';
import { useRouterLink } from '@atlaskit/app-provider';
import noop from '@atlaskit/ds-lib/noop';
import { useId } from '@atlaskit/ds-lib/use-id';
import InteractionContext from '@atlaskit/interaction-context';
import VisuallyHidden from '@atlaskit/visually-hidden';
import Focusable from './focusable';
var styles = {
  root: "_4bfu1r31 _1hms8stv _ajmmnqa1 _vchhusvi"
};
var IS_EXTERNAL_LINK_REGEX = /^(?:(http|https):\/\/)/;
var IS_NON_HTTP_BASED = /^(((mailto|tel|sms|blob):)|(#))/;

/**
 * __Anchor__
 *
 * A primitive for building custom anchor links.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
var AnchorNoRef = function AnchorNoRef(_ref, ref) {
  var href = _ref.href,
    children = _ref.children,
    _ref$onClick = _ref.onClick,
    providedOnClick = _ref$onClick === void 0 ? noop : _ref$onClick,
    interactionName = _ref.interactionName,
    componentName = _ref.componentName,
    analyticsContext = _ref.analyticsContext,
    ariaLabel = _ref['aria-label'],
    ariaLabelledBy = _ref['aria-labelledby'],
    style = _ref.style,
    target = _ref.target,
    testId = _ref.testId,
    xcss = _ref.xcss,
    _ref$newWindowLabel = _ref.newWindowLabel,
    newWindowLabel = _ref$newWindowLabel === void 0 ? '(opens new window)' : _ref$newWindowLabel,
    htmlAttributes = _objectWithoutProperties(_ref, _excluded);
  var interactionContext = useContext(InteractionContext);
  var handleClick = useCallback(function (e, analyticsEvent) {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  var opensNewWindowLabelId = useId();
  var onClick = usePlatformLeafEventHandler({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Anchor',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'link'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = _objectWithoutProperties(htmlAttributes, _excluded2);
  var RouterLink = useRouterLink();
  var isExternal = typeof href === 'string' && IS_EXTERNAL_LINK_REGEX.test(href);
  var isNonHttpBased = typeof href === 'string' && IS_NON_HTTP_BASED.test(href);

  /**
   * Renders a router link if:
   *
   * - a link component is set in the app provider
   * - it's not an external link (starting with `http://` or `https://`)
   * - it's not a non-HTTP-based link (e.g. emails, phone numbers, hash links etc.).
   */
  var isRouterLink = RouterLink && !isExternal && !isNonHttpBased;
  var hrefObjectUsedWithoutRouterLink = RouterLink === undefined && _typeof(href) === 'object';
  invariant(!hrefObjectUsedWithoutRouterLink, "@atlaskit/primitives: Anchor primitive cannot pass an object to 'href' unless a router link is configured in the AppProvider");
  var Component = isRouterLink ? RouterLink : 'a';
  return /*#__PURE__*/React.createElement(Focusable
  // @ts-expect-error we don't allow `a` on Focusable for makers as they should use Anchor instead
  , _extends({
    as: Component,
    className: xcss
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- TODO: Properly type this and allow pass-through if we can determine the type
    ,
    style: style,
    ref: ref
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, safeHtmlAttributes, {
    href: !isRouterLink && typeof href !== 'string' ? undefined : href,
    target: target,
    onClick: onClick,
    "aria-label": ariaLabel && target === '_blank' && !ariaLabelledBy ? "".concat(ariaLabel, " , ").concat(newWindowLabel) : ariaLabel,
    "aria-labelledby": ariaLabelledBy && target === '_blank' ? "".concat(ariaLabelledBy, " ").concat(opensNewWindowLabelId) : ariaLabelledBy,
    xcss: cx(styles.root, xcss),
    testId: testId,
    "data-is-router-link": testId ? isRouterLink ? 'true' : 'false' : undefined
  }), children, target === '_blank' && (children && !ariaLabel && !ariaLabelledBy || ariaLabelledBy) && /*#__PURE__*/React.createElement(VisuallyHidden, {
    id: opensNewWindowLabelId
  }, ", ".concat(newWindowLabel)));
};

// Workarounds to support generic types with forwardRef
/**
 * __Anchor__
 *
 * Anchor is a primitive for building custom anchor links. It's a wrapper around the HTML `<a>` element that provides a consistent API for handling client-side routing and Atlassian Design System styling.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
var Anchor = /*#__PURE__*/forwardRef(AnchorNoRef);
export default Anchor;