// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
import { css as cssEmotion } from '@emotion/react';
import { allSpaceMap, backgroundColorMap, borderColorMap, borderRadiusMap, borderWidthMap, dimensionMap, fontFamilyMap, fontMap, fontWeightMap, layerMap, opacityMap, positiveSpaceMap, shadowMap, textColorMap } from './style-maps.partial';
export const tokensMap = {
  backgroundColor: backgroundColorMap,
  blockSize: dimensionMap,
  borderBlockColor: borderColorMap,
  borderBlockEndColor: borderColorMap,
  borderBlockEndWidth: borderWidthMap,
  borderBlockStartColor: borderColorMap,
  borderBlockStartWidth: borderWidthMap,
  borderBlockWidth: borderWidthMap,
  borderBottomColor: borderColorMap,
  borderBottomLeftRadius: borderRadiusMap,
  borderBottomRightRadius: borderRadiusMap,
  borderBottomWidth: borderWidthMap,
  borderColor: borderColorMap,
  borderEndEndRadius: borderRadiusMap,
  borderEndStartRadius: borderRadiusMap,
  borderInlineColor: borderColorMap,
  borderInlineEndColor: borderColorMap,
  borderInlineEndWidth: borderWidthMap,
  borderInlineStartColor: borderColorMap,
  borderInlineStartWidth: borderWidthMap,
  borderInlineWidth: borderWidthMap,
  borderLeftColor: borderColorMap,
  borderLeftWidth: borderWidthMap,
  borderRadius: borderRadiusMap,
  borderRightColor: borderColorMap,
  borderRightWidth: borderWidthMap,
  borderStartEndRadius: borderRadiusMap,
  borderStartStartRadius: borderRadiusMap,
  borderTopColor: borderColorMap,
  borderTopLeftRadius: borderRadiusMap,
  borderTopRightRadius: borderRadiusMap,
  borderTopWidth: borderWidthMap,
  borderWidth: borderWidthMap,
  bottom: allSpaceMap,
  boxShadow: shadowMap,
  color: textColorMap,
  columnGap: positiveSpaceMap,
  font: fontMap,
  fontFamily: fontFamilyMap,
  fontWeight: fontWeightMap,
  gap: positiveSpaceMap,
  height: dimensionMap,
  inlineSize: dimensionMap,
  inset: allSpaceMap,
  insetBlock: allSpaceMap,
  insetBlockEnd: allSpaceMap,
  insetBlockStart: allSpaceMap,
  insetInline: allSpaceMap,
  insetInlineEnd: allSpaceMap,
  insetInlineStart: allSpaceMap,
  left: allSpaceMap,
  margin: allSpaceMap,
  marginBlock: allSpaceMap,
  marginBlockEnd: allSpaceMap,
  marginBlockStart: allSpaceMap,
  marginBottom: allSpaceMap,
  marginInline: allSpaceMap,
  marginInlineEnd: allSpaceMap,
  marginInlineStart: allSpaceMap,
  marginLeft: allSpaceMap,
  marginRight: allSpaceMap,
  marginTop: allSpaceMap,
  maxBlockSize: dimensionMap,
  maxHeight: dimensionMap,
  maxInlineSize: dimensionMap,
  maxWidth: dimensionMap,
  minBlockSize: dimensionMap,
  minHeight: dimensionMap,
  minInlineSize: dimensionMap,
  minWidth: dimensionMap,
  opacity: opacityMap,
  outlineColor: borderColorMap,
  outlineOffset: allSpaceMap,
  outlineWidth: borderWidthMap,
  padding: positiveSpaceMap,
  paddingBlock: positiveSpaceMap,
  paddingBlockEnd: positiveSpaceMap,
  paddingBlockStart: positiveSpaceMap,
  paddingBottom: positiveSpaceMap,
  paddingInline: positiveSpaceMap,
  paddingInlineEnd: positiveSpaceMap,
  paddingInlineStart: positiveSpaceMap,
  paddingLeft: positiveSpaceMap,
  paddingRight: positiveSpaceMap,
  paddingTop: positiveSpaceMap,
  right: allSpaceMap,
  rowGap: positiveSpaceMap,
  top: allSpaceMap,
  width: dimensionMap,
  zIndex: layerMap
};
const uniqueSymbol = Symbol('UNSAFE_INTERNAL_styles');
const isSafeEnvToThrow = () => typeof process === 'object' && typeof process.env === 'object' && process.env.NODE_ENV !== 'production';
const reNestedSelectors = /(\.|\s|&+|\*\>|#|\[.*\])/;
const safeSelectors = /^@media .*$|^::?.*$|^@supports .*$/;
const transformStyles = styleObj => {
  if (!styleObj || typeof styleObj !== 'object') {
    return styleObj;
  }

  // If styles are defined as a CSSObject[], recursively call on each element until we reach CSSObject
  if (Array.isArray(styleObj)) {
    return styleObj.map(transformStyles);
  }

  // Modifies styleObj in place. Be careful.
  Object.entries(styleObj).forEach(([key, value]) => {
    // If key is a pseudo class or a pseudo element, then value should be an object.
    // So, call transformStyles on the value
    if (typeof value === 'object' && safeSelectors.test(key)) {
      styleObj[key] = transformStyles(value);
      return;
    }
    if (isSafeEnvToThrow()) {
      // We don't support `.class`, `[data-testid]`, `> *`, `#some-id`
      if (reNestedSelectors.test(key)) {
        throw new Error(`Styles not supported for key '${key}'.`);
      }
    }

    // We have now dealt with all the special cases, so,
    // check whether what remains is a style property
    // that can be transformed.
    if (!(key in tokensMap)) {
      return;
    }
    const tokenValue = tokensMap[key][value];
    styleObj[key] = tokenValue !== null && tokenValue !== void 0 ? tokenValue : value;
  });
  return styleObj;
};
const baseXcss = style => {
  const transformedStyles = transformStyles(style);
  return {
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-unsafe-values, @atlaskit/ui-styling-standard/no-imported-style-values -- Ignored via go/DSP-18766
    [uniqueSymbol]: cssEmotion(transformedStyles)
  };
};

/**
 * Picks out runtime XCSS objects and build-time XCSS strings. This is needed
 * to supported both Emotion and Compiled styles until we've fully migrated
 * to Compiled.
 *
 * @private
 * @deprecated
 */
export const parseXcss = args => {
  if (Array.isArray(args)) {
    const emotion = [];
    const staticArr = [];
    for (const arg of args) {
      const result = parseXcss(arg);
      if (result.emotion) {
        emotion.push(...result.emotion);
      }
      if (result.static) {
        staticArr.push(result.static);
      }
    }
    return {
      emotion,
      static: staticArr.join(' ')
    };
  }
  const objArgs = args;
  const {
    [uniqueSymbol]: styles
  } = objArgs || {};
  if (styles) {
    return {
      emotion: [styles]
    };
  }
  if (args) {
    // We use string interpolation here instead of .toString() just
    // in case the resulting object doesn't have the method available.
    const stringifiedArgs = `${args}`;
    if (stringifiedArgs) {
      return {
        static: stringifiedArgs
      };
    }
  }
  return {};
};

// Media queries should not contain nested media queries

// Allow only a specific subset of chained selectors to maintain workable TypeScript performance

// Pseudos should not contain nested pseudos, or media queries

/**
 * ### xcss
 *
 * `xcss` is a safer, tokens-first approach to CSS-in-JS. It allows token-backed values for
 * CSS application.
 *
 * ```tsx
 * const styles = xcss({
 *   padding: 'space.100'
 * })
 * ```
 */
export function xcss(style) {
  return baseXcss(style);
}