/* hide.tsx generated by @compiled/babel-plugin v0.36.1 */
import "./hide.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
const styles = {
  'above.xs': "_114bglyw",
  'above.sm': "_181nglyw",
  'above.md': "_dm25glyw",
  'above.lg': "_je3oglyw",
  'above.xl': "_1uxvglyw",
  'below.xs': "_1m0aglyw",
  'below.sm': "_sugaglyw",
  'below.md': "_1mjbglyw",
  'below.lg': "_liwcglyw",
  'below.xl': "_14wzglyw"
};
/**
 * Hides the content at a given breakpoint.  By default, content is shown.  The primary use case is for visual presentation.
 * Mix `<Hide above="md">` with `<Show above="md">` to achieve content that shifts at a breakpoint.
 *
 * Please note:
 * - This only uses `display: none` hide, it does not skip rendering of children trees.
 * - As this is rendered at all times, there is little performance savings here (just that this is not painted).
 */
export const Hide = ({
  above,
  below,
  children,
  as: AsElement = 'div',
  xcss
}) => {
  return /*#__PURE__*/React.createElement(AsElement, {
    className: ax([above && styles[`above.${above}`], below && styles[`below.${below}`], xcss])
  }, children);
};