/* pressable.tsx generated by @compiled/babel-plugin v0.36.1 */
import _extends from "@babel/runtime/helpers/extends";
import "./pressable.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
import { forwardRef, useCallback, useContext } from 'react';
import { cx } from '@compiled/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next';
import { isSafari } from '@atlaskit/ds-lib/device-check';
import noop from '@atlaskit/ds-lib/noop';
import InteractionContext from '@atlaskit/interaction-context';
import Focusable from './focusable';
const styles = {
  root: "_19itglyw _vchhusvi _r06hglyw _80omtlke",
  disabled: "_80om13gf"
};

/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
const Pressable = /*#__PURE__*/forwardRef(({
  children,
  isDisabled,
  type = 'button',
  onClick: providedOnClick = noop,
  interactionName,
  componentName,
  analyticsContext,
  style,
  testId,
  xcss,
  tabIndex,
  ...htmlAttributes
}, ref) => {
  const interactionContext = useContext(InteractionContext);
  const handleClick = useCallback((e, analyticsEvent) => {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  const onClick = usePlatformLeafEventHandler({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Pressable',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'button'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  const {
    className: _spreadClass,
    ...safeHtmlAttributes
  } = htmlAttributes;
  return /*#__PURE__*/React.createElement(Focusable
  // @ts-expect-error we don't allow `button` on Focusable for makers as they should use Pressable instead
  , _extends({
    as: "button"
    // Safari does not apply focus to buttons on click like other browsers, which means click events will not be fired.
    // Adding a tabIndex of 0 to the button will allow it to be focused on click.
    // This is a known issue in Safari that is meant to be "intended", see https://bugs.webkit.org/show_bug.cgi?id=22261
    ,
    tabIndex: tabIndex !== null && tabIndex !== void 0 ? tabIndex : isSafari() && !isDisabled ? 0 : undefined
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- TODO: Properly type this and allow pass-through if we can determine the type
    ,
    style: style
  }, safeHtmlAttributes, {
    type: type,
    onClick: onClick,
    disabled: isDisabled,
    xcss: cx(styles.root, isDisabled && styles.disabled, xcss),
    testId: testId,
    ref: ref
  }), children);
});
export default Pressable;