"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tokensMap = exports.parseXcss = void 0;
exports.xcss = xcss;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _react = require("@emotion/react");
var _styleMaps = require("./style-maps.partial");
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } // eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766
var tokensMap = exports.tokensMap = {
  backgroundColor: _styleMaps.backgroundColorMap,
  blockSize: _styleMaps.dimensionMap,
  borderBlockColor: _styleMaps.borderColorMap,
  borderBlockEndColor: _styleMaps.borderColorMap,
  borderBlockEndWidth: _styleMaps.borderWidthMap,
  borderBlockStartColor: _styleMaps.borderColorMap,
  borderBlockStartWidth: _styleMaps.borderWidthMap,
  borderBlockWidth: _styleMaps.borderWidthMap,
  borderBottomColor: _styleMaps.borderColorMap,
  borderBottomLeftRadius: _styleMaps.borderRadiusMap,
  borderBottomRightRadius: _styleMaps.borderRadiusMap,
  borderBottomWidth: _styleMaps.borderWidthMap,
  borderColor: _styleMaps.borderColorMap,
  borderEndEndRadius: _styleMaps.borderRadiusMap,
  borderEndStartRadius: _styleMaps.borderRadiusMap,
  borderInlineColor: _styleMaps.borderColorMap,
  borderInlineEndColor: _styleMaps.borderColorMap,
  borderInlineEndWidth: _styleMaps.borderWidthMap,
  borderInlineStartColor: _styleMaps.borderColorMap,
  borderInlineStartWidth: _styleMaps.borderWidthMap,
  borderInlineWidth: _styleMaps.borderWidthMap,
  borderLeftColor: _styleMaps.borderColorMap,
  borderLeftWidth: _styleMaps.borderWidthMap,
  borderRadius: _styleMaps.borderRadiusMap,
  borderRightColor: _styleMaps.borderColorMap,
  borderRightWidth: _styleMaps.borderWidthMap,
  borderStartEndRadius: _styleMaps.borderRadiusMap,
  borderStartStartRadius: _styleMaps.borderRadiusMap,
  borderTopColor: _styleMaps.borderColorMap,
  borderTopLeftRadius: _styleMaps.borderRadiusMap,
  borderTopRightRadius: _styleMaps.borderRadiusMap,
  borderTopWidth: _styleMaps.borderWidthMap,
  borderWidth: _styleMaps.borderWidthMap,
  bottom: _styleMaps.allSpaceMap,
  boxShadow: _styleMaps.shadowMap,
  color: _styleMaps.textColorMap,
  columnGap: _styleMaps.positiveSpaceMap,
  font: _styleMaps.fontMap,
  fontFamily: _styleMaps.fontFamilyMap,
  fontWeight: _styleMaps.fontWeightMap,
  gap: _styleMaps.positiveSpaceMap,
  height: _styleMaps.dimensionMap,
  inlineSize: _styleMaps.dimensionMap,
  inset: _styleMaps.allSpaceMap,
  insetBlock: _styleMaps.allSpaceMap,
  insetBlockEnd: _styleMaps.allSpaceMap,
  insetBlockStart: _styleMaps.allSpaceMap,
  insetInline: _styleMaps.allSpaceMap,
  insetInlineEnd: _styleMaps.allSpaceMap,
  insetInlineStart: _styleMaps.allSpaceMap,
  left: _styleMaps.allSpaceMap,
  margin: _styleMaps.allSpaceMap,
  marginBlock: _styleMaps.allSpaceMap,
  marginBlockEnd: _styleMaps.allSpaceMap,
  marginBlockStart: _styleMaps.allSpaceMap,
  marginBottom: _styleMaps.allSpaceMap,
  marginInline: _styleMaps.allSpaceMap,
  marginInlineEnd: _styleMaps.allSpaceMap,
  marginInlineStart: _styleMaps.allSpaceMap,
  marginLeft: _styleMaps.allSpaceMap,
  marginRight: _styleMaps.allSpaceMap,
  marginTop: _styleMaps.allSpaceMap,
  maxBlockSize: _styleMaps.dimensionMap,
  maxHeight: _styleMaps.dimensionMap,
  maxInlineSize: _styleMaps.dimensionMap,
  maxWidth: _styleMaps.dimensionMap,
  minBlockSize: _styleMaps.dimensionMap,
  minHeight: _styleMaps.dimensionMap,
  minInlineSize: _styleMaps.dimensionMap,
  minWidth: _styleMaps.dimensionMap,
  opacity: _styleMaps.opacityMap,
  outlineColor: _styleMaps.borderColorMap,
  outlineOffset: _styleMaps.allSpaceMap,
  outlineWidth: _styleMaps.borderWidthMap,
  padding: _styleMaps.positiveSpaceMap,
  paddingBlock: _styleMaps.positiveSpaceMap,
  paddingBlockEnd: _styleMaps.positiveSpaceMap,
  paddingBlockStart: _styleMaps.positiveSpaceMap,
  paddingBottom: _styleMaps.positiveSpaceMap,
  paddingInline: _styleMaps.positiveSpaceMap,
  paddingInlineEnd: _styleMaps.positiveSpaceMap,
  paddingInlineStart: _styleMaps.positiveSpaceMap,
  paddingLeft: _styleMaps.positiveSpaceMap,
  paddingRight: _styleMaps.positiveSpaceMap,
  paddingTop: _styleMaps.positiveSpaceMap,
  right: _styleMaps.allSpaceMap,
  rowGap: _styleMaps.positiveSpaceMap,
  top: _styleMaps.allSpaceMap,
  width: _styleMaps.dimensionMap,
  zIndex: _styleMaps.layerMap
};
var uniqueSymbol = Symbol('UNSAFE_INTERNAL_styles');
var isSafeEnvToThrow = function isSafeEnvToThrow() {
  return (typeof process === "undefined" ? "undefined" : (0, _typeof2.default)(process)) === 'object' && (0, _typeof2.default)(process.env) === 'object' && process.env.NODE_ENV !== 'production';
};
var reNestedSelectors = /(\.|\s|&+|\*\>|#|\[.*\])/;
var safeSelectors = /^@media .*$|^::?.*$|^@supports .*$/;
var _transformStyles = function transformStyles(styleObj) {
  if (!styleObj || (0, _typeof2.default)(styleObj) !== 'object') {
    return styleObj;
  }

  // If styles are defined as a CSSObject[], recursively call on each element until we reach CSSObject
  if (Array.isArray(styleObj)) {
    return styleObj.map(_transformStyles);
  }

  // Modifies styleObj in place. Be careful.
  Object.entries(styleObj).forEach(function (_ref) {
    var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
      key = _ref2[0],
      value = _ref2[1];
    // If key is a pseudo class or a pseudo element, then value should be an object.
    // So, call transformStyles on the value
    if ((0, _typeof2.default)(value) === 'object' && safeSelectors.test(key)) {
      styleObj[key] = _transformStyles(value);
      return;
    }
    if (isSafeEnvToThrow()) {
      // We don't support `.class`, `[data-testid]`, `> *`, `#some-id`
      if (reNestedSelectors.test(key)) {
        throw new Error("Styles not supported for key '".concat(key, "'."));
      }
    }

    // We have now dealt with all the special cases, so,
    // check whether what remains is a style property
    // that can be transformed.
    if (!(key in tokensMap)) {
      return;
    }
    var tokenValue = tokensMap[key][value];
    styleObj[key] = tokenValue !== null && tokenValue !== void 0 ? tokenValue : value;
  });
  return styleObj;
};
var baseXcss = function baseXcss(style) {
  var transformedStyles = _transformStyles(style);
  return (0, _defineProperty2.default)({}, uniqueSymbol, (0, _react.css)(transformedStyles));
};

/**
 * Picks out runtime XCSS objects and build-time XCSS strings. This is needed
 * to supported both Emotion and Compiled styles until we've fully migrated
 * to Compiled.
 *
 * @private
 * @deprecated
 */
var _parseXcss = exports.parseXcss = function parseXcss(args) {
  if (Array.isArray(args)) {
    var emotion = [];
    var staticArr = [];
    var _iterator = _createForOfIteratorHelper(args),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var arg = _step.value;
        var result = _parseXcss(arg);
        if (result.emotion) {
          emotion.push.apply(emotion, (0, _toConsumableArray2.default)(result.emotion));
        }
        if (result.static) {
          staticArr.push(result.static);
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return {
      emotion: emotion,
      static: staticArr.join(' ')
    };
  }
  var objArgs = args;
  var _ref4 = objArgs || {},
    styles = _ref4[uniqueSymbol];
  if (styles) {
    return {
      emotion: [styles]
    };
  }
  if (args) {
    // We use string interpolation here instead of .toString() just
    // in case the resulting object doesn't have the method available.
    var stringifiedArgs = "".concat(args);
    if (stringifiedArgs) {
      return {
        static: stringifiedArgs
      };
    }
  }
  return {};
};
// Media queries should not contain nested media queries

// Allow only a specific subset of chained selectors to maintain workable TypeScript performance

// Pseudos should not contain nested pseudos, or media queries

/**
 * ### xcss
 *
 * `xcss` is a safer, tokens-first approach to CSS-in-JS. It allows token-backed values for
 * CSS application.
 *
 * ```tsx
 * const styles = xcss({
 *   padding: 'space.100'
 * })
 * ```
 */
function xcss(style) {
  return baseXcss(style);
}