/**
 * Same API as `Promise.withResolvers()` which allows us to get the same
 * outcomes before including `"ES2024.Promise"` in `tsconfig.json: "lib"`
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/withResolvers.
 *
 * Does not support `.call()` on `withResolvers` with non-promise constructors
 *
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise/withResolvers#calling_withresolvers_on_a_non-promise_constructor
 */
export declare function withResolvers<TValue>(): {
    promise: Promise<TValue>;
    resolve: (value: TValue | PromiseLike<TValue>) => void;
    reject: (reason?: any) => void;
};
