"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDropTargetForDraggable = useDropTargetForDraggable;
var _react = require("react");
var _closestEdge = require("@atlaskit/pragmatic-drag-and-drop-hitbox/closest-edge");
var _adapter = require("@atlaskit/pragmatic-drag-and-drop/element/adapter");
var _rbdInvariant = require("../drag-drop-context/rbd-invariant");
var _data = require("../draggable/data");
function useDropTargetForDraggable(_ref) {
  var elementRef = _ref.elementRef,
    data = _ref.data,
    direction = _ref.direction,
    contextId = _ref.contextId,
    isDropDisabled = _ref.isDropDisabled,
    type = _ref.type;
  (0, _react.useEffect)(function () {
    var element = elementRef.current;
    (0, _rbdInvariant.rbdInvariant)(element instanceof HTMLElement);
    return (0, _adapter.dropTargetForElements)({
      element: element,
      getIsSticky: function getIsSticky() {
        return true;
      },
      canDrop: function canDrop(_ref2) {
        var source = _ref2.source;
        if (!(0, _data.isDraggableData)(source.data)) {
          // not dragging something from the migration layer
          // we should not allow dropping
          return false;
        }
        if (isDropDisabled) {
          return false;
        }
        return source.data.type === type && source.data.contextId === contextId;
      },
      getData: function getData(_ref3) {
        var input = _ref3.input;
        return (0, _closestEdge.attachClosestEdge)(data, {
          element: element,
          input: input,
          allowedEdges: direction === 'vertical' ? ['top', 'bottom'] : ['left', 'right']
        });
      }
    });
  }, [data, direction, contextId, isDropDisabled, type, elementRef]);
}