"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragDropContextProvider = DragDropContextProvider;
exports.useDragDropContext = useDragDropContext;
var _react = _interopRequireWildcard(require("react"));
var _rbdInvariant = require("./rbd-invariant");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); return f; })(e, t); }
var DragDropContext = /*#__PURE__*/(0, _react.createContext)(null);
function useDragDropContext() {
  var value = (0, _react.useContext)(DragDropContext);
  (0, _rbdInvariant.rbdInvariant)(value !== null, 'Unable to find DragDropContext context');
  return value;
}
function DragDropContextProvider(_ref) {
  var children = _ref.children,
    contextId = _ref.contextId,
    getDragState = _ref.getDragState,
    startKeyboardDrag = _ref.startKeyboardDrag,
    droppableRegistry = _ref.droppableRegistry;
  var value = (0, _react.useMemo)(function () {
    return {
      contextId: contextId,
      getDragState: getDragState,
      startKeyboardDrag: startKeyboardDrag,
      droppableRegistry: droppableRegistry
    };
  }, [contextId, getDragState, startKeyboardDrag, droppableRegistry]);
  return /*#__PURE__*/_react.default.createElement(DragDropContext.Provider, {
    value: value
  }, children);
}