"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDroppableRegistry = useDroppableRegistry;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
function createDroppableRegistry() {
  var droppableMap = new Map();
  var getEntry = function getEntry(_ref) {
    var _droppableMap$get;
    var droppableId = _ref.droppableId;
    return (_droppableMap$get = droppableMap.get(droppableId)) !== null && _droppableMap$get !== void 0 ? _droppableMap$get : null;
  };
  var updateListener = null;
  var setUpdateListener = function setUpdateListener(listener) {
    updateListener = listener;
  };
  var register = function register(entry) {
    var _updateListener;
    droppableMap.set(entry.droppableId, entry);
    (_updateListener = updateListener) === null || _updateListener === void 0 || _updateListener(entry);
    return function () {
      droppableMap.delete(entry.droppableId);
    };
  };
  return {
    getEntry: getEntry,
    register: register,
    setUpdateListener: setUpdateListener
  };
}
function useDroppableRegistry() {
  var _useState = (0, _react.useState)(createDroppableRegistry),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    droppableRegistry = _useState2[0];
  return droppableRegistry;
}