// Source: https://github.com/atlassian/react-beautiful-dnd

import config from '../../config';

// all in pixels

// converts the percentages in the config into actual pixel values
export const getDistanceThresholds = (container, axis) => {
  const startScrollingFrom = container[axis.size] * config.startFromPercentage;
  const maxScrollValueAt = container[axis.size] * config.maxScrollAtPercentage;
  const thresholds = {
    startScrollingFrom,
    maxScrollValueAt
  };
  return thresholds;
};
export default getDistanceThresholds;