import { type EvaluationDetails as NewEvaluationDetails, SecondaryExposure, type StatsigUser } from '@statsig/js-client';
import { type EvaluationDetails } from './compat/types';
import { type BaseClientOptions, type CustomAttributes, type FeatureGateOptions, type Identifiers, type NewFeatureGateOptions, type OptionsWithDefaults } from './types';
export declare const getOptionsWithDefaults: <T extends BaseClientOptions>(options: T) => OptionsWithDefaults<T>;
export declare const shallowEquals: (objectA?: object, objectB?: object) => boolean;
/**
 * This method creates an instance of StatsigUser from the given set of identifiers and
 * attributes.
 */
export declare const toStatsigUser: (identifiers: Identifiers, customAttributes?: CustomAttributes) => StatsigUser;
export declare const migrateInitializationOptions: <T extends FeatureGateOptions>(options: T) => Omit<T, keyof FeatureGateOptions> & NewFeatureGateOptions;
export declare const migrateEvaluationDetails: (details: NewEvaluationDetails) => EvaluationDetails;
export declare const migrateSecondaryExposures: (secondaryExposures: SecondaryExposure[] | string[]) => Record<string, string>[];
