"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnalyticsEvents = useAnalyticsEvents;
var _useMemoOne = require("use-memo-one");
var _UIAnalyticsEvent = _interopRequireDefault(require("../events/UIAnalyticsEvent"));
var _useAnalyticsContext = require("./useAnalyticsContext");
function useAnalyticsEvents() {
  var analyticsContext = (0, _useAnalyticsContext.useAnalyticsContext)();
  var createAnalyticsEvent = (0, _useMemoOne.useCallbackOne)(function (payload) {
    return new _UIAnalyticsEvent.default({
      context: analyticsContext.getAtlaskitAnalyticsContext(),
      handlers: analyticsContext.getAtlaskitAnalyticsEventHandlers(),
      payload: payload
    });
  }, [analyticsContext]);
  return {
    createAnalyticsEvent: createAnalyticsEvent
  };
}