/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.layout;

import com.jgoodies.layout.layout.Sizes;

public enum Unit {
    PIXEL("px", true),
    EFFECTIVE_PIXEL("epx", true),
    POINT("pt", true),
    DIALOG_UNITS("dlu", true),
    MILLIMETER("mm", false),
    CENTIMETER("cm", false),
    INCH("in", false);

    private final String abbreviation;
    final boolean requiresIntegers;

    private Unit(String abbreviation, boolean requiresIntegers) {
        this.abbreviation = abbreviation;
        this.requiresIntegers = requiresIntegers;
    }

    static Unit decode(String name) {
        if (name.isEmpty()) {
            return Sizes.getDefaultUnit();
        }
        switch (name) {
            case "dlu": {
                return DIALOG_UNITS;
            }
            case "epx": {
                return EFFECTIVE_PIXEL;
            }
            case "px": {
                return PIXEL;
            }
            case "pt": {
                return POINT;
            }
            case "in": {
                return INCH;
            }
            case "mm": {
                return MILLIMETER;
            }
            case "cm": {
                return CENTIMETER;
            }
        }
        throw new IllegalArgumentException("Invalid unit name '" + name + "'. Must be one of: px, epx, dlu, pt, mm, cm, in");
    }

    boolean requiresIntegers() {
        return this.requiresIntegers;
    }

    public String encode() {
        return this.abbreviation;
    }

    public String abbreviation() {
        return this.abbreviation;
    }
}

