/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.jsdl.internal.ScaledIconAccess;
import com.jgoodies.components.internal.PopupIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class TextFieldIcons {
    private static ResourceMap resources;
    private static String resourcePrefix;
    private static String lookAndFeelName;

    private TextFieldIcons() {
    }

    public static Icon getPopupIcon() {
        if (SystemUtils.IS_OS_MAC) {
            return new PopupIcon();
        }
        TextFieldIcons.ensureValidImages();
        return ScaledIconAccess.getIcon(TextFieldIcons.getResources(), TextFieldIcons.getResourcePrefix() + ".popup.image");
    }

    public static Icon getSearchIcon() {
        TextFieldIcons.ensureValidImages();
        return ScaledIconAccess.getIcon(TextFieldIcons.getResources(), TextFieldIcons.getResourcePrefix() + ".search.image");
    }

    public static Icon getSearchIconSmall() {
        TextFieldIcons.ensureValidImages();
        return ScaledIconAccess.getIcon(TextFieldIcons.getResources(), TextFieldIcons.getResourcePrefix() + ".search.image.small");
    }

    public static Icon getClearIcon() {
        TextFieldIcons.ensureValidImages();
        return ScaledIconAccess.getIcon(TextFieldIcons.getResources(), TextFieldIcons.getResourcePrefix() + ".clear.image");
    }

    public static Icon getEllipsisIcon() {
        TextFieldIcons.ensureValidImages();
        return ScaledIconAccess.getIcon(TextFieldIcons.getResources(), TextFieldIcons.getResourcePrefix() + ".ellipsis.image");
    }

    static Icon getButtonIcon(int width, int height) {
        Image buttonImage = TextFieldIcons.getResources().getImage(TextFieldIcons.getResourcePrefix() + ".button.image");
        return new ScalingIcon(buttonImage, TextFieldIcons.getButtonInsets(), width, height);
    }

    static Icon getButtonIconRollover(int width, int height) {
        Image buttonImageRollover = TextFieldIcons.getResources().getImage(TextFieldIcons.getResourcePrefix() + ".button.image.rollover");
        return new ScalingIcon(buttonImageRollover, TextFieldIcons.getButtonInsets(), width, height);
    }

    static Icon getButtonIconPressed(int width, int height) {
        Image buttonImagePressed = TextFieldIcons.getResources().getImage(TextFieldIcons.getResourcePrefix() + ".button.image.pressed");
        return new ScalingIcon(buttonImagePressed, TextFieldIcons.getButtonInsets(), width, height);
    }

    static void ensureValidImages() {
        String currentLookAndFeelName = UIManager.getLookAndFeel().getName();
        if (!currentLookAndFeelName.equals(lookAndFeelName)) {
            resources = null;
            resourcePrefix = null;
            lookAndFeelName = currentLookAndFeelName;
        }
    }

    private static ResourceMap getResources() {
        if (resources == null) {
            resources = Application.getResourceMap(TextFieldIcons.class);
        }
        return resources;
    }

    private static String getResourcePrefix() {
        if (resourcePrefix == null) {
            resourcePrefix = TextFieldIcons.computeResourcePrefix();
        }
        return resourcePrefix;
    }

    private static String computeResourcePrefix() {
        return "metro";
    }

    private static Insets getButtonInsets() {
        return TextFieldIcons.getResources().getInsets(TextFieldIcons.getResourcePrefix() + ".button.insets");
    }

    private static final class ScalingIcon
    implements Icon {
        private final Image image;
        private final Insets insets;
        private final int w;
        private final int h;
        private final int width;
        private final int height;

        ScalingIcon(Image image, Insets insets, int width, int height) {
            this.image = image;
            this.insets = insets;
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
            this.w = width;
            this.h = height;
        }

        @Override
        public int getIconWidth() {
            return this.w;
        }

        @Override
        public int getIconHeight() {
            return this.h;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int t = this.insets.top;
            int l = this.insets.left;
            int b = this.insets.bottom;
            int r = this.insets.right;
            g.translate(x, y);
            g.drawImage(this.image, 0, 0, l, t, 0, 0, l, t, null);
            g.drawImage(this.image, l, 0, this.w - r, t, l, 0, this.width - r, t, null);
            g.drawImage(this.image, this.w - r, 0, this.w, t, this.width - r, 0, this.width, t, null);
            g.drawImage(this.image, 0, t, l, this.h - b, 0, t, l, this.height - b, null);
            g.drawImage(this.image, l, this.h - b, this.w - r, this.h, l, this.height - b, this.width - r, this.height, null);
            g.drawImage(this.image, 0, this.h - b, l, this.h, 0, this.height - b, l, this.height, null);
            g.drawImage(this.image, this.w - r, this.h - b, this.w, this.h, this.width - r, this.height - b, this.width, this.height, null);
            g.drawImage(this.image, this.w - r, t, this.w, this.h - b, this.width - r, t, this.width, this.height - b, null);
            g.drawImage(this.image, l, t, this.w - r, this.h - b, l, t, this.width - r, this.height - b, null);
            g.translate(-x, -y);
        }
    }
}

