/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Task;
import com.jgoodies.application.TaskService;
import com.jgoodies.common.swing.internal.EDTBean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingWorker;

public final class TaskMonitor
extends EDTBean {
    public static final String PROPERTY_FOREGROUND_TASK = "foregroundTask";
    public static final String PROPERTY_AUTO_UPDATE_FOREGROUND_TASK = "autoUpdateForegroundTask";
    public static final String PROPERTY_TASKS = "tasks";
    public static final String PROPERTY_PENDING = "pending";
    public static final String PROPERTY_STARTED = "started";
    public static final String PROPERTY_BACKGROUND_DONE = "backgroundDone";
    public static final String PROPERTY_DONE = "done";
    private final PropertyChangeListener foregroundTaskStateHandler = this::onForegroundTaskChanged;
    private final LinkedList<Task<?, ?>> taskQueue = new LinkedList();
    private Task<?, ?> foregroundTask = null;
    private boolean autoUpdateForegroundTask = true;

    TaskMonitor(TaskService taskService) {
        taskService.addPropertyChangeListener(this::onTaskServiceTasksChanged);
    }

    public Task<?, ?> getForegroundTask() {
        return this.foregroundTask;
    }

    public void setForegroundTask(Task<?, ?> newTask) {
        Task<?, ?> oldTask = this.getForegroundTask();
        if (oldTask != null) {
            oldTask.removePropertyChangeListener(this.foregroundTaskStateHandler);
        }
        this.foregroundTask = oldTask;
        if (newTask != null) {
            newTask.addPropertyChangeListener(this.foregroundTaskStateHandler);
        }
        this.foregroundTask = newTask;
        this.firePropertyChange(PROPERTY_FOREGROUND_TASK, oldTask, newTask);
    }

    public boolean getAutoUpdateForegroundTask() {
        return this.autoUpdateForegroundTask;
    }

    public void setAutoUpdateForegroundTask(boolean newValue) {
        boolean oldValue = this.getAutoUpdateForegroundTask();
        this.autoUpdateForegroundTask = newValue;
        this.firePropertyChange(PROPERTY_AUTO_UPDATE_FOREGROUND_TASK, oldValue, newValue);
    }

    public List<Task<?, ?>> getTasks() {
        return this.copyTaskQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task<?, ?>> copyTaskQueue() {
        LinkedList<Task<?, ?>> linkedList = this.taskQueue;
        synchronized (linkedList) {
            if (this.taskQueue.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList(this.taskQueue);
        }
    }

    private void updateTasks(List<Task<?, ?>> oldTasks, List<Task<?, ?>> newTasks) {
        boolean tasksChanged = false;
        List<Task<?, ?>> oldTaskQueue = this.copyTaskQueue();
        for (Task<?, ?> oldTask : oldTasks) {
            if (newTasks.contains(oldTask) || !this.taskQueue.remove(oldTask)) continue;
            tasksChanged = true;
        }
        for (Task<?, ?> newTask : newTasks) {
            if (this.taskQueue.contains(newTask)) continue;
            this.taskQueue.addLast(newTask);
            tasksChanged = true;
        }
        Iterator tasks = this.taskQueue.iterator();
        while (tasks.hasNext()) {
            Task task = (Task)tasks.next();
            if (!task.isDone()) continue;
            tasks.remove();
            tasksChanged = true;
        }
        if (tasksChanged) {
            List<Task<?, ?>> newTaskQueue = this.copyTaskQueue();
            this.firePropertyChange(PROPERTY_TASKS, oldTaskQueue, newTaskQueue);
        }
        if (this.autoUpdateForegroundTask && this.getForegroundTask() == null) {
            this.setForegroundTask(this.taskQueue.isEmpty() ? null : this.taskQueue.getLast());
        }
    }

    private void onTaskServiceTasksChanged(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (PROPERTY_TASKS.equals(propertyName)) {
            List oldList = (List)e.getOldValue();
            List newList = (List)e.getNewValue();
            this.updateTasks(oldList, newList);
        }
    }

    private void onForegroundTaskChanged(PropertyChangeEvent evt) {
        Task task = (Task)evt.getSource();
        if (task == null || task != this.getForegroundTask()) {
            return;
        }
        PropertyChangeEvent evtWithMonitorSource = new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.firePropertyChange(evtWithMonitorSource);
        if ("extendedState".equals(evt.getPropertyName())) {
            this.fireStateChange(task, PROPERTY_BACKGROUND_DONE);
            return;
        }
        if ("state".equals(evt.getPropertyName())) {
            SwingWorker.StateValue newState = (SwingWorker.StateValue)((Object)evt.getNewValue());
            switch (newState) {
                case PENDING: {
                    this.fireStateChange(task, PROPERTY_PENDING);
                    break;
                }
                case STARTED: {
                    this.fireStateChange(task, PROPERTY_STARTED);
                    break;
                }
                case DONE: {
                    this.fireStateChange(task, PROPERTY_DONE);
                    this.setForegroundTask(null);
                    break;
                }
            }
        }
    }

    private void fireStateChange(Task<?, ?> task, String propertyName) {
        this.firePropertyChange(new PropertyChangeEvent(task, propertyName, Boolean.FALSE, Boolean.TRUE));
    }
}

