// Copyright 2022 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Based on the OpenGL loader generated by glad 0.1.35 on Mon Mar 21 12:42:33 2022.
//
// The original generated code is distributed under CC0.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// Language/Generator: C/C++
// Specification: gl
// APIs: gl=1.5
// Profile: compatibility
// Extensions:
//     GL_ARB_framebuffer_object,
//     GL_ARB_seamless_cube_map,
//     GL_ARB_vertex_buffer_object,
//     GL_KHR_debug
// Loader: True
// Local files: False
// Omit khrplatform: False
// Reproducible: False
//
// Commandline:
//     --profile="compatibility" --api="gl=1.5" --generator="c" --spec="gl" --extensions="GL_ARB_framebuffer_object,GL_ARB_seamless_cube_map,GL_ARB_vertex_buffer_object,GL_KHR_debug"
// Online:
//     https://glad.dav1d.de/#profile=compatibility&language=c&specification=gl&loader=on&api=gl%3D1.5&extensions=GL_ARB_framebuffer_object&extensions=GL_ARB_seamless_cube_map&extensions=GL_ARB_vertex_buffer_object&extensions=GL_KHR_debug

#if !defined(_WIN32) && !defined(__CYGWIN__) && !defined(__APPLE__) && \
    !defined(__HAIKU__) && !defined(_GNU_SOURCE)
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "engine/engine_util_errmem.h"
#include "render/glad/glad.h"

static void* mjGlad_get_proc(const char *namez);

#if defined(_WIN32) || defined(__CYGWIN__)
#ifndef _WINDOWS_
#undef APIENTRY
#endif
#include <windows.h>
static HMODULE mjGlad_libGL;

typedef void* (APIENTRYP PFNWGLGETPROCADDRESSPROC_PRIVATE)(const char*);
static PFNWGLGETPROCADDRESSPROC_PRIVATE mjGladGetProcAddressPtr;

#ifdef _MSC_VER
#ifdef __has_include
  #if __has_include(<winapifamily.h>)
    #define HAVE_WINAPIFAMILY 1
  #endif
#elif _MSC_VER >= 1700 && !_USING_V110_SDK71_
  #define HAVE_WINAPIFAMILY 1
#endif
#endif

#ifdef HAVE_WINAPIFAMILY
  #include <winapifamily.h>
  #if !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) && \
      WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)
    #define IS_UWP 1
  #endif
#endif

static
int mjGlad_open_gl(void) {
#ifndef IS_UWP
  mjGlad_libGL = LoadLibraryW(L"opengl32.dll");
  if(mjGlad_libGL != NULL) {
    void (* tmp)(void);
    tmp = (void(*)(void)) GetProcAddress(mjGlad_libGL, "wglGetProcAddress");
    mjGladGetProcAddressPtr = (PFNWGLGETPROCADDRESSPROC_PRIVATE) tmp;
    return mjGladGetProcAddressPtr != NULL;
  }
#endif

    return 0;
}

static
void mjGlad_close_gl(void) {
  if(mjGlad_libGL != NULL) {
    FreeLibrary((HMODULE) mjGlad_libGL);
    mjGlad_libGL = NULL;
  }
}
#else
#include <dlfcn.h>
static void* mjGlad_libGL;

#if !defined(__APPLE__) && !defined(__HAIKU__)
#include <link.h>

typedef void* (APIENTRYP PFNGLXGETPROCADDRESSPROC_PRIVATE)(const char*);
static PFNGLXGETPROCADDRESSPROC_PRIVATE mjGladGetProcAddressPtr;

typedef enum mjtGLPlatform {
  mjGL_NONE,
  mjGL_GLX,
  mjGL_EGL,
  mjGL_OSMESA
} mjtGLPlatform;

static int mjGlad_str_startswith(const char* s, const char* prefix) {
  for (size_t i = 0; prefix[i] != '\0'; ++i) {
    if (s[i] != prefix[i]) {
      return 0;
    }
  }
  return 1;
}

// There are two versions of basename on a Linux system (see man 3 basename), and one of them can
// modify the original string. To prevent bad things from happening, we implement our own.
// This function assums that s is null-terminated, but since we are only using it with
// dl_phdr_info.dlpi_name that comes from dl_iterate_phdr, this is guaranteed.
static const char* mjGlad_platform_basename(const char* s) {
  const char* last_slash = NULL;
  for (const char* ss = s; *ss != '\0'; ++ss) {
    if (*ss == '/') {
      last_slash = ss;
    }
  }
  return last_slash ? last_slash + 1 : s;
}

// See `man 3 dl_iterate_phdr` for detail on how this works.
static int mjGlad_dl_iterate_callback(struct dl_phdr_info* info, size_t size, void* data) {
  mjtGLPlatform result = mjGL_NONE;
  const char* const libname = mjGlad_platform_basename(info->dlpi_name);
  if (mjGlad_str_startswith(libname, "libGLX.so") || mjGlad_str_startswith(libname, "libGL.so")) {
    result = mjGL_GLX;
  } else if (mjGlad_str_startswith(libname, "libEGL.so")) {
    result = mjGL_EGL;
  } else if (mjGlad_str_startswith(libname, "libOSMesa.so")) {
    result = mjGL_OSMESA;
  }
  if (data) {
    *(const char**)data = result ? info->dlpi_name : NULL;
  }
  return result;
}

static int mjGlad_open_gl(void) {
  mjGladGetProcAddressPtr = NULL;

  // We try to load a GetProcAddress symbol that's already been loaded into the process first.
  // Since MuJoCo relies on user code to set up a working OpenGL environment, one of these symbols
  // may already be present. We go through all supported GetProcAddress functions until we find one.
  void* handle = dlopen(NULL, RTLD_NOW | RTLD_GLOBAL);
  if (handle) {
    // Try EGL.
    mjGladGetProcAddressPtr = (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle,
        "eglGetProcAddress");
    if (mjGladGetProcAddressPtr) { return 1; }

    // Try OSMesa.
    mjGladGetProcAddressPtr = (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle,
        "OSMesaGetProcAddress");
    if (mjGladGetProcAddressPtr) { return 1; }

    // Try GLX.
    mjGladGetProcAddressPtr = (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle,
        "glXGetProcAddressARB");
    if (mjGladGetProcAddressPtr) { return 1; }
  }

  // If *GetProcAddress isn't already present in the symbol table, we try to load in a dynamic
  // library. Since mjr_makeContext cannot succeed without a valid OpenGL having already been
  // created, we assume that some GL platform library has already been dynamically loaded, but
  // the symbols aren't visible because the load was done with RTLD_LOCAL. We walk through the
  // list of DSOs already loaded to see which platform we should be using.
  const char* libname = NULL;
  const mjtGLPlatform platform = dl_iterate_phdr(&mjGlad_dl_iterate_callback, &libname);
  if (!platform) {
    mju_error("an OpenGL platform library has not been loaded into this process, "
              "this most likely means that a valid OpenGL context has not been created before "
              "mjr_makeContext was called");
  }
  if (!libname) {
    mju_error("unexpected error: dl_iterate_phdr found an OpenGL platform library "
              "but its name pointer is null");
  }

  handle = dlopen(libname, RTLD_NOW | RTLD_LOCAL);
  if (!handle) {
    mju_error_s("failed to dlopen %s", libname);
  }

  if (platform == mjGL_GLX) {
    mjGladGetProcAddressPtr =
        (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle, "glXGetProcAddressARB");
  } else if (platform == mjGL_EGL) {
    mjGladGetProcAddressPtr =
        (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle, "eglGetProcAddress");
  } else if (platform == mjGL_OSMESA) {
    mjGladGetProcAddressPtr =
        (PFNGLXGETPROCADDRESSPROC_PRIVATE)dlsym(handle, "OSMesaGetProcAddress");
  }

  return mjGladGetProcAddressPtr ? 1 : 0;
}
#else
static int mjGlad_open_gl(void) {
  static const char *NAMES[] = {
      "../Frameworks/OpenGL.framework/OpenGL",
      "/Library/Frameworks/OpenGL.framework/OpenGL",
      "/System/Library/Frameworks/OpenGL.framework/OpenGL",
      "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL"
  };

  unsigned int index = 0;
  for (index = 0; index < (sizeof(NAMES) / sizeof(NAMES[0])); index++) {
    mjGlad_libGL = dlopen(NAMES[index], RTLD_NOW | RTLD_GLOBAL);

    if (mjGlad_libGL != NULL) {
      return 1;
    }
  }

  return 0;
}
#endif

static
void mjGlad_close_gl(void) {
  if(mjGlad_libGL != NULL) {
    dlclose(mjGlad_libGL);
    mjGlad_libGL = NULL;
  }
}
#endif

static
void* mjGlad_get_proc(const char *namez) {
  void* result = NULL;

#if !defined(__APPLE__) && !defined(__HAIKU__)
  if(mjGladGetProcAddressPtr != NULL) {
    result = mjGladGetProcAddressPtr(namez);
  }
#endif
  if(result == NULL) {
    if(mjGlad_libGL == NULL) return NULL;
#if defined(_WIN32) || defined(__CYGWIN__)
    result = (void*)GetProcAddress((HMODULE) mjGlad_libGL, namez);
#else
    result = dlsym(mjGlad_libGL, namez);
#endif
  }

  return result;
}

struct gladGLversionStruct mjGLVersion = { 0, 0 };

#if defined(GL_ES_VERSION_3_0) || defined(GL_VERSION_3_0)
#define _GLAD_IS_SOME_NEW_VERSION 1
#endif

static int mjGlad_max_loaded_major;
static int mjGlad_max_loaded_minor;

static const char *mjGlad_exts = NULL;
static int mjGlad_num_exts_i = 0;
static char **mjGlad_exts_i = NULL;

static int mjGlad_get_exts(void) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
  if(mjGlad_max_loaded_major < 3) {
#endif
    mjGlad_exts = (const char *)glGetString(GL_EXTENSIONS);
#ifdef _GLAD_IS_SOME_NEW_VERSION
  } else {
    unsigned int index;

    mjGlad_num_exts_i = 0;
    glGetIntegerv(GL_NUM_EXTENSIONS, &mjGlad_num_exts_i);
    if (mjGlad_num_exts_i > 0) {
      mjGlad_exts_i = (char **)malloc((size_t)mjGlad_num_exts_i * (sizeof *mjGlad_exts_i));
    }

    if (mjGlad_exts_i == NULL) {
      return 0;
    }

    for(index = 0; index < (unsigned)mjGlad_num_exts_i; index++) {
      const char *gl_str_tmp = (const char*)glGetStringi(GL_EXTENSIONS, index);
      size_t len = strlen(gl_str_tmp);

      char *local_str = (char*)malloc((len+1) * sizeof(char));
      if(local_str != NULL) {
        memcpy(local_str, gl_str_tmp, (len+1) * sizeof(char));
      }
      mjGlad_exts_i[index] = local_str;
    }
  }
#endif
  return 1;
}

static void mjGlad_free_exts(void) {
  if (mjGlad_exts_i != NULL) {
    int index;
    for(index = 0; index < mjGlad_num_exts_i; index++) {
        free((char *)mjGlad_exts_i[index]);
    }
    free((void *)mjGlad_exts_i);
    mjGlad_exts_i = NULL;
  }
}

static int mjGlad_has_ext(const char *ext) {
#ifdef _GLAD_IS_SOME_NEW_VERSION
  if(mjGlad_max_loaded_major < 3) {
#endif
  const char *extensions;
  const char *loc;
  const char *terminator;
  extensions = mjGlad_exts;
  if(extensions == NULL || ext == NULL) {
    return 0;
  }

  while(1) {
    loc = strstr(extensions, ext);
    if(loc == NULL) {
      return 0;
    }

    terminator = loc + strlen(ext);
    if((loc == extensions || *(loc - 1) == ' ') &&
      (*terminator == ' ' || *terminator == '\0')) {
      return 1;
    }
    extensions = terminator;
  }
#ifdef _GLAD_IS_SOME_NEW_VERSION
  } else {
    int index;
    if(mjGlad_exts_i == NULL) return 0;
    for(index = 0; index < mjGlad_num_exts_i; index++) {
      const char *e = mjGlad_exts_i[index];

      if(mjGlad_exts_i[index] != NULL && strcmp(e, ext) == 0) {
        return 1;
      }
    }
  }
#endif

  return 0;
}
int mjGLAD_GL_VERSION_1_0 = 0;
int mjGLAD_GL_VERSION_1_1 = 0;
int mjGLAD_GL_VERSION_1_2 = 0;
int mjGLAD_GL_VERSION_1_3 = 0;
int mjGLAD_GL_VERSION_1_4 = 0;
int mjGLAD_GL_VERSION_1_5 = 0;
PFNGLACCUMPROC mjGlad_glAccum = NULL;
PFNGLACTIVETEXTUREPROC mjGlad_glActiveTexture = NULL;
PFNGLALPHAFUNCPROC mjGlad_glAlphaFunc = NULL;
PFNGLARETEXTURESRESIDENTPROC mjGlad_glAreTexturesResident = NULL;
PFNGLARRAYELEMENTPROC mjGlad_glArrayElement = NULL;
PFNGLBEGINPROC mjGlad_glBegin = NULL;
PFNGLBEGINQUERYPROC mjGlad_glBeginQuery = NULL;
PFNGLBINDBUFFERPROC mjGlad_glBindBuffer = NULL;
PFNGLBINDTEXTUREPROC mjGlad_glBindTexture = NULL;
PFNGLBITMAPPROC mjGlad_glBitmap = NULL;
PFNGLBLENDCOLORPROC mjGlad_glBlendColor = NULL;
PFNGLBLENDEQUATIONPROC mjGlad_glBlendEquation = NULL;
PFNGLBLENDFUNCPROC mjGlad_glBlendFunc = NULL;
PFNGLBLENDFUNCSEPARATEPROC mjGlad_glBlendFuncSeparate = NULL;
PFNGLBUFFERDATAPROC mjGlad_glBufferData = NULL;
PFNGLBUFFERSUBDATAPROC mjGlad_glBufferSubData = NULL;
PFNGLCALLLISTPROC mjGlad_glCallList = NULL;
PFNGLCALLLISTSPROC mjGlad_glCallLists = NULL;
PFNGLCLEARPROC mjGlad_glClear = NULL;
PFNGLCLEARACCUMPROC mjGlad_glClearAccum = NULL;
PFNGLCLEARCOLORPROC mjGlad_glClearColor = NULL;
PFNGLCLEARDEPTHPROC mjGlad_glClearDepth = NULL;
PFNGLCLEARINDEXPROC mjGlad_glClearIndex = NULL;
PFNGLCLEARSTENCILPROC mjGlad_glClearStencil = NULL;
PFNGLCLIENTACTIVETEXTUREPROC mjGlad_glClientActiveTexture = NULL;
PFNGLCLIPPLANEPROC mjGlad_glClipPlane = NULL;
PFNGLCOLOR3BPROC mjGlad_glColor3b = NULL;
PFNGLCOLOR3BVPROC mjGlad_glColor3bv = NULL;
PFNGLCOLOR3DPROC mjGlad_glColor3d = NULL;
PFNGLCOLOR3DVPROC mjGlad_glColor3dv = NULL;
PFNGLCOLOR3FPROC mjGlad_glColor3f = NULL;
PFNGLCOLOR3FVPROC mjGlad_glColor3fv = NULL;
PFNGLCOLOR3IPROC mjGlad_glColor3i = NULL;
PFNGLCOLOR3IVPROC mjGlad_glColor3iv = NULL;
PFNGLCOLOR3SPROC mjGlad_glColor3s = NULL;
PFNGLCOLOR3SVPROC mjGlad_glColor3sv = NULL;
PFNGLCOLOR3UBPROC mjGlad_glColor3ub = NULL;
PFNGLCOLOR3UBVPROC mjGlad_glColor3ubv = NULL;
PFNGLCOLOR3UIPROC mjGlad_glColor3ui = NULL;
PFNGLCOLOR3UIVPROC mjGlad_glColor3uiv = NULL;
PFNGLCOLOR3USPROC mjGlad_glColor3us = NULL;
PFNGLCOLOR3USVPROC mjGlad_glColor3usv = NULL;
PFNGLCOLOR4BPROC mjGlad_glColor4b = NULL;
PFNGLCOLOR4BVPROC mjGlad_glColor4bv = NULL;
PFNGLCOLOR4DPROC mjGlad_glColor4d = NULL;
PFNGLCOLOR4DVPROC mjGlad_glColor4dv = NULL;
PFNGLCOLOR4FPROC mjGlad_glColor4f = NULL;
PFNGLCOLOR4FVPROC mjGlad_glColor4fv = NULL;
PFNGLCOLOR4IPROC mjGlad_glColor4i = NULL;
PFNGLCOLOR4IVPROC mjGlad_glColor4iv = NULL;
PFNGLCOLOR4SPROC mjGlad_glColor4s = NULL;
PFNGLCOLOR4SVPROC mjGlad_glColor4sv = NULL;
PFNGLCOLOR4UBPROC mjGlad_glColor4ub = NULL;
PFNGLCOLOR4UBVPROC mjGlad_glColor4ubv = NULL;
PFNGLCOLOR4UIPROC mjGlad_glColor4ui = NULL;
PFNGLCOLOR4UIVPROC mjGlad_glColor4uiv = NULL;
PFNGLCOLOR4USPROC mjGlad_glColor4us = NULL;
PFNGLCOLOR4USVPROC mjGlad_glColor4usv = NULL;
PFNGLCOLORMASKPROC mjGlad_glColorMask = NULL;
PFNGLCOLORMATERIALPROC mjGlad_glColorMaterial = NULL;
PFNGLCOLORPOINTERPROC mjGlad_glColorPointer = NULL;
PFNGLCOMPRESSEDTEXIMAGE1DPROC mjGlad_glCompressedTexImage1D = NULL;
PFNGLCOMPRESSEDTEXIMAGE2DPROC mjGlad_glCompressedTexImage2D = NULL;
PFNGLCOMPRESSEDTEXIMAGE3DPROC mjGlad_glCompressedTexImage3D = NULL;
PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC mjGlad_glCompressedTexSubImage1D = NULL;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC mjGlad_glCompressedTexSubImage2D = NULL;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC mjGlad_glCompressedTexSubImage3D = NULL;
PFNGLCOPYPIXELSPROC mjGlad_glCopyPixels = NULL;
PFNGLCOPYTEXIMAGE1DPROC mjGlad_glCopyTexImage1D = NULL;
PFNGLCOPYTEXIMAGE2DPROC mjGlad_glCopyTexImage2D = NULL;
PFNGLCOPYTEXSUBIMAGE1DPROC mjGlad_glCopyTexSubImage1D = NULL;
PFNGLCOPYTEXSUBIMAGE2DPROC mjGlad_glCopyTexSubImage2D = NULL;
PFNGLCOPYTEXSUBIMAGE3DPROC mjGlad_glCopyTexSubImage3D = NULL;
PFNGLCULLFACEPROC mjGlad_glCullFace = NULL;
PFNGLDELETEBUFFERSPROC mjGlad_glDeleteBuffers = NULL;
PFNGLDELETELISTSPROC mjGlad_glDeleteLists = NULL;
PFNGLDELETEQUERIESPROC mjGlad_glDeleteQueries = NULL;
PFNGLDELETETEXTURESPROC mjGlad_glDeleteTextures = NULL;
PFNGLDEPTHFUNCPROC mjGlad_glDepthFunc = NULL;
PFNGLDEPTHMASKPROC mjGlad_glDepthMask = NULL;
PFNGLDEPTHRANGEPROC mjGlad_glDepthRange = NULL;
PFNGLDISABLEPROC mjGlad_glDisable = NULL;
PFNGLDISABLECLIENTSTATEPROC mjGlad_glDisableClientState = NULL;
PFNGLDRAWARRAYSPROC mjGlad_glDrawArrays = NULL;
PFNGLDRAWBUFFERPROC mjGlad_glDrawBuffer = NULL;
PFNGLDRAWELEMENTSPROC mjGlad_glDrawElements = NULL;
PFNGLDRAWPIXELSPROC mjGlad_glDrawPixels = NULL;
PFNGLDRAWRANGEELEMENTSPROC mjGlad_glDrawRangeElements = NULL;
PFNGLEDGEFLAGPROC mjGlad_glEdgeFlag = NULL;
PFNGLEDGEFLAGPOINTERPROC mjGlad_glEdgeFlagPointer = NULL;
PFNGLEDGEFLAGVPROC mjGlad_glEdgeFlagv = NULL;
PFNGLENABLEPROC mjGlad_glEnable = NULL;
PFNGLENABLECLIENTSTATEPROC mjGlad_glEnableClientState = NULL;
PFNGLENDPROC mjGlad_glEnd = NULL;
PFNGLENDLISTPROC mjGlad_glEndList = NULL;
PFNGLENDQUERYPROC mjGlad_glEndQuery = NULL;
PFNGLEVALCOORD1DPROC mjGlad_glEvalCoord1d = NULL;
PFNGLEVALCOORD1DVPROC mjGlad_glEvalCoord1dv = NULL;
PFNGLEVALCOORD1FPROC mjGlad_glEvalCoord1f = NULL;
PFNGLEVALCOORD1FVPROC mjGlad_glEvalCoord1fv = NULL;
PFNGLEVALCOORD2DPROC mjGlad_glEvalCoord2d = NULL;
PFNGLEVALCOORD2DVPROC mjGlad_glEvalCoord2dv = NULL;
PFNGLEVALCOORD2FPROC mjGlad_glEvalCoord2f = NULL;
PFNGLEVALCOORD2FVPROC mjGlad_glEvalCoord2fv = NULL;
PFNGLEVALMESH1PROC mjGlad_glEvalMesh1 = NULL;
PFNGLEVALMESH2PROC mjGlad_glEvalMesh2 = NULL;
PFNGLEVALPOINT1PROC mjGlad_glEvalPoint1 = NULL;
PFNGLEVALPOINT2PROC mjGlad_glEvalPoint2 = NULL;
PFNGLFEEDBACKBUFFERPROC mjGlad_glFeedbackBuffer = NULL;
PFNGLFINISHPROC mjGlad_glFinish = NULL;
PFNGLFLUSHPROC mjGlad_glFlush = NULL;
PFNGLFOGCOORDPOINTERPROC mjGlad_glFogCoordPointer = NULL;
PFNGLFOGCOORDDPROC mjGlad_glFogCoordd = NULL;
PFNGLFOGCOORDDVPROC mjGlad_glFogCoorddv = NULL;
PFNGLFOGCOORDFPROC mjGlad_glFogCoordf = NULL;
PFNGLFOGCOORDFVPROC mjGlad_glFogCoordfv = NULL;
PFNGLFOGFPROC mjGlad_glFogf = NULL;
PFNGLFOGFVPROC mjGlad_glFogfv = NULL;
PFNGLFOGIPROC mjGlad_glFogi = NULL;
PFNGLFOGIVPROC mjGlad_glFogiv = NULL;
PFNGLFRONTFACEPROC mjGlad_glFrontFace = NULL;
PFNGLFRUSTUMPROC mjGlad_glFrustum = NULL;
PFNGLGENBUFFERSPROC mjGlad_glGenBuffers = NULL;
PFNGLGENLISTSPROC mjGlad_glGenLists = NULL;
PFNGLGENQUERIESPROC mjGlad_glGenQueries = NULL;
PFNGLGENTEXTURESPROC mjGlad_glGenTextures = NULL;
PFNGLGETBOOLEANVPROC mjGlad_glGetBooleanv = NULL;
PFNGLGETBUFFERPARAMETERIVPROC mjGlad_glGetBufferParameteriv = NULL;
PFNGLGETBUFFERPOINTERVPROC mjGlad_glGetBufferPointerv = NULL;
PFNGLGETBUFFERSUBDATAPROC mjGlad_glGetBufferSubData = NULL;
PFNGLGETCLIPPLANEPROC mjGlad_glGetClipPlane = NULL;
PFNGLGETCOMPRESSEDTEXIMAGEPROC mjGlad_glGetCompressedTexImage = NULL;
PFNGLGETDOUBLEVPROC mjGlad_glGetDoublev = NULL;
PFNGLGETERRORPROC mjGlad_glGetError = NULL;
PFNGLGETFLOATVPROC mjGlad_glGetFloatv = NULL;
PFNGLGETINTEGERVPROC mjGlad_glGetIntegerv = NULL;
PFNGLGETLIGHTFVPROC mjGlad_glGetLightfv = NULL;
PFNGLGETLIGHTIVPROC mjGlad_glGetLightiv = NULL;
PFNGLGETMAPDVPROC mjGlad_glGetMapdv = NULL;
PFNGLGETMAPFVPROC mjGlad_glGetMapfv = NULL;
PFNGLGETMAPIVPROC mjGlad_glGetMapiv = NULL;
PFNGLGETMATERIALFVPROC mjGlad_glGetMaterialfv = NULL;
PFNGLGETMATERIALIVPROC mjGlad_glGetMaterialiv = NULL;
PFNGLGETPIXELMAPFVPROC mjGlad_glGetPixelMapfv = NULL;
PFNGLGETPIXELMAPUIVPROC mjGlad_glGetPixelMapuiv = NULL;
PFNGLGETPIXELMAPUSVPROC mjGlad_glGetPixelMapusv = NULL;
PFNGLGETPOINTERVPROC mjGlad_glGetPointerv = NULL;
PFNGLGETPOLYGONSTIPPLEPROC mjGlad_glGetPolygonStipple = NULL;
PFNGLGETQUERYOBJECTIVPROC mjGlad_glGetQueryObjectiv = NULL;
PFNGLGETQUERYOBJECTUIVPROC mjGlad_glGetQueryObjectuiv = NULL;
PFNGLGETQUERYIVPROC mjGlad_glGetQueryiv = NULL;
PFNGLGETSTRINGPROC mjGlad_glGetString = NULL;
PFNGLGETTEXENVFVPROC mjGlad_glGetTexEnvfv = NULL;
PFNGLGETTEXENVIVPROC mjGlad_glGetTexEnviv = NULL;
PFNGLGETTEXGENDVPROC mjGlad_glGetTexGendv = NULL;
PFNGLGETTEXGENFVPROC mjGlad_glGetTexGenfv = NULL;
PFNGLGETTEXGENIVPROC mjGlad_glGetTexGeniv = NULL;
PFNGLGETTEXIMAGEPROC mjGlad_glGetTexImage = NULL;
PFNGLGETTEXLEVELPARAMETERFVPROC mjGlad_glGetTexLevelParameterfv = NULL;
PFNGLGETTEXLEVELPARAMETERIVPROC mjGlad_glGetTexLevelParameteriv = NULL;
PFNGLGETTEXPARAMETERFVPROC mjGlad_glGetTexParameterfv = NULL;
PFNGLGETTEXPARAMETERIVPROC mjGlad_glGetTexParameteriv = NULL;
PFNGLHINTPROC mjGlad_glHint = NULL;
PFNGLINDEXMASKPROC mjGlad_glIndexMask = NULL;
PFNGLINDEXPOINTERPROC mjGlad_glIndexPointer = NULL;
PFNGLINDEXDPROC mjGlad_glIndexd = NULL;
PFNGLINDEXDVPROC mjGlad_glIndexdv = NULL;
PFNGLINDEXFPROC mjGlad_glIndexf = NULL;
PFNGLINDEXFVPROC mjGlad_glIndexfv = NULL;
PFNGLINDEXIPROC mjGlad_glIndexi = NULL;
PFNGLINDEXIVPROC mjGlad_glIndexiv = NULL;
PFNGLINDEXSPROC mjGlad_glIndexs = NULL;
PFNGLINDEXSVPROC mjGlad_glIndexsv = NULL;
PFNGLINDEXUBPROC mjGlad_glIndexub = NULL;
PFNGLINDEXUBVPROC mjGlad_glIndexubv = NULL;
PFNGLINITNAMESPROC mjGlad_glInitNames = NULL;
PFNGLINTERLEAVEDARRAYSPROC mjGlad_glInterleavedArrays = NULL;
PFNGLISBUFFERPROC mjGlad_glIsBuffer = NULL;
PFNGLISENABLEDPROC mjGlad_glIsEnabled = NULL;
PFNGLISLISTPROC mjGlad_glIsList = NULL;
PFNGLISQUERYPROC mjGlad_glIsQuery = NULL;
PFNGLISTEXTUREPROC mjGlad_glIsTexture = NULL;
PFNGLLIGHTMODELFPROC mjGlad_glLightModelf = NULL;
PFNGLLIGHTMODELFVPROC mjGlad_glLightModelfv = NULL;
PFNGLLIGHTMODELIPROC mjGlad_glLightModeli = NULL;
PFNGLLIGHTMODELIVPROC mjGlad_glLightModeliv = NULL;
PFNGLLIGHTFPROC mjGlad_glLightf = NULL;
PFNGLLIGHTFVPROC mjGlad_glLightfv = NULL;
PFNGLLIGHTIPROC mjGlad_glLighti = NULL;
PFNGLLIGHTIVPROC mjGlad_glLightiv = NULL;
PFNGLLINESTIPPLEPROC mjGlad_glLineStipple = NULL;
PFNGLLINEWIDTHPROC mjGlad_glLineWidth = NULL;
PFNGLLISTBASEPROC mjGlad_glListBase = NULL;
PFNGLLOADIDENTITYPROC mjGlad_glLoadIdentity = NULL;
PFNGLLOADMATRIXDPROC mjGlad_glLoadMatrixd = NULL;
PFNGLLOADMATRIXFPROC mjGlad_glLoadMatrixf = NULL;
PFNGLLOADNAMEPROC mjGlad_glLoadName = NULL;
PFNGLLOADTRANSPOSEMATRIXDPROC mjGlad_glLoadTransposeMatrixd = NULL;
PFNGLLOADTRANSPOSEMATRIXFPROC mjGlad_glLoadTransposeMatrixf = NULL;
PFNGLLOGICOPPROC mjGlad_glLogicOp = NULL;
PFNGLMAP1DPROC mjGlad_glMap1d = NULL;
PFNGLMAP1FPROC mjGlad_glMap1f = NULL;
PFNGLMAP2DPROC mjGlad_glMap2d = NULL;
PFNGLMAP2FPROC mjGlad_glMap2f = NULL;
PFNGLMAPBUFFERPROC mjGlad_glMapBuffer = NULL;
PFNGLMAPGRID1DPROC mjGlad_glMapGrid1d = NULL;
PFNGLMAPGRID1FPROC mjGlad_glMapGrid1f = NULL;
PFNGLMAPGRID2DPROC mjGlad_glMapGrid2d = NULL;
PFNGLMAPGRID2FPROC mjGlad_glMapGrid2f = NULL;
PFNGLMATERIALFPROC mjGlad_glMaterialf = NULL;
PFNGLMATERIALFVPROC mjGlad_glMaterialfv = NULL;
PFNGLMATERIALIPROC mjGlad_glMateriali = NULL;
PFNGLMATERIALIVPROC mjGlad_glMaterialiv = NULL;
PFNGLMATRIXMODEPROC mjGlad_glMatrixMode = NULL;
PFNGLMULTMATRIXDPROC mjGlad_glMultMatrixd = NULL;
PFNGLMULTMATRIXFPROC mjGlad_glMultMatrixf = NULL;
PFNGLMULTTRANSPOSEMATRIXDPROC mjGlad_glMultTransposeMatrixd = NULL;
PFNGLMULTTRANSPOSEMATRIXFPROC mjGlad_glMultTransposeMatrixf = NULL;
PFNGLMULTIDRAWARRAYSPROC mjGlad_glMultiDrawArrays = NULL;
PFNGLMULTIDRAWELEMENTSPROC mjGlad_glMultiDrawElements = NULL;
PFNGLMULTITEXCOORD1DPROC mjGlad_glMultiTexCoord1d = NULL;
PFNGLMULTITEXCOORD1DVPROC mjGlad_glMultiTexCoord1dv = NULL;
PFNGLMULTITEXCOORD1FPROC mjGlad_glMultiTexCoord1f = NULL;
PFNGLMULTITEXCOORD1FVPROC mjGlad_glMultiTexCoord1fv = NULL;
PFNGLMULTITEXCOORD1IPROC mjGlad_glMultiTexCoord1i = NULL;
PFNGLMULTITEXCOORD1IVPROC mjGlad_glMultiTexCoord1iv = NULL;
PFNGLMULTITEXCOORD1SPROC mjGlad_glMultiTexCoord1s = NULL;
PFNGLMULTITEXCOORD1SVPROC mjGlad_glMultiTexCoord1sv = NULL;
PFNGLMULTITEXCOORD2DPROC mjGlad_glMultiTexCoord2d = NULL;
PFNGLMULTITEXCOORD2DVPROC mjGlad_glMultiTexCoord2dv = NULL;
PFNGLMULTITEXCOORD2FPROC mjGlad_glMultiTexCoord2f = NULL;
PFNGLMULTITEXCOORD2FVPROC mjGlad_glMultiTexCoord2fv = NULL;
PFNGLMULTITEXCOORD2IPROC mjGlad_glMultiTexCoord2i = NULL;
PFNGLMULTITEXCOORD2IVPROC mjGlad_glMultiTexCoord2iv = NULL;
PFNGLMULTITEXCOORD2SPROC mjGlad_glMultiTexCoord2s = NULL;
PFNGLMULTITEXCOORD2SVPROC mjGlad_glMultiTexCoord2sv = NULL;
PFNGLMULTITEXCOORD3DPROC mjGlad_glMultiTexCoord3d = NULL;
PFNGLMULTITEXCOORD3DVPROC mjGlad_glMultiTexCoord3dv = NULL;
PFNGLMULTITEXCOORD3FPROC mjGlad_glMultiTexCoord3f = NULL;
PFNGLMULTITEXCOORD3FVPROC mjGlad_glMultiTexCoord3fv = NULL;
PFNGLMULTITEXCOORD3IPROC mjGlad_glMultiTexCoord3i = NULL;
PFNGLMULTITEXCOORD3IVPROC mjGlad_glMultiTexCoord3iv = NULL;
PFNGLMULTITEXCOORD3SPROC mjGlad_glMultiTexCoord3s = NULL;
PFNGLMULTITEXCOORD3SVPROC mjGlad_glMultiTexCoord3sv = NULL;
PFNGLMULTITEXCOORD4DPROC mjGlad_glMultiTexCoord4d = NULL;
PFNGLMULTITEXCOORD4DVPROC mjGlad_glMultiTexCoord4dv = NULL;
PFNGLMULTITEXCOORD4FPROC mjGlad_glMultiTexCoord4f = NULL;
PFNGLMULTITEXCOORD4FVPROC mjGlad_glMultiTexCoord4fv = NULL;
PFNGLMULTITEXCOORD4IPROC mjGlad_glMultiTexCoord4i = NULL;
PFNGLMULTITEXCOORD4IVPROC mjGlad_glMultiTexCoord4iv = NULL;
PFNGLMULTITEXCOORD4SPROC mjGlad_glMultiTexCoord4s = NULL;
PFNGLMULTITEXCOORD4SVPROC mjGlad_glMultiTexCoord4sv = NULL;
PFNGLNEWLISTPROC mjGlad_glNewList = NULL;
PFNGLNORMAL3BPROC mjGlad_glNormal3b = NULL;
PFNGLNORMAL3BVPROC mjGlad_glNormal3bv = NULL;
PFNGLNORMAL3DPROC mjGlad_glNormal3d = NULL;
PFNGLNORMAL3DVPROC mjGlad_glNormal3dv = NULL;
PFNGLNORMAL3FPROC mjGlad_glNormal3f = NULL;
PFNGLNORMAL3FVPROC mjGlad_glNormal3fv = NULL;
PFNGLNORMAL3IPROC mjGlad_glNormal3i = NULL;
PFNGLNORMAL3IVPROC mjGlad_glNormal3iv = NULL;
PFNGLNORMAL3SPROC mjGlad_glNormal3s = NULL;
PFNGLNORMAL3SVPROC mjGlad_glNormal3sv = NULL;
PFNGLNORMALPOINTERPROC mjGlad_glNormalPointer = NULL;
PFNGLORTHOPROC mjGlad_glOrtho = NULL;
PFNGLPASSTHROUGHPROC mjGlad_glPassThrough = NULL;
PFNGLPIXELMAPFVPROC mjGlad_glPixelMapfv = NULL;
PFNGLPIXELMAPUIVPROC mjGlad_glPixelMapuiv = NULL;
PFNGLPIXELMAPUSVPROC mjGlad_glPixelMapusv = NULL;
PFNGLPIXELSTOREFPROC mjGlad_glPixelStoref = NULL;
PFNGLPIXELSTOREIPROC mjGlad_glPixelStorei = NULL;
PFNGLPIXELTRANSFERFPROC mjGlad_glPixelTransferf = NULL;
PFNGLPIXELTRANSFERIPROC mjGlad_glPixelTransferi = NULL;
PFNGLPIXELZOOMPROC mjGlad_glPixelZoom = NULL;
PFNGLPOINTPARAMETERFPROC mjGlad_glPointParameterf = NULL;
PFNGLPOINTPARAMETERFVPROC mjGlad_glPointParameterfv = NULL;
PFNGLPOINTPARAMETERIPROC mjGlad_glPointParameteri = NULL;
PFNGLPOINTPARAMETERIVPROC mjGlad_glPointParameteriv = NULL;
PFNGLPOINTSIZEPROC mjGlad_glPointSize = NULL;
PFNGLPOLYGONMODEPROC mjGlad_glPolygonMode = NULL;
PFNGLPOLYGONOFFSETPROC mjGlad_glPolygonOffset = NULL;
PFNGLPOLYGONSTIPPLEPROC mjGlad_glPolygonStipple = NULL;
PFNGLPOPATTRIBPROC mjGlad_glPopAttrib = NULL;
PFNGLPOPCLIENTATTRIBPROC mjGlad_glPopClientAttrib = NULL;
PFNGLPOPMATRIXPROC mjGlad_glPopMatrix = NULL;
PFNGLPOPNAMEPROC mjGlad_glPopName = NULL;
PFNGLPRIORITIZETEXTURESPROC mjGlad_glPrioritizeTextures = NULL;
PFNGLPUSHATTRIBPROC mjGlad_glPushAttrib = NULL;
PFNGLPUSHCLIENTATTRIBPROC mjGlad_glPushClientAttrib = NULL;
PFNGLPUSHMATRIXPROC mjGlad_glPushMatrix = NULL;
PFNGLPUSHNAMEPROC mjGlad_glPushName = NULL;
PFNGLRASTERPOS2DPROC mjGlad_glRasterPos2d = NULL;
PFNGLRASTERPOS2DVPROC mjGlad_glRasterPos2dv = NULL;
PFNGLRASTERPOS2FPROC mjGlad_glRasterPos2f = NULL;
PFNGLRASTERPOS2FVPROC mjGlad_glRasterPos2fv = NULL;
PFNGLRASTERPOS2IPROC mjGlad_glRasterPos2i = NULL;
PFNGLRASTERPOS2IVPROC mjGlad_glRasterPos2iv = NULL;
PFNGLRASTERPOS2SPROC mjGlad_glRasterPos2s = NULL;
PFNGLRASTERPOS2SVPROC mjGlad_glRasterPos2sv = NULL;
PFNGLRASTERPOS3DPROC mjGlad_glRasterPos3d = NULL;
PFNGLRASTERPOS3DVPROC mjGlad_glRasterPos3dv = NULL;
PFNGLRASTERPOS3FPROC mjGlad_glRasterPos3f = NULL;
PFNGLRASTERPOS3FVPROC mjGlad_glRasterPos3fv = NULL;
PFNGLRASTERPOS3IPROC mjGlad_glRasterPos3i = NULL;
PFNGLRASTERPOS3IVPROC mjGlad_glRasterPos3iv = NULL;
PFNGLRASTERPOS3SPROC mjGlad_glRasterPos3s = NULL;
PFNGLRASTERPOS3SVPROC mjGlad_glRasterPos3sv = NULL;
PFNGLRASTERPOS4DPROC mjGlad_glRasterPos4d = NULL;
PFNGLRASTERPOS4DVPROC mjGlad_glRasterPos4dv = NULL;
PFNGLRASTERPOS4FPROC mjGlad_glRasterPos4f = NULL;
PFNGLRASTERPOS4FVPROC mjGlad_glRasterPos4fv = NULL;
PFNGLRASTERPOS4IPROC mjGlad_glRasterPos4i = NULL;
PFNGLRASTERPOS4IVPROC mjGlad_glRasterPos4iv = NULL;
PFNGLRASTERPOS4SPROC mjGlad_glRasterPos4s = NULL;
PFNGLRASTERPOS4SVPROC mjGlad_glRasterPos4sv = NULL;
PFNGLREADBUFFERPROC mjGlad_glReadBuffer = NULL;
PFNGLREADPIXELSPROC mjGlad_glReadPixels = NULL;
PFNGLRECTDPROC mjGlad_glRectd = NULL;
PFNGLRECTDVPROC mjGlad_glRectdv = NULL;
PFNGLRECTFPROC mjGlad_glRectf = NULL;
PFNGLRECTFVPROC mjGlad_glRectfv = NULL;
PFNGLRECTIPROC mjGlad_glRecti = NULL;
PFNGLRECTIVPROC mjGlad_glRectiv = NULL;
PFNGLRECTSPROC mjGlad_glRects = NULL;
PFNGLRECTSVPROC mjGlad_glRectsv = NULL;
PFNGLRENDERMODEPROC mjGlad_glRenderMode = NULL;
PFNGLROTATEDPROC mjGlad_glRotated = NULL;
PFNGLROTATEFPROC mjGlad_glRotatef = NULL;
PFNGLSAMPLECOVERAGEPROC mjGlad_glSampleCoverage = NULL;
PFNGLSCALEDPROC mjGlad_glScaled = NULL;
PFNGLSCALEFPROC mjGlad_glScalef = NULL;
PFNGLSCISSORPROC mjGlad_glScissor = NULL;
PFNGLSECONDARYCOLOR3BPROC mjGlad_glSecondaryColor3b = NULL;
PFNGLSECONDARYCOLOR3BVPROC mjGlad_glSecondaryColor3bv = NULL;
PFNGLSECONDARYCOLOR3DPROC mjGlad_glSecondaryColor3d = NULL;
PFNGLSECONDARYCOLOR3DVPROC mjGlad_glSecondaryColor3dv = NULL;
PFNGLSECONDARYCOLOR3FPROC mjGlad_glSecondaryColor3f = NULL;
PFNGLSECONDARYCOLOR3FVPROC mjGlad_glSecondaryColor3fv = NULL;
PFNGLSECONDARYCOLOR3IPROC mjGlad_glSecondaryColor3i = NULL;
PFNGLSECONDARYCOLOR3IVPROC mjGlad_glSecondaryColor3iv = NULL;
PFNGLSECONDARYCOLOR3SPROC mjGlad_glSecondaryColor3s = NULL;
PFNGLSECONDARYCOLOR3SVPROC mjGlad_glSecondaryColor3sv = NULL;
PFNGLSECONDARYCOLOR3UBPROC mjGlad_glSecondaryColor3ub = NULL;
PFNGLSECONDARYCOLOR3UBVPROC mjGlad_glSecondaryColor3ubv = NULL;
PFNGLSECONDARYCOLOR3UIPROC mjGlad_glSecondaryColor3ui = NULL;
PFNGLSECONDARYCOLOR3UIVPROC mjGlad_glSecondaryColor3uiv = NULL;
PFNGLSECONDARYCOLOR3USPROC mjGlad_glSecondaryColor3us = NULL;
PFNGLSECONDARYCOLOR3USVPROC mjGlad_glSecondaryColor3usv = NULL;
PFNGLSECONDARYCOLORPOINTERPROC mjGlad_glSecondaryColorPointer = NULL;
PFNGLSELECTBUFFERPROC mjGlad_glSelectBuffer = NULL;
PFNGLSHADEMODELPROC mjGlad_glShadeModel = NULL;
PFNGLSTENCILFUNCPROC mjGlad_glStencilFunc = NULL;
PFNGLSTENCILMASKPROC mjGlad_glStencilMask = NULL;
PFNGLSTENCILOPPROC mjGlad_glStencilOp = NULL;
PFNGLTEXCOORD1DPROC mjGlad_glTexCoord1d = NULL;
PFNGLTEXCOORD1DVPROC mjGlad_glTexCoord1dv = NULL;
PFNGLTEXCOORD1FPROC mjGlad_glTexCoord1f = NULL;
PFNGLTEXCOORD1FVPROC mjGlad_glTexCoord1fv = NULL;
PFNGLTEXCOORD1IPROC mjGlad_glTexCoord1i = NULL;
PFNGLTEXCOORD1IVPROC mjGlad_glTexCoord1iv = NULL;
PFNGLTEXCOORD1SPROC mjGlad_glTexCoord1s = NULL;
PFNGLTEXCOORD1SVPROC mjGlad_glTexCoord1sv = NULL;
PFNGLTEXCOORD2DPROC mjGlad_glTexCoord2d = NULL;
PFNGLTEXCOORD2DVPROC mjGlad_glTexCoord2dv = NULL;
PFNGLTEXCOORD2FPROC mjGlad_glTexCoord2f = NULL;
PFNGLTEXCOORD2FVPROC mjGlad_glTexCoord2fv = NULL;
PFNGLTEXCOORD2IPROC mjGlad_glTexCoord2i = NULL;
PFNGLTEXCOORD2IVPROC mjGlad_glTexCoord2iv = NULL;
PFNGLTEXCOORD2SPROC mjGlad_glTexCoord2s = NULL;
PFNGLTEXCOORD2SVPROC mjGlad_glTexCoord2sv = NULL;
PFNGLTEXCOORD3DPROC mjGlad_glTexCoord3d = NULL;
PFNGLTEXCOORD3DVPROC mjGlad_glTexCoord3dv = NULL;
PFNGLTEXCOORD3FPROC mjGlad_glTexCoord3f = NULL;
PFNGLTEXCOORD3FVPROC mjGlad_glTexCoord3fv = NULL;
PFNGLTEXCOORD3IPROC mjGlad_glTexCoord3i = NULL;
PFNGLTEXCOORD3IVPROC mjGlad_glTexCoord3iv = NULL;
PFNGLTEXCOORD3SPROC mjGlad_glTexCoord3s = NULL;
PFNGLTEXCOORD3SVPROC mjGlad_glTexCoord3sv = NULL;
PFNGLTEXCOORD4DPROC mjGlad_glTexCoord4d = NULL;
PFNGLTEXCOORD4DVPROC mjGlad_glTexCoord4dv = NULL;
PFNGLTEXCOORD4FPROC mjGlad_glTexCoord4f = NULL;
PFNGLTEXCOORD4FVPROC mjGlad_glTexCoord4fv = NULL;
PFNGLTEXCOORD4IPROC mjGlad_glTexCoord4i = NULL;
PFNGLTEXCOORD4IVPROC mjGlad_glTexCoord4iv = NULL;
PFNGLTEXCOORD4SPROC mjGlad_glTexCoord4s = NULL;
PFNGLTEXCOORD4SVPROC mjGlad_glTexCoord4sv = NULL;
PFNGLTEXCOORDPOINTERPROC mjGlad_glTexCoordPointer = NULL;
PFNGLTEXENVFPROC mjGlad_glTexEnvf = NULL;
PFNGLTEXENVFVPROC mjGlad_glTexEnvfv = NULL;
PFNGLTEXENVIPROC mjGlad_glTexEnvi = NULL;
PFNGLTEXENVIVPROC mjGlad_glTexEnviv = NULL;
PFNGLTEXGENDPROC mjGlad_glTexGend = NULL;
PFNGLTEXGENDVPROC mjGlad_glTexGendv = NULL;
PFNGLTEXGENFPROC mjGlad_glTexGenf = NULL;
PFNGLTEXGENFVPROC mjGlad_glTexGenfv = NULL;
PFNGLTEXGENIPROC mjGlad_glTexGeni = NULL;
PFNGLTEXGENIVPROC mjGlad_glTexGeniv = NULL;
PFNGLTEXIMAGE1DPROC mjGlad_glTexImage1D = NULL;
PFNGLTEXIMAGE2DPROC mjGlad_glTexImage2D = NULL;
PFNGLTEXIMAGE3DPROC mjGlad_glTexImage3D = NULL;
PFNGLTEXPARAMETERFPROC mjGlad_glTexParameterf = NULL;
PFNGLTEXPARAMETERFVPROC mjGlad_glTexParameterfv = NULL;
PFNGLTEXPARAMETERIPROC mjGlad_glTexParameteri = NULL;
PFNGLTEXPARAMETERIVPROC mjGlad_glTexParameteriv = NULL;
PFNGLTEXSUBIMAGE1DPROC mjGlad_glTexSubImage1D = NULL;
PFNGLTEXSUBIMAGE2DPROC mjGlad_glTexSubImage2D = NULL;
PFNGLTEXSUBIMAGE3DPROC mjGlad_glTexSubImage3D = NULL;
PFNGLTRANSLATEDPROC mjGlad_glTranslated = NULL;
PFNGLTRANSLATEFPROC mjGlad_glTranslatef = NULL;
PFNGLUNMAPBUFFERPROC mjGlad_glUnmapBuffer = NULL;
PFNGLVERTEX2DPROC mjGlad_glVertex2d = NULL;
PFNGLVERTEX2DVPROC mjGlad_glVertex2dv = NULL;
PFNGLVERTEX2FPROC mjGlad_glVertex2f = NULL;
PFNGLVERTEX2FVPROC mjGlad_glVertex2fv = NULL;
PFNGLVERTEX2IPROC mjGlad_glVertex2i = NULL;
PFNGLVERTEX2IVPROC mjGlad_glVertex2iv = NULL;
PFNGLVERTEX2SPROC mjGlad_glVertex2s = NULL;
PFNGLVERTEX2SVPROC mjGlad_glVertex2sv = NULL;
PFNGLVERTEX3DPROC mjGlad_glVertex3d = NULL;
PFNGLVERTEX3DVPROC mjGlad_glVertex3dv = NULL;
PFNGLVERTEX3FPROC mjGlad_glVertex3f = NULL;
PFNGLVERTEX3FVPROC mjGlad_glVertex3fv = NULL;
PFNGLVERTEX3IPROC mjGlad_glVertex3i = NULL;
PFNGLVERTEX3IVPROC mjGlad_glVertex3iv = NULL;
PFNGLVERTEX3SPROC mjGlad_glVertex3s = NULL;
PFNGLVERTEX3SVPROC mjGlad_glVertex3sv = NULL;
PFNGLVERTEX4DPROC mjGlad_glVertex4d = NULL;
PFNGLVERTEX4DVPROC mjGlad_glVertex4dv = NULL;
PFNGLVERTEX4FPROC mjGlad_glVertex4f = NULL;
PFNGLVERTEX4FVPROC mjGlad_glVertex4fv = NULL;
PFNGLVERTEX4IPROC mjGlad_glVertex4i = NULL;
PFNGLVERTEX4IVPROC mjGlad_glVertex4iv = NULL;
PFNGLVERTEX4SPROC mjGlad_glVertex4s = NULL;
PFNGLVERTEX4SVPROC mjGlad_glVertex4sv = NULL;
PFNGLVERTEXPOINTERPROC mjGlad_glVertexPointer = NULL;
PFNGLVIEWPORTPROC mjGlad_glViewport = NULL;
PFNGLWINDOWPOS2DPROC mjGlad_glWindowPos2d = NULL;
PFNGLWINDOWPOS2DVPROC mjGlad_glWindowPos2dv = NULL;
PFNGLWINDOWPOS2FPROC mjGlad_glWindowPos2f = NULL;
PFNGLWINDOWPOS2FVPROC mjGlad_glWindowPos2fv = NULL;
PFNGLWINDOWPOS2IPROC mjGlad_glWindowPos2i = NULL;
PFNGLWINDOWPOS2IVPROC mjGlad_glWindowPos2iv = NULL;
PFNGLWINDOWPOS2SPROC mjGlad_glWindowPos2s = NULL;
PFNGLWINDOWPOS2SVPROC mjGlad_glWindowPos2sv = NULL;
PFNGLWINDOWPOS3DPROC mjGlad_glWindowPos3d = NULL;
PFNGLWINDOWPOS3DVPROC mjGlad_glWindowPos3dv = NULL;
PFNGLWINDOWPOS3FPROC mjGlad_glWindowPos3f = NULL;
PFNGLWINDOWPOS3FVPROC mjGlad_glWindowPos3fv = NULL;
PFNGLWINDOWPOS3IPROC mjGlad_glWindowPos3i = NULL;
PFNGLWINDOWPOS3IVPROC mjGlad_glWindowPos3iv = NULL;
PFNGLWINDOWPOS3SPROC mjGlad_glWindowPos3s = NULL;
PFNGLWINDOWPOS3SVPROC mjGlad_glWindowPos3sv = NULL;
int mjGLAD_GL_ARB_framebuffer_object = 0;
int mjGLAD_GL_ARB_seamless_cube_map = 0;
int mjGLAD_GL_ARB_vertex_buffer_object = 0;
int mjGLAD_GL_KHR_debug = 0;
PFNGLISRENDERBUFFERPROC mjGlad_glIsRenderbuffer = NULL;
PFNGLBINDRENDERBUFFERPROC mjGlad_glBindRenderbuffer = NULL;
PFNGLDELETERENDERBUFFERSPROC mjGlad_glDeleteRenderbuffers = NULL;
PFNGLGENRENDERBUFFERSPROC mjGlad_glGenRenderbuffers = NULL;
PFNGLRENDERBUFFERSTORAGEPROC mjGlad_glRenderbufferStorage = NULL;
PFNGLGETRENDERBUFFERPARAMETERIVPROC mjGlad_glGetRenderbufferParameteriv = NULL;
PFNGLISFRAMEBUFFERPROC mjGlad_glIsFramebuffer = NULL;
PFNGLBINDFRAMEBUFFERPROC mjGlad_glBindFramebuffer = NULL;
PFNGLDELETEFRAMEBUFFERSPROC mjGlad_glDeleteFramebuffers = NULL;
PFNGLGENFRAMEBUFFERSPROC mjGlad_glGenFramebuffers = NULL;
PFNGLCHECKFRAMEBUFFERSTATUSPROC mjGlad_glCheckFramebufferStatus = NULL;
PFNGLFRAMEBUFFERTEXTURE1DPROC mjGlad_glFramebufferTexture1D = NULL;
PFNGLFRAMEBUFFERTEXTURE2DPROC mjGlad_glFramebufferTexture2D = NULL;
PFNGLFRAMEBUFFERTEXTURE3DPROC mjGlad_glFramebufferTexture3D = NULL;
PFNGLFRAMEBUFFERRENDERBUFFERPROC mjGlad_glFramebufferRenderbuffer = NULL;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC mjGlad_glGetFramebufferAttachmentParameteriv = NULL;
PFNGLGENERATEMIPMAPPROC mjGlad_glGenerateMipmap = NULL;
PFNGLBLITFRAMEBUFFERPROC mjGlad_glBlitFramebuffer = NULL;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC mjGlad_glRenderbufferStorageMultisample = NULL;
PFNGLFRAMEBUFFERTEXTURELAYERPROC mjGlad_glFramebufferTextureLayer = NULL;
PFNGLBINDBUFFERARBPROC mjGlad_glBindBufferARB = NULL;
PFNGLDELETEBUFFERSARBPROC mjGlad_glDeleteBuffersARB = NULL;
PFNGLGENBUFFERSARBPROC mjGlad_glGenBuffersARB = NULL;
PFNGLISBUFFERARBPROC mjGlad_glIsBufferARB = NULL;
PFNGLBUFFERDATAARBPROC mjGlad_glBufferDataARB = NULL;
PFNGLBUFFERSUBDATAARBPROC mjGlad_glBufferSubDataARB = NULL;
PFNGLGETBUFFERSUBDATAARBPROC mjGlad_glGetBufferSubDataARB = NULL;
PFNGLMAPBUFFERARBPROC mjGlad_glMapBufferARB = NULL;
PFNGLUNMAPBUFFERARBPROC mjGlad_glUnmapBufferARB = NULL;
PFNGLGETBUFFERPARAMETERIVARBPROC mjGlad_glGetBufferParameterivARB = NULL;
PFNGLGETBUFFERPOINTERVARBPROC mjGlad_glGetBufferPointervARB = NULL;
PFNGLDEBUGMESSAGECONTROLPROC mjGlad_glDebugMessageControl = NULL;
PFNGLDEBUGMESSAGEINSERTPROC mjGlad_glDebugMessageInsert = NULL;
PFNGLDEBUGMESSAGECALLBACKPROC mjGlad_glDebugMessageCallback = NULL;
PFNGLGETDEBUGMESSAGELOGPROC mjGlad_glGetDebugMessageLog = NULL;
PFNGLPUSHDEBUGGROUPPROC mjGlad_glPushDebugGroup = NULL;
PFNGLPOPDEBUGGROUPPROC mjGlad_glPopDebugGroup = NULL;
PFNGLOBJECTLABELPROC mjGlad_glObjectLabel = NULL;
PFNGLGETOBJECTLABELPROC mjGlad_glGetObjectLabel = NULL;
PFNGLOBJECTPTRLABELPROC mjGlad_glObjectPtrLabel = NULL;
PFNGLGETOBJECTPTRLABELPROC mjGlad_glGetObjectPtrLabel = NULL;
PFNGLDEBUGMESSAGECONTROLKHRPROC mjGlad_glDebugMessageControlKHR = NULL;
PFNGLDEBUGMESSAGEINSERTKHRPROC mjGlad_glDebugMessageInsertKHR = NULL;
PFNGLDEBUGMESSAGECALLBACKKHRPROC mjGlad_glDebugMessageCallbackKHR = NULL;
PFNGLGETDEBUGMESSAGELOGKHRPROC mjGlad_glGetDebugMessageLogKHR = NULL;
PFNGLPUSHDEBUGGROUPKHRPROC mjGlad_glPushDebugGroupKHR = NULL;
PFNGLPOPDEBUGGROUPKHRPROC mjGlad_glPopDebugGroupKHR = NULL;
PFNGLOBJECTLABELKHRPROC mjGlad_glObjectLabelKHR = NULL;
PFNGLGETOBJECTLABELKHRPROC mjGlad_glGetObjectLabelKHR = NULL;
PFNGLOBJECTPTRLABELKHRPROC mjGlad_glObjectPtrLabelKHR = NULL;
PFNGLGETOBJECTPTRLABELKHRPROC mjGlad_glGetObjectPtrLabelKHR = NULL;
PFNGLGETPOINTERVKHRPROC mjGlad_glGetPointervKHR = NULL;
static void mjGlad_load_GL_VERSION_1_0(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_0) return;
  mjGlad_glCullFace = (PFNGLCULLFACEPROC)load("glCullFace");
  mjGlad_glFrontFace = (PFNGLFRONTFACEPROC)load("glFrontFace");
  mjGlad_glHint = (PFNGLHINTPROC)load("glHint");
  mjGlad_glLineWidth = (PFNGLLINEWIDTHPROC)load("glLineWidth");
  mjGlad_glPointSize = (PFNGLPOINTSIZEPROC)load("glPointSize");
  mjGlad_glPolygonMode = (PFNGLPOLYGONMODEPROC)load("glPolygonMode");
  mjGlad_glScissor = (PFNGLSCISSORPROC)load("glScissor");
  mjGlad_glTexParameterf = (PFNGLTEXPARAMETERFPROC)load("glTexParameterf");
  mjGlad_glTexParameterfv = (PFNGLTEXPARAMETERFVPROC)load("glTexParameterfv");
  mjGlad_glTexParameteri = (PFNGLTEXPARAMETERIPROC)load("glTexParameteri");
  mjGlad_glTexParameteriv = (PFNGLTEXPARAMETERIVPROC)load("glTexParameteriv");
  mjGlad_glTexImage1D = (PFNGLTEXIMAGE1DPROC)load("glTexImage1D");
  mjGlad_glTexImage2D = (PFNGLTEXIMAGE2DPROC)load("glTexImage2D");
  mjGlad_glDrawBuffer = (PFNGLDRAWBUFFERPROC)load("glDrawBuffer");
  mjGlad_glClear = (PFNGLCLEARPROC)load("glClear");
  mjGlad_glClearColor = (PFNGLCLEARCOLORPROC)load("glClearColor");
  mjGlad_glClearStencil = (PFNGLCLEARSTENCILPROC)load("glClearStencil");
  mjGlad_glClearDepth = (PFNGLCLEARDEPTHPROC)load("glClearDepth");
  mjGlad_glStencilMask = (PFNGLSTENCILMASKPROC)load("glStencilMask");
  mjGlad_glColorMask = (PFNGLCOLORMASKPROC)load("glColorMask");
  mjGlad_glDepthMask = (PFNGLDEPTHMASKPROC)load("glDepthMask");
  mjGlad_glDisable = (PFNGLDISABLEPROC)load("glDisable");
  mjGlad_glEnable = (PFNGLENABLEPROC)load("glEnable");
  mjGlad_glFinish = (PFNGLFINISHPROC)load("glFinish");
  mjGlad_glFlush = (PFNGLFLUSHPROC)load("glFlush");
  mjGlad_glBlendFunc = (PFNGLBLENDFUNCPROC)load("glBlendFunc");
  mjGlad_glLogicOp = (PFNGLLOGICOPPROC)load("glLogicOp");
  mjGlad_glStencilFunc = (PFNGLSTENCILFUNCPROC)load("glStencilFunc");
  mjGlad_glStencilOp = (PFNGLSTENCILOPPROC)load("glStencilOp");
  mjGlad_glDepthFunc = (PFNGLDEPTHFUNCPROC)load("glDepthFunc");
  mjGlad_glPixelStoref = (PFNGLPIXELSTOREFPROC)load("glPixelStoref");
  mjGlad_glPixelStorei = (PFNGLPIXELSTOREIPROC)load("glPixelStorei");
  mjGlad_glReadBuffer = (PFNGLREADBUFFERPROC)load("glReadBuffer");
  mjGlad_glReadPixels = (PFNGLREADPIXELSPROC)load("glReadPixels");
  mjGlad_glGetBooleanv = (PFNGLGETBOOLEANVPROC)load("glGetBooleanv");
  mjGlad_glGetDoublev = (PFNGLGETDOUBLEVPROC)load("glGetDoublev");
  mjGlad_glGetError = (PFNGLGETERRORPROC)load("glGetError");
  mjGlad_glGetFloatv = (PFNGLGETFLOATVPROC)load("glGetFloatv");
  mjGlad_glGetIntegerv = (PFNGLGETINTEGERVPROC)load("glGetIntegerv");
  mjGlad_glGetString = (PFNGLGETSTRINGPROC)load("glGetString");
  mjGlad_glGetTexImage = (PFNGLGETTEXIMAGEPROC)load("glGetTexImage");
  mjGlad_glGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)load("glGetTexParameterfv");
  mjGlad_glGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)load("glGetTexParameteriv");
  mjGlad_glGetTexLevelParameterfv = (PFNGLGETTEXLEVELPARAMETERFVPROC)load("glGetTexLevelParameterfv");
  mjGlad_glGetTexLevelParameteriv = (PFNGLGETTEXLEVELPARAMETERIVPROC)load("glGetTexLevelParameteriv");
  mjGlad_glIsEnabled = (PFNGLISENABLEDPROC)load("glIsEnabled");
  mjGlad_glDepthRange = (PFNGLDEPTHRANGEPROC)load("glDepthRange");
  mjGlad_glViewport = (PFNGLVIEWPORTPROC)load("glViewport");
  mjGlad_glNewList = (PFNGLNEWLISTPROC)load("glNewList");
  mjGlad_glEndList = (PFNGLENDLISTPROC)load("glEndList");
  mjGlad_glCallList = (PFNGLCALLLISTPROC)load("glCallList");
  mjGlad_glCallLists = (PFNGLCALLLISTSPROC)load("glCallLists");
  mjGlad_glDeleteLists = (PFNGLDELETELISTSPROC)load("glDeleteLists");
  mjGlad_glGenLists = (PFNGLGENLISTSPROC)load("glGenLists");
  mjGlad_glListBase = (PFNGLLISTBASEPROC)load("glListBase");
  mjGlad_glBegin = (PFNGLBEGINPROC)load("glBegin");
  mjGlad_glBitmap = (PFNGLBITMAPPROC)load("glBitmap");
  mjGlad_glColor3b = (PFNGLCOLOR3BPROC)load("glColor3b");
  mjGlad_glColor3bv = (PFNGLCOLOR3BVPROC)load("glColor3bv");
  mjGlad_glColor3d = (PFNGLCOLOR3DPROC)load("glColor3d");
  mjGlad_glColor3dv = (PFNGLCOLOR3DVPROC)load("glColor3dv");
  mjGlad_glColor3f = (PFNGLCOLOR3FPROC)load("glColor3f");
  mjGlad_glColor3fv = (PFNGLCOLOR3FVPROC)load("glColor3fv");
  mjGlad_glColor3i = (PFNGLCOLOR3IPROC)load("glColor3i");
  mjGlad_glColor3iv = (PFNGLCOLOR3IVPROC)load("glColor3iv");
  mjGlad_glColor3s = (PFNGLCOLOR3SPROC)load("glColor3s");
  mjGlad_glColor3sv = (PFNGLCOLOR3SVPROC)load("glColor3sv");
  mjGlad_glColor3ub = (PFNGLCOLOR3UBPROC)load("glColor3ub");
  mjGlad_glColor3ubv = (PFNGLCOLOR3UBVPROC)load("glColor3ubv");
  mjGlad_glColor3ui = (PFNGLCOLOR3UIPROC)load("glColor3ui");
  mjGlad_glColor3uiv = (PFNGLCOLOR3UIVPROC)load("glColor3uiv");
  mjGlad_glColor3us = (PFNGLCOLOR3USPROC)load("glColor3us");
  mjGlad_glColor3usv = (PFNGLCOLOR3USVPROC)load("glColor3usv");
  mjGlad_glColor4b = (PFNGLCOLOR4BPROC)load("glColor4b");
  mjGlad_glColor4bv = (PFNGLCOLOR4BVPROC)load("glColor4bv");
  mjGlad_glColor4d = (PFNGLCOLOR4DPROC)load("glColor4d");
  mjGlad_glColor4dv = (PFNGLCOLOR4DVPROC)load("glColor4dv");
  mjGlad_glColor4f = (PFNGLCOLOR4FPROC)load("glColor4f");
  mjGlad_glColor4fv = (PFNGLCOLOR4FVPROC)load("glColor4fv");
  mjGlad_glColor4i = (PFNGLCOLOR4IPROC)load("glColor4i");
  mjGlad_glColor4iv = (PFNGLCOLOR4IVPROC)load("glColor4iv");
  mjGlad_glColor4s = (PFNGLCOLOR4SPROC)load("glColor4s");
  mjGlad_glColor4sv = (PFNGLCOLOR4SVPROC)load("glColor4sv");
  mjGlad_glColor4ub = (PFNGLCOLOR4UBPROC)load("glColor4ub");
  mjGlad_glColor4ubv = (PFNGLCOLOR4UBVPROC)load("glColor4ubv");
  mjGlad_glColor4ui = (PFNGLCOLOR4UIPROC)load("glColor4ui");
  mjGlad_glColor4uiv = (PFNGLCOLOR4UIVPROC)load("glColor4uiv");
  mjGlad_glColor4us = (PFNGLCOLOR4USPROC)load("glColor4us");
  mjGlad_glColor4usv = (PFNGLCOLOR4USVPROC)load("glColor4usv");
  mjGlad_glEdgeFlag = (PFNGLEDGEFLAGPROC)load("glEdgeFlag");
  mjGlad_glEdgeFlagv = (PFNGLEDGEFLAGVPROC)load("glEdgeFlagv");
  mjGlad_glEnd = (PFNGLENDPROC)load("glEnd");
  mjGlad_glIndexd = (PFNGLINDEXDPROC)load("glIndexd");
  mjGlad_glIndexdv = (PFNGLINDEXDVPROC)load("glIndexdv");
  mjGlad_glIndexf = (PFNGLINDEXFPROC)load("glIndexf");
  mjGlad_glIndexfv = (PFNGLINDEXFVPROC)load("glIndexfv");
  mjGlad_glIndexi = (PFNGLINDEXIPROC)load("glIndexi");
  mjGlad_glIndexiv = (PFNGLINDEXIVPROC)load("glIndexiv");
  mjGlad_glIndexs = (PFNGLINDEXSPROC)load("glIndexs");
  mjGlad_glIndexsv = (PFNGLINDEXSVPROC)load("glIndexsv");
  mjGlad_glNormal3b = (PFNGLNORMAL3BPROC)load("glNormal3b");
  mjGlad_glNormal3bv = (PFNGLNORMAL3BVPROC)load("glNormal3bv");
  mjGlad_glNormal3d = (PFNGLNORMAL3DPROC)load("glNormal3d");
  mjGlad_glNormal3dv = (PFNGLNORMAL3DVPROC)load("glNormal3dv");
  mjGlad_glNormal3f = (PFNGLNORMAL3FPROC)load("glNormal3f");
  mjGlad_glNormal3fv = (PFNGLNORMAL3FVPROC)load("glNormal3fv");
  mjGlad_glNormal3i = (PFNGLNORMAL3IPROC)load("glNormal3i");
  mjGlad_glNormal3iv = (PFNGLNORMAL3IVPROC)load("glNormal3iv");
  mjGlad_glNormal3s = (PFNGLNORMAL3SPROC)load("glNormal3s");
  mjGlad_glNormal3sv = (PFNGLNORMAL3SVPROC)load("glNormal3sv");
  mjGlad_glRasterPos2d = (PFNGLRASTERPOS2DPROC)load("glRasterPos2d");
  mjGlad_glRasterPos2dv = (PFNGLRASTERPOS2DVPROC)load("glRasterPos2dv");
  mjGlad_glRasterPos2f = (PFNGLRASTERPOS2FPROC)load("glRasterPos2f");
  mjGlad_glRasterPos2fv = (PFNGLRASTERPOS2FVPROC)load("glRasterPos2fv");
  mjGlad_glRasterPos2i = (PFNGLRASTERPOS2IPROC)load("glRasterPos2i");
  mjGlad_glRasterPos2iv = (PFNGLRASTERPOS2IVPROC)load("glRasterPos2iv");
  mjGlad_glRasterPos2s = (PFNGLRASTERPOS2SPROC)load("glRasterPos2s");
  mjGlad_glRasterPos2sv = (PFNGLRASTERPOS2SVPROC)load("glRasterPos2sv");
  mjGlad_glRasterPos3d = (PFNGLRASTERPOS3DPROC)load("glRasterPos3d");
  mjGlad_glRasterPos3dv = (PFNGLRASTERPOS3DVPROC)load("glRasterPos3dv");
  mjGlad_glRasterPos3f = (PFNGLRASTERPOS3FPROC)load("glRasterPos3f");
  mjGlad_glRasterPos3fv = (PFNGLRASTERPOS3FVPROC)load("glRasterPos3fv");
  mjGlad_glRasterPos3i = (PFNGLRASTERPOS3IPROC)load("glRasterPos3i");
  mjGlad_glRasterPos3iv = (PFNGLRASTERPOS3IVPROC)load("glRasterPos3iv");
  mjGlad_glRasterPos3s = (PFNGLRASTERPOS3SPROC)load("glRasterPos3s");
  mjGlad_glRasterPos3sv = (PFNGLRASTERPOS3SVPROC)load("glRasterPos3sv");
  mjGlad_glRasterPos4d = (PFNGLRASTERPOS4DPROC)load("glRasterPos4d");
  mjGlad_glRasterPos4dv = (PFNGLRASTERPOS4DVPROC)load("glRasterPos4dv");
  mjGlad_glRasterPos4f = (PFNGLRASTERPOS4FPROC)load("glRasterPos4f");
  mjGlad_glRasterPos4fv = (PFNGLRASTERPOS4FVPROC)load("glRasterPos4fv");
  mjGlad_glRasterPos4i = (PFNGLRASTERPOS4IPROC)load("glRasterPos4i");
  mjGlad_glRasterPos4iv = (PFNGLRASTERPOS4IVPROC)load("glRasterPos4iv");
  mjGlad_glRasterPos4s = (PFNGLRASTERPOS4SPROC)load("glRasterPos4s");
  mjGlad_glRasterPos4sv = (PFNGLRASTERPOS4SVPROC)load("glRasterPos4sv");
  mjGlad_glRectd = (PFNGLRECTDPROC)load("glRectd");
  mjGlad_glRectdv = (PFNGLRECTDVPROC)load("glRectdv");
  mjGlad_glRectf = (PFNGLRECTFPROC)load("glRectf");
  mjGlad_glRectfv = (PFNGLRECTFVPROC)load("glRectfv");
  mjGlad_glRecti = (PFNGLRECTIPROC)load("glRecti");
  mjGlad_glRectiv = (PFNGLRECTIVPROC)load("glRectiv");
  mjGlad_glRects = (PFNGLRECTSPROC)load("glRects");
  mjGlad_glRectsv = (PFNGLRECTSVPROC)load("glRectsv");
  mjGlad_glTexCoord1d = (PFNGLTEXCOORD1DPROC)load("glTexCoord1d");
  mjGlad_glTexCoord1dv = (PFNGLTEXCOORD1DVPROC)load("glTexCoord1dv");
  mjGlad_glTexCoord1f = (PFNGLTEXCOORD1FPROC)load("glTexCoord1f");
  mjGlad_glTexCoord1fv = (PFNGLTEXCOORD1FVPROC)load("glTexCoord1fv");
  mjGlad_glTexCoord1i = (PFNGLTEXCOORD1IPROC)load("glTexCoord1i");
  mjGlad_glTexCoord1iv = (PFNGLTEXCOORD1IVPROC)load("glTexCoord1iv");
  mjGlad_glTexCoord1s = (PFNGLTEXCOORD1SPROC)load("glTexCoord1s");
  mjGlad_glTexCoord1sv = (PFNGLTEXCOORD1SVPROC)load("glTexCoord1sv");
  mjGlad_glTexCoord2d = (PFNGLTEXCOORD2DPROC)load("glTexCoord2d");
  mjGlad_glTexCoord2dv = (PFNGLTEXCOORD2DVPROC)load("glTexCoord2dv");
  mjGlad_glTexCoord2f = (PFNGLTEXCOORD2FPROC)load("glTexCoord2f");
  mjGlad_glTexCoord2fv = (PFNGLTEXCOORD2FVPROC)load("glTexCoord2fv");
  mjGlad_glTexCoord2i = (PFNGLTEXCOORD2IPROC)load("glTexCoord2i");
  mjGlad_glTexCoord2iv = (PFNGLTEXCOORD2IVPROC)load("glTexCoord2iv");
  mjGlad_glTexCoord2s = (PFNGLTEXCOORD2SPROC)load("glTexCoord2s");
  mjGlad_glTexCoord2sv = (PFNGLTEXCOORD2SVPROC)load("glTexCoord2sv");
  mjGlad_glTexCoord3d = (PFNGLTEXCOORD3DPROC)load("glTexCoord3d");
  mjGlad_glTexCoord3dv = (PFNGLTEXCOORD3DVPROC)load("glTexCoord3dv");
  mjGlad_glTexCoord3f = (PFNGLTEXCOORD3FPROC)load("glTexCoord3f");
  mjGlad_glTexCoord3fv = (PFNGLTEXCOORD3FVPROC)load("glTexCoord3fv");
  mjGlad_glTexCoord3i = (PFNGLTEXCOORD3IPROC)load("glTexCoord3i");
  mjGlad_glTexCoord3iv = (PFNGLTEXCOORD3IVPROC)load("glTexCoord3iv");
  mjGlad_glTexCoord3s = (PFNGLTEXCOORD3SPROC)load("glTexCoord3s");
  mjGlad_glTexCoord3sv = (PFNGLTEXCOORD3SVPROC)load("glTexCoord3sv");
  mjGlad_glTexCoord4d = (PFNGLTEXCOORD4DPROC)load("glTexCoord4d");
  mjGlad_glTexCoord4dv = (PFNGLTEXCOORD4DVPROC)load("glTexCoord4dv");
  mjGlad_glTexCoord4f = (PFNGLTEXCOORD4FPROC)load("glTexCoord4f");
  mjGlad_glTexCoord4fv = (PFNGLTEXCOORD4FVPROC)load("glTexCoord4fv");
  mjGlad_glTexCoord4i = (PFNGLTEXCOORD4IPROC)load("glTexCoord4i");
  mjGlad_glTexCoord4iv = (PFNGLTEXCOORD4IVPROC)load("glTexCoord4iv");
  mjGlad_glTexCoord4s = (PFNGLTEXCOORD4SPROC)load("glTexCoord4s");
  mjGlad_glTexCoord4sv = (PFNGLTEXCOORD4SVPROC)load("glTexCoord4sv");
  mjGlad_glVertex2d = (PFNGLVERTEX2DPROC)load("glVertex2d");
  mjGlad_glVertex2dv = (PFNGLVERTEX2DVPROC)load("glVertex2dv");
  mjGlad_glVertex2f = (PFNGLVERTEX2FPROC)load("glVertex2f");
  mjGlad_glVertex2fv = (PFNGLVERTEX2FVPROC)load("glVertex2fv");
  mjGlad_glVertex2i = (PFNGLVERTEX2IPROC)load("glVertex2i");
  mjGlad_glVertex2iv = (PFNGLVERTEX2IVPROC)load("glVertex2iv");
  mjGlad_glVertex2s = (PFNGLVERTEX2SPROC)load("glVertex2s");
  mjGlad_glVertex2sv = (PFNGLVERTEX2SVPROC)load("glVertex2sv");
  mjGlad_glVertex3d = (PFNGLVERTEX3DPROC)load("glVertex3d");
  mjGlad_glVertex3dv = (PFNGLVERTEX3DVPROC)load("glVertex3dv");
  mjGlad_glVertex3f = (PFNGLVERTEX3FPROC)load("glVertex3f");
  mjGlad_glVertex3fv = (PFNGLVERTEX3FVPROC)load("glVertex3fv");
  mjGlad_glVertex3i = (PFNGLVERTEX3IPROC)load("glVertex3i");
  mjGlad_glVertex3iv = (PFNGLVERTEX3IVPROC)load("glVertex3iv");
  mjGlad_glVertex3s = (PFNGLVERTEX3SPROC)load("glVertex3s");
  mjGlad_glVertex3sv = (PFNGLVERTEX3SVPROC)load("glVertex3sv");
  mjGlad_glVertex4d = (PFNGLVERTEX4DPROC)load("glVertex4d");
  mjGlad_glVertex4dv = (PFNGLVERTEX4DVPROC)load("glVertex4dv");
  mjGlad_glVertex4f = (PFNGLVERTEX4FPROC)load("glVertex4f");
  mjGlad_glVertex4fv = (PFNGLVERTEX4FVPROC)load("glVertex4fv");
  mjGlad_glVertex4i = (PFNGLVERTEX4IPROC)load("glVertex4i");
  mjGlad_glVertex4iv = (PFNGLVERTEX4IVPROC)load("glVertex4iv");
  mjGlad_glVertex4s = (PFNGLVERTEX4SPROC)load("glVertex4s");
  mjGlad_glVertex4sv = (PFNGLVERTEX4SVPROC)load("glVertex4sv");
  mjGlad_glClipPlane = (PFNGLCLIPPLANEPROC)load("glClipPlane");
  mjGlad_glColorMaterial = (PFNGLCOLORMATERIALPROC)load("glColorMaterial");
  mjGlad_glFogf = (PFNGLFOGFPROC)load("glFogf");
  mjGlad_glFogfv = (PFNGLFOGFVPROC)load("glFogfv");
  mjGlad_glFogi = (PFNGLFOGIPROC)load("glFogi");
  mjGlad_glFogiv = (PFNGLFOGIVPROC)load("glFogiv");
  mjGlad_glLightf = (PFNGLLIGHTFPROC)load("glLightf");
  mjGlad_glLightfv = (PFNGLLIGHTFVPROC)load("glLightfv");
  mjGlad_glLighti = (PFNGLLIGHTIPROC)load("glLighti");
  mjGlad_glLightiv = (PFNGLLIGHTIVPROC)load("glLightiv");
  mjGlad_glLightModelf = (PFNGLLIGHTMODELFPROC)load("glLightModelf");
  mjGlad_glLightModelfv = (PFNGLLIGHTMODELFVPROC)load("glLightModelfv");
  mjGlad_glLightModeli = (PFNGLLIGHTMODELIPROC)load("glLightModeli");
  mjGlad_glLightModeliv = (PFNGLLIGHTMODELIVPROC)load("glLightModeliv");
  mjGlad_glLineStipple = (PFNGLLINESTIPPLEPROC)load("glLineStipple");
  mjGlad_glMaterialf = (PFNGLMATERIALFPROC)load("glMaterialf");
  mjGlad_glMaterialfv = (PFNGLMATERIALFVPROC)load("glMaterialfv");
  mjGlad_glMateriali = (PFNGLMATERIALIPROC)load("glMateriali");
  mjGlad_glMaterialiv = (PFNGLMATERIALIVPROC)load("glMaterialiv");
  mjGlad_glPolygonStipple = (PFNGLPOLYGONSTIPPLEPROC)load("glPolygonStipple");
  mjGlad_glShadeModel = (PFNGLSHADEMODELPROC)load("glShadeModel");
  mjGlad_glTexEnvf = (PFNGLTEXENVFPROC)load("glTexEnvf");
  mjGlad_glTexEnvfv = (PFNGLTEXENVFVPROC)load("glTexEnvfv");
  mjGlad_glTexEnvi = (PFNGLTEXENVIPROC)load("glTexEnvi");
  mjGlad_glTexEnviv = (PFNGLTEXENVIVPROC)load("glTexEnviv");
  mjGlad_glTexGend = (PFNGLTEXGENDPROC)load("glTexGend");
  mjGlad_glTexGendv = (PFNGLTEXGENDVPROC)load("glTexGendv");
  mjGlad_glTexGenf = (PFNGLTEXGENFPROC)load("glTexGenf");
  mjGlad_glTexGenfv = (PFNGLTEXGENFVPROC)load("glTexGenfv");
  mjGlad_glTexGeni = (PFNGLTEXGENIPROC)load("glTexGeni");
  mjGlad_glTexGeniv = (PFNGLTEXGENIVPROC)load("glTexGeniv");
  mjGlad_glFeedbackBuffer = (PFNGLFEEDBACKBUFFERPROC)load("glFeedbackBuffer");
  mjGlad_glSelectBuffer = (PFNGLSELECTBUFFERPROC)load("glSelectBuffer");
  mjGlad_glRenderMode = (PFNGLRENDERMODEPROC)load("glRenderMode");
  mjGlad_glInitNames = (PFNGLINITNAMESPROC)load("glInitNames");
  mjGlad_glLoadName = (PFNGLLOADNAMEPROC)load("glLoadName");
  mjGlad_glPassThrough = (PFNGLPASSTHROUGHPROC)load("glPassThrough");
  mjGlad_glPopName = (PFNGLPOPNAMEPROC)load("glPopName");
  mjGlad_glPushName = (PFNGLPUSHNAMEPROC)load("glPushName");
  mjGlad_glClearAccum = (PFNGLCLEARACCUMPROC)load("glClearAccum");
  mjGlad_glClearIndex = (PFNGLCLEARINDEXPROC)load("glClearIndex");
  mjGlad_glIndexMask = (PFNGLINDEXMASKPROC)load("glIndexMask");
  mjGlad_glAccum = (PFNGLACCUMPROC)load("glAccum");
  mjGlad_glPopAttrib = (PFNGLPOPATTRIBPROC)load("glPopAttrib");
  mjGlad_glPushAttrib = (PFNGLPUSHATTRIBPROC)load("glPushAttrib");
  mjGlad_glMap1d = (PFNGLMAP1DPROC)load("glMap1d");
  mjGlad_glMap1f = (PFNGLMAP1FPROC)load("glMap1f");
  mjGlad_glMap2d = (PFNGLMAP2DPROC)load("glMap2d");
  mjGlad_glMap2f = (PFNGLMAP2FPROC)load("glMap2f");
  mjGlad_glMapGrid1d = (PFNGLMAPGRID1DPROC)load("glMapGrid1d");
  mjGlad_glMapGrid1f = (PFNGLMAPGRID1FPROC)load("glMapGrid1f");
  mjGlad_glMapGrid2d = (PFNGLMAPGRID2DPROC)load("glMapGrid2d");
  mjGlad_glMapGrid2f = (PFNGLMAPGRID2FPROC)load("glMapGrid2f");
  mjGlad_glEvalCoord1d = (PFNGLEVALCOORD1DPROC)load("glEvalCoord1d");
  mjGlad_glEvalCoord1dv = (PFNGLEVALCOORD1DVPROC)load("glEvalCoord1dv");
  mjGlad_glEvalCoord1f = (PFNGLEVALCOORD1FPROC)load("glEvalCoord1f");
  mjGlad_glEvalCoord1fv = (PFNGLEVALCOORD1FVPROC)load("glEvalCoord1fv");
  mjGlad_glEvalCoord2d = (PFNGLEVALCOORD2DPROC)load("glEvalCoord2d");
  mjGlad_glEvalCoord2dv = (PFNGLEVALCOORD2DVPROC)load("glEvalCoord2dv");
  mjGlad_glEvalCoord2f = (PFNGLEVALCOORD2FPROC)load("glEvalCoord2f");
  mjGlad_glEvalCoord2fv = (PFNGLEVALCOORD2FVPROC)load("glEvalCoord2fv");
  mjGlad_glEvalMesh1 = (PFNGLEVALMESH1PROC)load("glEvalMesh1");
  mjGlad_glEvalPoint1 = (PFNGLEVALPOINT1PROC)load("glEvalPoint1");
  mjGlad_glEvalMesh2 = (PFNGLEVALMESH2PROC)load("glEvalMesh2");
  mjGlad_glEvalPoint2 = (PFNGLEVALPOINT2PROC)load("glEvalPoint2");
  mjGlad_glAlphaFunc = (PFNGLALPHAFUNCPROC)load("glAlphaFunc");
  mjGlad_glPixelZoom = (PFNGLPIXELZOOMPROC)load("glPixelZoom");
  mjGlad_glPixelTransferf = (PFNGLPIXELTRANSFERFPROC)load("glPixelTransferf");
  mjGlad_glPixelTransferi = (PFNGLPIXELTRANSFERIPROC)load("glPixelTransferi");
  mjGlad_glPixelMapfv = (PFNGLPIXELMAPFVPROC)load("glPixelMapfv");
  mjGlad_glPixelMapuiv = (PFNGLPIXELMAPUIVPROC)load("glPixelMapuiv");
  mjGlad_glPixelMapusv = (PFNGLPIXELMAPUSVPROC)load("glPixelMapusv");
  mjGlad_glCopyPixels = (PFNGLCOPYPIXELSPROC)load("glCopyPixels");
  mjGlad_glDrawPixels = (PFNGLDRAWPIXELSPROC)load("glDrawPixels");
  mjGlad_glGetClipPlane = (PFNGLGETCLIPPLANEPROC)load("glGetClipPlane");
  mjGlad_glGetLightfv = (PFNGLGETLIGHTFVPROC)load("glGetLightfv");
  mjGlad_glGetLightiv = (PFNGLGETLIGHTIVPROC)load("glGetLightiv");
  mjGlad_glGetMapdv = (PFNGLGETMAPDVPROC)load("glGetMapdv");
  mjGlad_glGetMapfv = (PFNGLGETMAPFVPROC)load("glGetMapfv");
  mjGlad_glGetMapiv = (PFNGLGETMAPIVPROC)load("glGetMapiv");
  mjGlad_glGetMaterialfv = (PFNGLGETMATERIALFVPROC)load("glGetMaterialfv");
  mjGlad_glGetMaterialiv = (PFNGLGETMATERIALIVPROC)load("glGetMaterialiv");
  mjGlad_glGetPixelMapfv = (PFNGLGETPIXELMAPFVPROC)load("glGetPixelMapfv");
  mjGlad_glGetPixelMapuiv = (PFNGLGETPIXELMAPUIVPROC)load("glGetPixelMapuiv");
  mjGlad_glGetPixelMapusv = (PFNGLGETPIXELMAPUSVPROC)load("glGetPixelMapusv");
  mjGlad_glGetPolygonStipple = (PFNGLGETPOLYGONSTIPPLEPROC)load("glGetPolygonStipple");
  mjGlad_glGetTexEnvfv = (PFNGLGETTEXENVFVPROC)load("glGetTexEnvfv");
  mjGlad_glGetTexEnviv = (PFNGLGETTEXENVIVPROC)load("glGetTexEnviv");
  mjGlad_glGetTexGendv = (PFNGLGETTEXGENDVPROC)load("glGetTexGendv");
  mjGlad_glGetTexGenfv = (PFNGLGETTEXGENFVPROC)load("glGetTexGenfv");
  mjGlad_glGetTexGeniv = (PFNGLGETTEXGENIVPROC)load("glGetTexGeniv");
  mjGlad_glIsList = (PFNGLISLISTPROC)load("glIsList");
  mjGlad_glFrustum = (PFNGLFRUSTUMPROC)load("glFrustum");
  mjGlad_glLoadIdentity = (PFNGLLOADIDENTITYPROC)load("glLoadIdentity");
  mjGlad_glLoadMatrixf = (PFNGLLOADMATRIXFPROC)load("glLoadMatrixf");
  mjGlad_glLoadMatrixd = (PFNGLLOADMATRIXDPROC)load("glLoadMatrixd");
  mjGlad_glMatrixMode = (PFNGLMATRIXMODEPROC)load("glMatrixMode");
  mjGlad_glMultMatrixf = (PFNGLMULTMATRIXFPROC)load("glMultMatrixf");
  mjGlad_glMultMatrixd = (PFNGLMULTMATRIXDPROC)load("glMultMatrixd");
  mjGlad_glOrtho = (PFNGLORTHOPROC)load("glOrtho");
  mjGlad_glPopMatrix = (PFNGLPOPMATRIXPROC)load("glPopMatrix");
  mjGlad_glPushMatrix = (PFNGLPUSHMATRIXPROC)load("glPushMatrix");
  mjGlad_glRotated = (PFNGLROTATEDPROC)load("glRotated");
  mjGlad_glRotatef = (PFNGLROTATEFPROC)load("glRotatef");
  mjGlad_glScaled = (PFNGLSCALEDPROC)load("glScaled");
  mjGlad_glScalef = (PFNGLSCALEFPROC)load("glScalef");
  mjGlad_glTranslated = (PFNGLTRANSLATEDPROC)load("glTranslated");
  mjGlad_glTranslatef = (PFNGLTRANSLATEFPROC)load("glTranslatef");
}
static void mjGlad_load_GL_VERSION_1_1(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_1) return;
  mjGlad_glDrawArrays = (PFNGLDRAWARRAYSPROC)load("glDrawArrays");
  mjGlad_glDrawElements = (PFNGLDRAWELEMENTSPROC)load("glDrawElements");
  mjGlad_glGetPointerv = (PFNGLGETPOINTERVPROC)load("glGetPointerv");
  mjGlad_glPolygonOffset = (PFNGLPOLYGONOFFSETPROC)load("glPolygonOffset");
  mjGlad_glCopyTexImage1D = (PFNGLCOPYTEXIMAGE1DPROC)load("glCopyTexImage1D");
  mjGlad_glCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)load("glCopyTexImage2D");
  mjGlad_glCopyTexSubImage1D = (PFNGLCOPYTEXSUBIMAGE1DPROC)load("glCopyTexSubImage1D");
  mjGlad_glCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)load("glCopyTexSubImage2D");
  mjGlad_glTexSubImage1D = (PFNGLTEXSUBIMAGE1DPROC)load("glTexSubImage1D");
  mjGlad_glTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)load("glTexSubImage2D");
  mjGlad_glBindTexture = (PFNGLBINDTEXTUREPROC)load("glBindTexture");
  mjGlad_glDeleteTextures = (PFNGLDELETETEXTURESPROC)load("glDeleteTextures");
  mjGlad_glGenTextures = (PFNGLGENTEXTURESPROC)load("glGenTextures");
  mjGlad_glIsTexture = (PFNGLISTEXTUREPROC)load("glIsTexture");
  mjGlad_glArrayElement = (PFNGLARRAYELEMENTPROC)load("glArrayElement");
  mjGlad_glColorPointer = (PFNGLCOLORPOINTERPROC)load("glColorPointer");
  mjGlad_glDisableClientState = (PFNGLDISABLECLIENTSTATEPROC)load("glDisableClientState");
  mjGlad_glEdgeFlagPointer = (PFNGLEDGEFLAGPOINTERPROC)load("glEdgeFlagPointer");
  mjGlad_glEnableClientState = (PFNGLENABLECLIENTSTATEPROC)load("glEnableClientState");
  mjGlad_glIndexPointer = (PFNGLINDEXPOINTERPROC)load("glIndexPointer");
  mjGlad_glInterleavedArrays = (PFNGLINTERLEAVEDARRAYSPROC)load("glInterleavedArrays");
  mjGlad_glNormalPointer = (PFNGLNORMALPOINTERPROC)load("glNormalPointer");
  mjGlad_glTexCoordPointer = (PFNGLTEXCOORDPOINTERPROC)load("glTexCoordPointer");
  mjGlad_glVertexPointer = (PFNGLVERTEXPOINTERPROC)load("glVertexPointer");
  mjGlad_glAreTexturesResident = (PFNGLARETEXTURESRESIDENTPROC)load("glAreTexturesResident");
  mjGlad_glPrioritizeTextures = (PFNGLPRIORITIZETEXTURESPROC)load("glPrioritizeTextures");
  mjGlad_glIndexub = (PFNGLINDEXUBPROC)load("glIndexub");
  mjGlad_glIndexubv = (PFNGLINDEXUBVPROC)load("glIndexubv");
  mjGlad_glPopClientAttrib = (PFNGLPOPCLIENTATTRIBPROC)load("glPopClientAttrib");
  mjGlad_glPushClientAttrib = (PFNGLPUSHCLIENTATTRIBPROC)load("glPushClientAttrib");
}
static void mjGlad_load_GL_VERSION_1_2(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_2) return;
  mjGlad_glDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)load("glDrawRangeElements");
  mjGlad_glTexImage3D = (PFNGLTEXIMAGE3DPROC)load("glTexImage3D");
  mjGlad_glTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)load("glTexSubImage3D");
  mjGlad_glCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)load("glCopyTexSubImage3D");
}
static void mjGlad_load_GL_VERSION_1_3(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_3) return;
  mjGlad_glActiveTexture = (PFNGLACTIVETEXTUREPROC)load("glActiveTexture");
  mjGlad_glSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)load("glSampleCoverage");
  mjGlad_glCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)load("glCompressedTexImage3D");
  mjGlad_glCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)load("glCompressedTexImage2D");
  mjGlad_glCompressedTexImage1D = (PFNGLCOMPRESSEDTEXIMAGE1DPROC)load("glCompressedTexImage1D");
  mjGlad_glCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)load("glCompressedTexSubImage3D");
  mjGlad_glCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)load("glCompressedTexSubImage2D");
  mjGlad_glCompressedTexSubImage1D = (PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC)load("glCompressedTexSubImage1D");
  mjGlad_glGetCompressedTexImage = (PFNGLGETCOMPRESSEDTEXIMAGEPROC)load("glGetCompressedTexImage");
  mjGlad_glClientActiveTexture = (PFNGLCLIENTACTIVETEXTUREPROC)load("glClientActiveTexture");
  mjGlad_glMultiTexCoord1d = (PFNGLMULTITEXCOORD1DPROC)load("glMultiTexCoord1d");
  mjGlad_glMultiTexCoord1dv = (PFNGLMULTITEXCOORD1DVPROC)load("glMultiTexCoord1dv");
  mjGlad_glMultiTexCoord1f = (PFNGLMULTITEXCOORD1FPROC)load("glMultiTexCoord1f");
  mjGlad_glMultiTexCoord1fv = (PFNGLMULTITEXCOORD1FVPROC)load("glMultiTexCoord1fv");
  mjGlad_glMultiTexCoord1i = (PFNGLMULTITEXCOORD1IPROC)load("glMultiTexCoord1i");
  mjGlad_glMultiTexCoord1iv = (PFNGLMULTITEXCOORD1IVPROC)load("glMultiTexCoord1iv");
  mjGlad_glMultiTexCoord1s = (PFNGLMULTITEXCOORD1SPROC)load("glMultiTexCoord1s");
  mjGlad_glMultiTexCoord1sv = (PFNGLMULTITEXCOORD1SVPROC)load("glMultiTexCoord1sv");
  mjGlad_glMultiTexCoord2d = (PFNGLMULTITEXCOORD2DPROC)load("glMultiTexCoord2d");
  mjGlad_glMultiTexCoord2dv = (PFNGLMULTITEXCOORD2DVPROC)load("glMultiTexCoord2dv");
  mjGlad_glMultiTexCoord2f = (PFNGLMULTITEXCOORD2FPROC)load("glMultiTexCoord2f");
  mjGlad_glMultiTexCoord2fv = (PFNGLMULTITEXCOORD2FVPROC)load("glMultiTexCoord2fv");
  mjGlad_glMultiTexCoord2i = (PFNGLMULTITEXCOORD2IPROC)load("glMultiTexCoord2i");
  mjGlad_glMultiTexCoord2iv = (PFNGLMULTITEXCOORD2IVPROC)load("glMultiTexCoord2iv");
  mjGlad_glMultiTexCoord2s = (PFNGLMULTITEXCOORD2SPROC)load("glMultiTexCoord2s");
  mjGlad_glMultiTexCoord2sv = (PFNGLMULTITEXCOORD2SVPROC)load("glMultiTexCoord2sv");
  mjGlad_glMultiTexCoord3d = (PFNGLMULTITEXCOORD3DPROC)load("glMultiTexCoord3d");
  mjGlad_glMultiTexCoord3dv = (PFNGLMULTITEXCOORD3DVPROC)load("glMultiTexCoord3dv");
  mjGlad_glMultiTexCoord3f = (PFNGLMULTITEXCOORD3FPROC)load("glMultiTexCoord3f");
  mjGlad_glMultiTexCoord3fv = (PFNGLMULTITEXCOORD3FVPROC)load("glMultiTexCoord3fv");
  mjGlad_glMultiTexCoord3i = (PFNGLMULTITEXCOORD3IPROC)load("glMultiTexCoord3i");
  mjGlad_glMultiTexCoord3iv = (PFNGLMULTITEXCOORD3IVPROC)load("glMultiTexCoord3iv");
  mjGlad_glMultiTexCoord3s = (PFNGLMULTITEXCOORD3SPROC)load("glMultiTexCoord3s");
  mjGlad_glMultiTexCoord3sv = (PFNGLMULTITEXCOORD3SVPROC)load("glMultiTexCoord3sv");
  mjGlad_glMultiTexCoord4d = (PFNGLMULTITEXCOORD4DPROC)load("glMultiTexCoord4d");
  mjGlad_glMultiTexCoord4dv = (PFNGLMULTITEXCOORD4DVPROC)load("glMultiTexCoord4dv");
  mjGlad_glMultiTexCoord4f = (PFNGLMULTITEXCOORD4FPROC)load("glMultiTexCoord4f");
  mjGlad_glMultiTexCoord4fv = (PFNGLMULTITEXCOORD4FVPROC)load("glMultiTexCoord4fv");
  mjGlad_glMultiTexCoord4i = (PFNGLMULTITEXCOORD4IPROC)load("glMultiTexCoord4i");
  mjGlad_glMultiTexCoord4iv = (PFNGLMULTITEXCOORD4IVPROC)load("glMultiTexCoord4iv");
  mjGlad_glMultiTexCoord4s = (PFNGLMULTITEXCOORD4SPROC)load("glMultiTexCoord4s");
  mjGlad_glMultiTexCoord4sv = (PFNGLMULTITEXCOORD4SVPROC)load("glMultiTexCoord4sv");
  mjGlad_glLoadTransposeMatrixf = (PFNGLLOADTRANSPOSEMATRIXFPROC)load("glLoadTransposeMatrixf");
  mjGlad_glLoadTransposeMatrixd = (PFNGLLOADTRANSPOSEMATRIXDPROC)load("glLoadTransposeMatrixd");
  mjGlad_glMultTransposeMatrixf = (PFNGLMULTTRANSPOSEMATRIXFPROC)load("glMultTransposeMatrixf");
  mjGlad_glMultTransposeMatrixd = (PFNGLMULTTRANSPOSEMATRIXDPROC)load("glMultTransposeMatrixd");
}
static void mjGlad_load_GL_VERSION_1_4(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_4) return;
  mjGlad_glBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)load("glBlendFuncSeparate");
  mjGlad_glMultiDrawArrays = (PFNGLMULTIDRAWARRAYSPROC)load("glMultiDrawArrays");
  mjGlad_glMultiDrawElements = (PFNGLMULTIDRAWELEMENTSPROC)load("glMultiDrawElements");
  mjGlad_glPointParameterf = (PFNGLPOINTPARAMETERFPROC)load("glPointParameterf");
  mjGlad_glPointParameterfv = (PFNGLPOINTPARAMETERFVPROC)load("glPointParameterfv");
  mjGlad_glPointParameteri = (PFNGLPOINTPARAMETERIPROC)load("glPointParameteri");
  mjGlad_glPointParameteriv = (PFNGLPOINTPARAMETERIVPROC)load("glPointParameteriv");
  mjGlad_glFogCoordf = (PFNGLFOGCOORDFPROC)load("glFogCoordf");
  mjGlad_glFogCoordfv = (PFNGLFOGCOORDFVPROC)load("glFogCoordfv");
  mjGlad_glFogCoordd = (PFNGLFOGCOORDDPROC)load("glFogCoordd");
  mjGlad_glFogCoorddv = (PFNGLFOGCOORDDVPROC)load("glFogCoorddv");
  mjGlad_glFogCoordPointer = (PFNGLFOGCOORDPOINTERPROC)load("glFogCoordPointer");
  mjGlad_glSecondaryColor3b = (PFNGLSECONDARYCOLOR3BPROC)load("glSecondaryColor3b");
  mjGlad_glSecondaryColor3bv = (PFNGLSECONDARYCOLOR3BVPROC)load("glSecondaryColor3bv");
  mjGlad_glSecondaryColor3d = (PFNGLSECONDARYCOLOR3DPROC)load("glSecondaryColor3d");
  mjGlad_glSecondaryColor3dv = (PFNGLSECONDARYCOLOR3DVPROC)load("glSecondaryColor3dv");
  mjGlad_glSecondaryColor3f = (PFNGLSECONDARYCOLOR3FPROC)load("glSecondaryColor3f");
  mjGlad_glSecondaryColor3fv = (PFNGLSECONDARYCOLOR3FVPROC)load("glSecondaryColor3fv");
  mjGlad_glSecondaryColor3i = (PFNGLSECONDARYCOLOR3IPROC)load("glSecondaryColor3i");
  mjGlad_glSecondaryColor3iv = (PFNGLSECONDARYCOLOR3IVPROC)load("glSecondaryColor3iv");
  mjGlad_glSecondaryColor3s = (PFNGLSECONDARYCOLOR3SPROC)load("glSecondaryColor3s");
  mjGlad_glSecondaryColor3sv = (PFNGLSECONDARYCOLOR3SVPROC)load("glSecondaryColor3sv");
  mjGlad_glSecondaryColor3ub = (PFNGLSECONDARYCOLOR3UBPROC)load("glSecondaryColor3ub");
  mjGlad_glSecondaryColor3ubv = (PFNGLSECONDARYCOLOR3UBVPROC)load("glSecondaryColor3ubv");
  mjGlad_glSecondaryColor3ui = (PFNGLSECONDARYCOLOR3UIPROC)load("glSecondaryColor3ui");
  mjGlad_glSecondaryColor3uiv = (PFNGLSECONDARYCOLOR3UIVPROC)load("glSecondaryColor3uiv");
  mjGlad_glSecondaryColor3us = (PFNGLSECONDARYCOLOR3USPROC)load("glSecondaryColor3us");
  mjGlad_glSecondaryColor3usv = (PFNGLSECONDARYCOLOR3USVPROC)load("glSecondaryColor3usv");
  mjGlad_glSecondaryColorPointer = (PFNGLSECONDARYCOLORPOINTERPROC)load("glSecondaryColorPointer");
  mjGlad_glWindowPos2d = (PFNGLWINDOWPOS2DPROC)load("glWindowPos2d");
  mjGlad_glWindowPos2dv = (PFNGLWINDOWPOS2DVPROC)load("glWindowPos2dv");
  mjGlad_glWindowPos2f = (PFNGLWINDOWPOS2FPROC)load("glWindowPos2f");
  mjGlad_glWindowPos2fv = (PFNGLWINDOWPOS2FVPROC)load("glWindowPos2fv");
  mjGlad_glWindowPos2i = (PFNGLWINDOWPOS2IPROC)load("glWindowPos2i");
  mjGlad_glWindowPos2iv = (PFNGLWINDOWPOS2IVPROC)load("glWindowPos2iv");
  mjGlad_glWindowPos2s = (PFNGLWINDOWPOS2SPROC)load("glWindowPos2s");
  mjGlad_glWindowPos2sv = (PFNGLWINDOWPOS2SVPROC)load("glWindowPos2sv");
  mjGlad_glWindowPos3d = (PFNGLWINDOWPOS3DPROC)load("glWindowPos3d");
  mjGlad_glWindowPos3dv = (PFNGLWINDOWPOS3DVPROC)load("glWindowPos3dv");
  mjGlad_glWindowPos3f = (PFNGLWINDOWPOS3FPROC)load("glWindowPos3f");
  mjGlad_glWindowPos3fv = (PFNGLWINDOWPOS3FVPROC)load("glWindowPos3fv");
  mjGlad_glWindowPos3i = (PFNGLWINDOWPOS3IPROC)load("glWindowPos3i");
  mjGlad_glWindowPos3iv = (PFNGLWINDOWPOS3IVPROC)load("glWindowPos3iv");
  mjGlad_glWindowPos3s = (PFNGLWINDOWPOS3SPROC)load("glWindowPos3s");
  mjGlad_glWindowPos3sv = (PFNGLWINDOWPOS3SVPROC)load("glWindowPos3sv");
  mjGlad_glBlendColor = (PFNGLBLENDCOLORPROC)load("glBlendColor");
  mjGlad_glBlendEquation = (PFNGLBLENDEQUATIONPROC)load("glBlendEquation");
}
static void mjGlad_load_GL_VERSION_1_5(GLADloadproc load) {
  if(!mjGLAD_GL_VERSION_1_5) return;
  mjGlad_glGenQueries = (PFNGLGENQUERIESPROC)load("glGenQueries");
  mjGlad_glDeleteQueries = (PFNGLDELETEQUERIESPROC)load("glDeleteQueries");
  mjGlad_glIsQuery = (PFNGLISQUERYPROC)load("glIsQuery");
  mjGlad_glBeginQuery = (PFNGLBEGINQUERYPROC)load("glBeginQuery");
  mjGlad_glEndQuery = (PFNGLENDQUERYPROC)load("glEndQuery");
  mjGlad_glGetQueryiv = (PFNGLGETQUERYIVPROC)load("glGetQueryiv");
  mjGlad_glGetQueryObjectiv = (PFNGLGETQUERYOBJECTIVPROC)load("glGetQueryObjectiv");
  mjGlad_glGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)load("glGetQueryObjectuiv");
  mjGlad_glBindBuffer = (PFNGLBINDBUFFERPROC)load("glBindBuffer");
  mjGlad_glDeleteBuffers = (PFNGLDELETEBUFFERSPROC)load("glDeleteBuffers");
  mjGlad_glGenBuffers = (PFNGLGENBUFFERSPROC)load("glGenBuffers");
  mjGlad_glIsBuffer = (PFNGLISBUFFERPROC)load("glIsBuffer");
  mjGlad_glBufferData = (PFNGLBUFFERDATAPROC)load("glBufferData");
  mjGlad_glBufferSubData = (PFNGLBUFFERSUBDATAPROC)load("glBufferSubData");
  mjGlad_glGetBufferSubData = (PFNGLGETBUFFERSUBDATAPROC)load("glGetBufferSubData");
  mjGlad_glMapBuffer = (PFNGLMAPBUFFERPROC)load("glMapBuffer");
  mjGlad_glUnmapBuffer = (PFNGLUNMAPBUFFERPROC)load("glUnmapBuffer");
  mjGlad_glGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)load("glGetBufferParameteriv");
  mjGlad_glGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)load("glGetBufferPointerv");
}
static void mjGlad_load_GL_ARB_framebuffer_object(GLADloadproc load) {
  if(!mjGLAD_GL_ARB_framebuffer_object) return;
  mjGlad_glIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)load("glIsRenderbuffer");
  mjGlad_glBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)load("glBindRenderbuffer");
  mjGlad_glDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)load("glDeleteRenderbuffers");
  mjGlad_glGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)load("glGenRenderbuffers");
  mjGlad_glRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)load("glRenderbufferStorage");
  mjGlad_glGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)load("glGetRenderbufferParameteriv");
  mjGlad_glIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)load("glIsFramebuffer");
  mjGlad_glBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)load("glBindFramebuffer");
  mjGlad_glDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)load("glDeleteFramebuffers");
  mjGlad_glGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)load("glGenFramebuffers");
  mjGlad_glCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)load("glCheckFramebufferStatus");
  mjGlad_glFramebufferTexture1D = (PFNGLFRAMEBUFFERTEXTURE1DPROC)load("glFramebufferTexture1D");
  mjGlad_glFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)load("glFramebufferTexture2D");
  mjGlad_glFramebufferTexture3D = (PFNGLFRAMEBUFFERTEXTURE3DPROC)load("glFramebufferTexture3D");
  mjGlad_glFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)load("glFramebufferRenderbuffer");
  mjGlad_glGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)load("glGetFramebufferAttachmentParameteriv");
  mjGlad_glGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)load("glGenerateMipmap");
  mjGlad_glBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)load("glBlitFramebuffer");
  mjGlad_glRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)load("glRenderbufferStorageMultisample");
  mjGlad_glFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)load("glFramebufferTextureLayer");
}
static void mjGlad_load_GL_ARB_vertex_buffer_object(GLADloadproc load) {
  if(!mjGLAD_GL_ARB_vertex_buffer_object) return;
  mjGlad_glBindBufferARB = (PFNGLBINDBUFFERARBPROC)load("glBindBufferARB");
  mjGlad_glDeleteBuffersARB = (PFNGLDELETEBUFFERSARBPROC)load("glDeleteBuffersARB");
  mjGlad_glGenBuffersARB = (PFNGLGENBUFFERSARBPROC)load("glGenBuffersARB");
  mjGlad_glIsBufferARB = (PFNGLISBUFFERARBPROC)load("glIsBufferARB");
  mjGlad_glBufferDataARB = (PFNGLBUFFERDATAARBPROC)load("glBufferDataARB");
  mjGlad_glBufferSubDataARB = (PFNGLBUFFERSUBDATAARBPROC)load("glBufferSubDataARB");
  mjGlad_glGetBufferSubDataARB = (PFNGLGETBUFFERSUBDATAARBPROC)load("glGetBufferSubDataARB");
  mjGlad_glMapBufferARB = (PFNGLMAPBUFFERARBPROC)load("glMapBufferARB");
  mjGlad_glUnmapBufferARB = (PFNGLUNMAPBUFFERARBPROC)load("glUnmapBufferARB");
  mjGlad_glGetBufferParameterivARB = (PFNGLGETBUFFERPARAMETERIVARBPROC)load("glGetBufferParameterivARB");
  mjGlad_glGetBufferPointervARB = (PFNGLGETBUFFERPOINTERVARBPROC)load("glGetBufferPointervARB");
}
static void mjGlad_load_GL_KHR_debug(GLADloadproc load) {
  if(!mjGLAD_GL_KHR_debug) return;
  mjGlad_glDebugMessageControl = (PFNGLDEBUGMESSAGECONTROLPROC)load("glDebugMessageControl");
  mjGlad_glDebugMessageInsert = (PFNGLDEBUGMESSAGEINSERTPROC)load("glDebugMessageInsert");
  mjGlad_glDebugMessageCallback = (PFNGLDEBUGMESSAGECALLBACKPROC)load("glDebugMessageCallback");
  mjGlad_glGetDebugMessageLog = (PFNGLGETDEBUGMESSAGELOGPROC)load("glGetDebugMessageLog");
  mjGlad_glPushDebugGroup = (PFNGLPUSHDEBUGGROUPPROC)load("glPushDebugGroup");
  mjGlad_glPopDebugGroup = (PFNGLPOPDEBUGGROUPPROC)load("glPopDebugGroup");
  mjGlad_glObjectLabel = (PFNGLOBJECTLABELPROC)load("glObjectLabel");
  mjGlad_glGetObjectLabel = (PFNGLGETOBJECTLABELPROC)load("glGetObjectLabel");
  mjGlad_glObjectPtrLabel = (PFNGLOBJECTPTRLABELPROC)load("glObjectPtrLabel");
  mjGlad_glGetObjectPtrLabel = (PFNGLGETOBJECTPTRLABELPROC)load("glGetObjectPtrLabel");
  mjGlad_glGetPointerv = (PFNGLGETPOINTERVPROC)load("glGetPointerv");
  mjGlad_glDebugMessageControlKHR = (PFNGLDEBUGMESSAGECONTROLKHRPROC)load("glDebugMessageControlKHR");
  mjGlad_glDebugMessageInsertKHR = (PFNGLDEBUGMESSAGEINSERTKHRPROC)load("glDebugMessageInsertKHR");
  mjGlad_glDebugMessageCallbackKHR = (PFNGLDEBUGMESSAGECALLBACKKHRPROC)load("glDebugMessageCallbackKHR");
  mjGlad_glGetDebugMessageLogKHR = (PFNGLGETDEBUGMESSAGELOGKHRPROC)load("glGetDebugMessageLogKHR");
  mjGlad_glPushDebugGroupKHR = (PFNGLPUSHDEBUGGROUPKHRPROC)load("glPushDebugGroupKHR");
  mjGlad_glPopDebugGroupKHR = (PFNGLPOPDEBUGGROUPKHRPROC)load("glPopDebugGroupKHR");
  mjGlad_glObjectLabelKHR = (PFNGLOBJECTLABELKHRPROC)load("glObjectLabelKHR");
  mjGlad_glGetObjectLabelKHR = (PFNGLGETOBJECTLABELKHRPROC)load("glGetObjectLabelKHR");
  mjGlad_glObjectPtrLabelKHR = (PFNGLOBJECTPTRLABELKHRPROC)load("glObjectPtrLabelKHR");
  mjGlad_glGetObjectPtrLabelKHR = (PFNGLGETOBJECTPTRLABELKHRPROC)load("glGetObjectPtrLabelKHR");
  mjGlad_glGetPointervKHR = (PFNGLGETPOINTERVKHRPROC)load("glGetPointervKHR");
}
static int mjGlad_find_extensionsGL(void) {
  if (!mjGlad_get_exts()) return 0;
  mjGLAD_GL_ARB_framebuffer_object = mjGlad_has_ext("GL_ARB_framebuffer_object");
  mjGLAD_GL_ARB_seamless_cube_map = mjGlad_has_ext("GL_ARB_seamless_cube_map");
  mjGLAD_GL_ARB_vertex_buffer_object = mjGlad_has_ext("GL_ARB_vertex_buffer_object");
  mjGLAD_GL_KHR_debug = mjGlad_has_ext("GL_KHR_debug");
  mjGlad_free_exts();
  return 1;
}

static void mjGlad_find_coreGL(void) {

  /* Thank you @elmindreda
   * https://github.com/elmindreda/greg/blob/master/templates/greg.c.in#L176
   * https://github.com/glfw/glfw/blob/master/src/context.c#L36
   */
  int i, major, minor;

  const char* version;
  const char* prefixes[] = {
      "OpenGL ES-CM ",
      "OpenGL ES-CL ",
      "OpenGL ES ",
      NULL
  };

  version = (const char*) glGetString(GL_VERSION);
  if (!version) return;

  for (i = 0;  prefixes[i];  i++) {
    const size_t length = strlen(prefixes[i]);
    if (strncmp(version, prefixes[i], length) == 0) {
      version += length;
      break;
    }
  }

/* PR #18 */
#ifdef _MSC_VER
  sscanf_s(version, "%d.%d", &major, &minor);
#else
  sscanf(version, "%d.%d", &major, &minor);
#endif

  mjGLVersion.major = major; mjGLVersion.minor = minor;
  mjGlad_max_loaded_major = major; mjGlad_max_loaded_minor = minor;
  mjGLAD_GL_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
  mjGLAD_GL_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
  mjGLAD_GL_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
  mjGLAD_GL_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
  mjGLAD_GL_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
  mjGLAD_GL_VERSION_1_5 = (major == 1 && minor >= 5) || major > 1;
  if (mjGLVersion.major > 1 ||
      (mjGLVersion.major >= 1 && mjGLVersion.minor >= 5)) {
    mjGlad_max_loaded_major = 1;
    mjGlad_max_loaded_minor = 5;
  }
}

int mjGladLoadGLUnsafe() {
  if(mjGlad_open_gl()) {
    mjGLVersion.major = 0; mjGLVersion.minor = 0;
    glGetString = (PFNGLGETSTRINGPROC)mjGlad_get_proc("glGetString");
    if(glGetString == NULL) return 0;
    if(glGetString(GL_VERSION) == NULL) return 0;
    mjGlad_find_coreGL();
    mjGlad_load_GL_VERSION_1_0(mjGlad_get_proc);
    mjGlad_load_GL_VERSION_1_1(mjGlad_get_proc);
    mjGlad_load_GL_VERSION_1_2(mjGlad_get_proc);
    mjGlad_load_GL_VERSION_1_3(mjGlad_get_proc);
    mjGlad_load_GL_VERSION_1_4(mjGlad_get_proc);
    mjGlad_load_GL_VERSION_1_5(mjGlad_get_proc);

    if (!mjGlad_find_extensionsGL()) return 0;
    mjGlad_load_GL_ARB_framebuffer_object(mjGlad_get_proc);
    mjGlad_load_GL_ARB_vertex_buffer_object(mjGlad_get_proc);
    mjGlad_load_GL_KHR_debug(mjGlad_get_proc);

    mjGlad_close_gl();
    return mjGLVersion.major != 0 || mjGLVersion.minor != 0;
  } else {
    return 0;
  }
}
