/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

/********* Language model for: Arabic *********/

/**
 * Generated by BuildLangModel.py
 * On: 2016-05-04 09:56:03.636668
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static unsigned char Latin6CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 50, 56, 59, 67, 68, 73, 70, 62, 69, 80, 79, 74, 63, 64, 78, /* 4X */
   57, 88, 66, 52, 60, 77, 82, 71, 89, 83, 86,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 36, 58, 48, 45, 34, 55, 53, 46, 38, 90, 65, 44, 49, 39, 40, /* 6X */
   61, 87, 37, 43, 42, 47, 75, 72, 84, 54, 76,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,ILL,ILL,ILL,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,SYM,ILL,ILL, /* AX */
  ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,SYM,ILL,ILL,ILL,SYM, /* BX */
  ILL, 32, 41, 15, 35, 24, 31,  0,  8,  9,  7, 28, 19, 18, 25, 11, /* CX */
   29,  6, 26, 13, 21, 22, 27,SYM, 33, 10, 30,ILL,ILL,ILL,ILL,ILL, /* DX */
   51, 12, 16, 17,  1,  3,  5, 14,  4, 23,  2,SYM,SYM,SYM,SYM,SYM, /* EX */
  SYM,SYM,SYM,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static unsigned char Windows1256CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 50, 56, 59, 67, 68, 73, 70, 62, 69, 80, 79, 74, 63, 64, 78, /* 4X */
   57, 88, 66, 52, 60, 77, 82, 71, 89, 83, 86,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 36, 58, 48, 45, 34, 55, 53, 46, 38, 90, 65, 44, 49, 39, 40, /* 6X */
   61, 87, 37, 43, 42, 47, 75, 72, 84, 54, 76,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM, 85,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 94,SYM, 95, 96, 97, 98, /* 8X */
   91,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 99,SYM,100,SYM,101,SYM,SYM,102, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,103,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  104, 32, 41, 15, 35, 24, 31,  0,  8,  9,  7, 28, 19, 18, 25, 11, /* CX */
   29,  6, 26, 13, 21, 22, 27,SYM, 20, 33, 10, 30, 51, 12, 16, 17, /* DX */
  105,  1,106,  3,  5, 14,  4,107,108, 92, 93,109, 23,  2,110,111, /* EX */
  SYM,SYM,SYM,SYM,112,SYM,SYM,SYM,SYM,113,SYM,114, 81,SYM,SYM,115, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1811
 * First 512 sequences: 0.9581153857597667
 * Next 512 sequences (512-1024): 0.03818471242821863
 * Rest: 0.0036999018120146346
 * Negative sequences: TODO
 */
static char ArabicLangModel[] =
{
  1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,0,3,3,3,3,2,2,3,
   3,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,
   1,2,0,2,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,1,3,3,3,3,2,2,2,
   2,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,0,3,2,2,3,2,3,2,
   0,2,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,
   2,2,0,1,0,0,1,0,0,2,0,1,0,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,
  3,2,3,3,3,2,2,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,2,1,2,3,2,1,3,2,2,
   0,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,1,2,3,3,2,1,3,3,
   1,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,2,2,3,2,
   0,3,0,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,2,1,2,2,2,2,2,2,3,2,
   1,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,0,3,2,3,3,0,3,2,0,2,2,3,3,2,0,0,3,3,2,2,0,0,
   0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,0,1,0,3,0,3,2,0,3,0,2,2,
   2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,3,3,2,2,3,3,2,3,3,2,2,2,2,2,2,3,2,2,3,1,2,2,2,
   1,3,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,3,2,3,3,1,0,2,0,2,1,0,0,0,1,2,
   0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,1,3,1,1,2,0,2,2,0,3,1,2,0,2,0,0,2,2,0,3,0,1,
   0,1,0,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,3,3,3,3,3,2,3,3,3,3,3,0,3,3,3,3,3,3,3,2,0,3,2,2,3,2,3,1,
   0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,0,2,1,1,0,3,2,3,2,0,0,1,3,1,2,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,2,2,3,2,2,2,2,2,2,1,2,1,1,1,1,3,1,3,2,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,2,3,0,3,3,3,2,0,3,3,0,2,2,2,3,2,0,0,3,2,2,2,0,0,
   0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,2,1,2,1,1,1,0,1,0,0,3,0,2,2,2,2,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,2,3,3,3,2,3,3,3,2,2,2,2,2,3,0,2,1,2,1,0,2,0,1,1,0,0,0,2,2,
   0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,2,3,3,3,2,3,2,2,1,3,2,2,3,2,2,2,1,1,1,0,3,0,0,0,0,2,2,
   0,1,0,2,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,2,3,3,0,2,0,2,1,3,0,2,0,2,2,0,2,0,0,0,0,2,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,3,3,3,0,3,2,2,2,0,3,3,2,3,2,0,3,3,2,2,2,2,2,0,0,2,2,3,2,2,2,1,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,2,0,3,2,2,2,0,0,0,0,1,3,2,3,0,0,1,2,2,0,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,2,2,2,0,2,1,2,2,2,2,1,0,0,0,0,2,1,0,0,0,1,2,
   2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,2,3,2,2,3,3,3,2,0,2,1,0,0,2,1,2,0,0,2,0,2,0,1,0,0,2,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,2,3,1,1,1,0,2,1,3,1,0,0,0,0,0,1,0,0,0,0,1,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,2,2,2,2,2,2,1,0,2,0,3,0,1,3,0,2,0,0,0,1,0,2,1,0,1,0,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,2,2,0,2,1,3,2,0,0,0,0,1,2,1,0,1,0,0,3,2,0,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,3,2,2,2,3,2,2,3,2,3,2,2,2,0,2,2,2,2,1,1,1,0,0,1,2,1,1,2,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  2,1,0,0,1,0,0,2,0,2,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,2,3,2,1,3,2,1,3,0,0,2,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,3,2,2,1,0,2,2,2,2,1,2,2,2,0,0,0,2,1,1,0,0,2,0,0,1,0,0,
  2,2,2,2,2,1,2,2,0,1,0,2,0,2,2,0,2,2,0,0,0,1,0,0,0,1,0,0,2,1,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,1,2,2,3,1,0,2,2,2,2,1,2,2,2,0,0,0,2,2,1,0,0,1,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,2,2,2,0,2,2,2,2,1,2,2,2,0,0,0,2,2,1,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,0,2,2,0,2,2,2,2,1,1,2,2,0,0,0,2,1,1,0,0,2,0,0,1,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,1,2,2,2,0,2,2,1,2,1,1,2,1,0,0,1,2,2,1,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,1,2,1,2,2,0,1,2,2,1,1,2,2,2,0,0,1,1,1,2,0,0,1,0,0,2,0,0,
  1,2,2,2,1,2,2,2,2,1,0,2,1,2,1,0,0,1,0,1,0,1,0,0,0,3,1,0,2,2,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,2,1,2,0,2,2,2,0,2,2,1,1,0,0,0,1,2,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,1,1,2,0,2,0,2,2,1,1,2,1,2,1,0,0,0,1,1,1,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,0,2,1,2,0,2,2,2,2,1,1,1,1,0,0,0,1,2,2,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,1,2,0,2,0,1,1,1,1,0,1,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,2,1,1,0,2,1,1,0,0,2,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,2,2,0,0,2,2,2,2,1,0,1,2,0,0,0,1,1,1,0,0,2,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,1,2,1,2,0,2,1,1,0,2,2,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,0,2,1,1,0,0,1,1,0,0,1,1,1,0,0,0,0,2,1,0,0,2,0,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,0,2,0,2,0,0,0,1,1,2,0,2,1,1,1,0,2,1,0,1,1,1,0,1,1,1,1,1,
  1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,0,1,1,1,0,0,0,0,0,1,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,1,0,1,0,2,0,2,0,0,0,1,1,1,1,1,0,1,0,0,0,2,1,0,1,0,1,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,1,1,2,0,1,1,1,1,2,1,0,1,0,0,0,1,1,0,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,2,1,1,1,1,0,1,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,1,2,1,1,2,0,1,1,1,0,0,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,1,2,1,0,2,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,2,2,1,0,2,0,0,1,1,0,0,1,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,1,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,2,0,1,0,1,1,2,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,2,1,1,0,2,0,0,1,1,0,2,2,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,1,1,1,0,2,0,0,1,0,0,2,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,2,1,0,1,0,1,0,1,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,0,2,0,2,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,2,1,2,0,2,0,0,0,0,1,0,1,0,0,1,0,0,0,1,0,0,1,0,1,0,0,0,0,
};


SequenceModel Latin6_ArabicModel =
{
  Latin6CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.9581153857597667,
  PR_FALSE,
  "ISO-8859-6"
};

SequenceModel Windows1256_ArabicModel =
{
  Windows1256CharToOrderMap,
  ArabicLangModel,
  64,
  (float)0.9581153857597667,
  PR_FALSE,
  "windows-1256"
};
