/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */

#ifndef DT_BINDINGS_ASPEED_WDT_H
#define DT_BINDINGS_ASPEED_WDT_H

#define AST2500_WDT_RESET_CPU		(1 << 0)
#define AST2500_WDT_RESET_COPROC	(1 << 1)
#define AST2500_WDT_RESET_SDRAM		(1 << 2)
#define AST2500_WDT_RESET_AHB		(1 << 3)
#define AST2500_WDT_RESET_I2C		(1 << 4)
#define AST2500_WDT_RESET_MAC0		(1 << 5)
#define AST2500_WDT_RESET_MAC1		(1 << 6)
#define AST2500_WDT_RESET_GRAPHICS	(1 << 7)
#define AST2500_WDT_RESET_USB2_HOST_HUB	(1 << 8)
#define AST2500_WDT_RESET_USB_HOST	(1 << 9)
#define AST2500_WDT_RESET_HID_EHCI	(1 << 10)
#define AST2500_WDT_RESET_VIDEO		(1 << 11)
#define AST2500_WDT_RESET_HAC		(1 << 12)
#define AST2500_WDT_RESET_LPC		(1 << 13)
#define AST2500_WDT_RESET_SDIO		(1 << 14)
#define AST2500_WDT_RESET_MIC		(1 << 15)
#define AST2500_WDT_RESET_CRT		(1 << 16)
#define AST2500_WDT_RESET_PWM		(1 << 17)
#define AST2500_WDT_RESET_PECI		(1 << 18)
#define AST2500_WDT_RESET_JTAG		(1 << 19)
#define AST2500_WDT_RESET_ADC		(1 << 20)
#define AST2500_WDT_RESET_GPIO		(1 << 21)
#define AST2500_WDT_RESET_MCTP		(1 << 22)
#define AST2500_WDT_RESET_XDMA		(1 << 23)
#define AST2500_WDT_RESET_SPI		(1 << 24)
#define AST2500_WDT_RESET_SOC_MISC	(1 << 25)

#define AST2500_WDT_RESET_DEFAULT 0x023ffff3

#define AST2600_WDT_RESET1_CPU		(1 << 0)
#define AST2600_WDT_RESET1_SDRAM	(1 << 1)
#define AST2600_WDT_RESET1_AHB		(1 << 2)
#define AST2600_WDT_RESET1_SLI		(1 << 3)
#define AST2600_WDT_RESET1_SOC_MISC0	(1 << 4)
#define AST2600_WDT_RESET1_COPROC	(1 << 5)
#define AST2600_WDT_RESET1_USB_A	(1 << 6)
#define AST2600_WDT_RESET1_USB_B	(1 << 7)
#define AST2600_WDT_RESET1_UHCI		(1 << 8)
#define AST2600_WDT_RESET1_GRAPHICS	(1 << 9)
#define AST2600_WDT_RESET1_CRT		(1 << 10)
#define AST2600_WDT_RESET1_VIDEO	(1 << 11)
#define AST2600_WDT_RESET1_HAC		(1 << 12)
#define AST2600_WDT_RESET1_DP		(1 << 13)
#define AST2600_WDT_RESET1_DP_MCU	(1 << 14)
#define AST2600_WDT_RESET1_GP_MCU	(1 << 15)
#define AST2600_WDT_RESET1_MAC0		(1 << 16)
#define AST2600_WDT_RESET1_MAC1		(1 << 17)
#define AST2600_WDT_RESET1_SDIO0	(1 << 18)
#define AST2600_WDT_RESET1_JTAG0	(1 << 19)
#define AST2600_WDT_RESET1_MCTP0	(1 << 20)
#define AST2600_WDT_RESET1_MCTP1	(1 << 21)
#define AST2600_WDT_RESET1_XDMA0	(1 << 22)
#define AST2600_WDT_RESET1_XDMA1	(1 << 23)
#define AST2600_WDT_RESET1_GPIO0	(1 << 24)
#define AST2600_WDT_RESET1_RVAS		(1 << 25)

#define AST2600_WDT_RESET1_DEFAULT 0x030f1ff1

#define AST2600_WDT_RESET2_CPU		(1 << 0)
#define AST2600_WDT_RESET2_SPI		(1 << 1)
#define AST2600_WDT_RESET2_AHB2		(1 << 2)
#define AST2600_WDT_RESET2_SLI2		(1 << 3)
#define AST2600_WDT_RESET2_SOC_MISC1	(1 << 4)
#define AST2600_WDT_RESET2_MAC2		(1 << 5)
#define AST2600_WDT_RESET2_MAC3		(1 << 6)
#define AST2600_WDT_RESET2_SDIO1	(1 << 7)
#define AST2600_WDT_RESET2_JTAG1	(1 << 8)
#define AST2600_WDT_RESET2_GPIO1	(1 << 9)
#define AST2600_WDT_RESET2_MDIO		(1 << 10)
#define AST2600_WDT_RESET2_LPC		(1 << 11)
#define AST2600_WDT_RESET2_PECI		(1 << 12)
#define AST2600_WDT_RESET2_PWM		(1 << 13)
#define AST2600_WDT_RESET2_ADC		(1 << 14)
#define AST2600_WDT_RESET2_FSI		(1 << 15)
#define AST2600_WDT_RESET2_I2C		(1 << 16)
#define AST2600_WDT_RESET2_I3C_GLOBAL	(1 << 17)
#define AST2600_WDT_RESET2_I3C0		(1 << 18)
#define AST2600_WDT_RESET2_I3C1		(1 << 19)
#define AST2600_WDT_RESET2_I3C2		(1 << 20)
#define AST2600_WDT_RESET2_I3C3		(1 << 21)
#define AST2600_WDT_RESET2_I3C4		(1 << 22)
#define AST2600_WDT_RESET2_I3C5		(1 << 23)
#define AST2600_WDT_RESET2_ESPI		(1 << 26)

#define AST2600_WDT_RESET2_DEFAULT 0x03fffff1

#define AST2700_WDT_RESET1_CPU		(1 << 0)
#define AST2700_WDT_RESET1_DRAM		(1 << 1)
#define AST2700_WDT_RESET1_SLI0		(1 << 2)
#define AST2700_WDT_RESET1_EHCI		(1 << 3)
#define AST2700_WDT_RESET1_HACE		(1 << 4)
#define AST2700_WDT_RESET1_SOC_MISC0	(1 << 5)
#define AST2700_WDT_RESET1_VIDEO	(1 << 6)
#define AST2700_WDT_RESET1_2D_GRAPHIC	(1 << 7)
#define AST2700_WDT_RESET1_RAVS0	(1 << 8)
#define AST2700_WDT_RESET1_RAVS1	(1 << 9)
#define AST2700_WDT_RESET1_GPIO0	(1 << 10)
#define AST2700_WDT_RESET1_SSP		(1 << 11)
#define AST2700_WDT_RESET1_TSP		(1 << 12)
#define AST2700_WDT_RESET1_CRT		(1 << 13)
#define AST2700_WDT_RESET1_USB20_HOST	(1 << 14)
#define AST2700_WDT_RESET1_USB11_HOST	(1 << 15)
#define AST2700_WDT_RESET1_UFS		(1 << 16)
#define AST2700_WDT_RESET1_EMMC		(1 << 17)
#define AST2700_WDT_RESET1_AHB_TO_PCIE1	(1 << 18)
#define AST2700_WDT_RESET1_XDMA0	(1 << 22)
#define AST2700_WDT_RESET1_MCTP1	(1 << 23)
#define AST2700_WDT_RESET1_MCTP0	(1 << 24)
#define AST2700_WDT_RESET1_JTAG0	(1 << 25)
#define AST2700_WDT_RESET1_ECC		(1 << 26)
#define AST2700_WDT_RESET1_XDMA1	(1 << 27)
#define AST2700_WDT_RESET1_DP		(1 << 28)
#define AST2700_WDT_RESET1_DP_MCU	(1 << 29)
#define AST2700_WDT_RESET1_AHB_TO_PCIE0	(1 << 31)

#define AST2700_WDT_RESET1_DEFAULT 0x8207ff71

#define AST2700_WDT_RESET2_USB3_A_HOST	(1 << 0)
#define AST2700_WDT_RESET2_USB3_A_VHUB3	(1 << 1)
#define AST2700_WDT_RESET2_USB3_A_VHUB2	(1 << 2)
#define AST2700_WDT_RESET2_USB3_B_HOST	(1 << 3)
#define AST2700_WDT_RESET2_USB3_B_VHUB3	(1 << 4)
#define AST2700_WDT_RESET2_USB3_B_VHUB2	(1 << 5)
#define AST2700_WDT_RESET2_SM3		(1 << 6)
#define AST2700_WDT_RESET2_SM4		(1 << 7)
#define AST2700_WDT_RESET2_SHA3		(1 << 8)
#define AST2700_WDT_RESET2_RSA		(1 << 9)

#define AST2700_WDT_RESET2_DEFAULT 0x000003f6

#define AST2700_WDT_RESET3_LPC0		(1 << 0)
#define AST2700_WDT_RESET3_LPC1		(1 << 1)
#define AST2700_WDT_RESET3_MDIO		(1 << 2)
#define AST2700_WDT_RESET3_PECI		(1 << 3)
#define AST2700_WDT_RESET3_PWM		(1 << 4)
#define AST2700_WDT_RESET3_MAC0		(1 << 5)
#define AST2700_WDT_RESET3_MAC1		(1 << 6)
#define AST2700_WDT_RESET3_MAC2		(1 << 7)
#define AST2700_WDT_RESET3_ADC		(1 << 8)
#define AST2700_WDT_RESET3_SDC		(1 << 9)
#define AST2700_WDT_RESET3_ESPI0	(1 << 10)
#define AST2700_WDT_RESET3_ESPI1	(1 << 11)
#define AST2700_WDT_RESET3_JTAG1	(1 << 12)
#define AST2700_WDT_RESET3_SPI0		(1 << 13)
#define AST2700_WDT_RESET3_SPI1		(1 << 14)
#define AST2700_WDT_RESET3_SPI2		(1 << 15)
#define AST2700_WDT_RESET3_I3C0		(1 << 16)
#define AST2700_WDT_RESET3_I3C1		(1 << 17)
#define AST2700_WDT_RESET3_I3C2		(1 << 18)
#define AST2700_WDT_RESET3_I3C3		(1 << 19)
#define AST2700_WDT_RESET3_I3C4		(1 << 20)
#define AST2700_WDT_RESET3_I3C5		(1 << 21)
#define AST2700_WDT_RESET3_I3C6		(1 << 22)
#define AST2700_WDT_RESET3_I3C7		(1 << 23)
#define AST2700_WDT_RESET3_I3C8		(1 << 24)
#define AST2700_WDT_RESET3_I3C9		(1 << 25)
#define AST2700_WDT_RESET3_I3C10	(1 << 26)
#define AST2700_WDT_RESET3_I3C11	(1 << 27)
#define AST2700_WDT_RESET3_I3C12	(1 << 28)
#define AST2700_WDT_RESET3_I3C13	(1 << 29)
#define AST2700_WDT_RESET3_I3C14	(1 << 30)
#define AST2700_WDT_RESET3_I3C15	(1 << 31)

#define AST2700_WDT_RESET3_DEFAULT 0x000093ec

#define AST2700_WDT_RESET4_FMC		(1 << 0)
#define AST2700_WDT_RESET4_SOC_MISC1	(1 << 1)
#define AST2700_WDT_RESET4_AHB		(1 << 2)
#define AST2700_WDT_RESET4_SLI1		(1 << 3)
#define AST2700_WDT_RESET4_UART0	(1 << 4)
#define AST2700_WDT_RESET4_UART1	(1 << 5)
#define AST2700_WDT_RESET4_UART2	(1 << 6)
#define AST2700_WDT_RESET4_UART3	(1 << 7)
#define AST2700_WDT_RESET4_I2C_MONITOR	(1 << 8)
#define AST2700_WDT_RESET4_HOST_TO_SPI1	(1 << 9)
#define AST2700_WDT_RESET4_HOST_TO_SPI2	(1 << 10)
#define AST2700_WDT_RESET4_GPIO1	(1 << 11)
#define AST2700_WDT_RESET4_FSI		(1 << 12)
#define AST2700_WDT_RESET4_CANBUS	(1 << 13)
#define AST2700_WDT_RESET4_MCTP		(1 << 14)
#define AST2700_WDT_RESET4_XDMA		(1 << 15)
#define AST2700_WDT_RESET4_UART5	(1 << 16)
#define AST2700_WDT_RESET4_UART6	(1 << 17)
#define AST2700_WDT_RESET4_UART7	(1 << 18)
#define AST2700_WDT_RESET4_UART8	(1 << 19)
#define AST2700_WDT_RESET4_BOOT_MCU	(1 << 20)
#define AST2700_WDT_RESET4_IO_MCU	(1 << 21)
#define AST2700_WDT_RESET4_LTPI0	(1 << 22)
#define AST2700_WDT_RESET4_VGA_LINK	(1 << 23)
#define AST2700_WDT_RESET4_LTPI1	(1 << 24)
#define AST2700_WDT_RESET4_LTPI_PHY	(1 << 25)
#define AST2700_WDT_RESET4_ACE		(1 << 26)
#define AST2700_WDT_RESET4_LTPI_GPIO0	(1 << 28)
#define AST2700_WDT_RESET4_LTPI_GPIO1	(1 << 29)
#define AST2700_WDT_RESET4_AHB_TO_PCIE1	(1 << 30)
#define AST2700_WDT_RESET4_I3C_DMA	(1 << 31)

#define AST2700_WDT_RESET4_DEFAULT 0x40303803

#define AST2700_WDT_RESET5_I2C_GLOBAL	(1 << 0)
#define AST2700_WDT_RESET5_I2C0		(1 << 1)
#define AST2700_WDT_RESET5_I2C1		(1 << 2)
#define AST2700_WDT_RESET5_I2C2		(1 << 3)
#define AST2700_WDT_RESET5_I2C3		(1 << 4)
#define AST2700_WDT_RESET5_I2C4		(1 << 5)
#define AST2700_WDT_RESET5_I2C5		(1 << 6)
#define AST2700_WDT_RESET5_I2C6		(1 << 7)
#define AST2700_WDT_RESET5_I2C7		(1 << 8)
#define AST2700_WDT_RESET5_I2C8		(1 << 9)
#define AST2700_WDT_RESET5_I2C9		(1 << 10)
#define AST2700_WDT_RESET5_I2C10	(1 << 11)
#define AST2700_WDT_RESET5_I2C11	(1 << 12)
#define AST2700_WDT_RESET5_I2C12	(1 << 13)
#define AST2700_WDT_RESET5_I2C13	(1 << 14)
#define AST2700_WDT_RESET5_I2C14	(1 << 15)
#define AST2700_WDT_RESET5_I2C15	(1 << 16)
#define AST2700_WDT_RESET5_UHCI		(1 << 17)
#define AST2700_WDT_RESET5_USB2_C_UART	(1 << 18)
#define AST2700_WDT_RESET5_USB2_C	(1 << 19)
#define AST2700_WDT_RESET5_USB2_D_UART	(1 << 20)
#define AST2700_WDT_RESET5_USB2_D	(1 << 21)

#define AST2700_WDT_RESET5_DEFAULT 0x00320000

#endif
