///////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) Crossbar.io Technologies GmbH and contributors
//
// Boost Software License - Version 1.0 - August 17th, 2003
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
///////////////////////////////////////////////////////////////////////////////

namespace autobahn {

inline wamp_challenge::wamp_challenge(
        const std::string & authmethod,
        const std::string & challenge,
        const std::string & salt,
        int iterations,
        int keylen)
: m_authmethod( authmethod )
, m_challenge( challenge )
, m_salt( salt )
, m_iterations( iterations )
, m_keylen( keylen )
{}

inline wamp_challenge::wamp_challenge( const wamp_challenge & ch )
{
    m_authmethod = ch.authmethod();
    m_challenge = ch.challenge();
    m_salt = ch.salt();
    m_iterations = ch.iterations();
    m_keylen = ch.keylen();
}


inline const std::string & wamp_challenge::authmethod() const { return m_authmethod; }
inline const std::string & wamp_challenge::challenge() const { return m_challenge; }
inline const std::string & wamp_challenge::salt() const { return m_salt; }
inline int wamp_challenge::iterations() const { return m_iterations; }
inline int wamp_challenge::keylen() const { return m_keylen; }


} // namespace autobahn
