# - Find the native HEIF includes and library
#

# This module defines
#  HEIF_INCLUDE_DIR, where to find heif.h, etc.
#  HEIF_LIBRARIES, the libraries to link against to use HEIF.
#  HEIF_FOUND, If false, do not try to use HEIF.
# Also defined, but not for general use are
#  HEIF_LIBRARY, where to find the HEIF library.

# Copyright (c) 2002 Kitware, Inc., Insight Consortium.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#  * Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#
#  * Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
#  * The names of Kitware, Inc., the Insight Consortium, or the names of
#    any consortium members, or of any contributors, may not be used to
#    endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

SET(HEIF_FOUND "NO")

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  find_package(PkgConfig)
  pkg_check_modules(HEIF_PKG libheif>=1.7.0 QUIET)
endif( NOT WIN32 )

FIND_PATH(HEIF_INCLUDE_DIR NAMES libheif/heif.h
  PATHS
    /usr/local/include
    /usr/include
  HINTS
    ${HEIF_PKG_INCLUDE_DIRS} # Generated by pkg-config
)

IF (HEIF_INCLUDE_DIR)
  include(CheckStructHasMember)
  CHECK_STRUCT_HAS_MEMBER("struct heif_decoding_options" convert_hdr_to_8bit libheif/heif.h HEIF_HDR_TO_8BIT LANGUAGE C)
  if (WIN32)
    SET(HEIF_PKG_FOUND 1)
  endif (WIN32)
ENDIF (HEIF_INCLUDE_DIR)

IF (NOT HEIF_HDR_TO_8BIT AND NOT HEIF_PKG_FOUND)
  MESSAGE(FATAL_ERROR "libheif version found is too old")
ENDIF (NOT HEIF_HDR_TO_8BIT AND NOT HEIF_PKG_FOUND)

SET(HEIF_NAMES ${HEIF_NAMES} heif ${HEIF_PKG_LIBRARY})
FIND_LIBRARY(HEIF_LIBRARY
  NAMES ${HEIF_NAMES}
  PATH /usr/local/lib /usr/lib
  PATH_SUFFIXES lib64 lib
  HINTS ${HEIF_PKG_LIBRARY_DIRS} # Generated by pkg-config
)

IF (HEIF_LIBRARY AND HEIF_INCLUDE_DIR)
	SET(HEIF_FOUND "YES")
	SET(HAVE_LIBHEIF 1)
	SET(HEIF_LIBRARIES ${HEIF_LIBRARY})
ENDIF (HEIF_LIBRARY AND HEIF_INCLUDE_DIR)

IF (HEIF_FOUND)
	IF (NOT HEIF_FIND_QUIETLY)
		MESSAGE(STATUS "Find HEIF: ${HEIF_LIBRARY}")
	ENDIF (NOT HEIF_FIND_QUIETLY)
ELSE (HEIF_FOUND)
	IF (HEIF_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find HEIF library")
	ENDIF (HEIF_FIND_REQUIRED)
ENDIF (HEIF_FOUND)

MARK_AS_ADVANCED(HEIF_INCLUDE_DIR HEIF_LIBRARY)
