/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugShaders.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSWebGLShader.h"
#include "KURL.h"
#include "WebGLDebugShaders.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugShadersPrototypeTableValues[] =
{
    { "getTranslatedShaderSource", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLDebugShadersPrototypeTable = { 2, 1, JSWebGLDebugShadersPrototypeTableValues, 0 };
const ClassInfo JSWebGLDebugShadersPrototype::s_info = { "WebGLDebugShadersPrototype", &Base::s_info, &JSWebGLDebugShadersPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLDebugShadersPrototype) };

JSObject* JSWebGLDebugShadersPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLDebugShaders>(exec, globalObject);
}

bool JSWebGLDebugShadersPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLDebugShadersPrototype* thisObject = jsCast<JSWebGLDebugShadersPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWebGLDebugShadersPrototypeTable, thisObject, propertyName, slot);
}

bool JSWebGLDebugShadersPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLDebugShadersPrototype* thisObject = jsCast<JSWebGLDebugShadersPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebGLDebugShadersPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebGLDebugShaders::s_info = { "WebGLDebugShaders", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSWebGLDebugShaders) };

JSWebGLDebugShaders::JSWebGLDebugShaders(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLDebugShaders> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebGLDebugShaders::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLDebugShaders::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLDebugShadersPrototype::create(exec->globalData(), globalObject, JSWebGLDebugShadersPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebGLDebugShaders::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugShaders* thisObject = static_cast<JSWebGLDebugShaders*>(cell);
    thisObject->JSWebGLDebugShaders::~JSWebGLDebugShaders();
}

JSWebGLDebugShaders::~JSWebGLDebugShaders()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsWebGLDebugShadersPrototypeFunctionGetTranslatedShaderSource(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebGLDebugShaders::s_info))
        return throwVMTypeError(exec);
    JSWebGLDebugShaders* castedThis = jsCast<JSWebGLDebugShaders*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebGLDebugShaders::s_info);
    WebGLDebugShaders* impl = static_cast<WebGLDebugShaders*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSWebGLShader::s_info))
        return throwVMTypeError(exec);
    WebGLShader* shader(toWebGLShader(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, impl->getTranslatedShaderSource(shader, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSWebGLDebugShaders* jsWebGLDebugShaders)
{
    if (jsWebGLDebugShaders->hasCustomProperties())
        return true;
    return false;
}

bool JSWebGLDebugShadersOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebGLDebugShaders* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.get().asCell());
    if (!isObservable(jsWebGLDebugShaders))
        return false;
    WebGLRenderingContext* root = jsWebGLDebugShaders->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSWebGLDebugShadersOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebGLDebugShaders* jsWebGLDebugShaders = jsCast<JSWebGLDebugShaders*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLDebugShaders->impl(), jsWebGLDebugShaders);
    jsWebGLDebugShaders->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLDebugShaders* impl)
{
    return wrap<JSWebGLDebugShaders>(exec, globalObject, impl);
}

WebGLDebugShaders* toWebGLDebugShaders(JSC::JSValue value)
{
    return value.inherits(&JSWebGLDebugShaders::s_info) ? jsCast<JSWebGLDebugShaders*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
