; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=jump-threading -S < %s | FileCheck %s

declare void @f()

define void @test1(i1 %cond, i1 %dummycond) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br i1 [[DUMMYCOND:%.*]], label [[REACHABLE:%.*]], label [[DUMMY:%.*]]
; CHECK:       B:
; CHECK-NEXT:    br i1 [[DUMMYCOND]], label [[REACHABLE]], label [[DUMMY]]
; CHECK:       REACHABLE:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       DUMMY:
; CHECK-NEXT:    ret void
;
  br i1 %cond, label %A, label %B
A:
  br i1 %dummycond, label %A2, label %DUMMY
A2:
  %cond.fr = freeze i1 %cond
  br i1 %cond.fr, label %REACHABLE, label %UNREACHABLE
B:
  br i1 %dummycond, label %B2, label %DUMMY
B2:
  %cond.fr2 = freeze i1 %cond
  br i1 %cond.fr2, label %UNREACHABLE, label %REACHABLE

REACHABLE:
  call void @f()
  ret void
UNREACHABLE:
  ret void
DUMMY:
  ret void
}

define void @test2(i1 %cond, i1 %dummycond) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[COND_FR0:%.*]] = freeze i1 [[COND:%.*]]
; CHECK-NEXT:    br i1 [[COND_FR0]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br i1 [[DUMMYCOND:%.*]], label [[REACHABLE:%.*]], label [[DUMMY:%.*]]
; CHECK:       B:
; CHECK-NEXT:    br i1 [[DUMMYCOND]], label [[REACHABLE]], label [[DUMMY]]
; CHECK:       REACHABLE:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       DUMMY:
; CHECK-NEXT:    ret void
;
  %cond.fr0 = freeze i1 %cond
  br i1 %cond.fr0, label %A, label %B
A:
  br i1 %dummycond, label %A2, label %DUMMY
A2:
  %cond.fr = freeze i1 %cond
  br i1 %cond.fr, label %REACHABLE, label %UNREACHABLE
B:
  br i1 %dummycond, label %B2, label %DUMMY
B2:
  %cond.fr2 = freeze i1 %cond
  br i1 %cond.fr2, label %UNREACHABLE, label %REACHABLE

REACHABLE:
  call void @f()
  ret void
UNREACHABLE:
  ret void
DUMMY:
  ret void
}

; In this specific example, it is still correct to fold %cond.fr into true.
; This case is unsupported because it is unclear what is the result of
; isImpliedCondition if LHS is poison or undef.
; If isImpliedCondition(poison, any value) is true,
; isImpliedCondition(and true, poison, false) is also true because 'and' propagates poison.
; However, freeze(and true, poison) does not imply false because the former can
; be frozen to true. Therefore, we cannot look through the argument of freeze (%cond.fr0)
; in general under this isImpliedCondition definition.
define void @and_noopt(i32 %x, i1 %cond2, i1 %dummycond) {
; CHECK-LABEL: @and_noopt(
; CHECK-NEXT:    [[COND1:%.*]] = icmp slt i32 0, [[X:%.*]]
; CHECK-NEXT:    [[COND:%.*]] = and i1 [[COND1]], [[COND2:%.*]]
; CHECK-NEXT:    [[COND_FR0:%.*]] = freeze i1 [[COND]]
; CHECK-NEXT:    br i1 [[COND_FR0]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br i1 [[DUMMYCOND:%.*]], label [[A2:%.*]], label [[DUMMY:%.*]]
; CHECK:       A2:
; CHECK-NEXT:    [[COND_FR:%.*]] = freeze i1 [[COND1]]
; CHECK-NEXT:    br i1 [[COND_FR]], label [[REACHABLE:%.*]], label [[UNREACHABLE:%.*]]
; CHECK:       B:
; CHECK-NEXT:    br i1 [[DUMMYCOND]], label [[B2:%.*]], label [[DUMMY]]
; CHECK:       B2:
; CHECK-NEXT:    [[COND_FR2:%.*]] = freeze i1 [[COND1]]
; CHECK-NEXT:    br i1 [[COND_FR2]], label [[UNREACHABLE]], label [[REACHABLE]]
; CHECK:       REACHABLE:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       UNREACHABLE:
; CHECK-NEXT:    ret void
; CHECK:       DUMMY:
; CHECK-NEXT:    ret void
;
  %cond1 = icmp slt i32 0, %x
  %cond = and i1 %cond1, %cond2
  %cond.fr0 = freeze i1 %cond
  br i1 %cond.fr0, label %A, label %B
A:
  br i1 %dummycond, label %A2, label %DUMMY
A2:
  %cond.fr = freeze i1 %cond1
  br i1 %cond.fr, label %REACHABLE, label %UNREACHABLE
B:
  br i1 %dummycond, label %B2, label %DUMMY
B2:
  %cond.fr2 = freeze i1 %cond1
  br i1 %cond.fr2, label %UNREACHABLE, label %REACHABLE

REACHABLE:
  call void @f()
  ret void
UNREACHABLE:
  ret void
DUMMY:
  ret void
}

define void @and(i32 %x, i1 %cond2, i1 %dummycond) {
; CHECK-LABEL: @and(
; CHECK-NEXT:    [[COND1:%.*]] = icmp slt i32 0, [[X:%.*]]
; CHECK-NEXT:    [[COND:%.*]] = and i1 [[COND1]], [[COND2:%.*]]
; CHECK-NEXT:    br i1 [[COND]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br i1 [[DUMMYCOND:%.*]], label [[REACHABLE:%.*]], label [[DUMMY:%.*]]
; CHECK:       B:
; CHECK-NEXT:    br i1 [[DUMMYCOND]], label [[B2:%.*]], label [[DUMMY]]
; CHECK:       B2:
; CHECK-NEXT:    [[COND_FR2:%.*]] = freeze i1 [[COND1]]
; CHECK-NEXT:    br i1 [[COND_FR2]], label [[REACHABLE]], label [[REACHABLE2:%.*]]
; CHECK:       REACHABLE:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       REACHABLE2:
; CHECK-NEXT:    call void @f()
; CHECK-NEXT:    ret void
; CHECK:       DUMMY:
; CHECK-NEXT:    ret void
;
  %cond1 = icmp slt i32 0, %x
  %cond = and i1 %cond1, %cond2
  br i1 %cond, label %A, label %B
A:
  br i1 %dummycond, label %A2, label %DUMMY
A2:
  %cond.fr = freeze i1 %cond1
  br i1 %cond.fr, label %REACHABLE, label %UNREACHABLE
B:
  br i1 %dummycond, label %B2, label %DUMMY
B2:
  %cond.fr2 = freeze i1 %cond1
  br i1 %cond.fr2, label %REACHABLE, label %REACHABLE2

REACHABLE:
  call void @f()
  ret void
REACHABLE2:
  call void @f()
  ret void
UNREACHABLE:
  ret void
DUMMY:
  ret void
}
